/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.controllers;

import android.content.Intent;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.microsoft.identity.common.adal.internal.net.HttpWebRequest;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.exception.ServiceException;
import com.microsoft.identity.common.internal.authorities.Authority;
import com.microsoft.identity.common.internal.authorities.AzureActiveDirectoryAuthority;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.cache.SchemaUtil;
import com.microsoft.identity.common.internal.dto.AccessTokenRecord;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import com.microsoft.identity.common.internal.dto.CredentialType;
import com.microsoft.identity.common.internal.dto.IdTokenRecord;
import com.microsoft.identity.common.internal.logging.DiagnosticContext;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.net.ObjectMapper;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftAuthorizationRequest;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftTokenRequest;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftTokenResponse;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryCloud;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsTokenResponse;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResponse;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.internal.providers.oauth2.IResult;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.internal.providers.oauth2.OpenIdConnectPromptParameter;
import com.microsoft.identity.common.internal.providers.oauth2.TokenRequest;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResponse;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResult;
import com.microsoft.identity.common.internal.request.AcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.AcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.OperationParameters;
import com.microsoft.identity.common.internal.request.SdkType;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.result.LocalAuthenticationResult;
import com.microsoft.identity.common.internal.telemetry.CliTelemInfo;
import com.microsoft.identity.common.internal.util.DateUtilities;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;

public abstract class BaseController {
    private static final String TAG = BaseController.class.getSimpleName();
    public static final int AUTH_REQUEST_TIMEOUT_IN_MINUTES = 10;

    public abstract AcquireTokenResult acquireToken(AcquireTokenOperationParameters var1) throws ExecutionException, InterruptedException, BaseException, IOException;

    public abstract void completeAcquireToken(int var1, int var2, Intent var3);

    public abstract AcquireTokenResult acquireTokenSilent(AcquireTokenSilentOperationParameters var1) throws IOException, BaseException;

    protected final AuthorizationRequest.Builder initializeAuthorizationRequestBuilder(@NonNull AuthorizationRequest.Builder builder, @NonNull OperationParameters parameters) {
        UUID correlationId = null;
        try {
            correlationId = UUID.fromString((String)DiagnosticContext.getRequestContext().get("correlation_id"));
        }
        catch (IllegalArgumentException ex) {
            Logger.error(TAG, "correlation id from diagnostic context is not a UUID", ex);
        }
        ((AuthorizationRequest.Builder)((AuthorizationRequest.Builder)builder.setClientId(parameters.getClientId())).setRedirectUri(parameters.getRedirectUri())).setCorrelationId(correlationId);
        if (parameters instanceof AcquireTokenOperationParameters) {
            AcquireTokenOperationParameters acquireTokenOperationParameters = (AcquireTokenOperationParameters)parameters;
            if (acquireTokenOperationParameters.getExtraScopesToConsent() != null) {
                parameters.getScopes().addAll(acquireTokenOperationParameters.getExtraScopesToConsent());
            }
            ((AuthorizationRequest.Builder)((AuthorizationRequest.Builder)((AuthorizationRequest.Builder)((AuthorizationRequest.Builder)builder.setLoginHint(acquireTokenOperationParameters.getLoginHint())).setExtraQueryParams(acquireTokenOperationParameters.getExtraQueryStringParameters())).setPrompt(acquireTokenOperationParameters.getOpenIdConnectPromptParameter().toString())).setClaims(parameters.getClaimsRequestJson())).setRequestHeaders(acquireTokenOperationParameters.getRequestHeaders());
            if (!StringExtensions.isNullOrBlank(acquireTokenOperationParameters.getLoginHint()) && acquireTokenOperationParameters.getOpenIdConnectPromptParameter() == OpenIdConnectPromptParameter.SELECT_ACCOUNT) {
                builder.setPrompt(null);
            }
            if (acquireTokenOperationParameters.getAuthority() instanceof AzureActiveDirectoryAuthority) {
                AzureActiveDirectoryAuthority requestAuthority = (AzureActiveDirectoryAuthority)acquireTokenOperationParameters.getAuthority();
                ((MicrosoftAuthorizationRequest.Builder)((MicrosoftAuthorizationRequest.Builder)((MicrosoftAuthorizationRequest.Builder)builder).setAuthority(requestAuthority.getAuthorityURL())).setMultipleCloudAware(requestAuthority.mMultipleCloudsSupported)).setSlice(requestAuthority.mSlice);
            }
        }
        builder.setScope(TextUtils.join((CharSequence)" ", parameters.getScopes()));
        return builder;
    }

    protected AuthorizationRequest getAuthorizationRequest(@NonNull OAuth2Strategy strategy, @NonNull OperationParameters parameters) {
        Object builder = strategy.createAuthorizationRequestBuilder(parameters.getAccount());
        this.initializeAuthorizationRequestBuilder((AuthorizationRequest.Builder)builder, parameters);
        return ((AuthorizationRequest.Builder)builder).build();
    }

    protected TokenResult performTokenRequest(@NonNull OAuth2Strategy strategy, @NonNull AuthorizationRequest request, @NonNull AuthorizationResponse response, @NonNull AcquireTokenOperationParameters parameters) throws IOException, ClientException {
        String methodName = ":performTokenRequest";
        HttpWebRequest.throwIfNetworkNotAvailable(parameters.getAppContext());
        Object tokenRequest = strategy.createTokenRequest(request, response);
        BaseController.logExposedFieldsOfObject(TAG + ":performTokenRequest", tokenRequest);
        ((TokenRequest)tokenRequest).setGrantType("authorization_code");
        Object tokenResult = strategy.requestToken(tokenRequest);
        BaseController.logResult(TAG, tokenResult);
        return tokenResult;
    }

    protected void renewAccessToken(@NonNull AcquireTokenSilentOperationParameters parameters, @NonNull AcquireTokenResult acquireTokenSilentResult, @NonNull OAuth2TokenCache tokenCache, @NonNull OAuth2Strategy strategy, @NonNull ICacheRecord cacheRecord) throws IOException, ClientException {
        String methodName = ":renewAccessToken";
        Logger.verbose(TAG + ":renewAccessToken", "Renewing access token...");
        parameters.setRefreshToken(cacheRecord.getRefreshToken());
        this.logParameters(TAG, parameters);
        TokenResult tokenResult = this.performSilentTokenRequest(strategy, parameters);
        acquireTokenSilentResult.setTokenResult(tokenResult);
        BaseController.logResult(TAG + ":renewAccessToken", tokenResult);
        if (tokenResult.getSuccess()) {
            Logger.verbose(TAG + ":renewAccessToken", "Token request was successful");
            ICacheRecord savedRecord = tokenCache.save(strategy, this.getAuthorizationRequest(strategy, parameters), tokenResult.getTokenResponse());
            LocalAuthenticationResult authenticationResult = new LocalAuthenticationResult(savedRecord, parameters.getSdkType());
            if (null != tokenResult.getCliTelemInfo()) {
                CliTelemInfo cliTelemInfo = tokenResult.getCliTelemInfo();
                authenticationResult.setSpeRing(cliTelemInfo.getSpeRing());
                authenticationResult.setRefreshTokenAge(cliTelemInfo.getRefreshTokenAge());
            }
            acquireTokenSilentResult.setLocalAuthenticationResult(authenticationResult);
        }
    }

    public static void logResult(@NonNull String tag, @NonNull IResult result) {
        AuthorizationResult authResult;
        String TAG = tag + ":" + result.getClass().getSimpleName();
        if (result.getSuccess()) {
            Logger.verbose(TAG, "Success Result");
            BaseController.logExposedFieldsOfObject(TAG, result.getSuccessResponse());
        } else {
            Logger.warn(TAG, "Failure Result");
            if (result.getErrorResponse() != null) {
                if (result.getErrorResponse().getError() != null) {
                    Logger.warn(TAG, "Error: " + result.getErrorResponse().getError());
                }
                if (result.getErrorResponse().getErrorDescription() != null) {
                    Logger.warnPII(TAG, "Description: " + result.getErrorResponse().getErrorDescription());
                }
                BaseController.logExposedFieldsOfObject(TAG, result.getErrorResponse());
            }
        }
        if (result instanceof AuthorizationResult && (authResult = (AuthorizationResult)result).getAuthorizationStatus() != null) {
            Logger.verbose(TAG, "Authorization Status: " + authResult.getAuthorizationStatus().toString());
        }
    }

    protected void logParameters(String tag, Object parameters) {
        String TAG = tag + ":" + parameters.getClass().getSimpleName();
        if (Logger.getAllowPii()) {
            Logger.verbosePII(TAG, ObjectMapper.serializeObjectToJsonString(parameters));
        } else {
            Logger.verbose(TAG, ObjectMapper.serializeExposedFieldsOfObjectToJsonString(parameters));
        }
    }

    protected static void logExposedFieldsOfObject(@NonNull String tag, @NonNull Object object) {
        String TAG = tag + ":" + object.getClass().getSimpleName();
        Logger.verbose(TAG, ObjectMapper.serializeExposedFieldsOfObjectToJsonString(object));
    }

    protected TokenResult performSilentTokenRequest(@NonNull OAuth2Strategy strategy, @NonNull AcquireTokenSilentOperationParameters parameters) throws ClientException, IOException {
        String methodName = ":performSilentTokenRequest";
        Logger.verbose(TAG + ":performSilentTokenRequest", "Requesting tokens...");
        HttpWebRequest.throwIfNetworkNotAvailable(parameters.getAppContext());
        Authority.KnownAuthorityResult authorityResult = Authority.getKnownAuthorityResult(parameters.getAuthority());
        if (!authorityResult.getKnown()) {
            throw authorityResult.getClientException();
        }
        Object refreshTokenRequest = strategy.createRefreshTokenRequest();
        ((TokenRequest)refreshTokenRequest).setClientId(parameters.getClientId());
        ((TokenRequest)refreshTokenRequest).setScope(TextUtils.join((CharSequence)" ", parameters.getScopes()));
        ((TokenRequest)refreshTokenRequest).setRefreshToken(parameters.getRefreshToken().getSecret());
        ((TokenRequest)refreshTokenRequest).setRedirectUri(parameters.getRedirectUri());
        if (parameters.getSdkType() == SdkType.ADAL) {
            ((MicrosoftTokenRequest)refreshTokenRequest).setIdTokenVersion("1");
        }
        if (!StringExtensions.isNullOrBlank(((TokenRequest)refreshTokenRequest).getScope())) {
            Logger.verbosePII(TAG + ":performSilentTokenRequest", "Scopes: [" + ((TokenRequest)refreshTokenRequest).getScope() + "]");
        }
        return strategy.requestToken(refreshTokenRequest);
    }

    protected ICacheRecord saveTokens(@NonNull OAuth2Strategy strategy, @NonNull AuthorizationRequest request, @NonNull TokenResponse tokenResponse, @NonNull OAuth2TokenCache tokenCache) throws ClientException {
        String methodName = ":saveTokens";
        Logger.verbose(TAG + ":saveTokens", "Saving tokens...");
        return tokenCache.save(strategy, request, tokenResponse);
    }

    protected boolean refreshTokenIsNull(@NonNull ICacheRecord cacheRecord) {
        return null == cacheRecord.getRefreshToken();
    }

    protected boolean accessTokenIsNull(@NonNull ICacheRecord cacheRecord) {
        return null == cacheRecord.getAccessToken();
    }

    protected boolean idTokenIsNull(@NonNull ICacheRecord cacheRecord, @NonNull SdkType sdkType) {
        IdTokenRecord idTokenRecord = sdkType == SdkType.ADAL ? cacheRecord.getV1IdToken() : cacheRecord.getIdToken();
        return null == idTokenRecord;
    }

    protected void addDefaultScopes(@NonNull OperationParameters operationParameters) {
        Set<String> requestScopes = operationParameters.getScopes();
        requestScopes.add("openid");
        requestScopes.add("offline_access");
        requestScopes.add("profile");
        requestScopes.removeAll(Arrays.asList("", null));
        operationParameters.setScopes(requestScopes);
    }

    public AccessTokenRecord getAccessTokenRecord(@NonNull MicrosoftStsTokenResponse tokenResponse, @NonNull OperationParameters requestParameters) {
        String methodName = ":getAccessTokenRecord";
        AccessTokenRecord accessTokenRecord = new AccessTokenRecord();
        try {
            ClientInfo clientInfo = new ClientInfo(tokenResponse.getClientInfo());
            accessTokenRecord.setHomeAccountId(SchemaUtil.getHomeAccountId(clientInfo));
            accessTokenRecord.setRealm(SchemaUtil.getTenantId(tokenResponse.getClientInfo(), tokenResponse.getIdToken()));
            AzureActiveDirectoryCloud cloudEnv = AzureActiveDirectory.getAzureActiveDirectoryCloud(requestParameters.getAuthority().getAuthorityURL());
            if (cloudEnv != null) {
                Logger.info(TAG, "Using preferred cache host name...");
                accessTokenRecord.setEnvironment(cloudEnv.getPreferredCacheHostName());
            } else {
                accessTokenRecord.setEnvironment(requestParameters.getAuthority().getAuthorityURL().getHost());
            }
        }
        catch (ServiceException e) {
            Logger.error(TAG + ":getAccessTokenRecord", "ClientInfo construction failed ", e);
        }
        accessTokenRecord.setClientId(requestParameters.getClientId());
        accessTokenRecord.setSecret(tokenResponse.getAccessToken());
        accessTokenRecord.setAccessTokenType(tokenResponse.getTokenType());
        accessTokenRecord.setAuthority(requestParameters.getAuthority().getAuthorityURL().toString());
        accessTokenRecord.setTarget(TextUtils.join((CharSequence)" ", requestParameters.getScopes()));
        accessTokenRecord.setCredentialType(CredentialType.AccessToken.name());
        if (tokenResponse.getExpiresIn() != null) {
            accessTokenRecord.setExpiresOn(String.valueOf(DateUtilities.getExpiresOn(tokenResponse.getExpiresIn())));
        }
        if (tokenResponse.getExtExpiresIn() != null) {
            accessTokenRecord.setExtendedExpiresOn(String.valueOf(DateUtilities.getExpiresOn(tokenResponse.getExtExpiresIn())));
        }
        accessTokenRecord.setCachedAt(String.valueOf(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())));
        return accessTokenRecord;
    }

    protected AccountRecord getCachedAccountRecord(@NonNull AcquireTokenSilentOperationParameters parameters) throws ClientException {
        if (parameters.getAccount() == null) {
            throw new ClientException("no_account_found", "No cached accounts found for the supplied homeAccountId and clientId");
        }
        String clientId = parameters.getClientId();
        String homeAccountId = parameters.getAccount().getHomeAccountId();
        String localAccountId = parameters.getAccount().getLocalAccountId();
        AccountRecord targetAccount = parameters.getTokenCache().getAccountWithLocalAccountId(null, clientId, localAccountId);
        if (null == targetAccount) {
            Logger.info(TAG, "No accounts found for clientId [" + clientId + ", ]", null);
            Logger.errorPII(TAG, "No accounts found for clientId, homeAccountId: [" + clientId + ", " + homeAccountId + "]", null);
            throw new ClientException("no_account_found", "No cached accounts found for the supplied homeAccountId");
        }
        return targetAccount;
    }

    protected boolean isMsaAccount(MicrosoftTokenResponse microsoftTokenResponse) {
        String tenantId = SchemaUtil.getTenantId(microsoftTokenResponse.getClientInfo(), microsoftTokenResponse.getIdToken());
        return "9188040d-6c67-4c5b-b112-36a304b66dad".equalsIgnoreCase(tenantId);
    }
}

