/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.controllers;

import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.util.Pair;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.UserCancelException;
import com.microsoft.identity.common.internal.controllers.ExceptionAdapter;
import com.microsoft.identity.common.internal.controllers.InteractiveTokenCommand;
import com.microsoft.identity.common.internal.controllers.TokenCommand;
import com.microsoft.identity.common.internal.logging.DiagnosticContext;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.logging.RequestContext;
import com.microsoft.identity.common.internal.request.AcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.AcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.result.ILocalAuthenticationResult;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ApiDispatcher {
    private static final String TAG = ApiDispatcher.class.getSimpleName();
    private static final ExecutorService sInteractiveExecutor = Executors.newSingleThreadExecutor();
    private static final ExecutorService sSilentExecutor = Executors.newCachedThreadPool();
    private static final Object sLock = new Object();
    private static InteractiveTokenCommand sCommand = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void beginInteractive(final InteractiveTokenCommand command) {
        String methodName = ":beginInteractive";
        Logger.verbose(TAG + ":beginInteractive", "Beginning interactive request");
        Object object = sLock;
        synchronized (object) {
            sInteractiveExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    ApiDispatcher.initializeDiagnosticContext();
                    if (command.mParameters instanceof AcquireTokenOperationParameters) {
                        ApiDispatcher.logInteractiveRequestParameters(":beginInteractive", (AcquireTokenOperationParameters)command.mParameters);
                    }
                    sCommand = command;
                    AcquireTokenResult result = null;
                    BaseException baseException = null;
                    try {
                        result = command.execute();
                    }
                    catch (Exception e) {
                        Logger.errorPII(TAG + ":beginInteractive", "Interactive request failed with Exception", e);
                        baseException = e instanceof BaseException ? (BaseException)e : ExceptionAdapter.baseExceptionFromException(e);
                    }
                    Handler handler = new Handler(Looper.getMainLooper());
                    if (baseException != null) {
                        final BaseException finalException = baseException;
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                command.getCallback().onError(finalException);
                            }
                        });
                    } else if (null != result && result.getSucceeded().booleanValue()) {
                        final ILocalAuthenticationResult authenticationResult = result.getLocalAuthenticationResult();
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                command.getCallback().onSuccess(authenticationResult);
                            }
                        });
                    } else {
                        baseException = ExceptionAdapter.exceptionFromAcquireTokenResult(result);
                        final BaseException finalException = baseException;
                        if (finalException instanceof UserCancelException) {
                            handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    command.getCallback().onCancel();
                                }
                            });
                        } else {
                            handler.post(new Runnable(){

                                @Override
                                public void run() {
                                    command.getCallback().onError(finalException);
                                }
                            });
                        }
                    }
                }
            });
        }
    }

    private static void logInteractiveRequestParameters(String methodName, AcquireTokenOperationParameters params) {
        Logger.verbose(TAG + methodName, "Requested " + params.getScopes().size() + " scopes");
        Logger.verbosePII(TAG + methodName, "----\nRequested scopes:");
        for (String string : params.getScopes()) {
            Logger.verbosePII(TAG + methodName, "\t" + string);
        }
        Logger.verbosePII(TAG + methodName, "----");
        Logger.verbosePII(TAG + methodName, "ClientId: [" + params.getClientId() + "]");
        Logger.verbosePII(TAG + methodName, "RedirectUri: [" + params.getRedirectUri() + "]");
        Logger.verbosePII(TAG + methodName, "Login hint: [" + params.getLoginHint() + "]");
        if (null != params.getExtraQueryStringParameters()) {
            Logger.verbosePII(TAG + methodName, "Extra query params:");
            for (Pair pair : params.getExtraQueryStringParameters()) {
                Logger.verbosePII(TAG + methodName, "\t\"" + (String)pair.first + "\":\"" + (String)pair.second + "\"");
            }
        }
        if (null != params.getExtraScopesToConsent()) {
            Logger.verbosePII(TAG + methodName, "Extra scopes to consent:");
            for (String string : params.getExtraScopesToConsent()) {
                Logger.verbosePII(TAG + methodName, "\t" + string);
            }
        }
        Logger.verbose(TAG + methodName, "Using authorization agent: " + params.getAuthorizationAgent().toString());
        if (null != params.getAccount()) {
            Logger.verbosePII(TAG + methodName, "Using account: " + params.getAccount().getHomeAccountId());
        }
    }

    private static void logSilentRequestParams(String methodName, AcquireTokenSilentOperationParameters parameters) {
        Logger.verbosePII(TAG + methodName, "ClientId: [" + parameters.getClientId() + "]");
        Logger.verbosePII(TAG + methodName, "----\nRequested scopes:");
        for (String scope : parameters.getScopes()) {
            Logger.verbosePII(TAG + methodName, "\t" + scope);
        }
        Logger.verbosePII(TAG + methodName, "----");
        if (null != parameters.getAccount()) {
            Logger.verbosePII(TAG + methodName, "Using account: " + parameters.getAccount().getHomeAccountId());
        }
        Logger.verbose(TAG + methodName, "Force refresh? [" + parameters.getForceRefresh() + "]");
    }

    public static void completeInteractive(int requestCode, int resultCode, Intent data) {
        sCommand.notify(requestCode, resultCode, data);
    }

    public static void submitSilent(final TokenCommand command) {
        String methodName = ":submitSilent";
        Logger.verbose(TAG + ":submitSilent", "Beginning silent request");
        sSilentExecutor.execute(new Runnable(){

            @Override
            public void run() {
                ApiDispatcher.initializeDiagnosticContext();
                if (command.mParameters instanceof AcquireTokenSilentOperationParameters) {
                    ApiDispatcher.logSilentRequestParams(":submitSilent", (AcquireTokenSilentOperationParameters)command.mParameters);
                }
                AcquireTokenResult result = null;
                BaseException baseException = null;
                try {
                    result = command.execute();
                }
                catch (Exception e) {
                    Logger.errorPII(TAG + ":submitSilent", "Silent request failed with Exception", e);
                    baseException = e instanceof BaseException ? (BaseException)e : ExceptionAdapter.baseExceptionFromException(e);
                }
                Handler handler = new Handler(Looper.getMainLooper());
                if (baseException != null) {
                    final BaseException finalException = baseException;
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            command.getCallback().onError(finalException);
                        }
                    });
                } else if (null != result && result.getSucceeded().booleanValue()) {
                    final ILocalAuthenticationResult authenticationResult = result.getLocalAuthenticationResult();
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            command.getCallback().onSuccess(authenticationResult);
                        }
                    });
                } else {
                    baseException = ExceptionAdapter.exceptionFromAcquireTokenResult(result);
                    final BaseException finalException = baseException;
                    if (finalException instanceof UserCancelException) {
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                command.getCallback().onCancel();
                            }
                        });
                    } else {
                        handler.post(new Runnable(){

                            @Override
                            public void run() {
                                command.getCallback().onError(finalException);
                            }
                        });
                    }
                }
            }
        });
    }

    public static String initializeDiagnosticContext() {
        String methodName = ":initializeDiagnosticContext";
        String correlationId = UUID.randomUUID().toString();
        RequestContext rc = new RequestContext();
        rc.put("correlation_id", correlationId);
        DiagnosticContext.setRequestContext(rc);
        Logger.verbose(TAG + ":initializeDiagnosticContext", "Initialized new DiagnosticContext");
        return correlationId;
    }
}

