/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import com.microsoft.identity.common.adal.internal.cache.StorageHelper;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.cache.AccountDeletionRecord;
import com.microsoft.identity.common.internal.cache.BrokerApplicationMetadata;
import com.microsoft.identity.common.internal.cache.CacheKeyValueDelegate;
import com.microsoft.identity.common.internal.cache.CacheRecord;
import com.microsoft.identity.common.internal.cache.IBrokerApplicationMetadataCache;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.cache.ISharedPreferencesFileManager;
import com.microsoft.identity.common.internal.cache.MicrosoftFamilyOAuth2TokenCache;
import com.microsoft.identity.common.internal.cache.MicrosoftStsAccountCredentialAdapter;
import com.microsoft.identity.common.internal.cache.MsalOAuth2TokenCache;
import com.microsoft.identity.common.internal.cache.SharedPreferencesAccountCredentialCache;
import com.microsoft.identity.common.internal.cache.SharedPreferencesFileManager;
import com.microsoft.identity.common.internal.dto.AccessTokenRecord;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import com.microsoft.identity.common.internal.dto.Credential;
import com.microsoft.identity.common.internal.dto.CredentialType;
import com.microsoft.identity.common.internal.dto.IdTokenRecord;
import com.microsoft.identity.common.internal.dto.RefreshTokenRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftAccount;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftRefreshToken;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftTokenResponse;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Strategy;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsTokenResponse;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2TokenCache;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class BrokerOAuth2TokenCache<GenericOAuth2Strategy extends OAuth2Strategy, GenericAuthorizationRequest extends AuthorizationRequest, GenericTokenResponse extends MicrosoftTokenResponse, GenericAccount extends MicrosoftAccount, GenericRefreshToken extends MicrosoftRefreshToken>
extends OAuth2TokenCache<GenericOAuth2Strategy, GenericAuthorizationRequest, GenericTokenResponse> {
    private static final String TAG = BrokerOAuth2TokenCache.class.getSimpleName();
    private static final String UNCHECKED = "unchecked";
    private final IBrokerApplicationMetadataCache mApplicationMetadataCache;
    private final MicrosoftFamilyOAuth2TokenCache mFociCache;
    private final int mCallingProcessUid;
    private ProcessUidCacheFactory mDelegate = null;

    public BrokerOAuth2TokenCache(@NonNull Context context, int callingProcessUid, @NonNull IBrokerApplicationMetadataCache applicationMetadataCache) {
        super(context);
        Logger.verbose(TAG + "ctor", "Init::" + TAG);
        this.mCallingProcessUid = callingProcessUid;
        this.mFociCache = BrokerOAuth2TokenCache.initializeFociCache(context);
        this.mApplicationMetadataCache = applicationMetadataCache;
    }

    @VisibleForTesting
    public BrokerOAuth2TokenCache(@NonNull Context context, int callingProcessUid, @NonNull IBrokerApplicationMetadataCache applicationMetadataCache, @NonNull ProcessUidCacheFactory delegate, @NonNull MicrosoftFamilyOAuth2TokenCache fociCache) {
        super(context);
        Logger.verbose(TAG + "ctor", "Init::" + TAG);
        this.mDelegate = delegate;
        this.mApplicationMetadataCache = applicationMetadataCache;
        this.mCallingProcessUid = callingProcessUid;
        this.mFociCache = fociCache;
    }

    public ICacheRecord save(@NonNull AccountRecord accountRecord, @NonNull IdTokenRecord idTokenRecord, @NonNull AccessTokenRecord accessTokenRecord, @Nullable String familyId) throws ClientException {
        ICacheRecord result;
        String methodName = ":save";
        boolean isFoci = !StringExtensions.isNullOrBlank(familyId);
        Logger.info(TAG + ":save", "Saving to FOCI cache? [" + isFoci + "}");
        if (isFoci) {
            result = this.mFociCache.save(accountRecord, idTokenRecord, accessTokenRecord);
        } else {
            MsalOAuth2TokenCache targetCache = this.getTokenCacheForClient(idTokenRecord.getClientId(), idTokenRecord.getEnvironment(), this.mCallingProcessUid);
            if (null == targetCache) {
                Logger.warn(TAG + ":save", "Existing cache not found. A new one will be created.");
                targetCache = this.initializeProcessUidCache(this.getContext(), this.mCallingProcessUid);
            }
            result = targetCache.save(accountRecord, idTokenRecord, accessTokenRecord);
        }
        this.updateApplicationMetadataCache(result.getAccessToken().getClientId(), result.getAccessToken().getEnvironment(), familyId, this.mCallingProcessUid);
        return result;
    }

    @Override
    public ICacheRecord save(@NonNull GenericOAuth2Strategy oAuth2Strategy, @NonNull GenericAuthorizationRequest request, @NonNull GenericTokenResponse response) throws ClientException {
        MsalOAuth2TokenCache targetCache;
        boolean isFoci;
        String methodName = ":save";
        boolean bl = isFoci = !StringExtensions.isNullOrBlank(((MicrosoftTokenResponse)response).getFamilyId());
        if (isFoci) {
            Logger.info(TAG + ":save", "Received FOCI value: [" + ((MicrosoftTokenResponse)response).getFamilyId() + "]");
        }
        Logger.info(TAG + ":save", "Saving to FOCI cache? [" + isFoci + "}");
        if (isFoci) {
            targetCache = this.mFociCache;
        } else {
            targetCache = this.getTokenCacheForClient(((AuthorizationRequest)request).getClientId(), ((OAuth2Strategy)oAuth2Strategy).getIssuerCacheIdentifier(request), this.mCallingProcessUid);
            if (null == targetCache) {
                Logger.warn(TAG + ":save", "Existing cache not found. A new one will be created.");
                targetCache = this.initializeProcessUidCache(this.getContext(), this.mCallingProcessUid);
            }
        }
        ICacheRecord result = ((OAuth2TokenCache)targetCache).save(oAuth2Strategy, request, response);
        this.updateApplicationMetadataCache(result.getRefreshToken().getClientId(), result.getRefreshToken().getEnvironment(), result.getRefreshToken().getFamilyId(), this.mCallingProcessUid);
        return result;
    }

    private void updateApplicationMetadataCache(@NonNull String clientId, @NonNull String environment, @Nullable String familyId, int callingProcessUid) {
        String methodName = ":updateApplicationMetadataCache";
        BrokerApplicationMetadata applicationMetadata = new BrokerApplicationMetadata();
        applicationMetadata.setClientId(clientId);
        applicationMetadata.setEnvironment(environment);
        applicationMetadata.setFoci(familyId);
        applicationMetadata.setUid(callingProcessUid);
        Logger.verbose(TAG + ":updateApplicationMetadataCache", "Adding cache entry for clientId: [" + clientId + "]");
        boolean success = this.mApplicationMetadataCache.insert(applicationMetadata);
        Logger.info(TAG + ":updateApplicationMetadataCache", "Cache updated successfully? [" + success + "]");
    }

    @Override
    public ICacheRecord save(@NonNull AccountRecord accountRecord, @NonNull IdTokenRecord idTokenRecord) {
        throw new UnsupportedOperationException("This method is unsupported.");
    }

    @Override
    public ICacheRecord load(@NonNull String clientId, @Nullable String target, @NonNull AccountRecord account) {
        String methodName = ":load";
        Logger.verbose(TAG + ":load", "Performing lookup in app-specific cache.");
        MsalOAuth2TokenCache targetCache = this.getTokenCacheForClient(clientId, account.getEnvironment(), this.mCallingProcessUid);
        boolean shouldUseFociCache = null == targetCache;
        ICacheRecord resultRecord = shouldUseFociCache ? this.mFociCache.loadByFamilyId(clientId, account) : ((OAuth2TokenCache)targetCache).load(clientId, target, account);
        boolean resultFound = null != resultRecord.getRefreshToken();
        Logger.verbose(TAG + ":load", "Result found? [" + resultFound + "]");
        return resultRecord;
    }

    @Override
    public boolean removeCredential(@NonNull Credential credential) {
        String methodName = ":removeCredential";
        MsalOAuth2TokenCache targetCache = this.getTokenCacheForClient(credential.getClientId(), credential.getEnvironment(), this.mCallingProcessUid);
        boolean removed = false;
        if (null != targetCache) {
            removed = ((OAuth2TokenCache)targetCache).removeCredential(credential);
        } else {
            Logger.warn(TAG + ":removeCredential", "Could not remove credential. Cache not found.");
        }
        Logger.verbose(TAG + ":removeCredential", "Credential removed? [" + removed + "]");
        return removed;
    }

    @Override
    @Nullable
    public AccountRecord getAccount(@Nullable String environment, @NonNull String clientId, @NonNull String homeAccountId, @Nullable String realm) {
        String methodName = ":getAccount";
        MsalOAuth2TokenCache targetCache = null;
        AccountRecord result = null;
        if (null != environment) {
            targetCache = this.getTokenCacheForClient(clientId, environment, this.mCallingProcessUid);
            if (null == targetCache) {
                Logger.verbose(TAG + ":getAccount", "Target cache was null. Using FOCI cache.");
                targetCache = this.mFociCache;
            }
            result = ((OAuth2TokenCache)targetCache).getAccount(environment, clientId, homeAccountId, realm);
        } else {
            List<OAuth2TokenCache> clientIdTokenCaches = this.getTokenCachesForClientId(clientId);
            Iterator<OAuth2TokenCache> cacheIterator = clientIdTokenCaches.iterator();
            while (null == result && cacheIterator.hasNext()) {
                result = cacheIterator.next().getAccount(environment, clientId, homeAccountId, realm);
            }
        }
        return result;
    }

    private List<OAuth2TokenCache> getTokenCachesForClientId(@NonNull String clientId) {
        List<BrokerApplicationMetadata> allMetadata = this.mApplicationMetadataCache.getAll();
        ArrayList<OAuth2TokenCache> result = new ArrayList<OAuth2TokenCache>();
        boolean containsFoci = false;
        for (BrokerApplicationMetadata metadata : allMetadata) {
            if (!clientId.equals(metadata.getClientId())) continue;
            if (null != metadata.getFoci() && !containsFoci) {
                result.add(this.mFociCache);
                containsFoci = true;
                continue;
            }
            MsalOAuth2TokenCache candidateCache = this.getTokenCacheForClient(metadata.getClientId(), metadata.getEnvironment(), this.mCallingProcessUid);
            if (null == candidateCache) continue;
            result.add(candidateCache);
        }
        return result;
    }

    @Override
    @Nullable
    public AccountRecord getAccountWithLocalAccountId(@Nullable String environment, @NonNull String clientId, @NonNull String localAccountId) {
        String methodName = ":getAccountWithLocalAccountId";
        Logger.verbose(TAG + ":getAccountWithLocalAccountId", "Loading account by local account id.");
        if (null != environment) {
            MsalOAuth2TokenCache targetCache = this.getTokenCacheForClient(clientId, environment, this.mCallingProcessUid);
            if (null != targetCache) {
                return ((OAuth2TokenCache)targetCache).getAccountWithLocalAccountId(environment, clientId, localAccountId);
            }
            return this.mFociCache.getAccountWithLocalAccountId(environment, clientId, localAccountId);
        }
        AccountRecord result = null;
        List<OAuth2TokenCache> cachesToInspect = this.getTokenCachesForClientId(clientId);
        Iterator<OAuth2TokenCache> cacheIterator = cachesToInspect.iterator();
        while (null == result && cacheIterator.hasNext()) {
            result = cacheIterator.next().getAccountWithLocalAccountId(environment, clientId, localAccountId);
        }
        return result;
    }

    @Override
    public List<AccountRecord> getAccounts(@Nullable String environment, @NonNull String clientId) {
        String methodName = ":getAccounts (2 param)";
        ArrayList<AccountRecord> result = new ArrayList<AccountRecord>();
        if (null != environment) {
            MsalOAuth2TokenCache targetCache = this.getTokenCacheForClient(clientId, environment, this.mCallingProcessUid);
            if (null != targetCache) {
                result.addAll(((OAuth2TokenCache)targetCache).getAccounts(environment, clientId));
            } else {
                Logger.warn(TAG + ":getAccounts (2 param)", "No caches to inspect.");
            }
        } else {
            List<OAuth2TokenCache> cachesToInspect = this.getTokenCachesForClientId(clientId);
            for (OAuth2TokenCache cache : cachesToInspect) {
                result.addAll(cache.getAccounts(environment, clientId));
            }
            Logger.verbose(TAG + ":getAccounts (2 param)", "Found [" + result.size() + "] accounts.");
        }
        return result;
    }

    public List<AccountRecord> getAccounts() {
        String methodName = ":getAccounts";
        HashSet<AccountRecord> allAccounts = new HashSet<AccountRecord>();
        List<BrokerApplicationMetadata> allMetadata = this.mApplicationMetadataCache.getAll();
        for (BrokerApplicationMetadata metadata : allMetadata) {
            MsalOAuth2TokenCache candidateCache = this.getTokenCacheForClient(metadata.getClientId(), metadata.getEnvironment(), metadata.getUid());
            if (null == candidateCache) continue;
            allAccounts.addAll(candidateCache.getAccountCredentialCache().getAccounts());
        }
        allAccounts.addAll(this.mFociCache.getAccountCredentialCache().getAccounts());
        ArrayList<AccountRecord> allAccountsResult = new ArrayList<AccountRecord>(allAccounts);
        Logger.verbose(TAG + ":getAccounts", "Found [" + allAccountsResult.size() + "] accounts.");
        return allAccountsResult;
    }

    public AccountDeletionRecord removeAccountFromDevice(@NonNull AccountRecord accountRecord) {
        String methodName = ":removeAccountFromDevice";
        if (null == accountRecord) {
            Logger.error(TAG + ":removeAccountFromDevice", "Illegal arg. Cannot delete a null AccountRecord!", null);
            throw new IllegalArgumentException("AccountRecord may not be null.");
        }
        Set<String> allClientIds = this.mApplicationMetadataCache.getAllClientIds();
        Logger.info(TAG + ":removeAccountFromDevice", "Found [" + allClientIds.size() + "] client ids.");
        ArrayList<AccountDeletionRecord> deletionRecordList = new ArrayList<AccountDeletionRecord>();
        for (String clientId : allClientIds) {
            deletionRecordList.add(this.removeAccountInternal(accountRecord.getEnvironment(), clientId, accountRecord.getHomeAccountId(), null, true));
        }
        ArrayList<AccountRecord> deletedAccountRecords = new ArrayList<AccountRecord>();
        for (AccountDeletionRecord accountDeletionRecord : deletionRecordList) {
            deletedAccountRecords.addAll(accountDeletionRecord);
        }
        Logger.info(TAG + ":removeAccountFromDevice", "Deleted [" + deletedAccountRecords.size() + "] AccountRecords.");
        return new AccountDeletionRecord(deletedAccountRecords);
    }

    @Override
    public AccountDeletionRecord removeAccount(@Nullable String environment, @Nullable String clientId, @Nullable String homeAccountId, @Nullable String realm) {
        return this.removeAccountInternal(environment, clientId, homeAccountId, realm, false);
    }

    public boolean isClientIdKnownToCache(@NonNull String clientId) {
        return this.getAllClientIds().contains(clientId);
    }

    public List<ICacheRecord> getFociCacheRecords() {
        ArrayList<ICacheRecord> result = new ArrayList<ICacheRecord>();
        List<BrokerApplicationMetadata> allFociApplicationMetadata = this.mApplicationMetadataCache.getAllFociApplicationMetadata();
        for (BrokerApplicationMetadata fociAppMetadata : allFociApplicationMetadata) {
            List<AccountRecord> accounts = this.mFociCache.getAccounts(fociAppMetadata.getEnvironment(), fociAppMetadata.getClientId());
            for (AccountRecord account : accounts) {
                List<Credential> refreshTokens = this.mFociCache.getAccountCredentialCache().getCredentialsFilteredBy(account.getHomeAccountId(), account.getEnvironment(), CredentialType.RefreshToken, fociAppMetadata.getClientId(), null, null);
                if (refreshTokens.isEmpty()) continue;
                CacheRecord cacheRecord = new CacheRecord();
                cacheRecord.setAccount(account);
                cacheRecord.setRefreshToken((RefreshTokenRecord)refreshTokens.get(0));
                result.add(cacheRecord);
            }
        }
        return result;
    }

    private AccountDeletionRecord removeAccountInternal(@Nullable String environment, @Nullable String clientId, @Nullable String homeAccountId, @Nullable String realm, boolean deviceWide) {
        String methodName = ":removeAccountInternal";
        List<BrokerApplicationMetadata> allMetadata = this.mApplicationMetadataCache.getAll();
        ArrayList<AccountDeletionRecord> deletionRecordList = new ArrayList<AccountDeletionRecord>();
        for (BrokerApplicationMetadata metadata : allMetadata) {
            MsalOAuth2TokenCache candidateCache = this.getTokenCacheForClient(metadata.getClientId(), metadata.getEnvironment(), deviceWide ? metadata.getUid() : this.mCallingProcessUid);
            if (null == candidateCache) continue;
            deletionRecordList.add(((OAuth2TokenCache)candidateCache).removeAccount(environment, clientId, homeAccountId, realm));
        }
        ArrayList<AccountRecord> deletedAccountRecords = new ArrayList<AccountRecord>();
        for (AccountDeletionRecord accountDeletionRecord : deletionRecordList) {
            deletedAccountRecords.addAll(accountDeletionRecord);
        }
        Logger.info(TAG + ":removeAccountInternal", "Deleted [" + deletedAccountRecords.size() + "] AccountRecords.");
        return new AccountDeletionRecord(deletedAccountRecords);
    }

    @Override
    protected Set<String> getAllClientIds() {
        return this.mApplicationMetadataCache.getAllClientIds();
    }

    private MsalOAuth2TokenCache initializeProcessUidCache(@NonNull Context context, int bindingProcessUid) {
        String methodName = ":initializeProcessUidCache";
        Logger.verbose(TAG + ":initializeProcessUidCache", "Initializing uid cache.");
        if (null != this.mDelegate) {
            Logger.warn(TAG + ":initializeProcessUidCache", "Using swapped delegate cache.");
            return this.mDelegate.getTokenCache(context, bindingProcessUid);
        }
        StorageHelper storageHelper = new StorageHelper(context);
        SharedPreferencesFileManager sharedPreferencesFileManager = new SharedPreferencesFileManager(context, SharedPreferencesAccountCredentialCache.getBrokerUidSequesteredFilename(bindingProcessUid), storageHelper);
        return BrokerOAuth2TokenCache.getTokenCache(context, sharedPreferencesFileManager, false);
    }

    private static MicrosoftFamilyOAuth2TokenCache initializeFociCache(@NonNull Context context) {
        String methodName = ":initializeFociCache";
        Logger.verbose(TAG + ":initializeFociCache", "Initializing foci cache");
        StorageHelper storageHelper = new StorageHelper(context);
        SharedPreferencesFileManager sharedPreferencesFileManager = new SharedPreferencesFileManager(context, "com.microsoft.identity.client.account_credential_cache.foci-1", storageHelper);
        return (MicrosoftFamilyOAuth2TokenCache)BrokerOAuth2TokenCache.getTokenCache(context, sharedPreferencesFileManager, true);
    }

    private static <T extends MsalOAuth2TokenCache> T getTokenCache(@NonNull Context context, @NonNull ISharedPreferencesFileManager spfm, boolean isFoci) {
        CacheKeyValueDelegate cacheKeyValueDelegate = new CacheKeyValueDelegate();
        SharedPreferencesAccountCredentialCache accountCredentialCache = new SharedPreferencesAccountCredentialCache(cacheKeyValueDelegate, spfm);
        MicrosoftStsAccountCredentialAdapter accountCredentialAdapter = new MicrosoftStsAccountCredentialAdapter();
        return (T)(isFoci ? new MicrosoftFamilyOAuth2TokenCache<MicrosoftStsOAuth2Strategy, MicrosoftStsAuthorizationRequest, MicrosoftStsTokenResponse, MicrosoftAccount, MicrosoftRefreshToken>(context, accountCredentialCache, accountCredentialAdapter) : new MsalOAuth2TokenCache<MicrosoftStsOAuth2Strategy, MicrosoftStsAuthorizationRequest, MicrosoftStsTokenResponse, MicrosoftAccount, MicrosoftRefreshToken>(context, accountCredentialCache, accountCredentialAdapter));
    }

    @Nullable
    private MsalOAuth2TokenCache getTokenCacheForClient(@NonNull String clientId, @NonNull String environment, int callingProcessUid) {
        String methodName = ":getTokenCacheForClient";
        BrokerApplicationMetadata metadata = this.mApplicationMetadataCache.getMetadata(clientId, environment, callingProcessUid);
        MsalOAuth2TokenCache targetCache = null;
        if (null != metadata) {
            boolean isFoci = null != metadata.getFoci();
            Logger.verbose(TAG + ":getTokenCacheForClient", "is Foci? [" + isFoci + "]");
            targetCache = isFoci ? this.mFociCache : this.initializeProcessUidCache(this.getContext(), callingProcessUid);
        }
        if (null == targetCache) {
            Logger.warn(TAG + ":getTokenCacheForClient", "Could not locate a cache for this app.");
        }
        return targetCache;
    }

    public void setSingleSignOnState(@NonNull String uidStr, @NonNull GenericAccount account, @NonNull GenericRefreshToken refreshToken) {
        MsalOAuth2TokenCache targetCache;
        String methodName = ":setSingleSignOnState";
        boolean isFrt = ((MicrosoftRefreshToken)refreshToken).getIsFamilyRefreshToken();
        int uid = Integer.valueOf(uidStr);
        if (isFrt) {
            Logger.verbose(TAG + ":setSingleSignOnState", "Saving tokens to foci cache.");
            targetCache = this.mFociCache;
        } else {
            targetCache = this.getTokenCacheForClient(((MicrosoftRefreshToken)refreshToken).getClientId(), ((MicrosoftRefreshToken)refreshToken).getEnvironment(), this.mCallingProcessUid);
            if (null == targetCache) {
                Logger.verbose(TAG + ":setSingleSignOnState", "Existing cache could not be found. Creating a new one...");
                targetCache = this.initializeProcessUidCache(this.getContext(), uid);
            }
        }
        try {
            targetCache.setSingleSignOnState(account, refreshToken);
            this.updateApplicationMetadataCache(((MicrosoftRefreshToken)refreshToken).getClientId(), ((MicrosoftRefreshToken)refreshToken).getEnvironment(), ((MicrosoftRefreshToken)refreshToken).getFamilyId(), uid);
        }
        catch (ClientException e) {
            Logger.warn(TAG + ":setSingleSignOnState", "Failed to save account/refresh token. Skipping.");
        }
    }

    @VisibleForTesting
    public static interface ProcessUidCacheFactory {
        public MsalOAuth2TokenCache getTokenCache(Context var1, int var2);
    }
}

