/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.adal.internal.util;

import android.accounts.AccountManager;
import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Bundle;
import android.util.Base64;
import com.microsoft.identity.common.adal.internal.ADALError;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.logging.Logger;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class PackageHelper {
    private static final String TAG = "CallerInfo";
    private Context mContext;
    private final AccountManager mAcctManager;

    public PackageHelper(Context ctx) {
        this.mContext = ctx;
        this.mAcctManager = AccountManager.get((Context)this.mContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressLint(value={"WrongConstant"})
    Object getValueFromMetaData(String packageName, ComponentName component, String metaDataName) {
        String methodName = "getValueFromMetadata";
        try {
            Logger.info(TAG + methodName, "Calling package:" + packageName);
            if (component != null) {
                Logger.verbose(TAG + methodName, "component:" + component.flattenToString());
                ActivityInfo ai = this.mContext.getPackageManager().getActivityInfo(component, 129);
                if (ai == null) return null;
                Bundle metaData = ai.metaData;
                if (metaData != null) return metaData.get(metaDataName);
                Logger.verbose(TAG + methodName, "metaData is null. Unable to get meta data for " + metaDataName);
                return null;
            } else {
                Logger.verbose(TAG + methodName, "calling component is null.");
            }
            return null;
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.error(TAG + methodName, "ActivityInfo is not found", e);
        }
        return null;
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    public String getCurrentSignatureForPackage(String packagename) {
        String methodName = "getCurrentSignatureForPackage";
        try {
            PackageInfo info = this.mContext.getPackageManager().getPackageInfo(packagename, 64);
            if (info != null && info.signatures != null && info.signatures.length > 0) {
                Signature signature = info.signatures[0];
                MessageDigest md = MessageDigest.getInstance("SHA");
                md.update(signature.toByteArray());
                return Base64.encodeToString((byte[])md.digest(), (int)2);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.error(TAG + methodName, "Calling App's package does not exist in PackageManager.", e);
        }
        catch (NoSuchAlgorithmException e) {
            Logger.error(TAG + methodName, "Digest SHA algorithm does not exists. ", e);
        }
        return null;
    }

    public int getUIDForPackage(String packageName) {
        String methodName = "getUIDForPackage";
        int callingUID = 0;
        try {
            ApplicationInfo info = this.mContext.getPackageManager().getApplicationInfo(packageName, 0);
            if (info != null) {
                callingUID = info.uid;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.error(TAG + methodName, "Package is not found. Package name: " + packageName, e);
        }
        return callingUID;
    }

    public boolean isPackageInstalledAndEnabled(String packageName) {
        String methodName = "#isPackageInstalledAndEnabled";
        boolean enabled = false;
        PackageManager pm = this.mContext.getPackageManager();
        try {
            ApplicationInfo applicationInfo = pm.getApplicationInfo(packageName, 0);
            if (applicationInfo != null) {
                enabled = applicationInfo.enabled;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.error("CallerInfo#isPackageInstalledAndEnabled", "Package is not found. Package name: " + packageName, e);
        }
        Logger.verbose("CallerInfo#isPackageInstalledAndEnabled", " Is package installed and enabled? [" + enabled + "]");
        return enabled;
    }

    public static String getBrokerRedirectUrl(String packageName, String signatureDigest) {
        String methodName = "getBrokerRedirectUrl";
        if (!StringExtensions.isNullOrBlank(packageName) && !StringExtensions.isNullOrBlank(signatureDigest)) {
            if (packageName.equals("com.azure.authenticator") && signatureDigest.equals("ho040S3ffZkmxqtQrSwpTVOn9r0=")) {
                return "urn:ietf:wg:oauth:2.0:oob";
            }
            try {
                return String.format("%s://%s/%s", "msauth", URLEncoder.encode(packageName, "UTF-8"), URLEncoder.encode(signatureDigest, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                Logger.error(TAG + methodName, ADALError.ENCODING_IS_NOT_SUPPORTED.getDescription(), e);
            }
        }
        return "";
    }
}

