/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.switchbrowser;

import android.net.Uri;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.logging.Logger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u000e\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0004J6\u0010\n\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00042$\b\u0002\u0010\u000b\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\fj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004`\rH\u0002J \u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/microsoft/identity/common/internal/ui/webview/switchbrowser/SwitchBrowserUriHelper;", "", "()V", "TAG", "", "buildProcessUri", "Landroid/net/Uri;", "uri", "buildResumeUri", "actionUri", "buildSwitchBrowserUri", "queryParams", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "isSwitchBrowserRedirectUrl", "", "url", "redirectUrl", "switchBrowserPath", "common_distRelease"})
public final class SwitchBrowserUriHelper {
    @NotNull
    public static final SwitchBrowserUriHelper INSTANCE = new SwitchBrowserUriHelper();
    @NotNull
    private static final String TAG = "SwitchBrowserUriHelper";

    private SwitchBrowserUriHelper() {
    }

    @NotNull
    public final Uri buildProcessUri(@NotNull Uri uri) throws ClientException, IllegalArgumentException, NullPointerException, UnsupportedOperationException {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String methodTag = "SwitchBrowserUriHelper:buildProcessUri";
        String code = uri.getQueryParameter("code");
        CharSequence charSequence = code;
        if (charSequence == null || charSequence.length() == 0) {
            String errorMessage = "switch browser code is null or empty";
            ClientException exception = new ClientException("malformed_url", errorMessage);
            Logger.error(methodTag, errorMessage, (Throwable)exception);
            throw exception;
        }
        String actionUri = uri.getQueryParameter("action_uri");
        CharSequence exception = actionUri;
        if (exception == null || exception.length() == 0) {
            String errorMessage = "switch browser action uri is null or empty";
            ClientException exception2 = new ClientException("malformed_url", errorMessage);
            Logger.error(methodTag, errorMessage, (Throwable)exception2);
            throw exception2;
        }
        HashMap<String, String> queryParams = new HashMap<String, String>();
        ((Map)queryParams).put("code", code);
        return this.buildSwitchBrowserUri(actionUri, queryParams);
    }

    private final Uri buildSwitchBrowserUri(String actionUri, HashMap<String, String> queryParams) throws IllegalArgumentException, NullPointerException, UnsupportedOperationException {
        String[] stringArray = new String[]{"/"};
        List paths = StringsKt.split$default((CharSequence)actionUri, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        String authority = (String)paths.get(0);
        Uri.Builder uriBuilder = new Uri.Builder().scheme("https").encodedAuthority(authority);
        int n = paths.size();
        for (int i = 1; i < n; ++i) {
            uriBuilder.appendPath((String)paths.get(i));
        }
        for (Map.Entry<String, String> entry : queryParams.entrySet()) {
            Intrinsics.checkNotNullExpressionValue(entry, (String)"queryParams.entries");
            String key = entry.getKey();
            String value = entry.getValue();
            uriBuilder.appendQueryParameter(key, value);
        }
        Uri uri = uriBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"uriBuilder.build()");
        return uri;
    }

    static /* synthetic */ Uri buildSwitchBrowserUri$default(SwitchBrowserUriHelper switchBrowserUriHelper, String string2, HashMap hashMap, int n, Object object) throws IllegalArgumentException, NullPointerException, UnsupportedOperationException {
        if ((n & 2) != 0) {
            hashMap = new HashMap<String, String>();
        }
        return switchBrowserUriHelper.buildSwitchBrowserUri(string2, hashMap);
    }

    @NotNull
    public final Uri buildResumeUri(@NotNull String actionUri) {
        Intrinsics.checkNotNullParameter((Object)actionUri, (String)"actionUri");
        return SwitchBrowserUriHelper.buildSwitchBrowserUri$default(this, actionUri, null, 2, null);
    }

    public final boolean isSwitchBrowserRedirectUrl(@Nullable String url, @NotNull String redirectUrl, @NotNull String switchBrowserPath) {
        Intrinsics.checkNotNullParameter((Object)redirectUrl, (String)"redirectUrl");
        Intrinsics.checkNotNullParameter((Object)switchBrowserPath, (String)"switchBrowserPath");
        if (url == null) {
            return false;
        }
        String expectedUrl = redirectUrl + '/' + switchBrowserPath;
        return StringsKt.startsWith((String)url, (String)expectedUrl, (boolean)true);
    }
}

