/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.challengehandlers;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.microsoft.identity.common.internal.ui.browser.AndroidBrowserSelector;
import com.microsoft.identity.common.internal.ui.browser.CustomTabsManager;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.IChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.SwitchBrowserChallenge;
import com.microsoft.identity.common.internal.ui.webview.switchbrowser.SwitchBrowserUriHelper;
import com.microsoft.identity.common.java.browser.Browser;
import com.microsoft.identity.common.java.browser.IBrowserSelector;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.opentelemetry.OTelUtility;
import com.microsoft.identity.common.java.opentelemetry.SpanExtension;
import com.microsoft.identity.common.java.opentelemetry.SpanName;
import com.microsoft.identity.common.java.ui.BrowserDescriptor;
import com.microsoft.identity.common.logging.Logger;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 !2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001!B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB/\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u001a\u001a\u00020\u00112\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001cJ\u0010\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0002H\u0016J\u0006\u0010 \u001a\u00020\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0014\u001a\u00020\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/microsoft/identity/common/internal/ui/webview/challengehandlers/SwitchBrowserRequestHandler;", "Lcom/microsoft/identity/common/internal/ui/webview/challengehandlers/IChallengeHandler;", "Lcom/microsoft/identity/common/internal/ui/webview/challengehandlers/SwitchBrowserChallenge;", "", "activity", "Landroid/app/Activity;", "spanContext", "Lio/opentelemetry/api/trace/SpanContext;", "(Landroid/app/Activity;Lio/opentelemetry/api/trace/SpanContext;)V", "context", "Landroid/content/Context;", "customTabsManager", "Lcom/microsoft/identity/common/internal/ui/browser/CustomTabsManager;", "browserSelector", "Lcom/microsoft/identity/common/java/browser/IBrowserSelector;", "(Landroid/app/Activity;Landroid/content/Context;Lcom/microsoft/identity/common/internal/ui/browser/CustomTabsManager;Lcom/microsoft/identity/common/java/browser/IBrowserSelector;Lio/opentelemetry/api/trace/SpanContext;)V", "<set-?>", "", "isChallengeHandled", "()Z", "span", "Lio/opentelemetry/api/trace/Span;", "getSpan", "()Lio/opentelemetry/api/trace/Span;", "span$delegate", "Lkotlin/Lazy;", "isSwitchBrowserRequest", "url", "", "redirectUrl", "processChallenge", "switchBrowserChallenge", "resetChallengeState", "Companion", "common_distRelease"})
public final class SwitchBrowserRequestHandler
implements IChallengeHandler<SwitchBrowserChallenge, Unit> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Activity activity;
    @NotNull
    private final Context context;
    @NotNull
    private final CustomTabsManager customTabsManager;
    @NotNull
    private final IBrowserSelector browserSelector;
    @Nullable
    private final SpanContext spanContext;
    @NotNull
    private final Lazy span$delegate;
    private boolean isChallengeHandled;
    @Nullable
    private static final String TAG = Reflection.getOrCreateKotlinClass(SwitchBrowserRequestHandler.class).getSimpleName();

    public SwitchBrowserRequestHandler(@NotNull Activity activity, @NotNull Context context, @NotNull CustomTabsManager customTabsManager, @NotNull IBrowserSelector browserSelector, @Nullable SpanContext spanContext) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)customTabsManager, (String)"customTabsManager");
        Intrinsics.checkNotNullParameter((Object)browserSelector, (String)"browserSelector");
        this.activity = activity;
        this.context = context;
        this.customTabsManager = customTabsManager;
        this.browserSelector = browserSelector;
        this.spanContext = spanContext;
        this.span$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Span>(this){
            final /* synthetic */ SwitchBrowserRequestHandler this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Span invoke() {
                Span span2 = OTelUtility.createSpanFromParent((String)SpanName.SwitchBrowserProcess.name(), (SpanContext)SwitchBrowserRequestHandler.access$getSpanContext$p(this.this$0));
                Intrinsics.checkNotNullExpressionValue((Object)span2, (String)"createSpanFromParent(Spa\u2026rocess.name, spanContext)");
                return span2;
            }
        }));
    }

    @NotNull
    public final Span getSpan() {
        Lazy lazy = this.span$delegate;
        return (Span)lazy.getValue();
    }

    public final boolean isChallengeHandled() {
        return this.isChallengeHandled;
    }

    public SwitchBrowserRequestHandler(@NotNull Activity activity, @Nullable SpanContext spanContext) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Context context = activity.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"activity.applicationContext");
        this(activity, context, new CustomTabsManager(activity.getApplicationContext()), new AndroidBrowserSelector(activity.getApplicationContext()), spanContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processChallenge(@NotNull SwitchBrowserChallenge switchBrowserChallenge) throws ClientException {
        Intrinsics.checkNotNullParameter((Object)switchBrowserChallenge, (String)"switchBrowserChallenge");
        AutoCloseable autoCloseable = (AutoCloseable)SpanExtension.makeCurrentSpan((Span)this.getSpan());
        Throwable throwable = null;
        try {
            Scope it = (Scope)autoCloseable;
            boolean bl = false;
            String methodTag = TAG + ":processChallenge";
            Browser browser = this.browserSelector.selectBrowser(BrowserDescriptor.getBrowserSafeListForSwitchBrowser(), null);
            if (browser == null) {
                ClientException exception = new ClientException("no_browsers_available", "No browser found for SwitchBrowserChallenge.");
                Logger.error(methodTag, "No browser found for SwitchBrowserChallenge.", (Throwable)exception);
                this.getSpan().setStatus(StatusCode.ERROR);
                this.getSpan().recordException((Throwable)exception);
                this.getSpan().end();
                throw exception;
            }
            Intent browserIntent = null;
            if (browser.isCustomTabsServiceSupported()) {
                Logger.info(methodTag, "CustomTabsService is supported.");
                if (!this.customTabsManager.bind(this.context, browser.getPackageName())) {
                    Logger.warn(methodTag, "Failed to bind CustomTabsService.");
                    browserIntent = new Intent("android.intent.action.VIEW");
                } else {
                    Intent intent = this.customTabsManager.getCustomTabsIntent().intent;
                    Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"customTabsManager.customTabsIntent.intent");
                    browserIntent = intent;
                }
            } else {
                Logger.warn(methodTag, "CustomTabsService is NOT supported");
                browserIntent = new Intent("android.intent.action.VIEW");
            }
            Logger.info(methodTag, "Launching switch browser request on browser: " + browser.getPackageName());
            browserIntent.setPackage(browser.getPackageName());
            browserIntent.setData(switchBrowserChallenge.getUri());
            this.activity.startActivity(browserIntent);
            this.isChallengeHandled = true;
            this.getSpan().setAttribute(AttributeName.is_switch_browser_request_handled.name(), this.isChallengeHandled);
            this.getSpan().setAttribute(AttributeName.browser_package_name.name(), browser.getPackageName());
            this.getSpan().setAttribute(AttributeName.is_custom_tabs_supported.name(), browser.isCustomTabsServiceSupported());
            this.getSpan().setStatus(StatusCode.OK);
            this.getSpan().end();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    public final boolean isSwitchBrowserRequest(@Nullable String url, @NotNull String redirectUrl) {
        Intrinsics.checkNotNullParameter((Object)redirectUrl, (String)"redirectUrl");
        return SwitchBrowserUriHelper.INSTANCE.isSwitchBrowserRedirectUrl(url, redirectUrl, "switch_browser");
    }

    public final void resetChallengeState() {
        this.customTabsManager.unbind();
        this.isChallengeHandled = false;
    }

    public static final /* synthetic */ SpanContext access$getSpanContext$p(SwitchBrowserRequestHandler $this) {
        return $this.spanContext;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/microsoft/identity/common/internal/ui/webview/challengehandlers/SwitchBrowserRequestHandler$Companion;", "", "()V", "TAG", "", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

