/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.crypto;

import android.content.Context;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import androidx.annotation.RequiresApi;
import com.microsoft.identity.common.internal.util.AndroidKeyStoreUtil;
import com.microsoft.identity.common.java.crypto.key.AES256KeyLoader;
import com.microsoft.identity.common.java.crypto.key.KeyUtil;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.flighting.CommonFlight;
import com.microsoft.identity.common.java.flighting.CommonFlightsManager;
import com.microsoft.identity.common.java.flighting.IFlightConfig;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.opentelemetry.OTelUtility;
import com.microsoft.identity.common.java.opentelemetry.SpanExtension;
import com.microsoft.identity.common.java.opentelemetry.SpanName;
import com.microsoft.identity.common.java.util.CachedData;
import com.microsoft.identity.common.java.util.FileUtil;
import com.microsoft.identity.common.logging.Logger;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.io.File;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import java.util.Locale;
import javax.crypto.SecretKey;
import javax.security.auth.x500.X500Principal;
import lombok.NonNull;

public class AndroidWrappedKeyLoader
extends AES256KeyLoader {
    private static final String TAG = AndroidWrappedKeyLoader.class.getSimpleName() + "#";
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static boolean sSkipKeyInvalidationCheck = false;
    private static final String WRAP_ALGORITHM = "RSA/ECB/PKCS1Padding";
    private static final String WRAP_KEY_ALGORITHM = "RSA";
    public static final String WRAPPED_KEY_KEY_IDENTIFIER = "A001";
    static final int KEY_FILE_SIZE = 1024;
    private final Context mContext;
    private final String mAlias;
    private final String mFilePath;
    private final CachedData<SecretKey> mKeyCache = new CachedData<SecretKey>(){

        public SecretKey getData() {
            if (!(sSkipKeyInvalidationCheck || AndroidKeyStoreUtil.canLoadKey(AndroidWrappedKeyLoader.this.mAlias) && AndroidWrappedKeyLoader.this.getKeyFile().exists())) {
                this.clear();
            }
            return (SecretKey)super.getData();
        }
    };

    @NonNull
    CachedData<SecretKey> getKeyCache() {
        return this.mKeyCache;
    }

    public AndroidWrappedKeyLoader(@NonNull String alias, @NonNull String filePath, @NonNull Context context) {
        if (alias == null) {
            throw new NullPointerException("alias is marked non-null but is null");
        }
        if (filePath == null) {
            throw new NullPointerException("filePath is marked non-null but is null");
        }
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.mAlias = alias;
        this.mFilePath = filePath;
        this.mContext = context;
    }

    @NonNull
    public String getAlias() {
        return this.mAlias;
    }

    @NonNull
    public String getKeyTypeIdentifier() {
        return WRAPPED_KEY_KEY_IDENTIFIER;
    }

    @NonNull
    public synchronized SecretKey getKey() throws ClientException {
        SecretKey key = (SecretKey)this.mKeyCache.getData();
        if (key == null) {
            key = this.readSecretKeyFromStorage();
        }
        if (key == null) {
            key = this.generateRandomKey();
        }
        this.mKeyCache.setData((Object)key);
        return key;
    }

    @NonNull
    protected SecretKey generateRandomKey() throws ClientException {
        String methodTag = TAG + ":generateRandomKey";
        SecretKey key = super.generateRandomKey();
        this.saveSecretKeyToStorage(key);
        Logger.info(methodTag, "New key is generated with thumbprint: " + KeyUtil.getKeyThumbPrint((SecretKey)key));
        return key;
    }

    @Nullable
    synchronized SecretKey readSecretKeyFromStorage() throws ClientException {
        String methodTag = TAG + ":readSecretKeyFromStorage";
        try {
            KeyPair keyPair = AndroidKeyStoreUtil.readKey(this.mAlias);
            if (keyPair == null) {
                Logger.info(methodTag, "key does not exist in keystore");
                this.deleteSecretKeyFromStorage();
                return null;
            }
            byte[] wrappedSecretKey = FileUtil.readFromFile((File)this.getKeyFile(), (int)1024);
            if (wrappedSecretKey == null) {
                Logger.warn(methodTag, "Key file is empty");
                FileUtil.deleteFile((File)this.getKeyFile());
                this.mKeyCache.clear();
                return null;
            }
            SecretKey key = AndroidKeyStoreUtil.unwrap(wrappedSecretKey, this.getKeySpecAlgorithm(), keyPair, WRAP_ALGORITHM);
            Logger.info(methodTag, "Key is loaded with thumbprint: " + KeyUtil.getKeyThumbPrint((SecretKey)key));
            return key;
        }
        catch (ClientException e) {
            Logger.warn(methodTag, "Error when loading key from Storage, wipe all existing key data ");
            this.deleteSecretKeyFromStorage();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSecretKeyToStorage(@NonNull SecretKey unencryptedKey) throws ClientException {
        if (unencryptedKey == null) {
            throw new NullPointerException("unencryptedKey is marked non-null but is null");
        }
        String methodTag = TAG + ":saveSecretKeyToStorage";
        KeyPair keyPair = AndroidKeyStoreUtil.readKey(this.mAlias);
        if (keyPair == null) {
            Logger.info(methodTag, "No existing keypair. Generating a new one.");
            if (Build.VERSION.SDK_INT >= 28 && CommonFlightsManager.INSTANCE.getFlightsProvider().isFlightEnabled((IFlightConfig)CommonFlight.ENABLE_NEW_KEY_GEN_SPEC_FOR_WRAP)) {
                long keypairGenStartTime = System.currentTimeMillis();
                Span span2 = OTelUtility.createSpanFromParent((String)SpanName.KeyPairGeneration.name(), (SpanContext)SpanExtension.current().getSpanContext());
                try (Scope scope = SpanExtension.makeCurrentSpan((Span)span2);){
                    keyPair = this.attemptKeyPairGeneration(this.mAlias, true, keypairGenStartTime);
                    Logger.info(methodTag, "Successfully generated keypair with new KeyPairGeneratorSpec with wrap purpose.");
                    span2.setAttribute(AttributeName.key_pair_gen_successful_method.name(), "new_key_gen_spec_with_wrap");
                    span2.setStatus(StatusCode.OK);
                }
                catch (ProviderException e) {
                    if ("SecureKeyImportUnavailableException".equals(e.getClass().getSimpleName())) {
                        Logger.warn(methodTag, "Wrap purpose may not be supported. Retrying without wrap.");
                        try {
                            keyPair = this.attemptKeyPairGeneration(this.mAlias, false, keypairGenStartTime);
                            Logger.info(methodTag, "Successfully generated keypair with new KeyPairGeneratorSpec without wrap purpose.");
                            span2.setAttribute(AttributeName.key_pair_gen_successful_method.name(), "new_key_gen_spec_without_wrap");
                            span2.setStatus(StatusCode.OK);
                        }
                        catch (Exception ex) {
                            Logger.warn(methodTag, "Second attempt without wrap also failed. Falling back to legacy spec." + ex);
                            keyPair = this.generateKeyPairWithLegacySpec(this.mAlias, keypairGenStartTime);
                            if (e.getMessage() != null) {
                                span2.setAttribute(AttributeName.keypair_gen_exception.name(), e.getMessage());
                            }
                            span2.setAttribute(AttributeName.key_pair_gen_successful_method.name(), "legacy_key_gen_spec");
                            span2.setStatus(StatusCode.OK);
                        }
                    }
                    Logger.warn(methodTag, "Some unknown exception occurred. Running legacy keygen spec logic." + e);
                    keyPair = this.generateKeyPairWithLegacySpec(this.mAlias, keypairGenStartTime);
                    span2.setAttribute(AttributeName.key_pair_gen_successful_method.name(), "legacy_key_gen_spec");
                    span2.setStatus(StatusCode.OK);
                }
                catch (Throwable throwable) {
                    Logger.warn(methodTag, "Unexpected error with new KeyPairGeneratorSpec. Falling back to legacy spec. " + throwable);
                    keyPair = this.generateKeyPairWithLegacySpec(this.mAlias, keypairGenStartTime);
                    if (throwable.getMessage() != null) {
                        span2.setAttribute(AttributeName.keypair_gen_exception.name(), throwable.getMessage());
                    }
                    span2.setAttribute(AttributeName.key_pair_gen_successful_method.name(), "legacy_key_gen_spec");
                    span2.setStatus(StatusCode.OK);
                }
                finally {
                    span2.end();
                }
            } else {
                Logger.info(methodTag, "Using legacy spec for keypair generation directly.");
                keyPair = AndroidKeyStoreUtil.generateKeyPair(WRAP_KEY_ALGORITHM, AndroidWrappedKeyLoader.getLegacySpecForKeyStoreKey(this.mContext, this.mAlias));
            }
        }
        byte[] keyWrapped = AndroidKeyStoreUtil.wrap(unencryptedKey, keyPair, WRAP_ALGORITHM);
        FileUtil.writeDataToFile((byte[])keyWrapped, (File)this.getKeyFile());
    }

    @RequiresApi(api=28)
    private KeyPair attemptKeyPairGeneration(@NonNull String alias, boolean useWrapPurpose, long keypairGenStartTime) throws ClientException {
        if (alias == null) {
            throw new NullPointerException("alias is marked non-null but is null");
        }
        KeyPair keyPair = AndroidKeyStoreUtil.generateKeyPair(WRAP_KEY_ALGORITHM, AndroidWrappedKeyLoader.getSpecForKeyStoreKey(alias, useWrapPurpose));
        this.recordKeyGenerationTime(keypairGenStartTime);
        return keyPair;
    }

    private KeyPair generateKeyPairWithLegacySpec(@NonNull String alias, long keypairGenStartTime) throws ClientException {
        if (alias == null) {
            throw new NullPointerException("alias is marked non-null but is null");
        }
        try {
            KeyPair keyPair = AndroidKeyStoreUtil.generateKeyPair(WRAP_KEY_ALGORITHM, AndroidWrappedKeyLoader.getLegacySpecForKeyStoreKey(this.mContext, alias));
            this.recordKeyGenerationTime(keypairGenStartTime);
            return keyPair;
        }
        catch (ClientException e) {
            SpanExtension.current().recordException((Throwable)e);
            SpanExtension.current().setStatus(StatusCode.ERROR);
            Logger.error(TAG + ":generateKeyPairWithLegacySpec", "Error generating keypair with legacy spec.", e);
            throw e;
        }
    }

    private void recordKeyGenerationTime(long keypairGenStartTime) {
        long elapsedTime = System.currentTimeMillis() - keypairGenStartTime;
        SpanExtension.current().setAttribute(AttributeName.elapsed_time_keypair_generation.name(), elapsedTime);
    }

    public void deleteSecretKeyFromStorage() throws ClientException {
        AndroidKeyStoreUtil.deleteKey(this.mAlias);
        FileUtil.deleteFile((File)this.getKeyFile());
        this.mKeyCache.clear();
    }

    private static AlgorithmParameterSpec getLegacySpecForKeyStoreKey(@NonNull Context context, @NonNull String alias) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        if (alias == null) {
            throw new NullPointerException("alias is marked non-null but is null");
        }
        String certInfo = String.format(Locale.ROOT, "CN=%s, OU=%s", alias, context.getPackageName());
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        int certValidYears = 100;
        end.add(1, 100);
        return new KeyPairGeneratorSpec.Builder(context).setAlias(alias).setSubject(new X500Principal(certInfo)).setSerialNumber(BigInteger.ONE).setStartDate(start.getTime()).setEndDate(end.getTime()).build();
    }

    @RequiresApi(api=28)
    private static AlgorithmParameterSpec getSpecForKeyStoreKey(@NonNull String alias, boolean tryPurposeWrap) {
        if (alias == null) {
            throw new NullPointerException("alias is marked non-null but is null");
        }
        int purposes = 3;
        if (tryPurposeWrap) {
            purposes |= 0x20;
        }
        return new KeyGenParameterSpec.Builder(alias, purposes).setKeySize(2048).setDigests(new String[]{"SHA-256", "SHA-512"}).setEncryptionPaddings(new String[]{"PKCS1Padding"}).build();
    }

    private File getKeyFile() {
        return new File(this.mContext.getDir(this.mContext.getPackageName(), 0), this.mFilePath);
    }
}

