/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.adal.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.os.PowerManager;
import androidx.annotation.NonNull;

public class PowerManagerWrapper {
    private static PowerManagerWrapper sInstance;
    private static final String UNKNOWN_STATUS = "Unknown";

    public static void setInstance(PowerManagerWrapper wrapper) {
        sInstance = wrapper;
    }

    public static synchronized PowerManagerWrapper getInstance() {
        if (sInstance == null) {
            sInstance = new PowerManagerWrapper();
        }
        return sInstance;
    }

    @TargetApi(value=23)
    public boolean isDeviceIdleMode(Context connectionContext) {
        return ((PowerManager)connectionContext.getSystemService("power")).isDeviceIdleMode();
    }

    @NonNull
    public String getDeviceIdleMode(@NonNull Context context) {
        try {
            if (Build.VERSION.SDK_INT < 23) {
                return UNKNOWN_STATUS;
            }
            PowerManager powerManager = (PowerManager)context.getSystemService("power");
            if (powerManager.isDeviceIdleMode()) {
                return "Idle";
            }
            if (Build.VERSION.SDK_INT >= 33 && powerManager.isDeviceLightIdleMode()) {
                return "LightIdle";
            }
        }
        catch (Exception e) {
            return UNKNOWN_STATUS;
        }
        return "";
    }

    @NonNull
    public String getPowerOptimizationSettings(@NonNull Context context) {
        try {
            if (Build.VERSION.SDK_INT < 23) {
                return UNKNOWN_STATUS;
            }
            PowerManager powerManager = (PowerManager)context.getSystemService("power");
            if (powerManager.isIgnoringBatteryOptimizations(context.getPackageName())) {
                return "OptOut";
            }
            return "";
        }
        catch (Exception e) {
            return UNKNOWN_STATUS;
        }
    }

    @TargetApi(value=23)
    public boolean isIgnoringBatteryOptimizations(Context connectionContext) {
        return ((PowerManager)connectionContext.getSystemService("power")).isIgnoringBatteryOptimizations(connectionContext.getPackageName());
    }
}

