/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.client.AccountAdapter;
import com.microsoft.identity.client.AcquireTokenParameters;
import com.microsoft.identity.client.AcquireTokenSilentParameters;
import com.microsoft.identity.client.AuthenticationCallback;
import com.microsoft.identity.client.IAccount;
import com.microsoft.identity.client.IAuthenticationResult;
import com.microsoft.identity.client.IMultipleAccountPublicClientApplication;
import com.microsoft.identity.client.IPublicClientApplication;
import com.microsoft.identity.client.MultiTenantAccount;
import com.microsoft.identity.client.PublicClientApplication;
import com.microsoft.identity.client.PublicClientApplicationConfiguration;
import com.microsoft.identity.client.SilentAuthenticationCallback;
import com.microsoft.identity.client.exception.MsalArgumentException;
import com.microsoft.identity.client.exception.MsalClientException;
import com.microsoft.identity.client.exception.MsalException;
import com.microsoft.identity.client.internal.AsyncResult;
import com.microsoft.identity.client.internal.CommandParametersAdapter;
import com.microsoft.identity.client.internal.MsalUtils;
import com.microsoft.identity.client.internal.controllers.MSALControllerFactory;
import com.microsoft.identity.client.internal.controllers.MsalExceptionAdapter;
import com.microsoft.identity.common.internal.commands.LoadAccountCommand;
import com.microsoft.identity.common.internal.commands.RemoveAccountCommand;
import com.microsoft.identity.common.internal.migration.TokenMigrationCallback;
import com.microsoft.identity.common.java.cache.ICacheRecord;
import com.microsoft.identity.common.java.commands.BaseCommand;
import com.microsoft.identity.common.java.commands.CommandCallback;
import com.microsoft.identity.common.java.commands.parameters.CommandParameters;
import com.microsoft.identity.common.java.commands.parameters.RemoveAccountCommandParameters;
import com.microsoft.identity.common.java.controllers.CommandDispatcher;
import com.microsoft.identity.common.java.controllers.IControllerFactory;
import com.microsoft.identity.common.java.dto.AccountRecord;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.util.ResultFuture;
import com.microsoft.identity.common.logging.Logger;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class MultipleAccountPublicClientApplication
extends PublicClientApplication
implements IMultipleAccountPublicClientApplication {
    private static final String TAG = MultipleAccountPublicClientApplication.class.getSimpleName();

    protected MultipleAccountPublicClientApplication(@NonNull PublicClientApplicationConfiguration config) throws MsalClientException {
        super(config);
    }

    @Override
    public IAuthenticationResult acquireTokenSilent(@NonNull AcquireTokenSilentParameters acquireTokenSilentParameters) throws MsalException, InterruptedException {
        return this.acquireTokenSilentInternal(acquireTokenSilentParameters, "30");
    }

    @Override
    @Deprecated
    public IAuthenticationResult acquireTokenSilent(@NonNull String[] scopes, @NonNull IAccount account, @NonNull String authority) throws MsalException, InterruptedException {
        return this.acquireTokenSilentSyncInternal(scopes, authority, account, false, "27");
    }

    @Override
    public void acquireTokenSilentAsync(@NonNull AcquireTokenSilentParameters acquireTokenSilentParameters) {
        this.acquireTokenSilentAsyncInternal(acquireTokenSilentParameters, "31");
    }

    @Override
    @Deprecated
    public void acquireTokenSilentAsync(@NonNull String[] scopes, @NonNull IAccount account, @NonNull String authority, @NonNull SilentAuthenticationCallback callback) {
        AcquireTokenSilentParameters acquireTokenSilentParameters = this.buildAcquireTokenSilentParameters(scopes, account, authority, false, null, callback);
        this.acquireTokenSilentAsyncInternal(acquireTokenSilentParameters, "28");
    }

    @Override
    public void getAccounts(@NonNull IPublicClientApplication.LoadAccountsCallback callback) {
        this.getAccountsInternal(callback, "924");
    }

    private void getAccountsInternal(final @NonNull IPublicClientApplication.LoadAccountsCallback callback, final @NonNull String publicApiId) {
        TokenMigrationCallback migrationCallback = new TokenMigrationCallback(){

            public void onMigrationFinished(int numberOfAccountsMigrated) {
                CommandParameters params = CommandParametersAdapter.createCommandParameters(MultipleAccountPublicClientApplication.this.mPublicClientConfiguration, MultipleAccountPublicClientApplication.this.mPublicClientConfiguration.getOAuth2TokenCache());
                LoadAccountCommand loadAccountCommand = new LoadAccountCommand(params, (IControllerFactory)new MSALControllerFactory(MultipleAccountPublicClientApplication.this.mPublicClientConfiguration), PublicClientApplication.getLoadAccountsCallback(callback), publicApiId);
                CommandDispatcher.submitSilent((BaseCommand)loadAccountCommand);
            }
        };
        this.performMigration(migrationCallback);
    }

    @Override
    public List<IAccount> getAccounts() throws InterruptedException, MsalException {
        MsalUtils.throwOnMainThread("getAccounts");
        final ResultFuture future = new ResultFuture();
        this.getAccountsInternal(new IPublicClientApplication.LoadAccountsCallback(){

            @Override
            public void onTaskCompleted(List<IAccount> result) {
                future.setResult(new AsyncResult<List<IAccount>>(result, null));
            }

            @Override
            public void onError(MsalException exception) {
                future.setResult(new AsyncResult<Object>(null, exception));
            }
        }, "923");
        try {
            AsyncResult result = (AsyncResult)future.get();
            if (result.getSuccess()) {
                return (List)result.getResult();
            }
            throw result.getException();
        }
        catch (ExecutionException e) {
            throw new MsalClientException("unknown_error", "Unexpected error while loading accounts.", e);
        }
    }

    @Override
    public void getAccount(@NonNull String identifier, @NonNull IMultipleAccountPublicClientApplication.GetAccountCallback callback) {
        this.getAccountInternal(identifier, callback, "926");
    }

    private void getAccountInternal(final @NonNull String identifier, final @NonNull IMultipleAccountPublicClientApplication.GetAccountCallback callback, final @NonNull String publicApiId) {
        final String methodTag = TAG + ":getAccountInternal";
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null or empty");
        }
        try {
            MsalUtils.validateNonNullArg(identifier, "identifier");
        }
        catch (MsalArgumentException e) {
            callback.onError(e);
        }
        TokenMigrationCallback migrationCallback = new TokenMigrationCallback(){

            public void onMigrationFinished(int numberOfAccountsMigrated) {
                Logger.verbose((String)methodTag, (String)"Get account with the identifier.");
                CommandParameters params = CommandParametersAdapter.createCommandParameters(MultipleAccountPublicClientApplication.this.mPublicClientConfiguration, MultipleAccountPublicClientApplication.this.mPublicClientConfiguration.getOAuth2TokenCache());
                LoadAccountCommand loadAccountCommand = new LoadAccountCommand(params, (IControllerFactory)new MSALControllerFactory(MultipleAccountPublicClientApplication.this.mPublicClientConfiguration), (CommandCallback)new CommandCallback<List<ICacheRecord>, BaseException>(){

                    public void onTaskCompleted(List<ICacheRecord> result) {
                        if (null == result || result.size() == 0) {
                            Logger.verbose((String)methodTag, (String)"No account found.");
                            callback.onTaskCompleted(null);
                        } else {
                            List<IAccount> accounts = AccountAdapter.adapt(result);
                            String trimmedIdentifier = identifier.trim();
                            PublicClientApplication.AccountMatcher accountMatcher = new PublicClientApplication.AccountMatcher(MultipleAccountPublicClientApplication.this, MultipleAccountPublicClientApplication.this.homeAccountMatcher, MultipleAccountPublicClientApplication.this.localAccountMatcher, MultipleAccountPublicClientApplication.this.usernameMatcher);
                            for (IAccount account : accounts) {
                                if (!accountMatcher.matches(trimmedIdentifier, account)) continue;
                                callback.onTaskCompleted(account);
                                return;
                            }
                            callback.onTaskCompleted(null);
                        }
                    }

                    public void onError(BaseException exception) {
                        Logger.error((String)methodTag, (String)exception.getMessage(), (Throwable)exception);
                        callback.onError(MsalExceptionAdapter.msalExceptionFromBaseException(exception));
                    }

                    public void onCancel() {
                    }
                }, publicApiId);
                CommandDispatcher.submitSilent((BaseCommand)loadAccountCommand);
            }
        };
        this.performMigration(migrationCallback);
    }

    @Override
    public IAccount getAccount(@NonNull String identifier) throws InterruptedException, MsalException {
        MsalUtils.throwOnMainThread("getAccount");
        final ResultFuture future = new ResultFuture();
        this.getAccountInternal(identifier, new IMultipleAccountPublicClientApplication.GetAccountCallback(){

            @Override
            public void onTaskCompleted(IAccount result) {
                future.setResult(new AsyncResult<IAccount>(result, null));
            }

            @Override
            public void onError(MsalException exception) {
                future.setResult(new AsyncResult<Object>(null, exception));
            }
        }, "925");
        try {
            AsyncResult result = (AsyncResult)future.get();
            if (result.getSuccess()) {
                return (IAccount)result.getResult();
            }
            throw result.getException();
        }
        catch (ExecutionException e) {
            throw new MsalClientException("unknown_error", "Unexpected error while loading account", e);
        }
    }

    @Override
    public void removeAccount(@Nullable IAccount account, @NonNull IMultipleAccountPublicClientApplication.RemoveAccountCallback callback) {
        this.removeAccountInternal(account, callback, "930");
    }

    private void removeAccountInternal(@Nullable IAccount account, final @NonNull IMultipleAccountPublicClientApplication.RemoveAccountCallback callback, @NonNull String publicApiId) {
        String methodTag = TAG + ":removeAccountInternal";
        MultiTenantAccount multiTenantAccount = (MultiTenantAccount)account;
        if (null == multiTenantAccount) {
            Logger.warn((String)methodTag, (String)"Requisite IAccount or IAccount fields were null. Insufficient criteria to remove IAccount.");
            callback.onError(new MsalClientException("invalid_parameter"));
            return;
        }
        AccountRecord requestAccountRecord = new AccountRecord();
        requestAccountRecord.setEnvironment(multiTenantAccount.getEnvironment());
        requestAccountRecord.setHomeAccountId(multiTenantAccount.getHomeAccountId());
        RemoveAccountCommandParameters params = CommandParametersAdapter.createRemoveAccountCommandParameters(this.mPublicClientConfiguration, this.mPublicClientConfiguration.getOAuth2TokenCache(), requestAccountRecord);
        RemoveAccountCommand removeAccountCommand = new RemoveAccountCommand(params, (IControllerFactory)new MSALControllerFactory(this.mPublicClientConfiguration), (CommandCallback)new CommandCallback<Boolean, BaseException>(){

            public void onError(BaseException error) {
                callback.onError(MsalExceptionAdapter.msalExceptionFromBaseException(error));
            }

            public void onTaskCompleted(Boolean success) {
                callback.onRemoved();
            }

            public void onCancel() {
            }
        }, publicApiId);
        CommandDispatcher.submitSilent((BaseCommand)removeAccountCommand);
    }

    @Override
    public boolean removeAccount(@Nullable IAccount account) throws MsalException, InterruptedException {
        final ResultFuture future = new ResultFuture();
        this.removeAccountInternal(account, new IMultipleAccountPublicClientApplication.RemoveAccountCallback(){

            @Override
            public void onRemoved() {
                future.setResult(new AsyncResult<Boolean>(true, null));
            }

            @Override
            public void onError(@NonNull MsalException exception) {
                future.setResult(new AsyncResult<Boolean>(false, exception));
            }
        }, "929");
        try {
            AsyncResult result = (AsyncResult)future.get();
            if (result.getSuccess()) {
                return (Boolean)result.getResult();
            }
            throw result.getException();
        }
        catch (ExecutionException e) {
            throw new MsalClientException("unknown_error", "Unexpected error while removing account.", e);
        }
    }

    @Override
    public void acquireToken(@NonNull AcquireTokenParameters acquireTokenParameters) {
        this.acquireTokenInternal(acquireTokenParameters, "136");
    }

    @Override
    @Deprecated
    public void acquireToken(@NonNull Activity activity, @NonNull String[] scopes, @Nullable String loginHint, @NonNull AuthenticationCallback callback) {
        AcquireTokenParameters acquireTokenParameters = this.buildAcquireTokenParameters(activity, null, Arrays.asList(scopes), null, null, null, null, null, callback, loginHint, null);
        this.acquireTokenInternal(acquireTokenParameters, "126");
    }
}

