/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.client.BrowserTabActivity;
import com.microsoft.identity.client.CurrentTaskBrowserTabActivity;
import com.microsoft.identity.client.configuration.AccountMode;
import com.microsoft.identity.client.configuration.HttpConfiguration;
import com.microsoft.identity.client.configuration.LoggerConfiguration;
import com.microsoft.identity.client.exception.MsalClientException;
import com.microsoft.identity.common.adal.internal.AuthenticationSettings;
import com.microsoft.identity.common.internal.authorities.UnknownAudience;
import com.microsoft.identity.common.internal.broker.PackageHelper;
import com.microsoft.identity.common.internal.telemetry.TelemetryConfiguration;
import com.microsoft.identity.common.java.authorities.Authority;
import com.microsoft.identity.common.java.authorities.AzureActiveDirectoryAuthority;
import com.microsoft.identity.common.java.authorities.Environment;
import com.microsoft.identity.common.java.authorities.UnknownAuthority;
import com.microsoft.identity.common.java.configuration.LibraryConfiguration;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.java.ui.AuthorizationAgent;
import com.microsoft.identity.common.java.ui.BrowserDescriptor;
import com.microsoft.identity.common.logging.Logger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;

public class PublicClientApplicationConfiguration {
    private static final String TAG = PublicClientApplicationConfiguration.class.getSimpleName();
    private static final String BROKER_REDIRECT_URI_SCHEME_AND_SEPARATOR = "msauth://";
    public static final String INVALID_REDIRECT_MSG = "Invalid, null, or malformed redirect_uri supplied";
    @SerializedName(value="client_id")
    private String mClientId;
    @SerializedName(value="redirect_uri")
    private String mRedirectUri;
    @SerializedName(value="authorities")
    private List<Authority> mAuthorities;
    @SerializedName(value="authorization_user_agent")
    private AuthorizationAgent mAuthorizationAgent;
    @SerializedName(value="http")
    private HttpConfiguration mHttpConfiguration;
    @SerializedName(value="logging")
    private LoggerConfiguration mLoggerConfiguration;
    @SerializedName(value="multiple_clouds_supported")
    private Boolean mMultipleCloudsSupported;
    @SerializedName(value="broker_redirect_uri_registered")
    private Boolean mUseBroker;
    @SerializedName(value="environment")
    private Environment mEnvironment;
    @SerializedName(value="minimum_required_broker_protocol_version")
    private String mRequiredBrokerProtocolVersion;
    @SerializedName(value="preferred_browser")
    private BrowserDescriptor mPreferredBrowser;
    @SerializedName(value="browser_safelist")
    private List<BrowserDescriptor> mBrowserSafeList;
    @SerializedName(value="telemetry")
    private TelemetryConfiguration mTelemetryConfiguration;
    @SerializedName(value="account_mode")
    private AccountMode mAccountMode;
    @SerializedName(value="client_capabilities")
    private String mClientCapabilities;
    @SerializedName(value="web_view_zoom_controls_enabled")
    private Boolean webViewZoomControlsEnabled;
    @SerializedName(value="web_view_zoom_enabled")
    private Boolean webViewZoomEnabled;
    @SerializedName(value="power_opt_check_for_network_req_enabled")
    private Boolean powerOptCheckEnabled;
    @SerializedName(value="handle_null_taskaffinity")
    private Boolean handleNullTaskAffinity;
    @SerializedName(value="authorization_in_current_task")
    private Boolean isAuthorizationInCurrentTask;
    @SerializedName(value="webauthn_capable")
    private Boolean webauthnCapable;
    @SerializedName(value="webauthn_version")
    private String webauthnVersion;
    private transient OAuth2TokenCache mOAuth2TokenCache;
    private transient Context mAppContext;
    private transient boolean mIsSharedDevice = false;

    public void setTokenCacheSecretKeys(@NonNull byte[] rawKey) {
        AuthenticationSettings.INSTANCE.setSecretKey(rawKey);
    }

    public BrowserDescriptor getPreferredBrowser() {
        return this.mPreferredBrowser;
    }

    public List<BrowserDescriptor> getBrowserSafeList() {
        return this.mBrowserSafeList;
    }

    public String getClientId() {
        return this.mClientId;
    }

    public void setClientId(String clientId) {
        this.mClientId = clientId;
    }

    public List<Authority> getAuthorities() {
        return this.mAuthorities;
    }

    public Environment getEnvironment() {
        return this.mEnvironment;
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.mHttpConfiguration;
    }

    public LoggerConfiguration getLoggerConfiguration() {
        return this.mLoggerConfiguration;
    }

    public TelemetryConfiguration getTelemetryConfiguration() {
        return this.mTelemetryConfiguration;
    }

    public String getRedirectUri() {
        return this.mRedirectUri;
    }

    public void setRedirectUri(@NonNull String redirectUri) {
        this.mRedirectUri = redirectUri;
    }

    public AuthorizationAgent getAuthorizationAgent() {
        return this.mAuthorizationAgent;
    }

    public Boolean getMultipleCloudsSupported() {
        return this.mMultipleCloudsSupported;
    }

    public Boolean getUseBroker() {
        return this.mUseBroker;
    }

    public AccountMode getAccountMode() {
        return this.mAccountMode;
    }

    public void setAccountMode(AccountMode accountMode) {
        this.mAccountMode = accountMode;
    }

    public String getClientCapabilities() {
        return this.mClientCapabilities;
    }

    public String getRequiredBrokerProtocolVersion() {
        return this.mRequiredBrokerProtocolVersion;
    }

    public Context getAppContext() {
        return this.mAppContext;
    }

    public void setAppContext(Context applicationContext) {
        this.mAppContext = applicationContext;
    }

    public OAuth2TokenCache getOAuth2TokenCache() {
        return this.mOAuth2TokenCache;
    }

    public void setOAuth2TokenCache(OAuth2TokenCache tokenCache) {
        this.mOAuth2TokenCache = tokenCache;
    }

    public boolean getIsSharedDevice() {
        return this.mIsSharedDevice;
    }

    public void setIsSharedDevice(boolean isSharedDevice) {
        this.mIsSharedDevice = isSharedDevice;
    }

    public boolean isWebViewZoomControlsEnabled() {
        return this.webViewZoomControlsEnabled;
    }

    public boolean isWebViewZoomEnabled() {
        return this.webViewZoomEnabled;
    }

    public void setWebViewZoomControlsEnabled(boolean webViewZoomControlsEnabled) {
        this.webViewZoomControlsEnabled = webViewZoomControlsEnabled;
    }

    public void setWebViewZoomEnabled(boolean webViewZoomEnabled) {
        this.webViewZoomEnabled = webViewZoomEnabled;
    }

    public Boolean isPowerOptCheckForEnabled() {
        return this.powerOptCheckEnabled;
    }

    public void setPowerOptCheckEnabled(Boolean powerOptCheckEnabled) {
        this.powerOptCheckEnabled = powerOptCheckEnabled;
    }

    public Boolean isHandleNullTaskAffinityEnabled() {
        return this.handleNullTaskAffinity;
    }

    public Boolean authorizationInCurrentTask() {
        return this.isAuthorizationInCurrentTask;
    }

    public Boolean isWebauthnCapable() {
        return Boolean.TRUE.equals(this.webauthnCapable);
    }

    public String getWebauthnVersion() {
        return this.webauthnVersion;
    }

    public Authority getDefaultAuthority() {
        if (this.mAuthorities != null) {
            if (this.mAuthorities.size() > 1) {
                for (Authority authority : this.mAuthorities) {
                    if (!authority.getDefault()) continue;
                    return authority;
                }
                return null;
            }
            return this.mAuthorities.get(0);
        }
        return null;
    }

    private void checkManifestPermissions() {
        PackageManager packageManager;
        int reorderTasksGranted;
        if (this.handleNullTaskAffinity != null && this.handleNullTaskAffinity.booleanValue() && (reorderTasksGranted = (packageManager = this.mAppContext.getPackageManager()).checkPermission("android.permission.REORDER_TASKS", this.mAppContext.getPackageName())) != 0) {
            throw new IllegalStateException("You requested that we handle null taskAffinity but your manifest does not include the REORDER_TASKS permission");
        }
    }

    private void checkDefaultAuthoritySpecified() {
        if (this.mAuthorities != null && this.mAuthorities.size() > 1) {
            int defaultCount = 0;
            for (Authority authority : this.mAuthorities) {
                if (!authority.getDefault()) continue;
                ++defaultCount;
            }
            if (defaultCount == 0) {
                throw new IllegalArgumentException("One authority in your configuration must be marked as default.");
            }
            if (defaultCount > 1) {
                throw new IllegalArgumentException("More than one authority in your configuration is marked as default.  Only one authority may be default.");
            }
        }
    }

    public boolean isDefaultAuthorityConfigured() {
        Authority authority = this.getDefaultAuthority();
        return authority != null;
    }

    public void mergeConfiguration(PublicClientApplicationConfiguration config) {
        this.mClientId = config.mClientId == null ? this.mClientId : config.mClientId;
        this.mRedirectUri = config.mRedirectUri == null ? this.mRedirectUri : config.mRedirectUri;
        this.mAuthorities = config.mAuthorities == null ? this.mAuthorities : config.mAuthorities;
        this.mAuthorizationAgent = config.mAuthorizationAgent == null ? this.mAuthorizationAgent : config.mAuthorizationAgent;
        this.mEnvironment = config.mEnvironment == null ? this.mEnvironment : config.mEnvironment;
        this.mHttpConfiguration = config.mHttpConfiguration == null ? this.mHttpConfiguration : config.mHttpConfiguration;
        this.mMultipleCloudsSupported = config.mMultipleCloudsSupported == null ? this.mMultipleCloudsSupported : config.mMultipleCloudsSupported;
        this.mUseBroker = config.mUseBroker == null ? this.mUseBroker : config.mUseBroker;
        this.mTelemetryConfiguration = config.mTelemetryConfiguration == null ? this.mTelemetryConfiguration : config.mTelemetryConfiguration;
        this.mRequiredBrokerProtocolVersion = config.mRequiredBrokerProtocolVersion == null ? this.mRequiredBrokerProtocolVersion : config.mRequiredBrokerProtocolVersion;
        BrowserDescriptor browserDescriptor = this.mPreferredBrowser = config.mPreferredBrowser == null ? this.mPreferredBrowser : config.mPreferredBrowser;
        if (this.mBrowserSafeList == null) {
            this.mBrowserSafeList = config.mBrowserSafeList;
        } else if (config.mBrowserSafeList != null) {
            this.mBrowserSafeList.addAll(config.mBrowserSafeList);
        }
        this.mAccountMode = config.mAccountMode != AccountMode.MULTIPLE && config.mAccountMode != null ? config.mAccountMode : this.mAccountMode;
        this.mClientCapabilities = config.mClientCapabilities == null ? this.mClientCapabilities : config.mClientCapabilities;
        this.mIsSharedDevice = config.mIsSharedDevice ? this.mIsSharedDevice : config.mIsSharedDevice;
        this.mLoggerConfiguration = config.mLoggerConfiguration == null ? this.mLoggerConfiguration : config.mLoggerConfiguration;
        this.webViewZoomControlsEnabled = config.webViewZoomControlsEnabled == null ? this.webViewZoomControlsEnabled : config.webViewZoomControlsEnabled;
        this.webViewZoomEnabled = config.webViewZoomEnabled == null ? this.webViewZoomEnabled : config.webViewZoomEnabled;
        this.powerOptCheckEnabled = config.powerOptCheckEnabled == null ? this.powerOptCheckEnabled : config.powerOptCheckEnabled;
        this.handleNullTaskAffinity = config.handleNullTaskAffinity == null ? this.handleNullTaskAffinity : config.handleNullTaskAffinity;
        this.isAuthorizationInCurrentTask = config.isAuthorizationInCurrentTask == null ? this.isAuthorizationInCurrentTask : config.isAuthorizationInCurrentTask;
        this.webauthnCapable = config.webauthnCapable == null ? this.webauthnCapable : config.webauthnCapable;
        this.webauthnVersion = config.webauthnVersion == null ? this.webauthnVersion : config.webauthnVersion;
    }

    public void validateConfiguration() {
        this.validateRedirectUri(this.mRedirectUri);
        PublicClientApplicationConfiguration.nullConfigurationCheck("client_id", this.mClientId);
        this.checkDefaultAuthoritySpecified();
        this.checkManifestPermissions();
        if (!this.mAuthorizationAgent.equals((Object)AuthorizationAgent.WEBVIEW) && (this.mBrowserSafeList == null || this.mBrowserSafeList.isEmpty())) {
            throw new IllegalArgumentException("Null browser safe list configured.");
        }
        for (Authority authority : this.mAuthorities) {
            if (authority instanceof UnknownAuthority) {
                throw new IllegalArgumentException("Unrecognized authority type -- null, invalid or unknown type specified.");
            }
            if (!(authority instanceof AzureActiveDirectoryAuthority)) continue;
            this.validateAzureActiveDirectoryAuthority((AzureActiveDirectoryAuthority)authority);
        }
    }

    private void validateRedirectUri(@NonNull String redirectUri) {
        boolean isInvalid = false;
        if (this.mAppContext != null && "com.azure.authenticator".equalsIgnoreCase(this.mAppContext.getPackageName())) {
            isInvalid = !this.isValidAuthenticatorRedirectUri();
        } else {
            boolean bl = isInvalid = TextUtils.isEmpty((CharSequence)redirectUri) || !this.hasSchemeAndAuthority(redirectUri);
        }
        if (isInvalid) {
            throw new IllegalArgumentException(INVALID_REDIRECT_MSG);
        }
    }

    private boolean hasSchemeAndAuthority(@NonNull String redirectUri) {
        String methodTag = TAG + ":hasSchemeAndAuthority";
        try {
            Uri parsedRedirectUri = Uri.parse((String)redirectUri);
            boolean hasScheme = !TextUtils.isEmpty((CharSequence)parsedRedirectUri.getScheme());
            boolean hasAuthority = !TextUtils.isEmpty((CharSequence)parsedRedirectUri.getAuthority());
            return hasScheme && hasAuthority;
        }
        catch (NullPointerException e) {
            com.microsoft.identity.common.internal.logging.Logger.errorPII((String)methodTag, (String)INVALID_REDIRECT_MSG, (Throwable)e);
            return false;
        }
    }

    private void validateAzureActiveDirectoryAuthority(@NonNull AzureActiveDirectoryAuthority azureActiveDirectoryAuthority) {
        if (null != azureActiveDirectoryAuthority.mAudience && azureActiveDirectoryAuthority.mAudience instanceof UnknownAudience) {
            throw new IllegalArgumentException("Unrecognized audience type for AzureActiveDirectoryAuthority -- null, invalid, or unknown type specified");
        }
    }

    private static void nullConfigurationCheck(String configKey, String configValue) {
        if (TextUtils.isEmpty((CharSequence)configValue)) {
            throw new IllegalArgumentException(configKey + " cannot be null.  Invalid configuration.");
        }
    }

    @VisibleForTesting
    public static boolean isBrokerRedirectUri(@NonNull String redirectUri, @NonNull String packageName) {
        String potentialPrefix = BROKER_REDIRECT_URI_SCHEME_AND_SEPARATOR + packageName + "/";
        return redirectUri != null && redirectUri.startsWith(potentialPrefix);
    }

    private void verifyRedirectUriWithAppSignature() throws MsalClientException {
        String methodTag = TAG + ":verifyRedirectUriWithAppSignature";
        String packageName = this.mAppContext.getPackageName();
        try {
            Signature[] signatures;
            PackageInfo info = PackageHelper.getPackageInfo((PackageManager)this.mAppContext.getPackageManager(), (String)packageName);
            Signature[] signatureArray = signatures = PackageHelper.getSignatures((PackageInfo)info);
            int n = signatureArray.length;
            int n2 = 0;
            if (n2 < n) {
                Signature signature = signatureArray[n2];
                MessageDigest messageDigest = MessageDigest.getInstance("SHA");
                messageDigest.update(signature.toByteArray());
                String signatureHash = Base64.encodeToString((byte[])messageDigest.digest(), (int)2);
                Uri.Builder builder = new Uri.Builder();
                Uri uri = builder.scheme("msauth").authority(packageName).appendPath(signatureHash).build();
                if (this.mRedirectUri.equalsIgnoreCase(uri.toString())) {
                    return;
                }
                throw new MsalClientException("redirect_uri_validation_error", "The redirect URI in the configuration file doesn't match with the one generated with package name and signature hash. Please verify the uri in the config file and your app registration in Azure portal.We expected '" + uri.toString() + "' and we received '" + this.mRedirectUri + "'.");
            }
        }
        catch (PackageManager.NameNotFoundException | NoSuchAlgorithmException e) {
            com.microsoft.identity.common.internal.logging.Logger.error((String)methodTag, (String)"Unexpected error in verifyRedirectUriWithAppSignature()", (Throwable)e);
            throw new MsalClientException("unknown_error", "Unexpected error in verifyRedirectUriWithAppSignature()", e);
        }
    }

    private static boolean validateCustomTabRedirectActivity(@NonNull Context context, @NonNull String url) throws MsalClientException {
        String methodTag = TAG + ":validateCustomTabRedirectActivity";
        PackageManager packageManager = context.getPackageManager();
        if (packageManager == null) {
            return false;
        }
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.addCategory("android.intent.category.BROWSABLE");
        intent.setDataAndNormalize(Uri.parse((String)url));
        List resolveInfoList = packageManager.queryIntentActivities(intent, 64);
        boolean hasActivity = false;
        for (ResolveInfo info : resolveInfoList) {
            ActivityInfo activityInfo = info.activityInfo;
            String activityClassName = BrowserTabActivity.class.getName();
            if (LibraryConfiguration.getInstance().isAuthorizationInCurrentTask()) {
                activityClassName = CurrentTaskBrowserTabActivity.class.getName();
            }
            if (activityInfo.name.equals(activityClassName) && activityInfo.packageName.equals(context.getPackageName())) {
                hasActivity = true;
                continue;
            }
            Logger.warn((String)methodTag, (String)String.format("Another application %s is listening for the URL scheme %s", activityInfo.packageName, url));
            throw new MsalClientException("multiple_apps_listening_url_scheme", "More than one app is listening for the URL scheme defined for BrowserTabActivity in the AndroidManifest. The package name of this other app is: " + activityInfo.packageName);
        }
        return hasActivity;
    }

    public void checkIntentFilterAddedToAppManifestForBrokerFlow() throws MsalClientException {
        boolean hasCustomTabRedirectActivity;
        String methodTag = TAG + ":checkIntentFilterAddedToAppManifestForBrokerFlow";
        if (!(this.getAuthorizationAgent() != AuthorizationAgent.DEFAULT && this.getAuthorizationAgent() != AuthorizationAgent.BROWSER || (hasCustomTabRedirectActivity = PublicClientApplicationConfiguration.validateCustomTabRedirectActivity(this.mAppContext, this.mRedirectUri)))) {
            String activityClassName = BrowserTabActivity.class.getSimpleName();
            if (LibraryConfiguration.getInstance().isAuthorizationInCurrentTask()) {
                activityClassName = CurrentTaskBrowserTabActivity.class.getSimpleName();
            }
            Uri redirectUri = Uri.parse((String)this.mRedirectUri);
            throw new MsalClientException("app_manifest_validation_error", "Intent filter for: " + activityClassName + " is missing.  Please make sure you have the following activity in your AndroidManifest.xml \n\n<activity android:name=\"com.microsoft.identity.client." + activityClassName + "\">\n\t<intent-filter>\n\t\t<action android:name=\"android.intent.action.VIEW\" />\n\t\t<category android:name=\"android.intent.category.DEFAULT\" />\n\t\t<category android:name=\"android.intent.category.BROWSABLE\" />\n\t\t<data\n\t\t\tandroid:host=\"" + redirectUri.getHost() + "\"\n\t\t\tandroid:path=\"" + redirectUri.getPath() + "\"\n\t\t\tandroid:scheme=\"" + redirectUri.getScheme() + "\" />\n\t</intent-filter>\n</activity>\n");
        }
        if (!this.mUseBroker.booleanValue()) {
            return;
        }
        if (this.mAppContext != null && "com.azure.authenticator".equalsIgnoreCase(this.mAppContext.getPackageName()) && this.isValidAuthenticatorRedirectUri()) {
            return;
        }
        if (this.mAppContext != null && !PublicClientApplicationConfiguration.isBrokerRedirectUri(this.mRedirectUri, this.mAppContext.getPackageName())) {
            com.microsoft.identity.common.internal.logging.Logger.warn((String)methodTag, (String)"The app is still using legacy MSAL redirect uri. Switch to MSAL local auth.  For brokered auth, the redirect URI is expected to conform to 'msauth://<authority>/.*' where the authority in that uri is the package name of the app. This package name is listed as 'applicationId' in the build.gradle file.");
            this.mUseBroker = false;
            return;
        }
        this.verifyRedirectUriWithAppSignature();
    }

    private boolean isValidAuthenticatorRedirectUri() {
        String methodTag = TAG + ":isValidAuthenticatorRedirectUri";
        try {
            PackageInfo info = this.mAppContext.getPackageManager().getPackageInfo("com.azure.authenticator", 64);
            if (info != null && info.signatures != null && info.signatures.length > 0) {
                Signature signature = info.signatures[0];
                MessageDigest md_sha512 = MessageDigest.getInstance("SHA-512");
                md_sha512.update(signature.toByteArray());
                String sha512_signingCertThumbprint = Base64.encodeToString((byte[])md_sha512.digest(), (int)2);
                if ("Gu8CuaYmSV5CHWd6dz3tGPXIE+YTalCVIXi5lEBXpvUgsMKoHbU9Rqou3WNRNU1tsz8pvEADTCCJ5f02fbw9qw==".equalsIgnoreCase(sha512_signingCertThumbprint) || "pdAtoxfsEwbpQsIaua5Uobl5AQEjqt40aPXI7UY1lIW0NTmg0G4jHQ5T5mujSjjU06q4mEHs5hb6z/Mr0PNlmQ==".equalsIgnoreCase(sha512_signingCertThumbprint)) {
                    MessageDigest md_sha1 = MessageDigest.getInstance("SHA");
                    md_sha1.update(signature.toByteArray());
                    String sha1_signingCertThumbprint = Base64.encodeToString((byte[])md_sha1.digest(), (int)2);
                    Uri.Builder builder = new Uri.Builder();
                    Uri uri = builder.scheme("msauth").authority(this.mAppContext.getPackageName()).appendPath(sha1_signingCertThumbprint).build();
                    if (this.mRedirectUri.equalsIgnoreCase(uri.toString()) || this.mRedirectUri.equalsIgnoreCase("urn:ietf:wg:oauth:2.0:oob") || this.mRedirectUri.equalsIgnoreCase("msauth://Microsoft.AAD.BrokerPlugin")) {
                        return true;
                    }
                }
            }
        }
        catch (PackageManager.NameNotFoundException | NoSuchAlgorithmException e) {
            com.microsoft.identity.common.internal.logging.Logger.error((String)methodTag, (String)"Unexpected error in getting package info/signature for Authenticator", (Throwable)e);
        }
        return false;
    }

    public static final class SerializedNames {
        static final String CLIENT_ID = "client_id";
        static final String REDIRECT_URI = "redirect_uri";
        static final String AUTHORITIES = "authorities";
        static final String AUTHORIZATION_USER_AGENT = "authorization_user_agent";
        static final String HTTP = "http";
        static final String LOGGING = "logging";
        static final String MULTIPLE_CLOUDS_SUPPORTED = "multiple_clouds_supported";
        static final String USE_BROKER = "broker_redirect_uri_registered";
        static final String ENVIRONMENT = "environment";
        static final String REQUIRED_BROKER_PROTOCOL_VERSION = "minimum_required_broker_protocol_version";
        static final String TELEMETRY = "telemetry";
        static final String PREFERRED_BROWSER = "preferred_browser";
        static final String BROWSER_SAFE_LIST = "browser_safelist";
        static final String ACCOUNT_MODE = "account_mode";
        static final String CLIENT_CAPABILITIES = "client_capabilities";
        static final String WEB_VIEW_ZOOM_CONTROLS_ENABLED = "web_view_zoom_controls_enabled";
        static final String WEB_VIEW_ZOOM_ENABLED = "web_view_zoom_enabled";
        static final String POWER_OPT_CHECK_FOR_NETWORK_REQUEST_ENABLED = "power_opt_check_for_network_req_enabled";
        static final String HANDLE_TASKS_WITH_NULL_TASKAFFINITY = "handle_null_taskaffinity";
        static final String AUTHORIZATION_IN_CURRENT_TASK = "authorization_in_current_task";
        static final String WEBAUTHN_CAPABLE = "webauthn_capable";
        static final String WEBAUTHN_VERSION = "webauthn_version";
    }
}

