/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.nativeauth;

import android.content.Context;
import androidx.annotation.WorkerThread;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.microsoft.identity.client.Logger;
import com.microsoft.identity.client.PublicClientApplicationConfiguration;
import com.microsoft.identity.client.PublicClientApplicationConfigurationFactory;
import com.microsoft.identity.client.internal.configuration.LogLevelDeserializer;
import com.microsoft.identity.common.components.AndroidPlatformComponentsFactory;
import com.microsoft.identity.common.internal.authorities.AzureActiveDirectoryAudienceDeserializer;
import com.microsoft.identity.common.java.authorities.Authority;
import com.microsoft.identity.common.java.authorities.AuthorityDeserializer;
import com.microsoft.identity.common.java.authorities.AzureActiveDirectoryAudience;
import com.microsoft.identity.common.java.cache.MsalOAuth2TokenCache;
import com.microsoft.identity.common.java.configuration.LibraryConfiguration;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.nativeauth.BuildValues;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftAccount;
import com.microsoft.identity.common.java.providers.microsoft.MicrosoftRefreshToken;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Strategy;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsTokenResponse;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.msal.R;
import com.microsoft.identity.nativeauth.NativeAuthPublicClientApplicationConfiguration;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/microsoft/identity/nativeauth/NativeAuthPublicClientApplicationConfigurationFactory;", "Lcom/microsoft/identity/client/PublicClientApplicationConfigurationFactory;", "()V", "Companion", "msal_distRelease"})
public final class NativeAuthPublicClientApplicationConfigurationFactory
extends PublicClientApplicationConfigurationFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final String TAG = NativeAuthPublicClientApplicationConfigurationFactory.class.getSimpleName();

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0006\u001a \u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J\u001a\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0003J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0003J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0003J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0003J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0003R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/microsoft/identity/nativeauth/NativeAuthPublicClientApplicationConfigurationFactory$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "createCache", "Lcom/microsoft/identity/common/java/cache/MsalOAuth2TokenCache;", "Lcom/microsoft/identity/common/java/providers/microsoft/microsoftsts/MicrosoftStsOAuth2Strategy;", "Lcom/microsoft/identity/common/java/providers/microsoft/microsoftsts/MicrosoftStsAuthorizationRequest;", "Lcom/microsoft/identity/common/java/providers/microsoft/microsoftsts/MicrosoftStsTokenResponse;", "Lcom/microsoft/identity/common/java/providers/microsoft/MicrosoftAccount;", "Lcom/microsoft/identity/common/java/providers/microsoft/MicrosoftRefreshToken;", "components", "Lcom/microsoft/identity/common/java/interfaces/IPlatformComponents;", "getGsonForLoadingConfiguration", "Lcom/google/gson/Gson;", "initializeBuildValues", "", "developerConfig", "Lcom/microsoft/identity/nativeauth/NativeAuthPublicClientApplicationConfiguration;", "initializeNativeAuthConfiguration", "context", "Landroid/content/Context;", "configFile", "Ljava/io/File;", "configResourceId", "", "initializeNativeAuthConfigurationInternal", "loadConfiguration", "configStream", "Ljava/io/InputStream;", "isDefaultConfiguration", "", "loadDefaultNativeAuthConfiguration", "msal_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        @WorkerThread
        @NotNull
        public final NativeAuthPublicClientApplicationConfiguration initializeNativeAuthConfiguration(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return this.initializeNativeAuthConfigurationInternal(context, null);
        }

        @WorkerThread
        @NotNull
        public final NativeAuthPublicClientApplicationConfiguration initializeNativeAuthConfiguration(@NotNull Context context, int configResourceId) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return this.initializeNativeAuthConfigurationInternal(context, this.loadConfiguration(context, configResourceId));
        }

        @WorkerThread
        @NotNull
        public final NativeAuthPublicClientApplicationConfiguration initializeNativeAuthConfiguration(@NotNull Context context, @NotNull File configFile) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)configFile, (String)"configFile");
            return this.initializeNativeAuthConfigurationInternal(context, this.loadConfiguration(configFile));
        }

        @WorkerThread
        private final NativeAuthPublicClientApplicationConfiguration initializeNativeAuthConfigurationInternal(Context context, NativeAuthPublicClientApplicationConfiguration developerConfig) {
            PublicClientApplicationConfiguration publicClientApplicationConfiguration = PublicClientApplicationConfigurationFactory.loadConfiguration(context, R.raw.msal_default_config);
            Intrinsics.checkNotNullExpressionValue((Object)publicClientApplicationConfiguration, (String)"loadConfiguration(contex\u2026.raw.msal_default_config)");
            PublicClientApplicationConfiguration defaultMsalConfiguration = publicClientApplicationConfiguration;
            NativeAuthPublicClientApplicationConfiguration defaultNativeAuthConfiguration = this.loadDefaultNativeAuthConfiguration(context);
            NativeAuthPublicClientApplicationConfiguration config = new NativeAuthPublicClientApplicationConfiguration();
            config.setAppContext(context);
            config.mergeConfiguration(defaultMsalConfiguration);
            config.mergeConfiguration(defaultNativeAuthConfiguration);
            config.getAuthorities().clear();
            if (developerConfig != null) {
                config.mergeConfiguration(developerConfig);
                config.validateConfiguration();
            }
            LibraryConfiguration.LibraryConfigurationBuilder libraryConfigurationBuilder = LibraryConfiguration.builder();
            Boolean bl = config.authorizationInCurrentTask();
            Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"config.authorizationInCurrentTask()");
            LibraryConfiguration libraryConfiguration = libraryConfigurationBuilder.authorizationInCurrentTask(bl.booleanValue()).build();
            LibraryConfiguration.intializeLibraryConfiguration((LibraryConfiguration)libraryConfiguration);
            IPlatformComponents iPlatformComponents = AndroidPlatformComponentsFactory.createFromContext((Context)context);
            Intrinsics.checkNotNullExpressionValue((Object)iPlatformComponents, (String)"createFromContext(context)");
            config.setOAuth2TokenCache((OAuth2TokenCache)this.createCache(iPlatformComponents));
            this.initializeBuildValues(developerConfig);
            return config;
        }

        private final void initializeBuildValues(NativeAuthPublicClientApplicationConfiguration developerConfig) {
            Boolean useMockAuthority;
            NativeAuthPublicClientApplicationConfiguration nativeAuthPublicClientApplicationConfiguration = developerConfig;
            String dc = nativeAuthPublicClientApplicationConfiguration != null ? nativeAuthPublicClientApplicationConfiguration.getDc() : null;
            NativeAuthPublicClientApplicationConfiguration nativeAuthPublicClientApplicationConfiguration2 = developerConfig;
            Boolean bl = useMockAuthority = nativeAuthPublicClientApplicationConfiguration2 != null ? nativeAuthPublicClientApplicationConfiguration2.getUseMockAuthority() : null;
            if (dc != null) {
                BuildValues.setDC((String)dc);
            }
            if (useMockAuthority != null) {
                BuildValues.setUseMockApiForNativeAuth((Boolean)useMockAuthority);
            }
        }

        @WorkerThread
        private final NativeAuthPublicClientApplicationConfiguration loadDefaultNativeAuthConfiguration(Context context) {
            String methodTag = TAG + ":loadDefaultNativeAuthConfiguration";
            Logger.verbose((String)methodTag, (String)"Loading default native auth configuration");
            return this.loadConfiguration(context, R.raw.msal_native_auth_default_config);
        }

        @WorkerThread
        private final NativeAuthPublicClientApplicationConfiguration loadConfiguration(Context context, int configResourceId) {
            InputStream inputStream = context.getResources().openRawResource(configResourceId);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"context.resources.openRa\u2026esource(configResourceId)");
            InputStream configStream = inputStream;
            boolean useDefaultConfigResourceId = configResourceId == R.raw.msal_native_auth_default_config;
            return this.loadConfiguration(configStream, useDefaultConfigResourceId);
        }

        @WorkerThread
        private final NativeAuthPublicClientApplicationConfiguration loadConfiguration(File configFile) {
            NativeAuthPublicClientApplicationConfiguration nativeAuthPublicClientApplicationConfiguration;
            try {
                nativeAuthPublicClientApplicationConfiguration = this.loadConfiguration(new FileInputStream(configFile), false);
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("Provided configuration file path=" + configFile.getPath() + " not found.");
            }
            return nativeAuthPublicClientApplicationConfiguration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        private final NativeAuthPublicClientApplicationConfiguration loadConfiguration(InputStream configStream, boolean isDefaultConfiguration) {
            NativeAuthPublicClientApplicationConfiguration nativeAuthPublicClientApplicationConfiguration;
            String methodTag = TAG + ":loadConfiguration";
            byte[] buffer = null;
            try {
                Closeable closeable = configStream;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl = false;
                    buffer = new byte[configStream.available()];
                    int n = configStream.read(buffer);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                if (isDefaultConfiguration) {
                    throw new IllegalStateException("Unable to open default native auth configuration file.", e);
                }
                throw new IllegalArgumentException("Unable to open provided native auth configuration file.", e);
            }
            String config = new String(buffer, Charsets.UTF_8);
            Gson gson = this.getGsonForLoadingConfiguration();
            try {
                Object object = gson.fromJson(config, NativeAuthPublicClientApplicationConfiguration.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"{\n                gson.f\u2026class.java)\n            }");
                nativeAuthPublicClientApplicationConfiguration = (NativeAuthPublicClientApplicationConfiguration)object;
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw new IllegalArgumentException("Error while processing configuration", e);
            }
            return nativeAuthPublicClientApplicationConfiguration;
        }

        private final MsalOAuth2TokenCache<MicrosoftStsOAuth2Strategy, MicrosoftStsAuthorizationRequest, MicrosoftStsTokenResponse, MicrosoftAccount, MicrosoftRefreshToken> createCache(IPlatformComponents components) {
            String methodName = ":createCache";
            Logger.verbose((String)(TAG + methodName), (String)"Creating MsalOAuth2TokenCache");
            MsalOAuth2TokenCache msalOAuth2TokenCache = MsalOAuth2TokenCache.create((IPlatformComponents)components);
            Intrinsics.checkNotNullExpressionValue((Object)msalOAuth2TokenCache, (String)"create(components)");
            return msalOAuth2TokenCache;
        }

        private final Gson getGsonForLoadingConfiguration() {
            Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)Authority.class), (Object)new AuthorityDeserializer()).registerTypeAdapter((Type)((Object)AzureActiveDirectoryAudience.class), (Object)new AzureActiveDirectoryAudienceDeserializer()).registerTypeAdapter((Type)((Object)Logger.LogLevel.class), (Object)new LogLevelDeserializer()).create();
            Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"GsonBuilder()\n          \u2026                .create()");
            return gson;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

