/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.nativeauth.statemachine.states;

import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import com.microsoft.identity.client.AuthenticationResultAdapter;
import com.microsoft.identity.client.IAuthenticationResult;
import com.microsoft.identity.client.exception.MsalException;
import com.microsoft.identity.client.internal.CommandParametersAdapter;
import com.microsoft.identity.common.java.commands.BaseCommand;
import com.microsoft.identity.common.java.commands.ICommandResult;
import com.microsoft.identity.common.java.controllers.CommandDispatcher;
import com.microsoft.identity.common.java.controllers.CommandResult;
import com.microsoft.identity.common.java.logging.LogSession;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.GetAuthMethodsCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.MFADefaultChallengeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.MFASubmitChallengeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.controllers.results.GetAuthMethodsCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.INativeAuthCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.MFAChallengeCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.MFACommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.MFASubmitChallengeCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.SignInCommandResult;
import com.microsoft.identity.common.java.nativeauth.util.ILoggable;
import com.microsoft.identity.common.nativeauth.internal.commands.GetAuthMethodsCommand;
import com.microsoft.identity.common.nativeauth.internal.commands.MFAChallengeCommand;
import com.microsoft.identity.common.nativeauth.internal.commands.MFASubmitChallengeCommand;
import com.microsoft.identity.common.nativeauth.internal.controllers.NativeAuthMsalController;
import com.microsoft.identity.nativeauth.AuthMethod;
import com.microsoft.identity.nativeauth.AuthMethodKt;
import com.microsoft.identity.nativeauth.NativeAuthPublicClientApplication;
import com.microsoft.identity.nativeauth.NativeAuthPublicClientApplicationConfiguration;
import com.microsoft.identity.nativeauth.statemachine.errors.MFAGetAuthMethodsError;
import com.microsoft.identity.nativeauth.statemachine.errors.MFARequestChallengeError;
import com.microsoft.identity.nativeauth.statemachine.errors.MFASubmitChallengeError;
import com.microsoft.identity.nativeauth.statemachine.results.MFAGetAuthMethodsResult;
import com.microsoft.identity.nativeauth.statemachine.results.MFARequiredResult;
import com.microsoft.identity.nativeauth.statemachine.results.MFASubmitChallengeResult;
import com.microsoft.identity.nativeauth.statemachine.results.SignInResult;
import com.microsoft.identity.nativeauth.statemachine.states.AccountState;
import com.microsoft.identity.nativeauth.statemachine.states.BaseState;
import com.microsoft.identity.nativeauth.statemachine.states.Callback;
import com.microsoft.identity.nativeauth.statemachine.states.State;
import java.io.Serializable;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 (2\u00020\u00012\u00020\u00022\u00020\u0003:\u0004()*+B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B-\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0011\u0010\u0015\u001a\u00020\u0016H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\u000e\u0010\u0015\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u001d\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001fJ\u001a\u0010\u001b\u001a\u00020\u00182\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0019\u001a\u00020 J\u0019\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J\u0016\u0010!\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020%J\u0018\u0010&\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u0014H\u0016R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\t\u001a\u00020\bX\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006,"}, d2={"Lcom/microsoft/identity/nativeauth/statemachine/states/MFARequiredState;", "Lcom/microsoft/identity/nativeauth/statemachine/states/BaseState;", "Lcom/microsoft/identity/nativeauth/statemachine/states/State;", "Landroid/os/Parcelable;", "parcel", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "continuationToken", "", "correlationId", "scopes", "", "config", "Lcom/microsoft/identity/nativeauth/NativeAuthPublicClientApplicationConfiguration;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lcom/microsoft/identity/nativeauth/NativeAuthPublicClientApplicationConfiguration;)V", "TAG", "getContinuationToken$msal_distRelease", "()Ljava/lang/String;", "getCorrelationId$msal_distRelease", "describeContents", "", "getAuthMethods", "Lcom/microsoft/identity/nativeauth/statemachine/results/MFAGetAuthMethodsResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "callback", "Lcom/microsoft/identity/nativeauth/statemachine/states/MFARequiredState$GetAuthMethodsCallback;", "requestChallenge", "Lcom/microsoft/identity/nativeauth/statemachine/results/MFARequiredResult;", "authMethod", "Lcom/microsoft/identity/nativeauth/AuthMethod;", "(Lcom/microsoft/identity/nativeauth/AuthMethod;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lcom/microsoft/identity/nativeauth/statemachine/states/MFARequiredState$RequestChallengeCallback;", "submitChallenge", "Lcom/microsoft/identity/nativeauth/statemachine/results/MFASubmitChallengeResult;", "challenge", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lcom/microsoft/identity/nativeauth/statemachine/states/MFARequiredState$SubmitChallengeCallback;", "writeToParcel", "flags", "CREATOR", "GetAuthMethodsCallback", "RequestChallengeCallback", "SubmitChallengeCallback", "msal_distRelease"})
@SourceDebugExtension(value={"SMAP\nMFAStates.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MFAStates.kt\ncom/microsoft/identity/nativeauth/statemachine/states/MFARequiredState\n+ 2 ParcelExtensions.kt\ncom/microsoft/identity/nativeauth/utils/ParcelExtensionsKt\n*L\n1#1,635:1\n32#2,4:636\n*S KotlinDebug\n*F\n+ 1 MFAStates.kt\ncom/microsoft/identity/nativeauth/statemachine/states/MFARequiredState\n*L\n612#1:636,4\n*E\n"})
public final class MFARequiredState
extends BaseState
implements State,
Parcelable {
    @NotNull
    public static final CREATOR CREATOR = new CREATOR(null);
    @NotNull
    private final String continuationToken;
    @NotNull
    private final String correlationId;
    @Nullable
    private final List<String> scopes;
    @NotNull
    private final NativeAuthPublicClientApplicationConfiguration config;
    @NotNull
    private final String TAG;

    public MFARequiredState(@NotNull String continuationToken, @NotNull String correlationId, @Nullable List<String> scopes, @NotNull NativeAuthPublicClientApplicationConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)continuationToken, (String)"continuationToken");
        Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(continuationToken, correlationId);
        this.continuationToken = continuationToken;
        this.correlationId = correlationId;
        this.scopes = scopes;
        this.config = config;
        String string = MFARequiredState.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MFARequiredState::class.java.simpleName");
        this.TAG = string;
    }

    @Override
    @NotNull
    public String getContinuationToken$msal_distRelease() {
        return this.continuationToken;
    }

    @Override
    @NotNull
    public String getCorrelationId$msal_distRelease() {
        return this.correlationId;
    }

    public final void getAuthMethods(@NotNull GetAuthMethodsCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        LogSession.Companion.logMethodCall(this.TAG, this.getCorrelationId$msal_distRelease(), this.TAG + ".getAuthMethods(callback: GetAuthMethodsCallback)");
        BuildersKt.launch$default((CoroutineScope)NativeAuthPublicClientApplication.Companion.getPcaScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, callback, null){
            int label;
            final /* synthetic */ MFARequiredState this$0;
            final /* synthetic */ GetAuthMethodsCallback $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.this$0.getAuthMethods((Continuation<? super MFAGetAuthMethodsResult>)((Continuation)this));
                        ** if (v0 != var3_2) goto lbl11
lbl10:
                        // 1 sources

                        return var3_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            result = (MFAGetAuthMethodsResult)v0;
                            this.$callback.onResult(result);
                        }
                        catch (MsalException e) {
                            Logger.error((String)MFARequiredState.access$getTAG$p(this.this$0), (String)"Exception thrown in getAuthMethods", (Throwable)((Throwable)e));
                            this.$callback.onError(e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Nullable
    public final Object getAuthMethods(@NotNull Continuation<? super MFAGetAuthMethodsResult> $completion) {
        LogSession.Companion.logMethodCall(this.TAG, this.getCorrelationId$msal_distRelease(), this.TAG + ".getAuthMethods()");
        Logger.warn((String)this.TAG, (String)"Warning: this API is experimental. It may be changed in the future without notice. Do not use in production applications.");
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super MFAGetAuthMethodsResult>, Object>(this, null){
            int label;
            final /* synthetic */ MFARequiredState this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            MFAGetAuthMethodsResult mFAGetAuthMethodsResult;
                            INativeAuthCommandResult iNativeAuthCommandResult;
                            Object object2;
                            void var2_2;
                            GetAuthMethodsCommandParameters params = CommandParametersAdapter.createGetAuthMethodsCommandParameters(MFARequiredState.access$getConfig$p(this.this$0), MFARequiredState.access$getConfig$p(this.this$0).getOAuth2TokenCache(), this.this$0.getContinuationToken$msal_distRelease(), this.this$0.getCorrelationId$msal_distRelease());
                            Intrinsics.checkNotNullExpressionValue((Object)params, (String)"params");
                            GetAuthMethodsCommand command2 = new GetAuthMethodsCommand((GetAuthMethodsCommandParameters)var2_2, new NativeAuthMsalController(), "252");
                            CommandResult rawCommandResult = (CommandResult)CommandDispatcher.submitSilentReturningFuture((BaseCommand)((BaseCommand)command2)).get();
                            Intrinsics.checkNotNullExpressionValue((Object)rawCommandResult, (String)"rawCommandResult");
                            CommandResult $this$checkAndWrapCommandResultType$iv = rawCommandResult;
                            boolean $i$f$checkAndWrapCommandResultType = false;
                            if ($this$checkAndWrapCommandResultType$iv.getStatus() != ICommandResult.ResultStatus.COMPLETED) {
                                Exception exception$iv = null;
                                String exceptionMessage$iv = "";
                                if ($this$checkAndWrapCommandResultType$iv.getResult() instanceof Exception) {
                                    Object object3 = $this$checkAndWrapCommandResultType$iv.getResult();
                                    Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                                    exception$iv = (Exception)object3;
                                    exceptionMessage$iv = exception$iv.getMessage();
                                }
                                object2 = exceptionMessage$iv;
                                Exception exception = exception$iv;
                                String string = $this$checkAndWrapCommandResultType$iv.getCorrelationId();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"correlationId");
                                iNativeAuthCommandResult = (INativeAuthCommandResult)((GetAuthMethodsCommandResult)new INativeAuthCommandResult.APIError("unsuccessful_command", (String)object2, null, string, null, exception, 20, null));
                            } else {
                                Object result$iv = $this$checkAndWrapCommandResultType$iv.getResult();
                                boolean bl = false;
                                if (result$iv instanceof Exception) {
                                    String string = "Type casting error: result of " + $this$checkAndWrapCommandResultType$iv + " is of type Exception, even though the command was marked as COMPLETED";
                                    String string2 = $this$checkAndWrapCommandResultType$iv.getCorrelationId();
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.correlationId");
                                    iNativeAuthCommandResult = (INativeAuthCommandResult)((GetAuthMethodsCommandResult)new INativeAuthCommandResult.APIError("unsuccessful_command", string, null, string2, null, null, 52, null));
                                } else {
                                    INativeAuthCommandResult iNativeAuthCommandResult2;
                                    try {
                                        Object object4 = result$iv;
                                        if (object4 == null) {
                                            throw new NullPointerException("null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.controllers.results.GetAuthMethodsCommandResult");
                                        }
                                        iNativeAuthCommandResult2 = (INativeAuthCommandResult)((GetAuthMethodsCommandResult)object4);
                                    }
                                    catch (ClassCastException classCastException) {
                                        String string = "Type casting error: result of " + $this$checkAndWrapCommandResultType$iv + " is not of type " + Reflection.getOrCreateKotlinClass(GetAuthMethodsCommandResult.class) + ", but of type " + Reflection.getOrCreateKotlinClass(result$iv.getClass()) + ", even though the command was marked as COMPLETED";
                                        String string3 = $this$checkAndWrapCommandResultType$iv.getCorrelationId();
                                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this.correlationId");
                                        iNativeAuthCommandResult2 = (INativeAuthCommandResult)((GetAuthMethodsCommandResult)new INativeAuthCommandResult.APIError("unsuccessful_command", string, null, string3, null, null, 52, null));
                                    }
                                    iNativeAuthCommandResult = iNativeAuthCommandResult2;
                                }
                            }
                            GetAuthMethodsCommandResult result = (GetAuthMethodsCommandResult)iNativeAuthCommandResult;
                            if (result instanceof MFACommandResult.SelectionRequired) {
                                mFAGetAuthMethodsResult = new MFARequiredResult.SelectionRequired(new MFARequiredState(((MFACommandResult.SelectionRequired)result).getContinuationToken(), result.getCorrelationId(), MFARequiredState.access$getScopes$p(this.this$0), MFARequiredState.access$getConfig$p(this.this$0)), AuthMethodKt.toListOfAuthMethods(((MFACommandResult.SelectionRequired)result).getAuthMethods()));
                            } else if (result instanceof INativeAuthCommandResult.APIError) {
                                Logger.warnWithObject((String)MFARequiredState.access$getTAG$p(this.this$0), (String)result.getCorrelationId(), (String)"getAuthMethods() received unexpected result: ", (ILoggable)((ILoggable)result));
                                String string = ((INativeAuthCommandResult.APIError)result).getErrorDescription();
                                String string4 = ((INativeAuthCommandResult.APIError)result).getError();
                                String string5 = result.getCorrelationId();
                                List list = ((INativeAuthCommandResult.APIError)result).getErrorCodes();
                                object2 = ((INativeAuthCommandResult.APIError)result).getException();
                                mFAGetAuthMethodsResult = new MFAGetAuthMethodsError(null, string4, string, string5, list, null, (Exception)object2, 33, null);
                            } else if (result instanceof INativeAuthCommandResult.Redirect) {
                                mFAGetAuthMethodsResult = new MFAGetAuthMethodsError("browser_required", ((INativeAuthCommandResult.Redirect)result).getError(), ((INativeAuthCommandResult.Redirect)result).getRedirectReason(), result.getCorrelationId(), null, null, null, 112, null);
                            } else {
                                throw new NoWhenBranchMatchedException();
                            }
                            return mFAGetAuthMethodsResult;
                        }
                        catch (Exception e) {
                            String string = this.this$0.getCorrelationId$msal_distRelease();
                            return new MFAGetAuthMethodsError("client_exception", null, "MSAL client exception occurred in getAuthMethods().", string, null, null, e, 50, null);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super MFAGetAuthMethodsResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public final void requestChallenge(@Nullable AuthMethod authMethod, @NotNull RequestChallengeCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        LogSession.Companion.logMethodCall(this.TAG, this.getCorrelationId$msal_distRelease(), this.TAG + ".requestChallenge(callback: RequestChallengeCallback)");
        BuildersKt.launch$default((CoroutineScope)NativeAuthPublicClientApplication.Companion.getPcaScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, authMethod, callback, null){
            int label;
            final /* synthetic */ MFARequiredState this$0;
            final /* synthetic */ AuthMethod $authMethod;
            final /* synthetic */ RequestChallengeCallback $callback;
            {
                this.this$0 = $receiver;
                this.$authMethod = $authMethod;
                this.$callback = $callback;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.this$0.requestChallenge(this.$authMethod, (Continuation<? super MFARequiredResult>)((Continuation)this));
                        ** if (v0 != var3_2) goto lbl11
lbl10:
                        // 1 sources

                        return var3_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            result = (MFARequiredResult)v0;
                            this.$callback.onResult(result);
                        }
                        catch (MsalException e) {
                            Logger.error((String)MFARequiredState.access$getTAG$p(this.this$0), (String)"Exception thrown in requestChallenge", (Throwable)((Throwable)e));
                            this.$callback.onError(e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static /* synthetic */ void requestChallenge$default(MFARequiredState mFARequiredState, AuthMethod authMethod, RequestChallengeCallback requestChallengeCallback, int n, Object object) {
        if ((n & 1) != 0) {
            authMethod = null;
        }
        mFARequiredState.requestChallenge(authMethod, requestChallengeCallback);
    }

    @Nullable
    public final Object requestChallenge(@Nullable AuthMethod authMethod, @NotNull Continuation<? super MFARequiredResult> $completion) {
        LogSession.Companion.logMethodCall(this.TAG, this.getCorrelationId$msal_distRelease(), this.TAG + ".requestChallenge(authMethod: AuthMethod)");
        Logger.warn((String)this.TAG, (String)"Warning: this API is experimental. It may be changed in the future without notice. Do not use in production applications.");
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super MFARequiredResult>, Object>(authMethod, this, null){
            int label;
            final /* synthetic */ AuthMethod $authMethod;
            final /* synthetic */ MFARequiredState this$0;
            {
                this.$authMethod = $authMethod;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            MFARequiredResult mFARequiredResult;
                            INativeAuthCommandResult iNativeAuthCommandResult;
                            Object object2;
                            void var2_2;
                            MFADefaultChallengeCommandParameters params = this.$authMethod != null ? (MFADefaultChallengeCommandParameters)CommandParametersAdapter.createMFASelectedChallengeCommandParameters(MFARequiredState.access$getConfig$p(this.this$0), MFARequiredState.access$getConfig$p(this.this$0).getOAuth2TokenCache(), this.this$0.getContinuationToken$msal_distRelease(), this.this$0.getCorrelationId$msal_distRelease(), this.$authMethod) : CommandParametersAdapter.createMFADefaultChallengeCommandParameters(MFARequiredState.access$getConfig$p(this.this$0), MFARequiredState.access$getConfig$p(this.this$0).getOAuth2TokenCache(), this.this$0.getContinuationToken$msal_distRelease(), this.this$0.getCorrelationId$msal_distRelease(), MFARequiredState.access$getScopes$p(this.this$0));
                            Intrinsics.checkNotNullExpressionValue((Object)params, (String)"params");
                            MFAChallengeCommand command2 = new MFAChallengeCommand((MFADefaultChallengeCommandParameters)var2_2, new NativeAuthMsalController(), "253");
                            CommandResult rawCommandResult = (CommandResult)CommandDispatcher.submitSilentReturningFuture((BaseCommand)((BaseCommand)command2)).get();
                            Intrinsics.checkNotNullExpressionValue((Object)rawCommandResult, (String)"rawCommandResult");
                            CommandResult $this$checkAndWrapCommandResultType$iv = rawCommandResult;
                            boolean $i$f$checkAndWrapCommandResultType = false;
                            if ($this$checkAndWrapCommandResultType$iv.getStatus() != ICommandResult.ResultStatus.COMPLETED) {
                                Exception exception$iv = null;
                                String exceptionMessage$iv = "";
                                if ($this$checkAndWrapCommandResultType$iv.getResult() instanceof Exception) {
                                    Object object3 = $this$checkAndWrapCommandResultType$iv.getResult();
                                    Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                                    exception$iv = (Exception)object3;
                                    exceptionMessage$iv = exception$iv.getMessage();
                                }
                                object2 = exceptionMessage$iv;
                                Exception exception = exception$iv;
                                String string = $this$checkAndWrapCommandResultType$iv.getCorrelationId();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"correlationId");
                                iNativeAuthCommandResult = (INativeAuthCommandResult)((MFAChallengeCommandResult)new INativeAuthCommandResult.APIError("unsuccessful_command", (String)object2, null, string, null, exception, 20, null));
                            } else {
                                Object result$iv = $this$checkAndWrapCommandResultType$iv.getResult();
                                boolean bl = false;
                                if (result$iv instanceof Exception) {
                                    String string = "Type casting error: result of " + $this$checkAndWrapCommandResultType$iv + " is of type Exception, even though the command was marked as COMPLETED";
                                    String string2 = $this$checkAndWrapCommandResultType$iv.getCorrelationId();
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.correlationId");
                                    iNativeAuthCommandResult = (INativeAuthCommandResult)((MFAChallengeCommandResult)new INativeAuthCommandResult.APIError("unsuccessful_command", string, null, string2, null, null, 52, null));
                                } else {
                                    INativeAuthCommandResult iNativeAuthCommandResult2;
                                    try {
                                        Object object4 = result$iv;
                                        if (object4 == null) {
                                            throw new NullPointerException("null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.controllers.results.MFAChallengeCommandResult");
                                        }
                                        iNativeAuthCommandResult2 = (INativeAuthCommandResult)((MFAChallengeCommandResult)object4);
                                    }
                                    catch (ClassCastException classCastException) {
                                        String string = "Type casting error: result of " + $this$checkAndWrapCommandResultType$iv + " is not of type " + Reflection.getOrCreateKotlinClass(MFAChallengeCommandResult.class) + ", but of type " + Reflection.getOrCreateKotlinClass(result$iv.getClass()) + ", even though the command was marked as COMPLETED";
                                        String string3 = $this$checkAndWrapCommandResultType$iv.getCorrelationId();
                                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this.correlationId");
                                        iNativeAuthCommandResult2 = (INativeAuthCommandResult)((MFAChallengeCommandResult)new INativeAuthCommandResult.APIError("unsuccessful_command", string, null, string3, null, null, 52, null));
                                    }
                                    iNativeAuthCommandResult = iNativeAuthCommandResult2;
                                }
                            }
                            MFAChallengeCommandResult result = (MFAChallengeCommandResult)iNativeAuthCommandResult;
                            if (result instanceof MFACommandResult.VerificationRequired) {
                                mFARequiredResult = new MFARequiredResult.VerificationRequired(new MFARequiredState(((MFACommandResult.VerificationRequired)result).getContinuationToken(), result.getCorrelationId(), MFARequiredState.access$getScopes$p(this.this$0), MFARequiredState.access$getConfig$p(this.this$0)), ((MFACommandResult.VerificationRequired)result).getCodeLength(), ((MFACommandResult.VerificationRequired)result).getChallengeTargetLabel(), ((MFACommandResult.VerificationRequired)result).getChallengeChannel());
                            } else if (result instanceof MFACommandResult.SelectionRequired) {
                                mFARequiredResult = new MFARequiredResult.SelectionRequired(new MFARequiredState(((MFACommandResult.SelectionRequired)result).getContinuationToken(), result.getCorrelationId(), MFARequiredState.access$getScopes$p(this.this$0), MFARequiredState.access$getConfig$p(this.this$0)), AuthMethodKt.toListOfAuthMethods(((MFACommandResult.SelectionRequired)result).getAuthMethods()));
                            } else if (result instanceof INativeAuthCommandResult.APIError) {
                                Logger.warnWithObject((String)MFARequiredState.access$getTAG$p(this.this$0), (String)result.getCorrelationId(), (String)"requestChallenge(authMethod) received unexpected result: ", (ILoggable)((ILoggable)result));
                                String string = ((INativeAuthCommandResult.APIError)result).getErrorDescription();
                                String string4 = ((INativeAuthCommandResult.APIError)result).getError();
                                String string5 = result.getCorrelationId();
                                List list = ((INativeAuthCommandResult.APIError)result).getErrorCodes();
                                object2 = ((INativeAuthCommandResult.APIError)result).getException();
                                mFARequiredResult = new MFARequestChallengeError(null, string4, string, string5, list, null, (Exception)object2, 33, null);
                            } else if (result instanceof INativeAuthCommandResult.Redirect) {
                                mFARequiredResult = new MFARequestChallengeError("browser_required", ((INativeAuthCommandResult.Redirect)result).getError(), ((INativeAuthCommandResult.Redirect)result).getRedirectReason(), result.getCorrelationId(), null, null, null, 112, null);
                            } else {
                                throw new NoWhenBranchMatchedException();
                            }
                            return mFARequiredResult;
                        }
                        catch (Exception e) {
                            String string = this.this$0.getCorrelationId$msal_distRelease();
                            return new MFARequestChallengeError("client_exception", null, "MSAL client exception occurred in requestChallenge(authMethod).", string, null, null, e, 50, null);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super MFARequiredResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static /* synthetic */ Object requestChallenge$default(MFARequiredState mFARequiredState, AuthMethod authMethod, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            authMethod = null;
        }
        return mFARequiredState.requestChallenge(authMethod, (Continuation<? super MFARequiredResult>)continuation);
    }

    public final void submitChallenge(@NotNull String challenge, @NotNull SubmitChallengeCallback callback) {
        Intrinsics.checkNotNullParameter((Object)challenge, (String)"challenge");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        LogSession.Companion.logMethodCall(this.TAG, this.getCorrelationId$msal_distRelease(), this.TAG + ".submitChallenge(callback: SubmitChallengeCallback)");
        BuildersKt.launch$default((CoroutineScope)NativeAuthPublicClientApplication.Companion.getPcaScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, challenge, callback, null){
            int label;
            final /* synthetic */ MFARequiredState this$0;
            final /* synthetic */ String $challenge;
            final /* synthetic */ SubmitChallengeCallback $callback;
            {
                this.this$0 = $receiver;
                this.$challenge = $challenge;
                this.$callback = $callback;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.this$0.submitChallenge(this.$challenge, (Continuation<? super MFASubmitChallengeResult>)((Continuation)this));
                        ** if (v0 != var3_2) goto lbl11
lbl10:
                        // 1 sources

                        return var3_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            result = (MFASubmitChallengeResult)v0;
                            this.$callback.onResult(result);
                        }
                        catch (MsalException e) {
                            Logger.error((String)MFARequiredState.access$getTAG$p(this.this$0), (String)"Exception thrown in submitChallenge", (Throwable)((Throwable)e));
                            this.$callback.onError(e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Nullable
    public final Object submitChallenge(@NotNull String challenge, @NotNull Continuation<? super MFASubmitChallengeResult> $completion) {
        LogSession.Companion.logMethodCall(this.TAG, this.getCorrelationId$msal_distRelease(), this.TAG + ".submitChallenge(challenge: String)");
        Logger.warn((String)this.TAG, (String)"Warning: this API is experimental. It may be changed in the future without notice. Do not use in production applications.");
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super MFASubmitChallengeResult>, Object>(this, challenge, null){
            int label;
            final /* synthetic */ MFARequiredState this$0;
            final /* synthetic */ String $challenge;
            {
                this.this$0 = $receiver;
                this.$challenge = $challenge;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            MFASubmitChallengeResult mFASubmitChallengeResult;
                            INativeAuthCommandResult iNativeAuthCommandResult;
                            Object object2;
                            void var2_2;
                            MFASubmitChallengeCommandParameters params = CommandParametersAdapter.createMFASubmitChallengeCommandParameters(MFARequiredState.access$getConfig$p(this.this$0), MFARequiredState.access$getConfig$p(this.this$0).getOAuth2TokenCache(), this.$challenge, this.this$0.getCorrelationId$msal_distRelease(), this.this$0.getContinuationToken$msal_distRelease(), MFARequiredState.access$getScopes$p(this.this$0));
                            Intrinsics.checkNotNullExpressionValue((Object)params, (String)"params");
                            MFASubmitChallengeCommand command2 = new MFASubmitChallengeCommand((MFASubmitChallengeCommandParameters)var2_2, new NativeAuthMsalController(), "254");
                            CommandResult rawCommandResult = (CommandResult)CommandDispatcher.submitSilentReturningFuture((BaseCommand)((BaseCommand)command2)).get();
                            Intrinsics.checkNotNullExpressionValue((Object)rawCommandResult, (String)"rawCommandResult");
                            CommandResult $this$checkAndWrapCommandResultType$iv = rawCommandResult;
                            boolean $i$f$checkAndWrapCommandResultType = false;
                            if ($this$checkAndWrapCommandResultType$iv.getStatus() != ICommandResult.ResultStatus.COMPLETED) {
                                Exception exception$iv = null;
                                String exceptionMessage$iv = "";
                                if ($this$checkAndWrapCommandResultType$iv.getResult() instanceof Exception) {
                                    Object object3 = $this$checkAndWrapCommandResultType$iv.getResult();
                                    Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
                                    exception$iv = (Exception)object3;
                                    exceptionMessage$iv = exception$iv.getMessage();
                                }
                                object2 = exceptionMessage$iv;
                                Exception exception = exception$iv;
                                String string = $this$checkAndWrapCommandResultType$iv.getCorrelationId();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"correlationId");
                                iNativeAuthCommandResult = (INativeAuthCommandResult)((MFASubmitChallengeCommandResult)new INativeAuthCommandResult.APIError("unsuccessful_command", (String)object2, null, string, null, exception, 20, null));
                            } else {
                                Object result$iv = $this$checkAndWrapCommandResultType$iv.getResult();
                                boolean bl = false;
                                if (result$iv instanceof Exception) {
                                    String string = "Type casting error: result of " + $this$checkAndWrapCommandResultType$iv + " is of type Exception, even though the command was marked as COMPLETED";
                                    String string2 = $this$checkAndWrapCommandResultType$iv.getCorrelationId();
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this.correlationId");
                                    iNativeAuthCommandResult = (INativeAuthCommandResult)((MFASubmitChallengeCommandResult)new INativeAuthCommandResult.APIError("unsuccessful_command", string, null, string2, null, null, 52, null));
                                } else {
                                    INativeAuthCommandResult iNativeAuthCommandResult2;
                                    try {
                                        Object object4 = result$iv;
                                        if (object4 == null) {
                                            throw new NullPointerException("null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.controllers.results.MFASubmitChallengeCommandResult");
                                        }
                                        iNativeAuthCommandResult2 = (INativeAuthCommandResult)((MFASubmitChallengeCommandResult)object4);
                                    }
                                    catch (ClassCastException classCastException) {
                                        String string = "Type casting error: result of " + $this$checkAndWrapCommandResultType$iv + " is not of type " + Reflection.getOrCreateKotlinClass(MFASubmitChallengeCommandResult.class) + ", but of type " + Reflection.getOrCreateKotlinClass(result$iv.getClass()) + ", even though the command was marked as COMPLETED";
                                        String string3 = $this$checkAndWrapCommandResultType$iv.getCorrelationId();
                                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this.correlationId");
                                        iNativeAuthCommandResult2 = (INativeAuthCommandResult)((MFASubmitChallengeCommandResult)new INativeAuthCommandResult.APIError("unsuccessful_command", string, null, string3, null, null, 52, null));
                                    }
                                    iNativeAuthCommandResult = iNativeAuthCommandResult2;
                                }
                            }
                            MFASubmitChallengeCommandResult result = (MFASubmitChallengeCommandResult)iNativeAuthCommandResult;
                            if (result instanceof SignInCommandResult.Complete) {
                                IAuthenticationResult authenticationResult = AuthenticationResultAdapter.adapt(((SignInCommandResult.Complete)result).getAuthenticationResult());
                                Intrinsics.checkNotNullExpressionValue((Object)authenticationResult, (String)"authenticationResult");
                                mFASubmitChallengeResult = new SignInResult.Complete(AccountState.CREATOR.createFromAuthenticationResult(authenticationResult, result.getCorrelationId(), MFARequiredState.access$getConfig$p(this.this$0)));
                            } else if (result instanceof SignInCommandResult.IncorrectCode) {
                                mFASubmitChallengeResult = new MFASubmitChallengeError("invalid_challenge", ((SignInCommandResult.IncorrectCode)result).getError(), ((SignInCommandResult.IncorrectCode)result).getErrorDescription(), result.getCorrelationId(), ((SignInCommandResult.IncorrectCode)result).getErrorCodes(), ((SignInCommandResult.IncorrectCode)result).getSubError(), null, 64, null);
                            } else if (result instanceof INativeAuthCommandResult.Redirect) {
                                mFASubmitChallengeResult = new MFASubmitChallengeError("browser_required", ((INativeAuthCommandResult.Redirect)result).getError(), ((INativeAuthCommandResult.Redirect)result).getRedirectReason(), result.getCorrelationId(), ((INativeAuthCommandResult.Redirect)result).getErrorCodes(), null, null, 96, null);
                            } else if (result instanceof INativeAuthCommandResult.APIError) {
                                Logger.warnWithObject((String)MFARequiredState.access$getTAG$p(this.this$0), (String)result.getCorrelationId(), (String)"submitChallenge(challenge) received unexpected result: ", (ILoggable)((ILoggable)result));
                                String string = ((INativeAuthCommandResult.APIError)result).getErrorDescription();
                                String string4 = ((INativeAuthCommandResult.APIError)result).getError();
                                String string5 = result.getCorrelationId();
                                List list = ((INativeAuthCommandResult.APIError)result).getErrorCodes();
                                object2 = ((INativeAuthCommandResult.APIError)result).getException();
                                mFASubmitChallengeResult = new MFASubmitChallengeError(null, string4, string, string5, list, null, (Exception)object2, 33, null);
                            } else {
                                throw new NoWhenBranchMatchedException();
                            }
                            return mFASubmitChallengeResult;
                        }
                        catch (Exception e) {
                            String string = this.this$0.getCorrelationId$msal_distRelease();
                            return new MFASubmitChallengeError("client_exception", null, "MSAL client exception occurred in submitChallenge(challenge)", string, null, null, e, 50, null);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super MFASubmitChallengeResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public MFARequiredState(@NotNull Parcel parcel) {
        Serializable serializable;
        String string;
        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
        String string2 = parcel.readString();
        if (string2 == null) {
            string2 = "";
        }
        if ((string = parcel.readString()) == null) {
            string = "UNSET";
        }
        List list = parcel.createStringArrayList();
        Parcel $this$serializable$iv = parcel;
        boolean $i$f$serializable = false;
        if (Build.VERSION.SDK_INT >= 33) {
            serializable = (Serializable)$this$serializable$iv.readSerializable(NativeAuthPublicClientApplicationConfiguration.class.getClassLoader(), NativeAuthPublicClientApplicationConfiguration.class);
        } else {
            Serializable serializable2 = $this$serializable$iv.readSerializable();
            if (!(serializable2 instanceof NativeAuthPublicClientApplicationConfiguration)) {
                serializable2 = null;
            }
            serializable = (NativeAuthPublicClientApplicationConfiguration)serializable2;
        }
        Intrinsics.checkNotNull((Object)serializable, (String)"null cannot be cast to non-null type com.microsoft.identity.nativeauth.NativeAuthPublicClientApplicationConfiguration");
        this(string2, string, list, (NativeAuthPublicClientApplicationConfiguration)serializable);
    }

    public void writeToParcel(@NotNull Parcel parcel, int flags) {
        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
        parcel.writeString(this.getContinuationToken$msal_distRelease());
        parcel.writeString(this.getCorrelationId$msal_distRelease());
        parcel.writeStringList(this.scopes);
        parcel.writeSerializable((Serializable)this.config);
    }

    public int describeContents() {
        return 0;
    }

    public static final /* synthetic */ String access$getTAG$p(MFARequiredState $this) {
        return $this.TAG;
    }

    public static final /* synthetic */ NativeAuthPublicClientApplicationConfiguration access$getConfig$p(MFARequiredState $this) {
        return $this.config;
    }

    public static final /* synthetic */ List access$getScopes$p(MFARequiredState $this) {
        return $this.scopes;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a8\u0006\u0003"}, d2={"Lcom/microsoft/identity/nativeauth/statemachine/states/MFARequiredState$GetAuthMethodsCallback;", "Lcom/microsoft/identity/nativeauth/statemachine/states/Callback;", "Lcom/microsoft/identity/nativeauth/statemachine/results/MFAGetAuthMethodsResult;", "msal_distRelease"})
    public static interface GetAuthMethodsCallback
    extends Callback<MFAGetAuthMethodsResult> {
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a8\u0006\u0003"}, d2={"Lcom/microsoft/identity/nativeauth/statemachine/states/MFARequiredState$RequestChallengeCallback;", "Lcom/microsoft/identity/nativeauth/statemachine/states/Callback;", "Lcom/microsoft/identity/nativeauth/statemachine/results/MFARequiredResult;", "msal_distRelease"})
    public static interface RequestChallengeCallback
    extends Callback<MFARequiredResult> {
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a8\u0006\u0003"}, d2={"Lcom/microsoft/identity/nativeauth/statemachine/states/MFARequiredState$SubmitChallengeCallback;", "Lcom/microsoft/identity/nativeauth/statemachine/states/Callback;", "Lcom/microsoft/identity/nativeauth/statemachine/results/MFASubmitChallengeResult;", "msal_distRelease"})
    public static interface SubmitChallengeCallback
    extends Callback<MFASubmitChallengeResult> {
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001d\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/microsoft/identity/nativeauth/statemachine/states/MFARequiredState$CREATOR;", "Landroid/os/Parcelable$Creator;", "Lcom/microsoft/identity/nativeauth/statemachine/states/MFARequiredState;", "()V", "createFromParcel", "parcel", "Landroid/os/Parcel;", "newArray", "", "size", "", "(I)[Lcom/microsoft/identity/nativeauth/statemachine/states/MFARequiredState;", "msal_distRelease"})
    public static final class CREATOR
    implements Parcelable.Creator<MFARequiredState> {
        private CREATOR() {
        }

        @NotNull
        public MFARequiredState createFromParcel(@NotNull Parcel parcel) {
            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
            return new MFARequiredState(parcel);
        }

        @NotNull
        public MFARequiredState[] newArray(int size) {
            return new MFARequiredState[size];
        }

        public /* synthetic */ CREATOR(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

