/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.app.Activity;
import androidx.annotation.Nullable;
import com.microsoft.identity.client.AuthenticationCallback;
import com.microsoft.identity.client.Prompt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public class SignInParameters {
    @NonNull
    private Activity activity;
    @Nullable
    private String loginHint;
    @NonNull
    private List<String> scopes;
    @Nullable
    private Prompt prompt;
    @NonNull
    private AuthenticationCallback callback;

    SignInParameters(@NonNull Activity activity, @Nullable String loginHint, @NonNull List<String> scopes, @Nullable Prompt prompt, @NonNull AuthenticationCallback callback) {
        if (activity == null) {
            throw new NullPointerException("activity is marked non-null but is null");
        }
        if (scopes == null) {
            throw new NullPointerException("scopes is marked non-null but is null");
        }
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        this.activity = activity;
        this.loginHint = loginHint;
        this.scopes = scopes;
        this.prompt = prompt;
        this.callback = callback;
    }

    public static SignInParametersBuilder builder() {
        return new SignInParametersBuilder();
    }

    @NonNull
    public Activity getActivity() {
        return this.activity;
    }

    @Nullable
    public String getLoginHint() {
        return this.loginHint;
    }

    @NonNull
    public List<String> getScopes() {
        return this.scopes;
    }

    @Nullable
    public Prompt getPrompt() {
        return this.prompt;
    }

    @NonNull
    public AuthenticationCallback getCallback() {
        return this.callback;
    }

    public void setActivity(@NonNull Activity activity) {
        if (activity == null) {
            throw new NullPointerException("activity is marked non-null but is null");
        }
        this.activity = activity;
    }

    public void setLoginHint(@Nullable String loginHint) {
        this.loginHint = loginHint;
    }

    public void setScopes(@NonNull List<String> scopes) {
        if (scopes == null) {
            throw new NullPointerException("scopes is marked non-null but is null");
        }
        this.scopes = scopes;
    }

    public void setPrompt(@Nullable Prompt prompt) {
        this.prompt = prompt;
    }

    public void setCallback(@NonNull AuthenticationCallback callback) {
        if (callback == null) {
            throw new NullPointerException("callback is marked non-null but is null");
        }
        this.callback = callback;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignInParameters)) {
            return false;
        }
        SignInParameters other = (SignInParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Activity this$activity = this.getActivity();
        Activity other$activity = other.getActivity();
        if (this$activity == null ? other$activity != null : !this$activity.equals(other$activity)) {
            return false;
        }
        String this$loginHint = this.getLoginHint();
        String other$loginHint = other.getLoginHint();
        if (this$loginHint == null ? other$loginHint != null : !this$loginHint.equals(other$loginHint)) {
            return false;
        }
        List<String> this$scopes = this.getScopes();
        List<String> other$scopes = other.getScopes();
        if (this$scopes == null ? other$scopes != null : !((Object)this$scopes).equals(other$scopes)) {
            return false;
        }
        Prompt this$prompt = this.getPrompt();
        Prompt other$prompt = other.getPrompt();
        if (this$prompt == null ? other$prompt != null : !((Object)((Object)this$prompt)).equals((Object)other$prompt)) {
            return false;
        }
        AuthenticationCallback this$callback = this.getCallback();
        AuthenticationCallback other$callback = other.getCallback();
        return !(this$callback == null ? other$callback != null : !this$callback.equals(other$callback));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SignInParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Activity $activity = this.getActivity();
        result = result * 59 + ($activity == null ? 43 : $activity.hashCode());
        String $loginHint = this.getLoginHint();
        result = result * 59 + ($loginHint == null ? 43 : $loginHint.hashCode());
        List<String> $scopes = this.getScopes();
        result = result * 59 + ($scopes == null ? 43 : ((Object)$scopes).hashCode());
        Prompt $prompt = this.getPrompt();
        result = result * 59 + ($prompt == null ? 43 : ((Object)((Object)$prompt)).hashCode());
        AuthenticationCallback $callback = this.getCallback();
        result = result * 59 + ($callback == null ? 43 : $callback.hashCode());
        return result;
    }

    public String toString() {
        return "SignInParameters(activity=" + this.getActivity() + ", loginHint=" + this.getLoginHint() + ", scopes=" + this.getScopes() + ", prompt=" + (Object)((Object)this.getPrompt()) + ", callback=" + this.getCallback() + ")";
    }

    public static class SignInParametersBuilder {
        private Activity activity;
        private String loginHint;
        private ArrayList<String> scopes;
        private Prompt prompt;
        private AuthenticationCallback callback;

        SignInParametersBuilder() {
        }

        public SignInParametersBuilder withActivity(@NonNull Activity activity) {
            if (activity == null) {
                throw new NullPointerException("activity is marked non-null but is null");
            }
            this.activity = activity;
            return this;
        }

        public SignInParametersBuilder withLoginHint(@Nullable String loginHint) {
            this.loginHint = loginHint;
            return this;
        }

        public SignInParametersBuilder withScope(String scope) {
            if (this.scopes == null) {
                this.scopes = new ArrayList();
            }
            this.scopes.add(scope);
            return this;
        }

        public SignInParametersBuilder withScopes(Collection<? extends String> scopes) {
            if (scopes == null) {
                throw new NullPointerException("scopes cannot be null");
            }
            if (this.scopes == null) {
                this.scopes = new ArrayList();
            }
            this.scopes.addAll(scopes);
            return this;
        }

        public SignInParametersBuilder clearScopes() {
            if (this.scopes != null) {
                this.scopes.clear();
            }
            return this;
        }

        public SignInParametersBuilder withPrompt(@Nullable Prompt prompt) {
            this.prompt = prompt;
            return this;
        }

        public SignInParametersBuilder withCallback(@NonNull AuthenticationCallback callback) {
            if (callback == null) {
                throw new NullPointerException("callback is marked non-null but is null");
            }
            this.callback = callback;
            return this;
        }

        public SignInParameters build() {
            List<String> scopes;
            switch (this.scopes == null ? 0 : this.scopes.size()) {
                case 0: {
                    scopes = Collections.emptyList();
                    break;
                }
                case 1: {
                    scopes = Collections.singletonList(this.scopes.get(0));
                    break;
                }
                default: {
                    scopes = Collections.unmodifiableList(new ArrayList<String>(this.scopes));
                }
            }
            return new SignInParameters(this.activity, this.loginHint, scopes, this.prompt, this.callback);
        }

        public String toString() {
            return "SignInParameters.SignInParametersBuilder(activity=" + this.activity + ", loginHint=" + this.loginHint + ", scopes=" + this.scopes + ", prompt=" + (Object)((Object)this.prompt) + ", callback=" + this.callback + ")";
        }
    }
}

