/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.nativeauth;

import android.text.TextUtils;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.client.PublicClientApplicationConfiguration;
import com.microsoft.identity.client.configuration.AccountMode;
import com.microsoft.identity.client.exception.MsalClientException;
import com.microsoft.identity.common.java.authorities.Authority;
import com.microsoft.identity.common.java.authorities.CIAMAuthority;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.nativeauth.authorities.NativeAuthCIAMAuthority;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0002\u001f B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005J\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005J\u000e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0000J\u0016\u0010\u001a\u001a\u00020\u00152\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005J\u0016\u0010\u001b\u001a\u00020\u00152\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005J\b\u0010\u001c\u001a\u00020\u0015H\u0002J\b\u0010\u001d\u001a\u00020\u0015H\u0002J\b\u0010\u001e\u001a\u00020\u0015H\u0016R\u001a\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\"\u0010\r\u001a\u0004\u0018\u00010\u000e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006!"}, d2={"Lcom/microsoft/identity/nativeauth/NativeAuthPublicClientApplicationConfiguration;", "Lcom/microsoft/identity/client/PublicClientApplicationConfiguration;", "Ljava/io/Serializable;", "()V", "capabilities", "", "", "challengeTypes", "dc", "getDc", "()Ljava/lang/String;", "setDc", "(Ljava/lang/String;)V", "useMockAuthority", "", "getUseMockAuthority", "()Ljava/lang/Boolean;", "setUseMockAuthority", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "checkIntentFilterAddedToAppManifestForBrokerFlow", "", "getCapabilities", "getChallengeTypes", "mergeConfiguration", "config", "setCapabilities", "setChallengeTypes", "validateCapabilities", "validateChallengeTypes", "validateConfiguration", "Companion", "NativeAuthSerializedNames", "msal_distRelease"})
public final class NativeAuthPublicClientApplicationConfiguration
extends PublicClientApplicationConfiguration
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @SerializedName(value="challenge_types")
    @Nullable
    private List<String> challengeTypes;
    @SerializedName(value="capabilities")
    @Nullable
    private List<String> capabilities;
    @SerializedName(value="use_mock_api_for_native_auth")
    @Nullable
    private Boolean useMockAuthority;
    @SerializedName(value="dc")
    @Nullable
    private String dc;
    private static final String TAG = NativeAuthPublicClientApplicationConfiguration.class.getSimpleName();
    @NotNull
    private static final List<String> VALID_CHALLENGE_TYPES;
    @NotNull
    private static final List<String> VALID_CAPABILITIES;

    @Nullable
    public final Boolean getUseMockAuthority() {
        return this.useMockAuthority;
    }

    public final void setUseMockAuthority(@Nullable Boolean bl) {
        this.useMockAuthority = bl;
    }

    @Nullable
    public final String getDc() {
        return this.dc;
    }

    public final void setDc(@Nullable String string) {
        this.dc = string;
    }

    @Nullable
    public final List<String> getChallengeTypes() {
        return this.challengeTypes;
    }

    public final void setChallengeTypes(@Nullable List<String> challengeTypes) {
        this.challengeTypes = challengeTypes;
    }

    @Nullable
    public final List<String> getCapabilities() {
        return this.capabilities;
    }

    public final void setCapabilities(@Nullable List<String> capabilities) {
        this.capabilities = capabilities;
    }

    public final void mergeConfiguration(@NotNull NativeAuthPublicClientApplicationConfiguration config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super.mergeConfiguration(config);
        this.setAccountMode(config.getAccountMode() != null ? config.getAccountMode() : this.getAccountMode());
        this.challengeTypes = config.challengeTypes == null ? this.challengeTypes : config.challengeTypes;
        this.capabilities = config.capabilities == null ? this.capabilities : config.capabilities;
        this.useMockAuthority = config.useMockAuthority == null ? this.useMockAuthority : config.useMockAuthority;
        this.dc = config.dc == null ? this.dc : config.dc;
    }

    @Override
    public void validateConfiguration() {
        if (TextUtils.isEmpty((CharSequence)this.getClientId())) {
            throw new MsalClientException("native_auth_use_without_client_id", "NativeAuthPublicClientApplication cannot be used without a client ID");
        }
        if (this.getRedirectUri() != null) {
            super.validateConfiguration();
        } else {
            Logger.warn((String)TAG, (String)"No redirect URI was passed.");
        }
        if (this.getAccountMode() != AccountMode.SINGLE) {
            throw new MsalClientException("native_auth_invalid_account_mode_config", "NativeAuthPublicClientApplication Native auth apps cannot be used with anything other than SINGLE account mode");
        }
        if (this.getAuthorities() == null || this.getAuthorities().size() == 0) {
            throw new MsalClientException("native_auth_use_with_no_authority", "NativeAuthPublicClientApplication can't be used with no authority.");
        }
        if (this.getAuthorities().size() > 1) {
            throw new MsalClientException("native_auth_use_with_multi_authority", "NativeAuthPublicClientApplication can't be used with multiple authorities");
        }
        if (!(this.getDefaultAuthority() instanceof NativeAuthCIAMAuthority)) {
            if (this.getDefaultAuthority() instanceof CIAMAuthority) {
                String string = this.getDefaultAuthority().getAuthorityUri().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"defaultAuthority.authorityUri.toString()");
                String string2 = this.getClientId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"clientId");
                NativeAuthCIAMAuthority nativeAuthAuthority = new NativeAuthCIAMAuthority(string, string2);
                this.getAuthorities().clear();
                this.getAuthorities().add((Authority)nativeAuthAuthority);
            } else {
                throw new MsalClientException("native_auth_invalid_ciam_authority", "NativeAuthPublicClientApplication can only be used with a valid CIAM Authority");
            }
        }
        if (this.getIsSharedDevice()) {
            throw new MsalClientException("native_auth_shared_device_mode", "NativeAuthPublicClientApplication cannot be used in shared device mode");
        }
        this.validateChallengeTypes();
        this.validateCapabilities();
    }

    /*
     * WARNING - void declaration
     */
    private final void validateChallengeTypes() throws MsalClientException {
        block4: {
            List list;
            NativeAuthPublicClientApplicationConfiguration nativeAuthPublicClientApplicationConfiguration = this;
            List<String> list2 = this.challengeTypes;
            if (list2 != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = list2;
                NativeAuthPublicClientApplicationConfiguration nativeAuthPublicClientApplicationConfiguration2 = nativeAuthPublicClientApplicationConfiguration;
                boolean $i$f$map = false;
                Iterator iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string2 = it.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    collection.add(string2);
                }
                list = (List)destination$iv$iv;
                nativeAuthPublicClientApplicationConfiguration = nativeAuthPublicClientApplicationConfiguration2;
            } else {
                list = null;
            }
            nativeAuthPublicClientApplicationConfiguration.challengeTypes = list;
            List<String> list3 = this.challengeTypes;
            this.challengeTypes = list3 != null ? CollectionsKt.distinct((Iterable)list3) : null;
            List<String> list4 = this.challengeTypes;
            if (list4 == null) break block4;
            Iterable $this$forEach$iv = list4;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String challengeType = (String)element$iv;
                boolean bl = false;
                if (VALID_CHALLENGE_TYPES.contains(challengeType)) continue;
                throw new MsalClientException("native_auth_invalid_challenge_type", "NativeAuthPublicClientApplication detected invalid challenge type. \"" + challengeType + '\"');
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void validateCapabilities() throws MsalClientException {
        block4: {
            List list;
            NativeAuthPublicClientApplicationConfiguration nativeAuthPublicClientApplicationConfiguration = this;
            List<String> list2 = this.capabilities;
            if (list2 != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = list2;
                NativeAuthPublicClientApplicationConfiguration nativeAuthPublicClientApplicationConfiguration2 = nativeAuthPublicClientApplicationConfiguration;
                boolean $i$f$map = false;
                Iterator iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string2 = it.toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    collection.add(string2);
                }
                list = (List)destination$iv$iv;
                nativeAuthPublicClientApplicationConfiguration = nativeAuthPublicClientApplicationConfiguration2;
            } else {
                list = null;
            }
            nativeAuthPublicClientApplicationConfiguration.capabilities = list;
            List<String> list3 = this.capabilities;
            this.capabilities = list3 != null ? CollectionsKt.distinct((Iterable)list3) : null;
            List<String> list4 = this.capabilities;
            if (list4 == null) break block4;
            Iterable $this$forEach$iv = list4;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String capability = (String)element$iv;
                boolean bl = false;
                if (VALID_CAPABILITIES.contains(capability)) continue;
                throw new MsalClientException("native_auth_invalid_capability", "NativeAuthPublicClientApplication detected invalid capability. \"" + capability + '\"');
            }
        }
    }

    @Override
    public void checkIntentFilterAddedToAppManifestForBrokerFlow() throws MsalClientException {
        if (this.getRedirectUri() != null) {
            super.checkIntentFilterAddedToAppManifestForBrokerFlow();
        }
    }

    static {
        Object[] objectArray = new String[]{"password", "oob", "redirect"};
        VALID_CHALLENGE_TYPES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"mfa_required", "registration_required"};
        VALID_CAPABILITIES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/microsoft/identity/nativeauth/NativeAuthPublicClientApplicationConfiguration$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "VALID_CAPABILITIES", "", "VALID_CHALLENGE_TYPES", "msal_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/microsoft/identity/nativeauth/NativeAuthPublicClientApplicationConfiguration$NativeAuthSerializedNames;", "", "()V", "CAPABILITIES", "", "CHALLENGE_TYPES", "DC", "USE_MOCK_API", "msal_distRelease"})
    private static final class NativeAuthSerializedNames {
        @NotNull
        public static final NativeAuthSerializedNames INSTANCE = new NativeAuthSerializedNames();
        @NotNull
        public static final String CHALLENGE_TYPES = "challenge_types";
        @NotNull
        public static final String CAPABILITIES = "capabilities";
        @NotNull
        public static final String USE_MOCK_API = "use_mock_api_for_native_auth";
        @NotNull
        public static final String DC = "dc";

        private NativeAuthSerializedNames() {
        }
    }
}

