/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.nativeauth.statemachine.states;

import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import com.microsoft.identity.client.Account;
import com.microsoft.identity.client.AcquireTokenSilentParameters;
import com.microsoft.identity.client.AuthenticationResultAdapter;
import com.microsoft.identity.client.IAccount;
import com.microsoft.identity.client.IAuthenticationResult;
import com.microsoft.identity.client.PublicClientApplication;
import com.microsoft.identity.client.exception.MsalClientException;
import com.microsoft.identity.client.exception.MsalException;
import com.microsoft.identity.client.internal.CommandParametersAdapter;
import com.microsoft.identity.common.internal.commands.RemoveCurrentAccountCommand;
import com.microsoft.identity.common.internal.controllers.LocalMSALController;
import com.microsoft.identity.common.java.AuthenticationConstants;
import com.microsoft.identity.common.java.commands.BaseCommand;
import com.microsoft.identity.common.java.commands.CommandCallback;
import com.microsoft.identity.common.java.commands.SilentTokenCommand;
import com.microsoft.identity.common.java.commands.parameters.RemoveAccountCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.java.controllers.CommandDispatcher;
import com.microsoft.identity.common.java.controllers.CommandResult;
import com.microsoft.identity.common.java.controllers.ExceptionAdapter;
import com.microsoft.identity.common.java.dto.AccountRecord;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.exception.ServiceException;
import com.microsoft.identity.common.java.logging.LogSession;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.result.ILocalAuthenticationResult;
import com.microsoft.identity.common.java.result.LocalAuthenticationResult;
import com.microsoft.identity.common.nativeauth.internal.controllers.NativeAuthMsalController;
import com.microsoft.identity.nativeauth.NativeAuthPublicClientApplication;
import com.microsoft.identity.nativeauth.NativeAuthPublicClientApplicationConfiguration;
import com.microsoft.identity.nativeauth.statemachine.errors.GetAccessTokenError;
import com.microsoft.identity.nativeauth.statemachine.errors.SignOutError;
import com.microsoft.identity.nativeauth.statemachine.results.GetAccessTokenResult;
import com.microsoft.identity.nativeauth.statemachine.results.SignOutResult;
import com.microsoft.identity.nativeauth.statemachine.states.Callback;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 &2\u00020\u0001:\u0003&'(B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001f\b\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u001b\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0013H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u0010\u001a\u00020\u00152\b\b\u0002\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017J)\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0019H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ&\u0010\u0010\u001a\u00020\u00152\b\b\u0002\u0010\u0012\u001a\u00020\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00192\u0006\u0010\u0016\u001a\u00020\u0017J'\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u0019H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ\u0006\u0010\u001c\u001a\u00020\u0006J\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0002\b\u0003\u0018\u00010\u001eJ\b\u0010\u001f\u001a\u0004\u0018\u00010\nJ\u0011\u0010 \u001a\u00020!H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\"J\u000e\u0010 \u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020#J\u0018\u0010$\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006)"}, d2={"Lcom/microsoft/identity/nativeauth/statemachine/states/AccountState;", "Landroid/os/Parcelable;", "parcel", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "account", "Lcom/microsoft/identity/client/IAccount;", "config", "Lcom/microsoft/identity/nativeauth/NativeAuthPublicClientApplicationConfiguration;", "correlationId", "", "(Lcom/microsoft/identity/client/IAccount;Lcom/microsoft/identity/nativeauth/NativeAuthPublicClientApplicationConfiguration;Ljava/lang/String;)V", "getCorrelationId", "()Ljava/lang/String;", "describeContents", "", "getAccessToken", "Lcom/microsoft/identity/nativeauth/statemachine/results/GetAccessTokenResult;", "forceRefresh", "", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "callback", "Lcom/microsoft/identity/nativeauth/statemachine/states/AccountState$GetAccessTokenCallback;", "scopes", "", "(ZLjava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getAccessTokenInternal", "getAccount", "getClaims", "", "getIdToken", "signOut", "Lcom/microsoft/identity/nativeauth/statemachine/results/SignOutResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lcom/microsoft/identity/nativeauth/statemachine/states/AccountState$SignOutCallback;", "writeToParcel", "flags", "CREATOR", "GetAccessTokenCallback", "SignOutCallback", "msal_distRelease"})
public final class AccountState
implements Parcelable {
    @NotNull
    public static final CREATOR CREATOR = new CREATOR(null);
    @NotNull
    private IAccount account;
    @NotNull
    private final NativeAuthPublicClientApplicationConfiguration config;
    @NotNull
    private final String correlationId;
    private static final String TAG = NativeAuthPublicClientApplication.class.getSimpleName();

    private AccountState(IAccount account, NativeAuthPublicClientApplicationConfiguration config, String correlationId) {
        this.account = account;
        this.config = config;
        this.correlationId = correlationId;
    }

    @NotNull
    public final String getCorrelationId() {
        return this.correlationId;
    }

    public AccountState(@NotNull Parcel parcel) {
        Serializable serializable;
        Serializable serializable2;
        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
        Parcel $this$serializable$iv = parcel;
        boolean $i$f$serializable = false;
        if (Build.VERSION.SDK_INT >= 33) {
            serializable2 = (Serializable)$this$serializable$iv.readSerializable(IAccount.class.getClassLoader(), IAccount.class);
        } else {
            Serializable serializable3 = $this$serializable$iv.readSerializable();
            if (!(serializable3 instanceof IAccount)) {
                serializable3 = null;
            }
            serializable2 = (IAccount)serializable3;
        }
        Intrinsics.checkNotNull((Object)serializable2, (String)"null cannot be cast to non-null type com.microsoft.identity.client.IAccount");
        IAccount iAccount = (IAccount)serializable2;
        String string = parcel.readString();
        if (string == null) {
            string = "UNSET";
        }
        String string2 = string;
        Parcel $this$serializable$iv2 = parcel;
        boolean $i$f$serializable2 = false;
        if (Build.VERSION.SDK_INT >= 33) {
            serializable = (Serializable)$this$serializable$iv2.readSerializable(NativeAuthPublicClientApplicationConfiguration.class.getClassLoader(), NativeAuthPublicClientApplicationConfiguration.class);
        } else {
            Serializable serializable4 = $this$serializable$iv2.readSerializable();
            if (!(serializable4 instanceof NativeAuthPublicClientApplicationConfiguration)) {
                serializable4 = null;
            }
            serializable = (NativeAuthPublicClientApplicationConfiguration)serializable4;
        }
        Intrinsics.checkNotNull((Object)serializable, (String)"null cannot be cast to non-null type com.microsoft.identity.nativeauth.NativeAuthPublicClientApplicationConfiguration");
        NativeAuthPublicClientApplicationConfiguration nativeAuthPublicClientApplicationConfiguration = (NativeAuthPublicClientApplicationConfiguration)serializable;
        this(iAccount, nativeAuthPublicClientApplicationConfiguration, string2);
    }

    public final void signOut(@NotNull SignOutCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, null, TAG + ".signOut(callback: SignOutCallback)");
        BuildersKt.launch$default((CoroutineScope)NativeAuthPublicClientApplication.Companion.getPcaScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, callback, null){
            int label;
            final /* synthetic */ AccountState this$0;
            final /* synthetic */ SignOutCallback $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.this$0.signOut((Continuation<? super SignOutResult>)((Continuation)this));
                        ** if (v0 != var3_2) goto lbl11
lbl10:
                        // 1 sources

                        return var3_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            result = (SignOutResult)v0;
                            this.$callback.onResult(result);
                        }
                        catch (MsalException e) {
                            Logger.error((String)AccountState.access$getTAG$cp(), (String)"Exception thrown in signOut", (Throwable)((Throwable)e));
                            this.$callback.onError(e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Nullable
    public final Object signOut(@NotNull Continuation<? super SignOutResult> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SignOutResult>, Object>(this, null){
            int label;
            final /* synthetic */ AccountState this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            String string = AccountState.access$getTAG$cp();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                            LogSession.Companion.logMethodCall(string, null, AccountState.access$getTAG$cp() + ".signOut()");
                            IAccount iAccount = NativeAuthPublicClientApplication.Companion.getCurrentAccountInternal(AccountState.access$getConfig$p(this.this$0));
                            if (iAccount == null) {
                                throw new MsalClientException("no_current_account", "There is no signed in account.");
                            }
                            IAccount account = iAccount;
                            AccountRecord requestAccountRecord = new AccountRecord();
                            requestAccountRecord.setEnvironment(((Account)account).getEnvironment());
                            requestAccountRecord.setHomeAccountId(((Account)account).getHomeAccountId());
                            RemoveAccountCommandParameters params = CommandParametersAdapter.createRemoveAccountCommandParameters(AccountState.access$getConfig$p(this.this$0), AccountState.access$getConfig$p(this.this$0).getOAuth2TokenCache(), requestAccountRecord);
                            RemoveCurrentAccountCommand removeCurrentAccountCommandParameters2 = new RemoveCurrentAccountCommand(params, new LocalMSALController().asControllerFactory(), (CommandCallback)new CommandCallback<Boolean, BaseException>(){

                                public void onError(@Nullable BaseException error) {
                                }

                                public void onTaskCompleted(@Nullable Boolean result) {
                                }

                                public void onCancel() {
                                }
                            }, "240");
                            Object object2 = ((CommandResult)CommandDispatcher.submitSilentReturningFuture((BaseCommand)((BaseCommand)removeCurrentAccountCommandParameters2)).get()).getResult();
                            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Boolean");
                            boolean result = (Boolean)object2;
                            if (!result) {
                                Logger.error((String)AccountState.access$getTAG$cp(), (String)"Unexpected error during signOut.", null);
                                throw new MsalClientException("unknown_error", "Unexpected error during signOut.");
                            }
                            return SignOutResult.Complete.INSTANCE;
                        }
                        catch (Exception e) {
                            String string = this.this$0.getCorrelationId();
                            return new SignOutError("client_exception", null, "MSAL client exception occurred in signOut.", string, null, e, 18, null);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super SignOutResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @NotNull
    public final IAccount getAccount() {
        return this.account;
    }

    @Nullable
    public final String getIdToken() {
        return this.account.getIdToken();
    }

    @Nullable
    public final Map<String, ?> getClaims() {
        return this.account.getClaims();
    }

    public final void getAccessToken(boolean forceRefresh, @NotNull GetAccessTokenCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, null, TAG + ".getAccessToken(forceRefresh: Boolean = " + forceRefresh + ", callback: GetAccessTokenCallback)");
        BuildersKt.launch$default((CoroutineScope)NativeAuthPublicClientApplication.Companion.getPcaScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, forceRefresh, callback, null){
            int label;
            final /* synthetic */ AccountState this$0;
            final /* synthetic */ boolean $forceRefresh;
            final /* synthetic */ GetAccessTokenCallback $callback;
            {
                this.this$0 = $receiver;
                this.$forceRefresh = $forceRefresh;
                this.$callback = $callback;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.this$0.getAccessToken(this.$forceRefresh, (Continuation<? super GetAccessTokenResult>)((Continuation)this));
                        ** if (v0 != var3_2) goto lbl11
lbl10:
                        // 1 sources

                        return var3_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            result = (GetAccessTokenResult)v0;
                            this.$callback.onResult(result);
                        }
                        catch (MsalException e) {
                            Logger.error((String)AccountState.access$getTAG$cp(), (String)"Exception thrown in getAccessToken", (Throwable)((Throwable)e));
                            this.$callback.onError(e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static /* synthetic */ void getAccessToken$default(AccountState accountState, boolean bl, GetAccessTokenCallback getAccessTokenCallback, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        accountState.getAccessToken(bl, getAccessTokenCallback);
    }

    @Nullable
    public final Object getAccessToken(boolean forceRefresh, @NotNull Continuation<? super GetAccessTokenResult> $completion) {
        Set set = AuthenticationConstants.DEFAULT_SCOPES;
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"DEFAULT_SCOPES");
        return this.getAccessTokenInternal(forceRefresh, CollectionsKt.toList((Iterable)set), $completion);
    }

    public static /* synthetic */ Object getAccessToken$default(AccountState accountState, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return accountState.getAccessToken(bl, (Continuation<? super GetAccessTokenResult>)continuation);
    }

    @Nullable
    public final Object getAccessToken(boolean forceRefresh, @NotNull List<String> scopes, @NotNull Continuation<? super GetAccessTokenResult> $completion) {
        if (scopes.isEmpty()) {
            return new GetAccessTokenError("invalid_scopes", null, "Empty or invalid scopes", this.correlationId, null, null, 50, null);
        }
        return this.getAccessTokenInternal(forceRefresh, scopes, $completion);
    }

    public static /* synthetic */ Object getAccessToken$default(AccountState accountState, boolean bl, List list, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return accountState.getAccessToken(bl, (List<String>)list, (Continuation<? super GetAccessTokenResult>)continuation);
    }

    public final void getAccessToken(boolean forceRefresh, @NotNull List<String> scopes, @NotNull GetAccessTokenCallback callback) {
        Intrinsics.checkNotNullParameter(scopes, (String)"scopes");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, null, TAG + ".getAccessToken(forceRefresh: Boolean = " + forceRefresh + ", scopes: List<String>, callback: GetAccessTokenCallback)");
        BuildersKt.launch$default((CoroutineScope)NativeAuthPublicClientApplication.Companion.getPcaScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, forceRefresh, scopes, callback, null){
            int label;
            final /* synthetic */ AccountState this$0;
            final /* synthetic */ boolean $forceRefresh;
            final /* synthetic */ List<String> $scopes;
            final /* synthetic */ GetAccessTokenCallback $callback;
            {
                this.this$0 = $receiver;
                this.$forceRefresh = $forceRefresh;
                this.$scopes = $scopes;
                this.$callback = $callback;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.this$0.getAccessToken(this.$forceRefresh, this.$scopes, (Continuation<? super GetAccessTokenResult>)((Continuation)this));
                        ** if (v0 != var3_2) goto lbl11
lbl10:
                        // 1 sources

                        return var3_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            result = (GetAccessTokenResult)v0;
                            this.$callback.onResult(result);
                        }
                        catch (MsalException e) {
                            Logger.error((String)AccountState.access$getTAG$cp(), (String)"Exception thrown in getAccessToken", (Throwable)((Throwable)e));
                            this.$callback.onError(e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static /* synthetic */ void getAccessToken$default(AccountState accountState, boolean bl, List list, GetAccessTokenCallback getAccessTokenCallback, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        accountState.getAccessToken(bl, (List<String>)list, getAccessTokenCallback);
    }

    private final Object getAccessTokenInternal(boolean forceRefresh, List<String> scopes, Continuation<? super GetAccessTokenResult> $completion) {
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, null, TAG + ".getAccessTokenInternal(forceRefresh: Boolean = " + forceRefresh + ", scopes: List<String>)");
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super GetAccessTokenResult>, Object>(this, forceRefresh, scopes, null){
            int label;
            final /* synthetic */ AccountState this$0;
            final /* synthetic */ boolean $forceRefresh;
            final /* synthetic */ List<String> $scopes;
            {
                this.this$0 = $receiver;
                this.$forceRefresh = $forceRefresh;
                this.$scopes = $scopes;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        try {
                            GetAccessTokenResult getAccessTokenResult;
                            Object commandResult;
                            IAccount iAccount = NativeAuthPublicClientApplication.Companion.getCurrentAccountInternal(AccountState.access$getConfig$p(this.this$0));
                            Account account = iAccount instanceof Account ? (Account)iAccount : null;
                            if (account == null) {
                                return new GetAccessTokenError("invalid_scopes", "no_current_account", "There is no signed in account.", this.this$0.getCorrelationId(), null, null, 48, null);
                            }
                            Account currentAccount = account;
                            String string = Intrinsics.areEqual((Object)this.this$0.getCorrelationId(), (Object)"UNSET") ? UUID.randomUUID().toString() : this.this$0.getCorrelationId();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (correlationId == \"UN\u2026 } else { correlationId }");
                            String privateCorrelationId = string;
                            AcquireTokenSilentParameters acquireTokenSilentParameters = ((AcquireTokenSilentParameters.Builder)((AcquireTokenSilentParameters.Builder)((AcquireTokenSilentParameters.Builder)((AcquireTokenSilentParameters.Builder)new AcquireTokenSilentParameters.Builder().forAccount(currentAccount)).fromAuthority(currentAccount.getAuthority())).withCorrelationId(UUID.fromString(privateCorrelationId))).forceRefresh(this.$forceRefresh).withScopes(this.$scopes)).build();
                            AccountRecord accountRecord = PublicClientApplication.selectAccountRecordForTokenRequest(AccountState.access$getConfig$p(this.this$0), acquireTokenSilentParameters);
                            acquireTokenSilentParameters.setAccountRecord(accountRecord);
                            SilentTokenCommandParameters params = CommandParametersAdapter.createSilentTokenCommandParameters(AccountState.access$getConfig$p(this.this$0), AccountState.access$getConfig$p(this.this$0).getOAuth2TokenCache(), acquireTokenSilentParameters);
                            SilentTokenCommand command2 = new SilentTokenCommand(params, new NativeAuthMsalController().asControllerFactory(), (CommandCallback)new CommandCallback<LocalAuthenticationResult, BaseException>(){

                                public void onError(@Nullable BaseException error) {
                                }

                                public void onTaskCompleted(@Nullable LocalAuthenticationResult result) {
                                }

                                public void onCancel() {
                                }
                            }, "250");
                            Object object2 = commandResult = ((CommandResult)CommandDispatcher.submitSilentReturningFuture((BaseCommand)((BaseCommand)command2)).get()).getResult();
                            if (object2 instanceof ServiceException) {
                                ServiceException serviceException = ExceptionAdapter.convertToNativeAuthException((ServiceException)((ServiceException)commandResult));
                                String string2 = ((ServiceException)commandResult).getCorrelationId();
                                if (string2 == null) {
                                    string2 = this.this$0.getCorrelationId();
                                }
                                String string3 = string2;
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"commandResult.correlationId ?: correlationId");
                                getAccessTokenResult = new GetAccessTokenError(null, null, null, string3, null, (Exception)serviceException, 23, null);
                            } else if (object2 instanceof Exception) {
                                String string4 = this.this$0.getCorrelationId();
                                getAccessTokenResult = new GetAccessTokenError(null, null, null, string4, null, (Exception)commandResult, 23, null);
                            } else {
                                Intrinsics.checkNotNull((Object)commandResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.result.ILocalAuthenticationResult");
                                IAccount iAccount2 = AuthenticationResultAdapter.adapt((ILocalAuthenticationResult)commandResult).getAccount();
                                Intrinsics.checkNotNullExpressionValue((Object)iAccount2, (String)"adapt(commandResult as I\u2026enticationResult).account");
                                AccountState.access$setAccount$p(this.this$0, iAccount2);
                                IAuthenticationResult iAuthenticationResult = AuthenticationResultAdapter.adapt((ILocalAuthenticationResult)commandResult);
                                Intrinsics.checkNotNullExpressionValue((Object)iAuthenticationResult, (String)"adapt(commandResult)");
                                getAccessTokenResult = new GetAccessTokenResult.Complete(iAuthenticationResult);
                            }
                            return getAccessTokenResult;
                        }
                        catch (Exception e) {
                            String string = this.this$0.getCorrelationId();
                            return new GetAccessTokenError("client_exception", null, "MSAL client exception occurred in getAccessToken.", string, null, e, 18, null);
                        }
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super GetAccessTokenResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public void writeToParcel(@NotNull Parcel parcel, int flags) {
        Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
        parcel.writeSerializable((Serializable)this.account);
        parcel.writeSerializable((Serializable)((Object)this.correlationId));
        parcel.writeSerializable((Serializable)this.config);
    }

    public int describeContents() {
        return 0;
    }

    public static final /* synthetic */ String access$getTAG$cp() {
        return TAG;
    }

    public static final /* synthetic */ NativeAuthPublicClientApplicationConfiguration access$getConfig$p(AccountState $this) {
        return $this.config;
    }

    public static final /* synthetic */ Object access$getAccessTokenInternal(AccountState $this, boolean forceRefresh, List scopes, Continuation $completion) {
        return $this.getAccessTokenInternal(forceRefresh, scopes, (Continuation<? super GetAccessTokenResult>)$completion);
    }

    public static final /* synthetic */ void access$setAccount$p(AccountState $this, IAccount iAccount) {
        $this.account = iAccount;
    }

    public /* synthetic */ AccountState(IAccount account, NativeAuthPublicClientApplicationConfiguration config, String correlationId, DefaultConstructorMarker $constructor_marker) {
        this(account, config, correlationId);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a8\u0006\u0003"}, d2={"Lcom/microsoft/identity/nativeauth/statemachine/states/AccountState$SignOutCallback;", "Lcom/microsoft/identity/nativeauth/statemachine/states/Callback;", "Lcom/microsoft/identity/nativeauth/statemachine/results/SignOutResult;", "msal_distRelease"})
    public static interface SignOutCallback
    extends Callback<SignOutResult> {
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a8\u0006\u0003"}, d2={"Lcom/microsoft/identity/nativeauth/statemachine/states/AccountState$GetAccessTokenCallback;", "Lcom/microsoft/identity/nativeauth/statemachine/states/Callback;", "Lcom/microsoft/identity/nativeauth/statemachine/results/GetAccessTokenResult;", "msal_distRelease"})
    public static interface GetAccessTokenCallback
    extends Callback<GetAccessTokenResult> {
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001d\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/microsoft/identity/nativeauth/statemachine/states/AccountState$CREATOR;", "Landroid/os/Parcelable$Creator;", "Lcom/microsoft/identity/nativeauth/statemachine/states/AccountState;", "()V", "TAG", "", "kotlin.jvm.PlatformType", "createFromAccountResult", "account", "Lcom/microsoft/identity/client/IAccount;", "correlationId", "config", "Lcom/microsoft/identity/nativeauth/NativeAuthPublicClientApplicationConfiguration;", "createFromAuthenticationResult", "authenticationResult", "Lcom/microsoft/identity/client/IAuthenticationResult;", "createFromParcel", "parcel", "Landroid/os/Parcel;", "newArray", "", "size", "", "(I)[Lcom/microsoft/identity/nativeauth/statemachine/states/AccountState;", "msal_distRelease"})
    public static final class CREATOR
    implements Parcelable.Creator<AccountState> {
        private CREATOR() {
        }

        @NotNull
        public AccountState createFromParcel(@NotNull Parcel parcel) {
            Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
            return new AccountState(parcel);
        }

        @NotNull
        public AccountState[] newArray(int size) {
            return new AccountState[size];
        }

        @NotNull
        public final AccountState createFromAuthenticationResult(@NotNull IAuthenticationResult authenticationResult, @NotNull String correlationId, @NotNull NativeAuthPublicClientApplicationConfiguration config) {
            Intrinsics.checkNotNullParameter((Object)authenticationResult, (String)"authenticationResult");
            Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            IAccount iAccount = authenticationResult.getAccount();
            Intrinsics.checkNotNullExpressionValue((Object)iAccount, (String)"account");
            return new AccountState(iAccount, config, correlationId, null);
        }

        @NotNull
        public final AccountState createFromAccountResult(@NotNull IAccount account, @NotNull String correlationId, @NotNull NativeAuthPublicClientApplicationConfiguration config) {
            Intrinsics.checkNotNullParameter((Object)account, (String)"account");
            Intrinsics.checkNotNullParameter((Object)correlationId, (String)"correlationId");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return new AccountState(account, config, correlationId, null);
        }

        public /* synthetic */ CREATOR(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

