/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.microsoft.identity.client.AcquireTokenParameters;
import com.microsoft.identity.client.AcquireTokenSilentParameters;
import com.microsoft.identity.client.DeviceCodeFlowParameters;
import com.microsoft.identity.client.IAccount;
import com.microsoft.identity.client.ITenantProfile;
import com.microsoft.identity.client.MultiTenantAccount;
import com.microsoft.identity.client.PoPAuthenticationScheme;
import com.microsoft.identity.client.PublicClientApplication;
import com.microsoft.identity.client.PublicClientApplicationConfiguration;
import com.microsoft.identity.client.claims.ClaimsRequest;
import com.microsoft.identity.client.claims.RequestedClaimAdditionalInformation;
import com.microsoft.identity.client.internal.IntuneAcquireTokenParameters;
import com.microsoft.identity.common.components.AndroidPlatformComponentsFactory;
import com.microsoft.identity.common.internal.commands.parameters.AndroidActivityInteractiveTokenCommandParameters;
import com.microsoft.identity.common.internal.util.StringUtil;
import com.microsoft.identity.common.java.authorities.Authority;
import com.microsoft.identity.common.java.authorities.AzureActiveDirectoryAuthority;
import com.microsoft.identity.common.java.authorities.AzureActiveDirectoryB2CAuthority;
import com.microsoft.identity.common.java.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.java.authscheme.AuthenticationSchemeFactory;
import com.microsoft.identity.common.java.authscheme.BearerAuthenticationSchemeInternal;
import com.microsoft.identity.common.java.authscheme.INameable;
import com.microsoft.identity.common.java.authscheme.IPoPAuthenticationSchemeParams;
import com.microsoft.identity.common.java.commands.parameters.CommandParameters;
import com.microsoft.identity.common.java.commands.parameters.DeviceCodeFlowCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.GenerateShrCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.RemoveAccountCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.java.dto.AccountRecord;
import com.microsoft.identity.common.java.dto.IAccountRecord;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.logging.DiagnosticContext;
import com.microsoft.identity.common.java.nativeauth.authorities.NativeAuthCIAMAuthority;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.AcquireTokenNoFixedScopesCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.ResetPasswordResendCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.ResetPasswordStartCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.ResetPasswordSubmitCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.ResetPasswordSubmitNewPasswordCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInResendCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInStartCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInSubmitCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInSubmitPasswordCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInWithContinuationTokenCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpResendCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpStartCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpSubmitCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpSubmitPasswordCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpSubmitUserAttributesCommandParameters;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.java.providers.oauth2.OpenIdConnectPromptParameter;
import com.microsoft.identity.common.java.request.SdkType;
import com.microsoft.identity.common.java.ui.AuthorizationAgent;
import com.microsoft.identity.common.java.util.SchemaUtil;
import com.microsoft.identity.common.logging.Logger;
import com.microsoft.identity.nativeauth.NativeAuthPublicClientApplicationConfiguration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CommandParametersAdapter {
    private static final String TAG = CommandParametersAdapter.class.getSimpleName();
    public static final String CLIENT_CAPABILITIES_CLAIM = "xms_cc";

    public static CommandParameters createCommandParameters(@NonNull PublicClientApplicationConfiguration configuration, @NonNull OAuth2TokenCache tokenCache) {
        CommandParameters commandParameters = CommandParameters.builder().platformComponents(AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext())).applicationName(configuration.getAppContext().getPackageName()).applicationVersion(CommandParametersAdapter.getPackageVersion(configuration.getAppContext())).clientId(configuration.getClientId()).isSharedDevice(configuration.getIsSharedDevice()).oAuth2TokenCache(tokenCache).redirectUri(configuration.getRedirectUri()).requiredBrokerProtocolVersion(configuration.getRequiredBrokerProtocolVersion()).sdkType(SdkType.MSAL).sdkVersion(PublicClientApplication.getSdkVersion()).powerOptCheckEnabled(configuration.isPowerOptCheckForEnabled().booleanValue()).build();
        return commandParameters;
    }

    public static RemoveAccountCommandParameters createRemoveAccountCommandParameters(@NonNull PublicClientApplicationConfiguration configuration, @NonNull OAuth2TokenCache tokenCache, @NonNull AccountRecord account) {
        RemoveAccountCommandParameters commandParameters = ((RemoveAccountCommandParameters.RemoveAccountCommandParametersBuilder)((RemoveAccountCommandParameters.RemoveAccountCommandParametersBuilder)((RemoveAccountCommandParameters.RemoveAccountCommandParametersBuilder)((RemoveAccountCommandParameters.RemoveAccountCommandParametersBuilder)((RemoveAccountCommandParameters.RemoveAccountCommandParametersBuilder)((RemoveAccountCommandParameters.RemoveAccountCommandParametersBuilder)((RemoveAccountCommandParameters.RemoveAccountCommandParametersBuilder)((RemoveAccountCommandParameters.RemoveAccountCommandParametersBuilder)((RemoveAccountCommandParameters.RemoveAccountCommandParametersBuilder)((RemoveAccountCommandParameters.RemoveAccountCommandParametersBuilder)((RemoveAccountCommandParameters.RemoveAccountCommandParametersBuilder)RemoveAccountCommandParameters.builder().platformComponents(AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext()))).applicationName(configuration.getAppContext().getPackageName())).applicationVersion(CommandParametersAdapter.getPackageVersion(configuration.getAppContext()))).clientId(configuration.getClientId())).isSharedDevice(configuration.getIsSharedDevice())).oAuth2TokenCache(tokenCache)).redirectUri(configuration.getRedirectUri())).requiredBrokerProtocolVersion(configuration.getRequiredBrokerProtocolVersion())).sdkType(SdkType.MSAL)).sdkVersion(PublicClientApplication.getSdkVersion())).account((IAccountRecord)account).browserSafeList(configuration.getBrowserSafeList()).powerOptCheckEnabled(configuration.isPowerOptCheckForEnabled().booleanValue())).build();
        return commandParameters;
    }

    public static InteractiveTokenCommandParameters createInteractiveTokenCommandParameters(@NonNull PublicClientApplicationConfiguration configuration, @NonNull OAuth2TokenCache tokenCache, @NonNull AcquireTokenParameters parameters) throws ClientException {
        AbstractAuthenticationScheme authenticationScheme = AuthenticationSchemeFactory.createScheme((IPlatformComponents)AndroidPlatformComponentsFactory.createFromContext((Context)parameters.getActivity()), (INameable)parameters.getAuthenticationScheme());
        Authority authority = CommandParametersAdapter.getAuthority(configuration, parameters);
        String claimsRequestJson = ClaimsRequest.getJsonStringFromClaimsRequest(CommandParametersAdapter.getClaimsRequest(parameters.getClaimsRequest(), configuration, authority));
        AndroidActivityInteractiveTokenCommandParameters commandParameters = ((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)AndroidActivityInteractiveTokenCommandParameters.builder().activity(parameters.getActivity()).platformComponents(AndroidPlatformComponentsFactory.createFromActivity((Activity)parameters.getActivity(), (Fragment)parameters.getFragment()))).applicationName(configuration.getAppContext().getPackageName())).applicationVersion(CommandParametersAdapter.getPackageVersion(configuration.getAppContext()))).clientId(configuration.getClientId())).isSharedDevice(configuration.getIsSharedDevice())).oAuth2TokenCache(tokenCache)).redirectUri(configuration.getRedirectUri())).requiredBrokerProtocolVersion(configuration.getRequiredBrokerProtocolVersion())).sdkType(SdkType.MSAL)).sdkVersion(PublicClientApplication.getSdkVersion())).preferredBrowser(configuration.getPreferredBrowser())).browserSafeList(configuration.getBrowserSafeList())).authority(authority)).claimsRequestJson(claimsRequestJson)).forceRefresh(parameters.getClaimsRequest() != null)).scopes(new HashSet<String>(parameters.getScopes()))).extraScopesToConsent(parameters.getExtraScopesToConsent())).extraQueryStringParameters(CommandParametersAdapter.appendToExtraQueryParametersIfWebAuthnCapable(parameters.getExtraQueryStringParameters(), configuration))).loginHint(CommandParametersAdapter.getLoginHint(parameters))).account((IAccountRecord)parameters.getAccountRecord())).authenticationScheme(authenticationScheme)).authorizationAgent(CommandParametersAdapter.getAuthorizationAgent(configuration))).brokerBrowserSupportEnabled(CommandParametersAdapter.getBrokerBrowserSupportEnabled(parameters))).prompt(CommandParametersAdapter.getPromptParameter(parameters))).isWebViewZoomControlsEnabled(configuration.isWebViewZoomControlsEnabled())).isWebViewZoomEnabled(configuration.isWebViewZoomEnabled())).handleNullTaskAffinity(configuration.isHandleNullTaskAffinityEnabled().booleanValue())).powerOptCheckEnabled(configuration.isPowerOptCheckForEnabled().booleanValue())).correlationId(parameters.getCorrelationId())).preferredAuthMethod(parameters.getPreferredAuthMethod())).build();
        return commandParameters;
    }

    public static SilentTokenCommandParameters createSilentTokenCommandParameters(@NonNull PublicClientApplicationConfiguration configuration, @NonNull OAuth2TokenCache tokenCache, @NonNull AcquireTokenSilentParameters parameters) throws ClientException {
        Authority authority = CommandParametersAdapter.getAuthority(configuration, parameters);
        ClaimsRequest claimsRequest = parameters.getClaimsRequest();
        ClaimsRequest mergedClaimsRequest = CommandParametersAdapter.getClaimsRequest(parameters.getClaimsRequest(), configuration, authority);
        String claimsRequestJson = ClaimsRequest.getJsonStringFromClaimsRequest(mergedClaimsRequest);
        boolean forceRefresh = claimsRequest != null || parameters.getForceRefresh();
        AbstractAuthenticationScheme authenticationScheme = AuthenticationSchemeFactory.createScheme((IPlatformComponents)AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext()), (INameable)parameters.getAuthenticationScheme());
        SilentTokenCommandParameters commandParameters = ((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)SilentTokenCommandParameters.builder().platformComponents(AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext()))).applicationName(configuration.getAppContext().getPackageName())).applicationVersion(CommandParametersAdapter.getPackageVersion(configuration.getAppContext()))).clientId(configuration.getClientId())).isSharedDevice(configuration.getIsSharedDevice())).oAuth2TokenCache(tokenCache)).redirectUri(configuration.getRedirectUri())).requiredBrokerProtocolVersion(configuration.getRequiredBrokerProtocolVersion())).sdkType(SdkType.MSAL)).sdkVersion(PublicClientApplication.getSdkVersion())).authority(authority)).claimsRequestJson(claimsRequestJson)).forceRefresh(forceRefresh)).account((IAccountRecord)parameters.getAccountRecord())).authenticationScheme(authenticationScheme)).scopes(new HashSet<String>(parameters.getScopes()))).powerOptCheckEnabled(configuration.isPowerOptCheckForEnabled().booleanValue())).correlationId(parameters.getCorrelationId())).build();
        return commandParameters;
    }

    public static DeviceCodeFlowCommandParameters createDeviceCodeFlowWithClaimsCommandParameters(@NonNull PublicClientApplicationConfiguration configuration, @NonNull OAuth2TokenCache tokenCache, @NonNull DeviceCodeFlowParameters parameters) {
        String claimsRequestJson = ClaimsRequest.getJsonStringFromClaimsRequest(parameters.getClaimsRequest());
        Authority authority = configuration.getDefaultAuthority();
        BearerAuthenticationSchemeInternal authenticationScheme = new BearerAuthenticationSchemeInternal();
        DeviceCodeFlowCommandParameters commandParameters = ((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)DeviceCodeFlowCommandParameters.builder().platformComponents(AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext()))).applicationName(configuration.getAppContext().getPackageName())).applicationVersion(CommandParametersAdapter.getPackageVersion(configuration.getAppContext()))).clientId(configuration.getClientId())).isSharedDevice(configuration.getIsSharedDevice())).redirectUri(configuration.getRedirectUri())).oAuth2TokenCache(tokenCache)).requiredBrokerProtocolVersion(configuration.getRequiredBrokerProtocolVersion())).sdkType(SdkType.MSAL)).sdkVersion(PublicClientApplication.getSdkVersion())).powerOptCheckEnabled(configuration.isPowerOptCheckForEnabled().booleanValue())).authenticationScheme((AbstractAuthenticationScheme)authenticationScheme)).scopes(new HashSet<String>(parameters.getScopes()))).authority(authority)).claimsRequestJson(claimsRequestJson)).correlationId(parameters.getCorrelationId())).build();
        return commandParameters;
    }

    public static AcquireTokenNoFixedScopesCommandParameters createAcquireTokenNoFixedScopesCommandParameters(@NonNull PublicClientApplicationConfiguration configuration, @NonNull OAuth2TokenCache tokenCache, @NonNull AccountRecord accountRecord, @NonNull Boolean forceRefresh, @NonNull String correlationId) throws ClientException {
        NativeAuthCIAMAuthority authority = (NativeAuthCIAMAuthority)configuration.getDefaultAuthority();
        BearerAuthenticationSchemeInternal authenticationScheme = new BearerAuthenticationSchemeInternal();
        AcquireTokenNoFixedScopesCommandParameters commandParameters = ((AcquireTokenNoFixedScopesCommandParameters.AcquireTokenNoFixedScopesCommandParametersBuilder)((AcquireTokenNoFixedScopesCommandParameters.AcquireTokenNoFixedScopesCommandParametersBuilder)((AcquireTokenNoFixedScopesCommandParameters.AcquireTokenNoFixedScopesCommandParametersBuilder)((AcquireTokenNoFixedScopesCommandParameters.AcquireTokenNoFixedScopesCommandParametersBuilder)((AcquireTokenNoFixedScopesCommandParameters.AcquireTokenNoFixedScopesCommandParametersBuilder)((AcquireTokenNoFixedScopesCommandParameters.AcquireTokenNoFixedScopesCommandParametersBuilder)((AcquireTokenNoFixedScopesCommandParameters.AcquireTokenNoFixedScopesCommandParametersBuilder)((AcquireTokenNoFixedScopesCommandParameters.AcquireTokenNoFixedScopesCommandParametersBuilder)((AcquireTokenNoFixedScopesCommandParameters.AcquireTokenNoFixedScopesCommandParametersBuilder)((AcquireTokenNoFixedScopesCommandParameters.AcquireTokenNoFixedScopesCommandParametersBuilder)((AcquireTokenNoFixedScopesCommandParameters.AcquireTokenNoFixedScopesCommandParametersBuilder)((AcquireTokenNoFixedScopesCommandParameters.AcquireTokenNoFixedScopesCommandParametersBuilder)((AcquireTokenNoFixedScopesCommandParameters.AcquireTokenNoFixedScopesCommandParametersBuilder)AcquireTokenNoFixedScopesCommandParameters.builder().platformComponents(AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext()))).applicationName(configuration.getAppContext().getPackageName())).applicationVersion(CommandParametersAdapter.getPackageVersion(configuration.getAppContext()))).clientId(configuration.getClientId())).isSharedDevice(configuration.getIsSharedDevice())).oAuth2TokenCache(tokenCache)).redirectUri(configuration.getRedirectUri())).requiredBrokerProtocolVersion(configuration.getRequiredBrokerProtocolVersion())).sdkType(SdkType.MSAL)).sdkVersion(PublicClientApplication.getSdkVersion())).authority(authority)).authenticationScheme((AbstractAuthenticationScheme)authenticationScheme).forceRefresh(forceRefresh.booleanValue()).account((IAccountRecord)accountRecord).correlationId(correlationId)).powerOptCheckEnabled(configuration.isPowerOptCheckForEnabled().booleanValue())).build();
        return commandParameters;
    }

    public static DeviceCodeFlowCommandParameters createDeviceCodeFlowCommandParameters(@NonNull PublicClientApplicationConfiguration configuration, @NonNull OAuth2TokenCache tokenCache, @NonNull List<String> scopes) {
        Authority authority = configuration.getDefaultAuthority();
        BearerAuthenticationSchemeInternal authenticationScheme = new BearerAuthenticationSchemeInternal();
        DeviceCodeFlowCommandParameters commandParameters = ((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)DeviceCodeFlowCommandParameters.builder().platformComponents(AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext()))).applicationName(configuration.getAppContext().getPackageName())).applicationVersion(CommandParametersAdapter.getPackageVersion(configuration.getAppContext()))).clientId(configuration.getClientId())).isSharedDevice(configuration.getIsSharedDevice())).redirectUri(configuration.getRedirectUri())).oAuth2TokenCache(tokenCache)).requiredBrokerProtocolVersion(configuration.getRequiredBrokerProtocolVersion())).sdkType(SdkType.MSAL)).sdkVersion(PublicClientApplication.getSdkVersion())).powerOptCheckEnabled(configuration.isPowerOptCheckForEnabled().booleanValue())).authenticationScheme((AbstractAuthenticationScheme)authenticationScheme)).scopes(new HashSet<String>(scopes))).authority(authority)).build();
        return commandParameters;
    }

    public static SignUpStartCommandParameters createSignUpStartCommandParameters(@NonNull NativeAuthPublicClientApplicationConfiguration configuration, @NonNull OAuth2TokenCache tokenCache, @NonNull String username, @Nullable char[] password, Map<String, String> userAttributes) {
        NativeAuthCIAMAuthority authority = (NativeAuthCIAMAuthority)configuration.getDefaultAuthority();
        return ((SignUpStartCommandParameters.SignUpStartCommandParametersBuilder)((SignUpStartCommandParameters.SignUpStartCommandParametersBuilder)((SignUpStartCommandParameters.SignUpStartCommandParametersBuilder)((SignUpStartCommandParameters.SignUpStartCommandParametersBuilder)((SignUpStartCommandParameters.SignUpStartCommandParametersBuilder)((SignUpStartCommandParameters.SignUpStartCommandParametersBuilder)((SignUpStartCommandParameters.SignUpStartCommandParametersBuilder)((SignUpStartCommandParameters.SignUpStartCommandParametersBuilder)((SignUpStartCommandParameters.SignUpStartCommandParametersBuilder)((SignUpStartCommandParameters.SignUpStartCommandParametersBuilder)((SignUpStartCommandParameters.SignUpStartCommandParametersBuilder)((SignUpStartCommandParameters.SignUpStartCommandParametersBuilder)((SignUpStartCommandParameters.SignUpStartCommandParametersBuilder)((SignUpStartCommandParameters.SignUpStartCommandParametersBuilder)SignUpStartCommandParameters.builder().platformComponents(AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext()))).applicationName(configuration.getAppContext().getPackageName())).applicationVersion(CommandParametersAdapter.getPackageVersion(configuration.getAppContext()))).clientId(configuration.getClientId())).isSharedDevice(configuration.getIsSharedDevice())).redirectUri(configuration.getRedirectUri())).oAuth2TokenCache(tokenCache)).requiredBrokerProtocolVersion(configuration.getRequiredBrokerProtocolVersion())).sdkType(SdkType.MSAL)).sdkVersion(PublicClientApplication.getSdkVersion())).powerOptCheckEnabled(configuration.isPowerOptCheckForEnabled().booleanValue())).authority(authority)).username(username).password(password).challengeType(configuration.getChallengeTypes())).userAttributes(userAttributes).correlationId(DiagnosticContext.INSTANCE.getThreadCorrelationId())).build();
    }

    public static SignUpSubmitCodeCommandParameters createSignUpSubmitCodeCommandParameters(@NonNull NativeAuthPublicClientApplicationConfiguration configuration, @NonNull OAuth2TokenCache tokenCache, @NonNull String code, @NonNull String continuationToken, @NonNull String correlationId) {
        NativeAuthCIAMAuthority authority = (NativeAuthCIAMAuthority)configuration.getDefaultAuthority();
        return ((SignUpSubmitCodeCommandParameters.SignUpSubmitCodeCommandParametersBuilder)((SignUpSubmitCodeCommandParameters.SignUpSubmitCodeCommandParametersBuilder)((SignUpSubmitCodeCommandParameters.SignUpSubmitCodeCommandParametersBuilder)((SignUpSubmitCodeCommandParameters.SignUpSubmitCodeCommandParametersBuilder)((SignUpSubmitCodeCommandParameters.SignUpSubmitCodeCommandParametersBuilder)((SignUpSubmitCodeCommandParameters.SignUpSubmitCodeCommandParametersBuilder)((SignUpSubmitCodeCommandParameters.SignUpSubmitCodeCommandParametersBuilder)((SignUpSubmitCodeCommandParameters.SignUpSubmitCodeCommandParametersBuilder)((SignUpSubmitCodeCommandParameters.SignUpSubmitCodeCommandParametersBuilder)((SignUpSubmitCodeCommandParameters.SignUpSubmitCodeCommandParametersBuilder)((SignUpSubmitCodeCommandParameters.SignUpSubmitCodeCommandParametersBuilder)((SignUpSubmitCodeCommandParameters.SignUpSubmitCodeCommandParametersBuilder)((SignUpSubmitCodeCommandParameters.SignUpSubmitCodeCommandParametersBuilder)((SignUpSubmitCodeCommandParameters.SignUpSubmitCodeCommandParametersBuilder)((SignUpSubmitCodeCommandParameters.SignUpSubmitCodeCommandParametersBuilder)SignUpSubmitCodeCommandParameters.builder().platformComponents(AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext()))).applicationName(configuration.getAppContext().getPackageName())).applicationVersion(CommandParametersAdapter.getPackageVersion(configuration.getAppContext()))).clientId(configuration.getClientId())).isSharedDevice(configuration.getIsSharedDevice())).redirectUri(configuration.getRedirectUri())).oAuth2TokenCache(tokenCache)).requiredBrokerProtocolVersion(configuration.getRequiredBrokerProtocolVersion())).sdkType(SdkType.MSAL)).sdkVersion(PublicClientApplication.getSdkVersion())).powerOptCheckEnabled(configuration.isPowerOptCheckForEnabled().booleanValue())).authority(authority)).challengeType(configuration.getChallengeTypes())).continuationToken(continuationToken)).code(code).correlationId(correlationId)).build();
    }

    public static SignUpResendCodeCommandParameters createSignUpResendCodeCommandParameters(@NonNull NativeAuthPublicClientApplicationConfiguration configuration, @NonNull OAuth2TokenCache tokenCache, @NonNull String continuationToken, @NonNull String correlationId) {
        NativeAuthCIAMAuthority authority = (NativeAuthCIAMAuthority)configuration.getDefaultAuthority();
        return ((SignUpResendCodeCommandParameters.SignUpResendCodeCommandParametersBuilder)((SignUpResendCodeCommandParameters.SignUpResendCodeCommandParametersBuilder)((SignUpResendCodeCommandParameters.SignUpResendCodeCommandParametersBuilder)((SignUpResendCodeCommandParameters.SignUpResendCodeCommandParametersBuilder)((SignUpResendCodeCommandParameters.SignUpResendCodeCommandParametersBuilder)((SignUpResendCodeCommandParameters.SignUpResendCodeCommandParametersBuilder)((SignUpResendCodeCommandParameters.SignUpResendCodeCommandParametersBuilder)((SignUpResendCodeCommandParameters.SignUpResendCodeCommandParametersBuilder)((SignUpResendCodeCommandParameters.SignUpResendCodeCommandParametersBuilder)((SignUpResendCodeCommandParameters.SignUpResendCodeCommandParametersBuilder)((SignUpResendCodeCommandParameters.SignUpResendCodeCommandParametersBuilder)((SignUpResendCodeCommandParameters.SignUpResendCodeCommandParametersBuilder)((SignUpResendCodeCommandParameters.SignUpResendCodeCommandParametersBuilder)((SignUpResendCodeCommandParameters.SignUpResendCodeCommandParametersBuilder)SignUpResendCodeCommandParameters.builder().platformComponents(AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext()))).applicationName(configuration.getAppContext().getPackageName())).applicationVersion(CommandParametersAdapter.getPackageVersion(configuration.getAppContext()))).clientId(configuration.getClientId())).isSharedDevice(configuration.getIsSharedDevice())).redirectUri(configuration.getRedirectUri())).oAuth2TokenCache(tokenCache)).requiredBrokerProtocolVersion(configuration.getRequiredBrokerProtocolVersion())).sdkType(SdkType.MSAL)).sdkVersion(PublicClientApplication.getSdkVersion())).powerOptCheckEnabled(configuration.isPowerOptCheckForEnabled().booleanValue())).challengeType(configuration.getChallengeTypes())).authority(authority)).continuationToken(continuationToken).correlationId(correlationId)).build();
    }

    public static SignUpSubmitUserAttributesCommandParameters createSignUpStarSubmitUserAttributesCommandParameters(@NonNull NativeAuthPublicClientApplicationConfiguration configuration, @NonNull OAuth2TokenCache tokenCache, @NonNull String continuationToken, @NonNull String correlationId, Map<String, String> userAttributes) {
        NativeAuthCIAMAuthority authority = (NativeAuthCIAMAuthority)configuration.getDefaultAuthority();
        return ((SignUpSubmitUserAttributesCommandParameters.SignUpSubmitUserAttributesCommandParametersBuilder)((SignUpSubmitUserAttributesCommandParameters.SignUpSubmitUserAttributesCommandParametersBuilder)((SignUpSubmitUserAttributesCommandParameters.SignUpSubmitUserAttributesCommandParametersBuilder)((SignUpSubmitUserAttributesCommandParameters.SignUpSubmitUserAttributesCommandParametersBuilder)((SignUpSubmitUserAttributesCommandParameters.SignUpSubmitUserAttributesCommandParametersBuilder)((SignUpSubmitUserAttributesCommandParameters.SignUpSubmitUserAttributesCommandParametersBuilder)((SignUpSubmitUserAttributesCommandParameters.SignUpSubmitUserAttributesCommandParametersBuilder)((SignUpSubmitUserAttributesCommandParameters.SignUpSubmitUserAttributesCommandParametersBuilder)((SignUpSubmitUserAttributesCommandParameters.SignUpSubmitUserAttributesCommandParametersBuilder)((SignUpSubmitUserAttributesCommandParameters.SignUpSubmitUserAttributesCommandParametersBuilder)((SignUpSubmitUserAttributesCommandParameters.SignUpSubmitUserAttributesCommandParametersBuilder)((SignUpSubmitUserAttributesCommandParameters.SignUpSubmitUserAttributesCommandParametersBuilder)((SignUpSubmitUserAttributesCommandParameters.SignUpSubmitUserAttributesCommandParametersBuilder)((SignUpSubmitUserAttributesCommandParameters.SignUpSubmitUserAttributesCommandParametersBuilder)((SignUpSubmitUserAttributesCommandParameters.SignUpSubmitUserAttributesCommandParametersBuilder)((SignUpSubmitUserAttributesCommandParameters.SignUpSubmitUserAttributesCommandParametersBuilder)SignUpSubmitUserAttributesCommandParameters.builder().platformComponents(AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext()))).applicationName(configuration.getAppContext().getPackageName())).applicationVersion(CommandParametersAdapter.getPackageVersion(configuration.getAppContext()))).clientId(configuration.getClientId())).isSharedDevice(configuration.getIsSharedDevice())).redirectUri(configuration.getRedirectUri())).oAuth2TokenCache(tokenCache)).requiredBrokerProtocolVersion(configuration.getRequiredBrokerProtocolVersion())).sdkType(SdkType.MSAL)).sdkVersion(PublicClientApplication.getSdkVersion())).powerOptCheckEnabled(configuration.isPowerOptCheckForEnabled().booleanValue())).authority(authority)).clientId(configuration.getClientId())).challengeType(configuration.getChallengeTypes())).continuationToken(continuationToken)).userAttributes(userAttributes).correlationId(correlationId)).build();
    }

    public static SignUpSubmitPasswordCommandParameters createSignUpSubmitPasswordCommandParameters(@NonNull NativeAuthPublicClientApplicationConfiguration configuration, @NonNull OAuth2TokenCache tokenCache, @NonNull String continuationToken, @NonNull String correlationId, @NonNull char[] password) {
        NativeAuthCIAMAuthority authority = (NativeAuthCIAMAuthority)configuration.getDefaultAuthority();
        return ((SignUpSubmitPasswordCommandParameters.SignUpSubmitPasswordCommandParametersBuilder)((SignUpSubmitPasswordCommandParameters.SignUpSubmitPasswordCommandParametersBuilder)((SignUpSubmitPasswordCommandParameters.SignUpSubmitPasswordCommandParametersBuilder)((SignUpSubmitPasswordCommandParameters.SignUpSubmitPasswordCommandParametersBuilder)((SignUpSubmitPasswordCommandParameters.SignUpSubmitPasswordCommandParametersBuilder)((SignUpSubmitPasswordCommandParameters.SignUpSubmitPasswordCommandParametersBuilder)((SignUpSubmitPasswordCommandParameters.SignUpSubmitPasswordCommandParametersBuilder)((SignUpSubmitPasswordCommandParameters.SignUpSubmitPasswordCommandParametersBuilder)((SignUpSubmitPasswordCommandParameters.SignUpSubmitPasswordCommandParametersBuilder)((SignUpSubmitPasswordCommandParameters.SignUpSubmitPasswordCommandParametersBuilder)((SignUpSubmitPasswordCommandParameters.SignUpSubmitPasswordCommandParametersBuilder)((SignUpSubmitPasswordCommandParameters.SignUpSubmitPasswordCommandParametersBuilder)((SignUpSubmitPasswordCommandParameters.SignUpSubmitPasswordCommandParametersBuilder)((SignUpSubmitPasswordCommandParameters.SignUpSubmitPasswordCommandParametersBuilder)((SignUpSubmitPasswordCommandParameters.SignUpSubmitPasswordCommandParametersBuilder)SignUpSubmitPasswordCommandParameters.builder().platformComponents(AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext()))).applicationName(configuration.getAppContext().getPackageName())).applicationVersion(CommandParametersAdapter.getPackageVersion(configuration.getAppContext()))).clientId(configuration.getClientId())).isSharedDevice(configuration.getIsSharedDevice())).redirectUri(configuration.getRedirectUri())).oAuth2TokenCache(tokenCache)).requiredBrokerProtocolVersion(configuration.getRequiredBrokerProtocolVersion())).sdkType(SdkType.MSAL)).sdkVersion(PublicClientApplication.getSdkVersion())).powerOptCheckEnabled(configuration.isPowerOptCheckForEnabled().booleanValue())).authority(authority)).challengeType(configuration.getChallengeTypes())).continuationToken(continuationToken)).password(password).correlationId(correlationId)).build();
    }

    public static SignInStartCommandParameters createSignInStartCommandParameters(@NonNull NativeAuthPublicClientApplicationConfiguration configuration, @NonNull OAuth2TokenCache tokenCache, @NonNull String username, @Nullable char[] password, List<String> scopes) throws ClientException {
        AbstractAuthenticationScheme authenticationScheme = AuthenticationSchemeFactory.createScheme((IPlatformComponents)AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext()), null);
        NativeAuthCIAMAuthority authority = (NativeAuthCIAMAuthority)configuration.getDefaultAuthority();
        SignInStartCommandParameters commandParameters = ((SignInStartCommandParameters.SignInStartCommandParametersBuilder)((SignInStartCommandParameters.SignInStartCommandParametersBuilder)((SignInStartCommandParameters.SignInStartCommandParametersBuilder)((SignInStartCommandParameters.SignInStartCommandParametersBuilder)((SignInStartCommandParameters.SignInStartCommandParametersBuilder)((SignInStartCommandParameters.SignInStartCommandParametersBuilder)((SignInStartCommandParameters.SignInStartCommandParametersBuilder)((SignInStartCommandParameters.SignInStartCommandParametersBuilder)((SignInStartCommandParameters.SignInStartCommandParametersBuilder)((SignInStartCommandParameters.SignInStartCommandParametersBuilder)((SignInStartCommandParameters.SignInStartCommandParametersBuilder)((SignInStartCommandParameters.SignInStartCommandParametersBuilder)((SignInStartCommandParameters.SignInStartCommandParametersBuilder)((SignInStartCommandParameters.SignInStartCommandParametersBuilder)((SignInStartCommandParameters.SignInStartCommandParametersBuilder)((SignInStartCommandParameters.SignInStartCommandParametersBuilder)((SignInStartCommandParameters.SignInStartCommandParametersBuilder)SignInStartCommandParameters.builder().platformComponents(AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext()))).applicationName(configuration.getAppContext().getPackageName())).applicationVersion(CommandParametersAdapter.getPackageVersion(configuration.getAppContext()))).clientId(configuration.getClientId())).isSharedDevice(configuration.getIsSharedDevice())).redirectUri(configuration.getRedirectUri())).oAuth2TokenCache(tokenCache)).requiredBrokerProtocolVersion(configuration.getRequiredBrokerProtocolVersion())).sdkType(SdkType.MSAL)).sdkVersion(PublicClientApplication.getSdkVersion())).powerOptCheckEnabled(configuration.isPowerOptCheckForEnabled().booleanValue())).authority(authority)).username(username).password(password).authenticationScheme(authenticationScheme)).clientId(configuration.getClientId())).challengeType(configuration.getChallengeTypes())).scopes(scopes)).correlationId(DiagnosticContext.INSTANCE.getThreadCorrelationId())).build();
        return commandParameters;
    }

    public static SignInWithContinuationTokenCommandParameters createSignInWithContinuationTokenCommandParameters(@NonNull NativeAuthPublicClientApplicationConfiguration configuration, @NonNull OAuth2TokenCache tokenCache, @Nullable String continuationToken, @Nullable String username, @NonNull String correlationId, List<String> scopes) throws ClientException {
        AbstractAuthenticationScheme authenticationScheme = AuthenticationSchemeFactory.createScheme((IPlatformComponents)AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext()), null);
        NativeAuthCIAMAuthority authority = (NativeAuthCIAMAuthority)configuration.getDefaultAuthority();
        SignInWithContinuationTokenCommandParameters commandParameters = ((SignInWithContinuationTokenCommandParameters.SignInWithContinuationTokenCommandParametersBuilder)((SignInWithContinuationTokenCommandParameters.SignInWithContinuationTokenCommandParametersBuilder)((SignInWithContinuationTokenCommandParameters.SignInWithContinuationTokenCommandParametersBuilder)((SignInWithContinuationTokenCommandParameters.SignInWithContinuationTokenCommandParametersBuilder)((SignInWithContinuationTokenCommandParameters.SignInWithContinuationTokenCommandParametersBuilder)((SignInWithContinuationTokenCommandParameters.SignInWithContinuationTokenCommandParametersBuilder)((SignInWithContinuationTokenCommandParameters.SignInWithContinuationTokenCommandParametersBuilder)((SignInWithContinuationTokenCommandParameters.SignInWithContinuationTokenCommandParametersBuilder)((SignInWithContinuationTokenCommandParameters.SignInWithContinuationTokenCommandParametersBuilder)((SignInWithContinuationTokenCommandParameters.SignInWithContinuationTokenCommandParametersBuilder)((SignInWithContinuationTokenCommandParameters.SignInWithContinuationTokenCommandParametersBuilder)((SignInWithContinuationTokenCommandParameters.SignInWithContinuationTokenCommandParametersBuilder)((SignInWithContinuationTokenCommandParameters.SignInWithContinuationTokenCommandParametersBuilder)((SignInWithContinuationTokenCommandParameters.SignInWithContinuationTokenCommandParametersBuilder)((SignInWithContinuationTokenCommandParameters.SignInWithContinuationTokenCommandParametersBuilder)((SignInWithContinuationTokenCommandParameters.SignInWithContinuationTokenCommandParametersBuilder)SignInWithContinuationTokenCommandParameters.builder().platformComponents(AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext()))).applicationName(configuration.getAppContext().getPackageName())).applicationVersion(CommandParametersAdapter.getPackageVersion(configuration.getAppContext()))).clientId(configuration.getClientId())).isSharedDevice(configuration.getIsSharedDevice())).redirectUri(configuration.getRedirectUri())).oAuth2TokenCache(tokenCache)).requiredBrokerProtocolVersion(configuration.getRequiredBrokerProtocolVersion())).sdkType(SdkType.MSAL)).sdkVersion(PublicClientApplication.getSdkVersion())).powerOptCheckEnabled(configuration.isPowerOptCheckForEnabled().booleanValue())).authority(authority)).continuationToken(continuationToken).username(username).challengeType(configuration.getChallengeTypes())).authenticationScheme(authenticationScheme)).scopes(scopes)).correlationId(correlationId)).build();
        return commandParameters;
    }

    public static SignInSubmitCodeCommandParameters createSignInSubmitCodeCommandParameters(@NonNull NativeAuthPublicClientApplicationConfiguration configuration, @NonNull OAuth2TokenCache tokenCache, @NonNull String code, @NonNull String continuationToken, @NonNull String correlationId, List<String> scopes) throws ClientException {
        NativeAuthCIAMAuthority authority = (NativeAuthCIAMAuthority)configuration.getDefaultAuthority();
        AbstractAuthenticationScheme authenticationScheme = AuthenticationSchemeFactory.createScheme((IPlatformComponents)AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext()), null);
        SignInSubmitCodeCommandParameters commandParameters = ((SignInSubmitCodeCommandParameters.SignInSubmitCodeCommandParametersBuilder)((SignInSubmitCodeCommandParameters.SignInSubmitCodeCommandParametersBuilder)((SignInSubmitCodeCommandParameters.SignInSubmitCodeCommandParametersBuilder)((SignInSubmitCodeCommandParameters.SignInSubmitCodeCommandParametersBuilder)((SignInSubmitCodeCommandParameters.SignInSubmitCodeCommandParametersBuilder)((SignInSubmitCodeCommandParameters.SignInSubmitCodeCommandParametersBuilder)((SignInSubmitCodeCommandParameters.SignInSubmitCodeCommandParametersBuilder)((SignInSubmitCodeCommandParameters.SignInSubmitCodeCommandParametersBuilder)((SignInSubmitCodeCommandParameters.SignInSubmitCodeCommandParametersBuilder)((SignInSubmitCodeCommandParameters.SignInSubmitCodeCommandParametersBuilder)((SignInSubmitCodeCommandParameters.SignInSubmitCodeCommandParametersBuilder)((SignInSubmitCodeCommandParameters.SignInSubmitCodeCommandParametersBuilder)((SignInSubmitCodeCommandParameters.SignInSubmitCodeCommandParametersBuilder)((SignInSubmitCodeCommandParameters.SignInSubmitCodeCommandParametersBuilder)((SignInSubmitCodeCommandParameters.SignInSubmitCodeCommandParametersBuilder)((SignInSubmitCodeCommandParameters.SignInSubmitCodeCommandParametersBuilder)SignInSubmitCodeCommandParameters.builder().platformComponents(AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext()))).applicationName(configuration.getAppContext().getPackageName())).applicationVersion(CommandParametersAdapter.getPackageVersion(configuration.getAppContext()))).clientId(configuration.getClientId())).isSharedDevice(configuration.getIsSharedDevice())).redirectUri(configuration.getRedirectUri())).oAuth2TokenCache(tokenCache)).requiredBrokerProtocolVersion(configuration.getRequiredBrokerProtocolVersion())).sdkType(SdkType.MSAL)).sdkVersion(PublicClientApplication.getSdkVersion())).powerOptCheckEnabled(configuration.isPowerOptCheckForEnabled().booleanValue())).authority(authority)).continuationToken(continuationToken).authenticationScheme(authenticationScheme)).challengeType(configuration.getChallengeTypes())).code(code).scopes(scopes)).correlationId(correlationId)).build();
        return commandParameters;
    }

    public static SignInResendCodeCommandParameters createSignInResendCodeCommandParameters(@NonNull NativeAuthPublicClientApplicationConfiguration configuration, @NonNull OAuth2TokenCache tokenCache, @NonNull String correlationId, @NonNull String continuationToken) {
        NativeAuthCIAMAuthority authority = (NativeAuthCIAMAuthority)configuration.getDefaultAuthority();
        SignInResendCodeCommandParameters commandParameters = ((SignInResendCodeCommandParameters.SignInResendCodeCommandParametersBuilder)((SignInResendCodeCommandParameters.SignInResendCodeCommandParametersBuilder)((SignInResendCodeCommandParameters.SignInResendCodeCommandParametersBuilder)((SignInResendCodeCommandParameters.SignInResendCodeCommandParametersBuilder)((SignInResendCodeCommandParameters.SignInResendCodeCommandParametersBuilder)((SignInResendCodeCommandParameters.SignInResendCodeCommandParametersBuilder)((SignInResendCodeCommandParameters.SignInResendCodeCommandParametersBuilder)((SignInResendCodeCommandParameters.SignInResendCodeCommandParametersBuilder)((SignInResendCodeCommandParameters.SignInResendCodeCommandParametersBuilder)((SignInResendCodeCommandParameters.SignInResendCodeCommandParametersBuilder)((SignInResendCodeCommandParameters.SignInResendCodeCommandParametersBuilder)((SignInResendCodeCommandParameters.SignInResendCodeCommandParametersBuilder)((SignInResendCodeCommandParameters.SignInResendCodeCommandParametersBuilder)((SignInResendCodeCommandParameters.SignInResendCodeCommandParametersBuilder)((SignInResendCodeCommandParameters.SignInResendCodeCommandParametersBuilder)SignInResendCodeCommandParameters.builder().platformComponents(AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext()))).applicationName(configuration.getAppContext().getPackageName())).applicationVersion(CommandParametersAdapter.getPackageVersion(configuration.getAppContext()))).clientId(configuration.getClientId())).isSharedDevice(configuration.getIsSharedDevice())).redirectUri(configuration.getRedirectUri())).oAuth2TokenCache(tokenCache)).requiredBrokerProtocolVersion(configuration.getRequiredBrokerProtocolVersion())).sdkType(SdkType.MSAL)).sdkVersion(PublicClientApplication.getSdkVersion())).powerOptCheckEnabled(configuration.isPowerOptCheckForEnabled().booleanValue())).authority(authority)).challengeType(configuration.getChallengeTypes())).continuationToken(continuationToken).challengeType(configuration.getChallengeTypes())).correlationId(correlationId)).build();
        return commandParameters;
    }

    public static SignInSubmitPasswordCommandParameters createSignInSubmitPasswordCommandParameters(@NonNull NativeAuthPublicClientApplicationConfiguration configuration, @NonNull OAuth2TokenCache tokenCache, @NonNull String continuationToken, @NonNull char[] password, @NonNull String correlationId, List<String> scopes) throws ClientException {
        NativeAuthCIAMAuthority authority = (NativeAuthCIAMAuthority)configuration.getDefaultAuthority();
        AbstractAuthenticationScheme authenticationScheme = AuthenticationSchemeFactory.createScheme((IPlatformComponents)AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext()), null);
        SignInSubmitPasswordCommandParameters commandParameters = ((SignInSubmitPasswordCommandParameters.SignInSubmitPasswordCommandParametersBuilder)((SignInSubmitPasswordCommandParameters.SignInSubmitPasswordCommandParametersBuilder)((SignInSubmitPasswordCommandParameters.SignInSubmitPasswordCommandParametersBuilder)((SignInSubmitPasswordCommandParameters.SignInSubmitPasswordCommandParametersBuilder)((SignInSubmitPasswordCommandParameters.SignInSubmitPasswordCommandParametersBuilder)((SignInSubmitPasswordCommandParameters.SignInSubmitPasswordCommandParametersBuilder)((SignInSubmitPasswordCommandParameters.SignInSubmitPasswordCommandParametersBuilder)((SignInSubmitPasswordCommandParameters.SignInSubmitPasswordCommandParametersBuilder)((SignInSubmitPasswordCommandParameters.SignInSubmitPasswordCommandParametersBuilder)((SignInSubmitPasswordCommandParameters.SignInSubmitPasswordCommandParametersBuilder)((SignInSubmitPasswordCommandParameters.SignInSubmitPasswordCommandParametersBuilder)((SignInSubmitPasswordCommandParameters.SignInSubmitPasswordCommandParametersBuilder)((SignInSubmitPasswordCommandParameters.SignInSubmitPasswordCommandParametersBuilder)((SignInSubmitPasswordCommandParameters.SignInSubmitPasswordCommandParametersBuilder)((SignInSubmitPasswordCommandParameters.SignInSubmitPasswordCommandParametersBuilder)((SignInSubmitPasswordCommandParameters.SignInSubmitPasswordCommandParametersBuilder)SignInSubmitPasswordCommandParameters.builder().platformComponents(AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext()))).applicationName(configuration.getAppContext().getPackageName())).applicationVersion(CommandParametersAdapter.getPackageVersion(configuration.getAppContext()))).clientId(configuration.getClientId())).isSharedDevice(configuration.getIsSharedDevice())).redirectUri(configuration.getRedirectUri())).oAuth2TokenCache(tokenCache)).requiredBrokerProtocolVersion(configuration.getRequiredBrokerProtocolVersion())).sdkType(SdkType.MSAL)).sdkVersion(PublicClientApplication.getSdkVersion())).powerOptCheckEnabled(configuration.isPowerOptCheckForEnabled().booleanValue())).authority(authority)).authenticationScheme(authenticationScheme)).continuationToken(continuationToken).password(password).scopes(scopes)).challengeType(configuration.getChallengeTypes())).correlationId(correlationId)).build();
        return commandParameters;
    }

    public static ResetPasswordStartCommandParameters createResetPasswordStartCommandParameters(@NonNull NativeAuthPublicClientApplicationConfiguration configuration, @NonNull OAuth2TokenCache tokenCache, @NonNull String username) {
        NativeAuthCIAMAuthority authority = (NativeAuthCIAMAuthority)configuration.getDefaultAuthority();
        ResetPasswordStartCommandParameters commandParameters = ((ResetPasswordStartCommandParameters.ResetPasswordStartCommandParametersBuilder)((ResetPasswordStartCommandParameters.ResetPasswordStartCommandParametersBuilder)((ResetPasswordStartCommandParameters.ResetPasswordStartCommandParametersBuilder)((ResetPasswordStartCommandParameters.ResetPasswordStartCommandParametersBuilder)((ResetPasswordStartCommandParameters.ResetPasswordStartCommandParametersBuilder)((ResetPasswordStartCommandParameters.ResetPasswordStartCommandParametersBuilder)((ResetPasswordStartCommandParameters.ResetPasswordStartCommandParametersBuilder)((ResetPasswordStartCommandParameters.ResetPasswordStartCommandParametersBuilder)((ResetPasswordStartCommandParameters.ResetPasswordStartCommandParametersBuilder)((ResetPasswordStartCommandParameters.ResetPasswordStartCommandParametersBuilder)((ResetPasswordStartCommandParameters.ResetPasswordStartCommandParametersBuilder)((ResetPasswordStartCommandParameters.ResetPasswordStartCommandParametersBuilder)((ResetPasswordStartCommandParameters.ResetPasswordStartCommandParametersBuilder)((ResetPasswordStartCommandParameters.ResetPasswordStartCommandParametersBuilder)((ResetPasswordStartCommandParameters.ResetPasswordStartCommandParametersBuilder)ResetPasswordStartCommandParameters.builder().platformComponents(AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext()))).applicationName(configuration.getAppContext().getPackageName())).applicationVersion(CommandParametersAdapter.getPackageVersion(configuration.getAppContext()))).clientId(configuration.getClientId())).isSharedDevice(configuration.getIsSharedDevice())).redirectUri(configuration.getRedirectUri())).oAuth2TokenCache(tokenCache)).requiredBrokerProtocolVersion(configuration.getRequiredBrokerProtocolVersion())).sdkType(SdkType.MSAL)).sdkVersion(PublicClientApplication.getSdkVersion())).powerOptCheckEnabled(configuration.isPowerOptCheckForEnabled().booleanValue())).authority(authority)).username(username).challengeType(configuration.getChallengeTypes())).clientId(configuration.getClientId())).correlationId(DiagnosticContext.INSTANCE.getThreadCorrelationId())).build();
        return commandParameters;
    }

    public static ResetPasswordSubmitCodeCommandParameters createResetPasswordSubmitCodeCommandParameters(@NonNull NativeAuthPublicClientApplicationConfiguration configuration, @NonNull OAuth2TokenCache tokenCache, @NonNull String code, @NonNull String correlationId, @NonNull String continuationToken) {
        NativeAuthCIAMAuthority authority = (NativeAuthCIAMAuthority)configuration.getDefaultAuthority();
        ResetPasswordSubmitCodeCommandParameters commandParameters = ((ResetPasswordSubmitCodeCommandParameters.ResetPasswordSubmitCodeCommandParametersBuilder)((ResetPasswordSubmitCodeCommandParameters.ResetPasswordSubmitCodeCommandParametersBuilder)((ResetPasswordSubmitCodeCommandParameters.ResetPasswordSubmitCodeCommandParametersBuilder)((ResetPasswordSubmitCodeCommandParameters.ResetPasswordSubmitCodeCommandParametersBuilder)((ResetPasswordSubmitCodeCommandParameters.ResetPasswordSubmitCodeCommandParametersBuilder)((ResetPasswordSubmitCodeCommandParameters.ResetPasswordSubmitCodeCommandParametersBuilder)((ResetPasswordSubmitCodeCommandParameters.ResetPasswordSubmitCodeCommandParametersBuilder)((ResetPasswordSubmitCodeCommandParameters.ResetPasswordSubmitCodeCommandParametersBuilder)((ResetPasswordSubmitCodeCommandParameters.ResetPasswordSubmitCodeCommandParametersBuilder)((ResetPasswordSubmitCodeCommandParameters.ResetPasswordSubmitCodeCommandParametersBuilder)((ResetPasswordSubmitCodeCommandParameters.ResetPasswordSubmitCodeCommandParametersBuilder)((ResetPasswordSubmitCodeCommandParameters.ResetPasswordSubmitCodeCommandParametersBuilder)((ResetPasswordSubmitCodeCommandParameters.ResetPasswordSubmitCodeCommandParametersBuilder)((ResetPasswordSubmitCodeCommandParameters.ResetPasswordSubmitCodeCommandParametersBuilder)((ResetPasswordSubmitCodeCommandParameters.ResetPasswordSubmitCodeCommandParametersBuilder)ResetPasswordSubmitCodeCommandParameters.builder().platformComponents(AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext()))).applicationName(configuration.getAppContext().getPackageName())).applicationVersion(CommandParametersAdapter.getPackageVersion(configuration.getAppContext()))).clientId(configuration.getClientId())).isSharedDevice(configuration.getIsSharedDevice())).redirectUri(configuration.getRedirectUri())).oAuth2TokenCache(tokenCache)).requiredBrokerProtocolVersion(configuration.getRequiredBrokerProtocolVersion())).sdkType(SdkType.MSAL)).sdkVersion(PublicClientApplication.getSdkVersion())).powerOptCheckEnabled(configuration.isPowerOptCheckForEnabled().booleanValue())).authority(authority)).code(code).challengeType(configuration.getChallengeTypes())).continuationToken(continuationToken).clientId(configuration.getClientId())).correlationId(correlationId)).build();
        return commandParameters;
    }

    public static ResetPasswordResendCodeCommandParameters createResetPasswordResendCodeCommandParameters(@NonNull NativeAuthPublicClientApplicationConfiguration configuration, @NonNull OAuth2TokenCache tokenCache, @NonNull String correlationId, @NonNull String continuationToken) {
        NativeAuthCIAMAuthority authority = (NativeAuthCIAMAuthority)configuration.getDefaultAuthority();
        ResetPasswordResendCodeCommandParameters commandParameters = ((ResetPasswordResendCodeCommandParameters.ResetPasswordResendCodeCommandParametersBuilder)((ResetPasswordResendCodeCommandParameters.ResetPasswordResendCodeCommandParametersBuilder)((ResetPasswordResendCodeCommandParameters.ResetPasswordResendCodeCommandParametersBuilder)((ResetPasswordResendCodeCommandParameters.ResetPasswordResendCodeCommandParametersBuilder)((ResetPasswordResendCodeCommandParameters.ResetPasswordResendCodeCommandParametersBuilder)((ResetPasswordResendCodeCommandParameters.ResetPasswordResendCodeCommandParametersBuilder)((ResetPasswordResendCodeCommandParameters.ResetPasswordResendCodeCommandParametersBuilder)((ResetPasswordResendCodeCommandParameters.ResetPasswordResendCodeCommandParametersBuilder)((ResetPasswordResendCodeCommandParameters.ResetPasswordResendCodeCommandParametersBuilder)((ResetPasswordResendCodeCommandParameters.ResetPasswordResendCodeCommandParametersBuilder)((ResetPasswordResendCodeCommandParameters.ResetPasswordResendCodeCommandParametersBuilder)((ResetPasswordResendCodeCommandParameters.ResetPasswordResendCodeCommandParametersBuilder)((ResetPasswordResendCodeCommandParameters.ResetPasswordResendCodeCommandParametersBuilder)((ResetPasswordResendCodeCommandParameters.ResetPasswordResendCodeCommandParametersBuilder)((ResetPasswordResendCodeCommandParameters.ResetPasswordResendCodeCommandParametersBuilder)ResetPasswordResendCodeCommandParameters.builder().platformComponents(AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext()))).applicationName(configuration.getAppContext().getPackageName())).applicationVersion(CommandParametersAdapter.getPackageVersion(configuration.getAppContext()))).clientId(configuration.getClientId())).isSharedDevice(configuration.getIsSharedDevice())).redirectUri(configuration.getRedirectUri())).oAuth2TokenCache(tokenCache)).requiredBrokerProtocolVersion(configuration.getRequiredBrokerProtocolVersion())).sdkType(SdkType.MSAL)).sdkVersion(PublicClientApplication.getSdkVersion())).powerOptCheckEnabled(configuration.isPowerOptCheckForEnabled().booleanValue())).authority(authority)).challengeType(configuration.getChallengeTypes())).continuationToken(continuationToken).clientId(configuration.getClientId())).correlationId(correlationId)).build();
        return commandParameters;
    }

    public static ResetPasswordSubmitNewPasswordCommandParameters createResetPasswordSubmitNewPasswordCommandParameters(@NonNull NativeAuthPublicClientApplicationConfiguration configuration, @NonNull OAuth2TokenCache tokenCache, @NonNull String continuationToken, @NonNull String correlationId, @NonNull char[] password) {
        NativeAuthCIAMAuthority authority = (NativeAuthCIAMAuthority)configuration.getDefaultAuthority();
        ResetPasswordSubmitNewPasswordCommandParameters commandParameters = ((ResetPasswordSubmitNewPasswordCommandParameters.ResetPasswordSubmitNewPasswordCommandParametersBuilder)((ResetPasswordSubmitNewPasswordCommandParameters.ResetPasswordSubmitNewPasswordCommandParametersBuilder)((ResetPasswordSubmitNewPasswordCommandParameters.ResetPasswordSubmitNewPasswordCommandParametersBuilder)((ResetPasswordSubmitNewPasswordCommandParameters.ResetPasswordSubmitNewPasswordCommandParametersBuilder)((ResetPasswordSubmitNewPasswordCommandParameters.ResetPasswordSubmitNewPasswordCommandParametersBuilder)((ResetPasswordSubmitNewPasswordCommandParameters.ResetPasswordSubmitNewPasswordCommandParametersBuilder)((ResetPasswordSubmitNewPasswordCommandParameters.ResetPasswordSubmitNewPasswordCommandParametersBuilder)((ResetPasswordSubmitNewPasswordCommandParameters.ResetPasswordSubmitNewPasswordCommandParametersBuilder)((ResetPasswordSubmitNewPasswordCommandParameters.ResetPasswordSubmitNewPasswordCommandParametersBuilder)((ResetPasswordSubmitNewPasswordCommandParameters.ResetPasswordSubmitNewPasswordCommandParametersBuilder)((ResetPasswordSubmitNewPasswordCommandParameters.ResetPasswordSubmitNewPasswordCommandParametersBuilder)((ResetPasswordSubmitNewPasswordCommandParameters.ResetPasswordSubmitNewPasswordCommandParametersBuilder)((ResetPasswordSubmitNewPasswordCommandParameters.ResetPasswordSubmitNewPasswordCommandParametersBuilder)((ResetPasswordSubmitNewPasswordCommandParameters.ResetPasswordSubmitNewPasswordCommandParametersBuilder)((ResetPasswordSubmitNewPasswordCommandParameters.ResetPasswordSubmitNewPasswordCommandParametersBuilder)ResetPasswordSubmitNewPasswordCommandParameters.builder().platformComponents(AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext()))).applicationName(configuration.getAppContext().getPackageName())).applicationVersion(CommandParametersAdapter.getPackageVersion(configuration.getAppContext()))).clientId(configuration.getClientId())).isSharedDevice(configuration.getIsSharedDevice())).redirectUri(configuration.getRedirectUri())).oAuth2TokenCache(tokenCache)).requiredBrokerProtocolVersion(configuration.getRequiredBrokerProtocolVersion())).sdkType(SdkType.MSAL)).sdkVersion(PublicClientApplication.getSdkVersion())).powerOptCheckEnabled(configuration.isPowerOptCheckForEnabled().booleanValue())).authority(authority)).continuationToken(continuationToken).challengeType(configuration.getChallengeTypes())).newPassword(password).clientId(configuration.getClientId())).correlationId(correlationId)).build();
        return commandParameters;
    }

    private static String getPackageVersion(@NonNull Context context) {
        String packageName = context.getPackageName();
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(packageName, 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Authority getRequestAuthority(@NonNull PublicClientApplicationConfiguration publicClientApplicationConfiguration) {
        String requestAuthority = null;
        if (publicClientApplicationConfiguration.getDefaultAuthority() instanceof AzureActiveDirectoryB2CAuthority) {
            requestAuthority = publicClientApplicationConfiguration.getDefaultAuthority().getAuthorityURL().toString();
        }
        Authority authority = requestAuthority == null ? publicClientApplicationConfiguration.getDefaultAuthority() : Authority.getAuthorityFromAuthorityUrl(requestAuthority);
        return authority;
    }

    public static ClaimsRequest addClientCapabilitiesToClaimsRequest(ClaimsRequest cr, String clientCapabilities) {
        ClaimsRequest mergedClaimsRequest;
        ClaimsRequest claimsRequest = mergedClaimsRequest = cr == null ? new ClaimsRequest() : cr;
        if (clientCapabilities != null) {
            RequestedClaimAdditionalInformation info = new RequestedClaimAdditionalInformation();
            String[] capabilities = clientCapabilities.split(",");
            info.setValues(new ArrayList<Object>(Arrays.asList(capabilities)));
            mergedClaimsRequest.requestClaimInAccessToken(CLIENT_CAPABILITIES_CLAIM, info);
        }
        return mergedClaimsRequest;
    }

    private static String getUsername(@NonNull IAccount account) {
        String username = null;
        if (null != account.getClaims()) {
            username = SchemaUtil.getDisplayableId(account.getClaims());
        } else {
            MultiTenantAccount multiTenantAccount = (MultiTenantAccount)account;
            Map<String, ITenantProfile> tenantProfiles = multiTenantAccount.getTenantProfiles();
            for (Map.Entry<String, ITenantProfile> profileEntry : tenantProfiles.entrySet()) {
                String displayableId;
                if (null == profileEntry.getValue().getClaims() || "Missing from the token response".equalsIgnoreCase(displayableId = SchemaUtil.getDisplayableId(profileEntry.getValue().getClaims()))) continue;
                username = displayableId;
                break;
            }
        }
        return username;
    }

    private static Authority getAuthority(PublicClientApplicationConfiguration configuration, @NonNull AcquireTokenParameters parameters) {
        Authority authority = StringUtil.isEmpty((String)parameters.getAuthority()) ? (parameters.getAccount() != null ? CommandParametersAdapter.getRequestAuthority(configuration) : configuration.getDefaultAuthority()) : Authority.getAuthorityFromAuthorityUrl((String)parameters.getAuthority());
        if (authority instanceof AzureActiveDirectoryAuthority) {
            AzureActiveDirectoryAuthority aadAuthority = (AzureActiveDirectoryAuthority)authority;
            aadAuthority.setMultipleCloudsSupported(configuration.getMultipleCloudsSupported().booleanValue());
        }
        return authority;
    }

    private static Authority getAuthority(@NonNull PublicClientApplicationConfiguration configuration, @NonNull AcquireTokenSilentParameters parameters) {
        String requestAuthority = parameters.getAuthority();
        Authority authority = Authority.getAuthorityFromAuthorityUrl((String)requestAuthority);
        if (authority instanceof AzureActiveDirectoryAuthority) {
            AzureActiveDirectoryAuthority aadAuthority = (AzureActiveDirectoryAuthority)authority;
            aadAuthority.setMultipleCloudsSupported(configuration.getMultipleCloudsSupported().booleanValue());
        }
        return authority;
    }

    private static ClaimsRequest getClaimsRequest(@NonNull ClaimsRequest requestedClaims, @NonNull PublicClientApplicationConfiguration configuration, @NonNull Authority authority) {
        if (authority instanceof AzureActiveDirectoryAuthority) {
            return CommandParametersAdapter.addClientCapabilitiesToClaimsRequest(requestedClaims, configuration.getClientCapabilities());
        }
        return requestedClaims;
    }

    private static String getLoginHint(@NonNull AcquireTokenParameters parameters) {
        if (parameters.getAccount() != null) {
            IAccount account = parameters.getAccount();
            return CommandParametersAdapter.getUsername(account);
        }
        return parameters.getLoginHint();
    }

    private static AuthorizationAgent getAuthorizationAgent(@NonNull PublicClientApplicationConfiguration configuration) {
        if (configuration.getAuthorizationAgent() != null) {
            return configuration.getAuthorizationAgent();
        }
        return AuthorizationAgent.DEFAULT;
    }

    private static boolean getBrokerBrowserSupportEnabled(@NonNull AcquireTokenParameters parameters) {
        String methodTag = TAG + ":getBrokerBrowserSupportEnabled";
        if (parameters instanceof IntuneAcquireTokenParameters) {
            boolean brokerBrowserEnabled = ((IntuneAcquireTokenParameters)parameters).isBrokerBrowserSupportEnabled();
            Logger.info((String)methodTag, (String)(" IntuneAcquireTokenParameters instance, broker browser enabled : " + brokerBrowserEnabled));
            return brokerBrowserEnabled;
        }
        return false;
    }

    private static OpenIdConnectPromptParameter getPromptParameter(@NonNull AcquireTokenParameters parameters) {
        if (parameters.getPrompt() == null) {
            return OpenIdConnectPromptParameter.SELECT_ACCOUNT;
        }
        return parameters.getPrompt().toOpenIdConnectPromptParameter();
    }

    public static GenerateShrCommandParameters createGenerateShrCommandParameters(@NonNull PublicClientApplicationConfiguration clientConfig, @NonNull OAuth2TokenCache oAuth2TokenCache, @NonNull String homeAccountId, @NonNull PoPAuthenticationScheme popParameters) {
        Context context = clientConfig.getAppContext();
        return ((GenerateShrCommandParameters.GenerateShrCommandParametersBuilder)((GenerateShrCommandParameters.GenerateShrCommandParametersBuilder)((GenerateShrCommandParameters.GenerateShrCommandParametersBuilder)((GenerateShrCommandParameters.GenerateShrCommandParametersBuilder)((GenerateShrCommandParameters.GenerateShrCommandParametersBuilder)((GenerateShrCommandParameters.GenerateShrCommandParametersBuilder)((GenerateShrCommandParameters.GenerateShrCommandParametersBuilder)((GenerateShrCommandParameters.GenerateShrCommandParametersBuilder)((GenerateShrCommandParameters.GenerateShrCommandParametersBuilder)((GenerateShrCommandParameters.GenerateShrCommandParametersBuilder)((GenerateShrCommandParameters.GenerateShrCommandParametersBuilder)GenerateShrCommandParameters.builder().platformComponents(AndroidPlatformComponentsFactory.createFromContext((Context)context))).applicationName(context.getPackageName())).applicationVersion(CommandParametersAdapter.getPackageVersion(context))).clientId(clientConfig.getClientId())).isSharedDevice(clientConfig.getIsSharedDevice())).redirectUri(clientConfig.getRedirectUri())).oAuth2TokenCache(oAuth2TokenCache)).requiredBrokerProtocolVersion(clientConfig.getRequiredBrokerProtocolVersion())).sdkType(SdkType.MSAL)).sdkVersion(PublicClientApplication.getSdkVersion())).powerOptCheckEnabled(clientConfig.isPowerOptCheckForEnabled().booleanValue())).homeAccountId(homeAccountId).popParameters((IPoPAuthenticationSchemeParams)popParameters).build();
    }

    @Nullable
    public static List<Map.Entry<String, String>> appendToExtraQueryParametersIfWebAuthnCapable(@Nullable List<Map.Entry<String, String>> queryStringParameters, @NonNull PublicClientApplicationConfiguration configuration) {
        if (configuration.isWebauthnCapable().booleanValue()) {
            AbstractMap.SimpleEntry<String, String> webauthnExtraParameter = new AbstractMap.SimpleEntry<String, String>("webauthn", "1");
            if (queryStringParameters == null) {
                return new ArrayList<Map.Entry<String, String>>(Collections.singletonList(webauthnExtraParameter));
            }
            if (!queryStringParameters.contains(webauthnExtraParameter)) {
                try {
                    queryStringParameters.add(webauthnExtraParameter);
                }
                catch (UnsupportedOperationException e) {
                    ArrayList<Map.Entry<String, String>> result = new ArrayList<Map.Entry<String, String>>(queryStringParameters);
                    result.add(webauthnExtraParameter);
                    return result;
                }
            }
        }
        return queryStringParameters;
    }
}

