/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.nativeauth.statemachine.states;

import com.microsoft.identity.client.Account;
import com.microsoft.identity.client.AcquireTokenSilentParameters;
import com.microsoft.identity.client.AuthenticationResultAdapter;
import com.microsoft.identity.client.IAccount;
import com.microsoft.identity.client.IAuthenticationResult;
import com.microsoft.identity.client.PublicClientApplication;
import com.microsoft.identity.client.exception.MsalClientException;
import com.microsoft.identity.client.exception.MsalException;
import com.microsoft.identity.client.internal.CommandParametersAdapter;
import com.microsoft.identity.common.internal.commands.RemoveCurrentAccountCommand;
import com.microsoft.identity.common.internal.controllers.LocalMSALController;
import com.microsoft.identity.common.java.commands.BaseCommand;
import com.microsoft.identity.common.java.commands.CommandCallback;
import com.microsoft.identity.common.java.commands.parameters.RemoveAccountCommandParameters;
import com.microsoft.identity.common.java.controllers.BaseController;
import com.microsoft.identity.common.java.controllers.CommandDispatcher;
import com.microsoft.identity.common.java.controllers.CommandResult;
import com.microsoft.identity.common.java.controllers.ExceptionAdapter;
import com.microsoft.identity.common.java.dto.AccountRecord;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.exception.ServiceException;
import com.microsoft.identity.common.java.logging.LogSession;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.AcquireTokenNoFixedScopesCommandParameters;
import com.microsoft.identity.common.java.result.ILocalAuthenticationResult;
import com.microsoft.identity.common.nativeauth.internal.commands.AcquireTokenNoFixedScopesCommand;
import com.microsoft.identity.common.nativeauth.internal.controllers.NativeAuthMsalController;
import com.microsoft.identity.nativeauth.NativeAuthPublicClientApplication;
import com.microsoft.identity.nativeauth.NativeAuthPublicClientApplicationConfiguration;
import com.microsoft.identity.nativeauth.statemachine.errors.GetAccessTokenError;
import com.microsoft.identity.nativeauth.statemachine.results.GetAccessTokenResult;
import com.microsoft.identity.nativeauth.statemachine.results.SignOutResult;
import com.microsoft.identity.nativeauth.statemachine.states.Callback;
import java.io.Serializable;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0003\u0018\u0019\u001aB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001b\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0007\u001a\u00020\f2\b\b\u0002\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0003J\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0002\b\u0003\u0018\u00010\u0011J\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012J\u0011\u0010\u0014\u001a\u00020\u0015H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Lcom/microsoft/identity/nativeauth/statemachine/states/AccountState;", "Ljava/io/Serializable;", "account", "Lcom/microsoft/identity/client/IAccount;", "config", "Lcom/microsoft/identity/nativeauth/NativeAuthPublicClientApplicationConfiguration;", "(Lcom/microsoft/identity/client/IAccount;Lcom/microsoft/identity/nativeauth/NativeAuthPublicClientApplicationConfiguration;)V", "getAccessToken", "Lcom/microsoft/identity/nativeauth/statemachine/results/GetAccessTokenResult;", "forceRefresh", "", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "", "callback", "Lcom/microsoft/identity/nativeauth/statemachine/states/AccountState$GetAccessTokenCallback;", "getAccount", "getClaims", "", "", "getIdToken", "signOut", "Lcom/microsoft/identity/nativeauth/statemachine/results/SignOutResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lcom/microsoft/identity/nativeauth/statemachine/states/AccountState$SignOutCallback;", "Companion", "GetAccessTokenCallback", "SignOutCallback", "msal_distRelease"})
public final class AccountState
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IAccount account;
    @NotNull
    private final NativeAuthPublicClientApplicationConfiguration config;
    private static final String TAG = NativeAuthPublicClientApplication.class.getSimpleName();

    private AccountState(IAccount account, NativeAuthPublicClientApplicationConfiguration config) {
        this.account = account;
        this.config = config;
    }

    public final void signOut(@NotNull SignOutCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, TAG + ".signOut");
        BuildersKt.launch$default((CoroutineScope)NativeAuthPublicClientApplication.Companion.getPcaScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, callback, null){
            int label;
            final /* synthetic */ AccountState this$0;
            final /* synthetic */ SignOutCallback $callback;
            {
                this.this$0 = $receiver;
                this.$callback = $callback;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.this$0.signOut((Continuation<? super SignOutResult>)((Continuation)this));
                        ** if (v0 != var3_2) goto lbl11
lbl10:
                        // 1 sources

                        return var3_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            result = (SignOutResult)v0;
                            this.$callback.onResult(result);
                        }
                        catch (MsalException e) {
                            Logger.error((String)AccountState.access$getTAG$cp(), (String)"Exception thrown in signOut", (Throwable)((Throwable)e));
                            this.$callback.onError(e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Nullable
    public final Object signOut(@NotNull Continuation<? super SignOutResult> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super SignOutResult.Complete>, Object>(this, null){
            int label;
            final /* synthetic */ AccountState this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        String string = AccountState.access$getTAG$cp();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
                        LogSession.Companion.logMethodCall(string, AccountState.access$getTAG$cp() + ".signOut.withContext");
                        IAccount iAccount = NativeAuthPublicClientApplication.Companion.getCurrentAccountInternal(AccountState.access$getConfig$p(this.this$0));
                        if (iAccount == null) {
                            throw new MsalClientException("no_current_account", "There is no signed in account.");
                        }
                        IAccount account = iAccount;
                        AccountRecord requestAccountRecord = new AccountRecord();
                        requestAccountRecord.setEnvironment(((Account)account).getEnvironment());
                        requestAccountRecord.setHomeAccountId(((Account)account).getHomeAccountId());
                        RemoveAccountCommandParameters params = CommandParametersAdapter.createRemoveAccountCommandParameters(AccountState.access$getConfig$p(this.this$0), AccountState.access$getConfig$p(this.this$0).getOAuth2TokenCache(), requestAccountRecord);
                        RemoveCurrentAccountCommand removeCurrentAccountCommandParameters2 = new RemoveCurrentAccountCommand(params, (BaseController)new LocalMSALController(), (CommandCallback)new CommandCallback<Boolean, BaseException>(){

                            public void onError(@Nullable BaseException error) {
                            }

                            public void onTaskCompleted(@Nullable Boolean result) {
                            }

                            public void onCancel() {
                            }
                        }, "240");
                        Object object2 = ((CommandResult)CommandDispatcher.submitSilentReturningFuture((BaseCommand)((BaseCommand)removeCurrentAccountCommandParameters2)).get()).getResult();
                        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Boolean");
                        boolean result = (Boolean)object2;
                        if (!result) {
                            Logger.error((String)AccountState.access$getTAG$cp(), (String)"Unexpected error during signOut.", null);
                            throw new MsalClientException("unknown_error", "Unexpected error during signOut.");
                        }
                        return SignOutResult.Complete.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super SignOutResult.Complete> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @NotNull
    public final IAccount getAccount() {
        return this.account;
    }

    @Nullable
    public final String getIdToken() {
        return this.account.getIdToken();
    }

    @Nullable
    public final Map<String, ?> getClaims() {
        return this.account.getClaims();
    }

    public final void getAccessToken(boolean forceRefresh, @NotNull GetAccessTokenCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, TAG + ".getAccessToken");
        BuildersKt.launch$default((CoroutineScope)NativeAuthPublicClientApplication.Companion.getPcaScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, forceRefresh, callback, null){
            int label;
            final /* synthetic */ AccountState this$0;
            final /* synthetic */ boolean $forceRefresh;
            final /* synthetic */ GetAccessTokenCallback $callback;
            {
                this.this$0 = $receiver;
                this.$forceRefresh = $forceRefresh;
                this.$callback = $callback;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = this.this$0.getAccessToken(this.$forceRefresh, (Continuation<? super GetAccessTokenResult>)((Continuation)this));
                        ** if (v0 != var3_2) goto lbl11
lbl10:
                        // 1 sources

                        return var3_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            result = (GetAccessTokenResult)v0;
                            this.$callback.onResult(result);
                        }
                        catch (MsalException e) {
                            Logger.error((String)AccountState.access$getTAG$cp(), (String)"Exception thrown in getAccessToken", (Throwable)((Throwable)e));
                            this.$callback.onError(e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static /* synthetic */ void getAccessToken$default(AccountState accountState, boolean bl, GetAccessTokenCallback getAccessTokenCallback, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        accountState.getAccessToken(bl, getAccessTokenCallback);
    }

    @Nullable
    public final Object getAccessToken(boolean forceRefresh, @NotNull Continuation<? super GetAccessTokenResult> $completion) {
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, TAG + ".getAccessToken(forceRefresh: Boolean)");
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super GetAccessTokenResult>, Object>(this, forceRefresh, null){
            int label;
            final /* synthetic */ AccountState this$0;
            final /* synthetic */ boolean $forceRefresh;
            {
                this.this$0 = $receiver;
                this.$forceRefresh = $forceRefresh;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        GetAccessTokenResult getAccessTokenResult;
                        Object commandResult;
                        ResultKt.throwOnFailure((Object)object);
                        IAccount iAccount = NativeAuthPublicClientApplication.Companion.getCurrentAccountInternal(AccountState.access$getConfig$p(this.this$0));
                        Account account = iAccount instanceof Account ? (Account)iAccount : null;
                        if (account == null) {
                            return new GetAccessTokenError("no_account_found", "no_current_account", "There is no signed in account.", null, null, null, 56, null);
                        }
                        Account account2 = account;
                        AcquireTokenSilentParameters acquireTokenSilentParameters = ((AcquireTokenSilentParameters.Builder)((AcquireTokenSilentParameters.Builder)new AcquireTokenSilentParameters.Builder().forAccount(account2)).fromAuthority(account2.getAuthority())).build();
                        AccountRecord accountToBeUsed = PublicClientApplication.selectAccountRecordForTokenRequest(AccountState.access$getConfig$p(this.this$0), acquireTokenSilentParameters);
                        AcquireTokenNoFixedScopesCommandParameters params = CommandParametersAdapter.createAcquireTokenNoFixedScopesCommandParameters(AccountState.access$getConfig$p(this.this$0), AccountState.access$getConfig$p(this.this$0).getOAuth2TokenCache(), accountToBeUsed, Boxing.boxBoolean((boolean)this.$forceRefresh));
                        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"params");
                        AcquireTokenNoFixedScopesCommand command2 = new AcquireTokenNoFixedScopesCommand(params, new NativeAuthMsalController(), "250");
                        Object object2 = commandResult = ((CommandResult)CommandDispatcher.submitSilentReturningFuture((BaseCommand)((BaseCommand)command2)).get()).getResult();
                        if (object2 instanceof ServiceException) {
                            getAccessTokenResult = new GetAccessTokenError(null, null, null, null, null, (Exception)ExceptionAdapter.convertToNativeAuthException((ServiceException)((ServiceException)commandResult)), 31, null);
                        } else if (object2 instanceof Exception) {
                            getAccessTokenResult = new GetAccessTokenError(null, null, null, null, null, (Exception)commandResult, 31, null);
                        } else {
                            Intrinsics.checkNotNull((Object)commandResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.result.ILocalAuthenticationResult");
                            IAuthenticationResult iAuthenticationResult = AuthenticationResultAdapter.adapt((ILocalAuthenticationResult)commandResult);
                            Intrinsics.checkNotNullExpressionValue((Object)iAuthenticationResult, (String)"adapt(commandResult as ILocalAuthenticationResult)");
                            getAccessTokenResult = new GetAccessTokenResult.Complete(iAuthenticationResult);
                        }
                        return getAccessTokenResult;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super GetAccessTokenResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    public static /* synthetic */ Object getAccessToken$default(AccountState accountState, boolean bl, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return accountState.getAccessToken(bl, (Continuation<? super GetAccessTokenResult>)continuation);
    }

    public /* synthetic */ AccountState(IAccount account, NativeAuthPublicClientApplicationConfiguration config, DefaultConstructorMarker $constructor_marker) {
        this(account, config);
    }

    public static final /* synthetic */ String access$getTAG$cp() {
        return TAG;
    }

    public static final /* synthetic */ NativeAuthPublicClientApplicationConfiguration access$getConfig$p(AccountState $this) {
        return $this.config;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bR\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/microsoft/identity/nativeauth/statemachine/states/AccountState$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "createFromAccountResult", "Lcom/microsoft/identity/nativeauth/statemachine/states/AccountState;", "account", "Lcom/microsoft/identity/client/IAccount;", "config", "Lcom/microsoft/identity/nativeauth/NativeAuthPublicClientApplicationConfiguration;", "createFromAuthenticationResult", "authenticationResult", "Lcom/microsoft/identity/client/IAuthenticationResult;", "msal_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AccountState createFromAuthenticationResult(@NotNull IAuthenticationResult authenticationResult, @NotNull NativeAuthPublicClientApplicationConfiguration config) {
            Intrinsics.checkNotNullParameter((Object)authenticationResult, (String)"authenticationResult");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            IAccount iAccount = authenticationResult.getAccount();
            Intrinsics.checkNotNullExpressionValue((Object)iAccount, (String)"authenticationResult.account");
            return new AccountState(iAccount, config, null);
        }

        @NotNull
        public final AccountState createFromAccountResult(@NotNull IAccount account, @NotNull NativeAuthPublicClientApplicationConfiguration config) {
            Intrinsics.checkNotNullParameter((Object)account, (String)"account");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            return new AccountState(account, config, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a8\u0006\u0003"}, d2={"Lcom/microsoft/identity/nativeauth/statemachine/states/AccountState$SignOutCallback;", "Lcom/microsoft/identity/nativeauth/statemachine/states/Callback;", "Lcom/microsoft/identity/nativeauth/statemachine/results/SignOutResult;", "msal_distRelease"})
    public static interface SignOutCallback
    extends Callback<SignOutResult> {
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a8\u0006\u0003"}, d2={"Lcom/microsoft/identity/nativeauth/statemachine/states/AccountState$GetAccessTokenCallback;", "Lcom/microsoft/identity/nativeauth/statemachine/states/Callback;", "Lcom/microsoft/identity/nativeauth/statemachine/results/GetAccessTokenResult;", "msal_distRelease"})
    public static interface GetAccessTokenCallback
    extends Callback<GetAccessTokenResult> {
    }
}

