/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.app.Activity;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.microsoft.identity.client.AcquireTokenParameters;
import com.microsoft.identity.client.AcquireTokenSilentParameters;
import com.microsoft.identity.client.AuthenticationCallback;
import com.microsoft.identity.client.IAccount;
import com.microsoft.identity.client.IAuthenticationResult;
import com.microsoft.identity.client.IPublicClientApplication;
import com.microsoft.identity.client.SilentAuthenticationCallback;
import com.microsoft.identity.client.exception.MsalException;
import com.microsoft.identity.common.java.util.TaskCompletedCallbackWithError;
import java.util.List;

public interface IMultipleAccountPublicClientApplication
extends IPublicClientApplication {
    public void getAccounts(@NonNull IPublicClientApplication.LoadAccountsCallback var1);

    @WorkerThread
    public List<IAccount> getAccounts() throws InterruptedException, MsalException;

    public void getAccount(@NonNull String var1, @NonNull GetAccountCallback var2);

    @WorkerThread
    public IAccount getAccount(@NonNull String var1) throws InterruptedException, MsalException;

    public void removeAccount(@Nullable IAccount var1, @NonNull RemoveAccountCallback var2);

    @WorkerThread
    public boolean removeAccount(@Nullable IAccount var1) throws MsalException, InterruptedException;

    @Override
    public void acquireToken(@NonNull AcquireTokenParameters var1);

    @Deprecated
    public void acquireToken(@NonNull Activity var1, @NonNull String[] var2, @Nullable String var3, @NonNull AuthenticationCallback var4);

    @Override
    @WorkerThread
    public IAuthenticationResult acquireTokenSilent(@NonNull AcquireTokenSilentParameters var1) throws MsalException, InterruptedException;

    @Deprecated
    @WorkerThread
    public IAuthenticationResult acquireTokenSilent(@NonNull String[] var1, @NonNull IAccount var2, @NonNull String var3) throws MsalException, InterruptedException;

    @Override
    public void acquireTokenSilentAsync(@NonNull AcquireTokenSilentParameters var1);

    @Deprecated
    public void acquireTokenSilentAsync(@NonNull String[] var1, @NonNull IAccount var2, @NonNull String var3, @NonNull SilentAuthenticationCallback var4);

    public static interface RemoveAccountCallback {
        public void onRemoved();

        public void onError(@NonNull MsalException var1);
    }

    public static interface GetAccountCallback
    extends TaskCompletedCallbackWithError<IAccount, MsalException> {
        public void onTaskCompleted(IAccount var1);

        public void onError(MsalException var1);
    }
}

