/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.controllers;

import com.microsoft.identity.client.exception.MsalArgumentException;
import com.microsoft.identity.client.exception.MsalClientException;
import com.microsoft.identity.client.exception.MsalException;
import com.microsoft.identity.client.exception.MsalIntuneAppProtectionPolicyRequiredException;
import com.microsoft.identity.client.exception.MsalServiceException;
import com.microsoft.identity.client.exception.MsalUiRequiredException;
import com.microsoft.identity.client.exception.MsalUnsupportedBrokerException;
import com.microsoft.identity.client.exception.MsalUserCancelException;
import com.microsoft.identity.common.java.exception.ArgumentException;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.exception.IntuneAppProtectionPolicyRequiredException;
import com.microsoft.identity.common.java.exception.ServiceException;
import com.microsoft.identity.common.java.exception.UiRequiredException;
import com.microsoft.identity.common.java.exception.UnsupportedBrokerException;
import com.microsoft.identity.common.java.exception.UserCancelException;

public class MsalExceptionAdapter {
    public static MsalException msalExceptionFromBaseException(BaseException e) {
        if (e instanceof MsalException) {
            return (MsalException)e;
        }
        if (e instanceof ClientException) {
            ClientException clientException = (ClientException)e;
            return new MsalClientException(clientException.getErrorCode(), clientException.getMessage(), (Throwable)clientException);
        }
        if (e instanceof ArgumentException) {
            ArgumentException argumentException = (ArgumentException)e;
            return new MsalArgumentException(argumentException.getArgumentName(), argumentException.getOperationName(), argumentException.getMessage(), (Throwable)argumentException);
        }
        if (e instanceof UiRequiredException) {
            UiRequiredException uiRequiredException = (UiRequiredException)e;
            return new MsalUiRequiredException(uiRequiredException.getErrorCode(), uiRequiredException.getOAuthSubErrorCode(), uiRequiredException.getMessage());
        }
        if (e instanceof IntuneAppProtectionPolicyRequiredException) {
            return new MsalIntuneAppProtectionPolicyRequiredException((IntuneAppProtectionPolicyRequiredException)e);
        }
        if (e instanceof UnsupportedBrokerException) {
            return new MsalUnsupportedBrokerException((UnsupportedBrokerException)e);
        }
        if (e instanceof ServiceException) {
            ServiceException serviceException = (ServiceException)e;
            return new MsalServiceException(serviceException.getErrorCode(), serviceException.getMessage(), serviceException.getHttpStatusCode(), serviceException);
        }
        if (e instanceof UserCancelException) {
            return new MsalUserCancelException();
        }
        return new MsalClientException("unknown_error", e.getMessage(), (Throwable)e);
    }
}

