/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.client.IAccount;
import com.microsoft.identity.client.ITenantProfile;
import com.microsoft.identity.client.MultiTenantAccount;
import com.microsoft.identity.client.TenantProfile;
import com.microsoft.identity.common.java.cache.ICacheRecord;
import com.microsoft.identity.common.java.dto.AccountRecord;
import com.microsoft.identity.common.java.exception.ServiceException;
import com.microsoft.identity.common.java.providers.oauth2.IDToken;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.logging.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class AccountAdapter {
    private static final String TAG = AccountAdapter.class.getSimpleName();
    private static final CacheRecordFilter guestAccountsWithNoHomeTenantAccountFilter = new CacheRecordFilter(){

        private boolean hasNoCorrespondingHomeAccount(@NonNull ICacheRecord guestRecord, final @NonNull List<ICacheRecord> homeRecords) {
            ArrayList<String> homeAccountIds = new ArrayList<String>(){
                {
                    for (ICacheRecord cacheRecord : homeRecords) {
                        this.add(cacheRecord.getAccount().getHomeAccountId());
                    }
                }
            };
            String guestAccountHomeAccountId = guestRecord.getAccount().getHomeAccountId();
            return !homeAccountIds.contains(guestAccountHomeAccountId);
        }

        @Override
        public List<ICacheRecord> filter(@NonNull List<ICacheRecord> records) {
            ArrayList<ICacheRecord> result = new ArrayList<ICacheRecord>();
            List homeRecords = AccountAdapter.filterCacheRecords(records, new HomeAccountFilter());
            List guestRecords = AccountAdapter.filterCacheRecords(records, new GuestAccountFilter());
            for (ICacheRecord guestRecord : guestRecords) {
                if (!this.hasNoCorrespondingHomeAccount(guestRecord, homeRecords)) continue;
                result.add(guestRecord);
            }
            return result;
        }
    };

    AccountAdapter() {
    }

    @NonNull
    static List<IAccount> adapt(@NonNull List<ICacheRecord> allCacheRecords) {
        List<ICacheRecord> homeCacheRecords = AccountAdapter.filterCacheRecords(allCacheRecords, new HomeAccountFilter());
        List<ICacheRecord> guestCacheRecords = AccountAdapter.filterCacheRecords(allCacheRecords, new GuestAccountFilter());
        List<ICacheRecord> guestCacheRecordsWithNoHomeAccount = AccountAdapter.filterCacheRecords(allCacheRecords, guestAccountsWithNoHomeTenantAccountFilter);
        guestCacheRecords.removeAll(guestCacheRecordsWithNoHomeAccount);
        List<IAccount> rootAccounts = AccountAdapter.createRootAccounts(homeCacheRecords);
        AccountAdapter.appendChildren(rootAccounts, guestCacheRecords);
        rootAccounts.addAll(AccountAdapter.createIAccountsForGuestsNotSignedIntoHomeTenant(guestCacheRecordsWithNoHomeAccount));
        return rootAccounts;
    }

    @NonNull
    private static List<IAccount> createIAccountsForGuestsNotSignedIntoHomeTenant(@NonNull List<ICacheRecord> guestCacheRecords) {
        HashMap bucketedRecords = new HashMap();
        for (ICacheRecord cacheRecord : guestCacheRecords) {
            String cacheRecordHomeAccountId = cacheRecord.getAccount().getHomeAccountId();
            if (null == bucketedRecords.get(cacheRecordHomeAccountId)) {
                bucketedRecords.put(cacheRecordHomeAccountId, new ArrayList());
            }
            ((List)bucketedRecords.get(cacheRecordHomeAccountId)).add(cacheRecord);
        }
        ArrayList<IAccount> result = new ArrayList<IAccount>();
        for (Map.Entry entry : bucketedRecords.entrySet()) {
            MultiTenantAccount emptyRoot = new MultiTenantAccount(null, null);
            emptyRoot.setId((String)StringUtil.getTenantInfo((String)((String)entry.getKey())).getKey());
            emptyRoot.setTenantId((String)StringUtil.getTenantInfo((String)((String)entry.getKey())).getValue());
            emptyRoot.setEnvironment(((ICacheRecord)((List)entry.getValue()).get(0)).getAccount().getEnvironment());
            HashMap<String, ITenantProfile> tenantProfileMap = new HashMap<String, ITenantProfile>();
            for (ICacheRecord cacheRecord : (List)entry.getValue()) {
                String tenantId = cacheRecord.getAccount().getRealm();
                TenantProfile profile = new TenantProfile(null, AccountAdapter.getIdToken(cacheRecord));
                tenantProfileMap.put(tenantId, profile);
            }
            emptyRoot.setTenantProfiles(tenantProfileMap);
            result.add(emptyRoot);
        }
        return result;
    }

    private static void appendChildren(@NonNull List<IAccount> rootAccounts, @NonNull List<ICacheRecord> guestCacheRecords) {
        for (IAccount account : rootAccounts) {
            HashMap<String, ITenantProfile> tenantProfiles = new HashMap<String, ITenantProfile>();
            for (ICacheRecord guestRecord : guestCacheRecords) {
                String guestRecordHomeAccountId = guestRecord.getAccount().getHomeAccountId();
                if (!guestRecordHomeAccountId.contains(account.getId())) continue;
                TenantProfile profile = new TenantProfile(null, AccountAdapter.getIdToken(guestRecord));
                profile.setEnvironment(guestRecord.getAccount().getEnvironment());
                tenantProfiles.put(guestRecord.getAccount().getRealm(), profile);
            }
            MultiTenantAccount multiTenantAccount = (MultiTenantAccount)account;
            multiTenantAccount.setTenantProfiles(tenantProfiles);
        }
    }

    @NonNull
    private static List<IAccount> createRootAccounts(@NonNull List<ICacheRecord> homeCacheRecords) {
        ArrayList<IAccount> result = new ArrayList<IAccount>();
        for (ICacheRecord homeCacheRecord : homeCacheRecords) {
            MultiTenantAccount rootAccount = new MultiTenantAccount(homeCacheRecord.getAccount().getClientInfo(), AccountAdapter.getIdToken(homeCacheRecord));
            rootAccount.setHomeAccountId(homeCacheRecord.getAccount().getHomeAccountId());
            rootAccount.setTenantId((String)StringUtil.getTenantInfo((String)homeCacheRecord.getAccount().getHomeAccountId()).getValue());
            rootAccount.setEnvironment(homeCacheRecord.getAccount().getEnvironment());
            result.add(rootAccount);
        }
        return result;
    }

    @Nullable
    private static IDToken getIdToken(@NonNull ICacheRecord cacheRecord) {
        String rawIdToken;
        if (null != cacheRecord.getIdToken()) {
            rawIdToken = cacheRecord.getIdToken().getSecret();
        } else if (null != cacheRecord.getV1IdToken()) {
            rawIdToken = cacheRecord.getV1IdToken().getSecret();
        } else {
            return null;
        }
        try {
            return new IDToken(rawIdToken);
        }
        catch (ServiceException e) {
            throw new IllegalStateException("Failed to restore IdToken");
        }
    }

    @NonNull
    private static List<ICacheRecord> filterCacheRecords(@NonNull List<ICacheRecord> allCacheRecords, @NonNull CacheRecordFilter filter) {
        return filter.filter(allCacheRecords);
    }

    @Nullable
    static AccountRecord getAccountInternal(@NonNull String clientId, @NonNull OAuth2TokenCache oAuth2TokenCache, @NonNull String homeAccountIdentifier, @Nullable String realm) {
        AccountRecord accountToReturn;
        String methodTag = TAG + ":getAccountInternal";
        if (!StringUtil.isNullOrEmpty((String)homeAccountIdentifier)) {
            accountToReturn = oAuth2TokenCache.getAccount(null, clientId, homeAccountIdentifier, realm);
        } else {
            Logger.warn((String)methodTag, (String)"homeAccountIdentifier was null or empty -- invalid criteria");
            accountToReturn = null;
        }
        return accountToReturn;
    }

    private static class HomeAccountFilter
    implements CacheRecordFilter {
        private HomeAccountFilter() {
        }

        @Override
        public List<ICacheRecord> filter(@NonNull List<ICacheRecord> records) {
            ArrayList<ICacheRecord> result = new ArrayList<ICacheRecord>();
            for (ICacheRecord cacheRecord : records) {
                String acctHomeAccountId = cacheRecord.getAccount().getHomeAccountId();
                String acctLocalAccountId = cacheRecord.getAccount().getLocalAccountId();
                if (acctLocalAccountId == null || !acctHomeAccountId.contains(acctLocalAccountId)) continue;
                result.add(cacheRecord);
            }
            return result;
        }
    }

    private static class GuestAccountFilter
    implements CacheRecordFilter {
        private GuestAccountFilter() {
        }

        @Override
        public List<ICacheRecord> filter(@NonNull List<ICacheRecord> records) {
            ArrayList<ICacheRecord> result = new ArrayList<ICacheRecord>();
            for (ICacheRecord cacheRecord : records) {
                String acctLocalAccountId;
                String acctHomeAccountId = cacheRecord.getAccount().getHomeAccountId();
                if (acctHomeAccountId.contains(acctLocalAccountId = cacheRecord.getAccount().getLocalAccountId())) continue;
                result.add(cacheRecord);
            }
            return result;
        }
    }

    private static interface CacheRecordFilter {
        public List<ICacheRecord> filter(@NonNull List<ICacheRecord> var1);
    }
}

