/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.controllers;

import android.content.Context;
import android.os.Build;
import android.os.PowerManager;
import androidx.annotation.VisibleForTesting;
import com.microsoft.identity.client.PublicClientApplicationConfiguration;
import com.microsoft.identity.common.components.AndroidPlatformComponentsFactory;
import com.microsoft.identity.common.internal.activebrokerdiscovery.BrokerDiscoveryClientFactory;
import com.microsoft.identity.common.internal.activebrokerdiscovery.IBrokerDiscoveryClient;
import com.microsoft.identity.common.internal.broker.BrokerData;
import com.microsoft.identity.common.internal.controllers.BrokerMsalController;
import com.microsoft.identity.common.internal.controllers.LocalMSALController;
import com.microsoft.identity.common.java.authorities.Authority;
import com.microsoft.identity.common.java.authorities.AzureActiveDirectoryAuthority;
import com.microsoft.identity.common.java.controllers.BaseController;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.logging.Logger;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0017\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/microsoft/identity/client/internal/controllers/MSALControllerFactory;", "", "applicationConfiguration", "Lcom/microsoft/identity/client/PublicClientApplicationConfiguration;", "(Lcom/microsoft/identity/client/PublicClientApplicationConfiguration;)V", "applicationContext", "Landroid/content/Context;", "platformComponents", "Lcom/microsoft/identity/common/java/interfaces/IPlatformComponents;", "(Landroid/content/Context;Lcom/microsoft/identity/common/java/interfaces/IPlatformComponents;Lcom/microsoft/identity/client/PublicClientApplicationConfiguration;)V", "discoveryClient", "Lcom/microsoft/identity/common/internal/activebrokerdiscovery/IBrokerDiscoveryClient;", "brokerEligible", "", "authority", "Lcom/microsoft/identity/common/java/authorities/Authority;", "brokerEligibleAndInstalled", "getActiveBrokerPackageName", "", "getAllControllers", "", "Lcom/microsoft/identity/common/java/controllers/BaseController;", "getDefaultController", "powerOptimizationEnabled", "Companion", "msal_distRelease"})
public final class MSALControllerFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context applicationContext;
    @NotNull
    private final IPlatformComponents platformComponents;
    @NotNull
    private final PublicClientApplicationConfiguration applicationConfiguration;
    @NotNull
    private final IBrokerDiscoveryClient discoveryClient;
    @Nullable
    private static final String TAG = Reflection.getOrCreateKotlinClass(MSALControllerFactory.class).getSimpleName();
    @Nullable
    private static BaseController injectedMockDefaultController;

    public MSALControllerFactory(@NotNull Context applicationContext, @NotNull IPlatformComponents platformComponents, @NotNull PublicClientApplicationConfiguration applicationConfiguration) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)platformComponents, (String)"platformComponents");
        Intrinsics.checkNotNullParameter((Object)applicationConfiguration, (String)"applicationConfiguration");
        this.applicationContext = applicationContext;
        this.platformComponents = platformComponents;
        this.applicationConfiguration = applicationConfiguration;
        this.discoveryClient = BrokerDiscoveryClientFactory.Companion.getInstance(this.applicationContext, this.platformComponents);
    }

    public MSALControllerFactory(@NotNull PublicClientApplicationConfiguration applicationConfiguration) {
        Intrinsics.checkNotNullParameter((Object)applicationConfiguration, (String)"applicationConfiguration");
        Context context = applicationConfiguration.getAppContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationConfiguration.appContext");
        IPlatformComponents iPlatformComponents = AndroidPlatformComponentsFactory.createFromContext((Context)applicationConfiguration.getAppContext());
        Intrinsics.checkNotNullExpressionValue((Object)iPlatformComponents, (String)"createFromContext(applic\u2026Configuration.appContext)");
        this(context, iPlatformComponents, applicationConfiguration);
    }

    @NotNull
    public final BaseController getDefaultController(@NotNull Authority authority) {
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        String activeBroker = this.getActiveBrokerPackageName();
        CharSequence charSequence = activeBroker;
        return !(charSequence == null || charSequence.length() == 0) && this.brokerEligible(authority) ? (BaseController)new BrokerMsalController(this.applicationContext, this.platformComponents, activeBroker) : (BaseController)new LocalMSALController();
    }

    @NotNull
    public final List<BaseController> getAllControllers(@NotNull Authority authority) {
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        String activeBroker = this.getActiveBrokerPackageName();
        List controllers = new ArrayList();
        controllers.add(new LocalMSALController());
        CharSequence charSequence = activeBroker;
        if (!(charSequence == null || charSequence.length() == 0) && this.brokerEligible(authority)) {
            controllers.add(new BrokerMsalController(this.applicationContext, this.platformComponents, activeBroker));
        }
        return CollectionsKt.toList((Iterable)controllers);
    }

    public final boolean brokerEligibleAndInstalled(@NotNull Authority authority) {
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        return this.getActiveBrokerPackageName() != null && this.brokerEligible(authority);
    }

    private final boolean brokerEligible(Authority authority) {
        String methodTag = TAG + ":brokerEligible";
        String logBrokerEligibleFalse = "Eligible to call broker? [false]. ";
        if (!this.applicationConfiguration.getUseBroker().booleanValue() || !(authority instanceof AzureActiveDirectoryAuthority)) {
            Logger.verbose((String)methodTag, (String)(logBrokerEligibleFalse + "App does not ask for Broker or the authority is not AAD authority."));
            return false;
        }
        if (this.powerOptimizationEnabled()) {
            Logger.verbose((String)methodTag, (String)"Is the power optimization enabled? [true]");
        }
        return true;
    }

    private final boolean powerOptimizationEnabled() {
        boolean bl;
        String methodTag = TAG + ":powerOptimizationEnabled";
        String packageName = this.applicationContext.getPackageName();
        Object object = this.applicationContext.getSystemService("power");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.os.PowerManager");
        PowerManager pm = (PowerManager)object;
        if (Build.VERSION.SDK_INT >= 23) {
            boolean isPowerOptimizationOn = pm.isIgnoringBatteryOptimizations(packageName);
            Logger.verbose((String)methodTag, (String)("Is power optimization on? [" + isPowerOptimizationOn + ']'));
            bl = isPowerOptimizationOn;
        } else {
            Logger.verbose((String)methodTag, (String)"Is power optimization on? [false]");
            bl = false;
        }
        return bl;
    }

    private final String getActiveBrokerPackageName() {
        BrokerData activeBroker;
        String methodTag = TAG + ":getActiveBrokerPackageName";
        BrokerData brokerData = activeBroker = this.discoveryClient.getActiveBroker(false);
        if (brokerData != null) {
            BrokerData it = brokerData;
            boolean bl = false;
            return it.getPackageName();
        }
        Logger.info((String)methodTag, (String)"Broker application is not installed.");
        return null;
    }

    @Nullable
    public static final BaseController getInjectedMockDefaultController() {
        return Companion.getInjectedMockDefaultController();
    }

    public static final void setInjectedMockDefaultController(@Nullable BaseController baseController) {
        Companion.setInjectedMockDefaultController(baseController);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/microsoft/identity/client/internal/controllers/MSALControllerFactory$Companion;", "", "()V", "TAG", "", "injectedMockDefaultController", "Lcom/microsoft/identity/common/java/controllers/BaseController;", "getInjectedMockDefaultController$annotations", "getInjectedMockDefaultController", "()Lcom/microsoft/identity/common/java/controllers/BaseController;", "setInjectedMockDefaultController", "(Lcom/microsoft/identity/common/java/controllers/BaseController;)V", "msal_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final BaseController getInjectedMockDefaultController() {
            return injectedMockDefaultController;
        }

        public final void setInjectedMockDefaultController(@Nullable BaseController baseController) {
            injectedMockDefaultController = baseController;
        }

        @JvmStatic
        @VisibleForTesting
        public static /* synthetic */ void getInjectedMockDefaultController$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

