/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.microsoft.identity.client.Logger;
import com.microsoft.identity.client.PublicClientApplicationConfiguration;
import com.microsoft.identity.client.internal.MsalUtils;
import com.microsoft.identity.client.internal.configuration.LogLevelDeserializer;
import com.microsoft.identity.common.components.AndroidPlatformComponentsFactory;
import com.microsoft.identity.common.internal.authorities.AzureActiveDirectoryAudienceDeserializer;
import com.microsoft.identity.common.java.authorities.Authority;
import com.microsoft.identity.common.java.authorities.AuthorityDeserializer;
import com.microsoft.identity.common.java.authorities.AzureActiveDirectoryAudience;
import com.microsoft.identity.common.java.cache.MsalOAuth2TokenCache;
import com.microsoft.identity.common.java.configuration.LibraryConfiguration;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.logging.Logger;
import com.microsoft.identity.msal.R;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class PublicClientApplicationConfigurationFactory {
    private static final String TAG = PublicClientApplicationConfigurationFactory.class.getSimpleName();

    @WorkerThread
    public static PublicClientApplicationConfiguration initializeConfiguration(@NonNull Context context) {
        return PublicClientApplicationConfigurationFactory.initializeConfigurationInternal(context, null);
    }

    @WorkerThread
    public static PublicClientApplicationConfiguration initializeConfiguration(@NonNull Context context, int configResourceId) {
        return PublicClientApplicationConfigurationFactory.initializeConfigurationInternal(context, PublicClientApplicationConfigurationFactory.loadConfiguration(context, configResourceId));
    }

    @WorkerThread
    public static PublicClientApplicationConfiguration initializeConfiguration(@NonNull Context context, @NonNull File configFile) {
        MsalUtils.validateNonNullArgument(configFile, "configFile");
        return PublicClientApplicationConfigurationFactory.initializeConfigurationInternal(context, PublicClientApplicationConfigurationFactory.loadConfiguration(configFile));
    }

    @WorkerThread
    private static PublicClientApplicationConfiguration initializeConfigurationInternal(@NonNull Context context, @Nullable PublicClientApplicationConfiguration developerConfig) {
        MsalUtils.validateNonNullArgument(context, "context");
        PublicClientApplicationConfiguration config = PublicClientApplicationConfigurationFactory.loadDefaultConfiguration(context);
        if (developerConfig != null) {
            config.mergeConfiguration(developerConfig);
            config.validateConfiguration();
        }
        LibraryConfiguration libraryConfiguration = LibraryConfiguration.builder().authorizationInCurrentTask(config.authorizationInCurrentTask().booleanValue()).build();
        LibraryConfiguration.intializeLibraryConfiguration((LibraryConfiguration)libraryConfiguration);
        config.setOAuth2TokenCache((OAuth2TokenCache)MsalOAuth2TokenCache.create((IPlatformComponents)AndroidPlatformComponentsFactory.createFromContext((Context)context)));
        return config;
    }

    @WorkerThread
    private static PublicClientApplicationConfiguration loadDefaultConfiguration(@NonNull Context context) {
        String methodTag = TAG + ":loadDefaultConfiguration";
        Logger.verbose((String)methodTag, (String)"Loading default configuration");
        PublicClientApplicationConfiguration config = PublicClientApplicationConfigurationFactory.loadConfiguration(context, R.raw.msal_default_config);
        config.setAppContext(context);
        return config;
    }

    @VisibleForTesting
    @WorkerThread
    static PublicClientApplicationConfiguration loadConfiguration(@NonNull Context context, int configResourceId) {
        InputStream configStream = context.getResources().openRawResource(configResourceId);
        boolean useDefaultConfigResourceId = configResourceId == R.raw.msal_default_config;
        return PublicClientApplicationConfigurationFactory.loadConfiguration(configStream, useDefaultConfigResourceId);
    }

    @VisibleForTesting
    @WorkerThread
    static PublicClientApplicationConfiguration loadConfiguration(@NonNull File configFile) {
        try {
            return PublicClientApplicationConfigurationFactory.loadConfiguration(new FileInputStream(configFile), false);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Provided configuration file path=" + configFile.getPath() + " not found.");
        }
    }

    @WorkerThread
    private static PublicClientApplicationConfiguration loadConfiguration(@NonNull InputStream configStream, boolean isDefaultConfiguration) {
        byte[] buffer;
        String methodTag = TAG + ":loadConfiguration";
        try {
            buffer = new byte[configStream.available()];
            configStream.read(buffer);
        }
        catch (IOException e) {
            if (isDefaultConfiguration) {
                throw new IllegalStateException("Unable to open default configuration file.", e);
            }
            throw new IllegalArgumentException("Unable to open provided configuration file.", e);
        }
        finally {
            try {
                configStream.close();
            }
            catch (IOException e) {
                if (isDefaultConfiguration) {
                    Logger.warn((String)methodTag, (String)"Unable to close default configuration file. This can cause memory leak.");
                }
                Logger.warn((String)methodTag, (String)"Unable to close provided configuration file. This can cause memory leak.");
            }
        }
        String config = new String(buffer);
        Gson gson = PublicClientApplicationConfigurationFactory.getGsonForLoadingConfiguration();
        try {
            return (PublicClientApplicationConfiguration)gson.fromJson(config, PublicClientApplicationConfiguration.class);
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new IllegalArgumentException("Error while processing configuration", e);
        }
    }

    private static Gson getGsonForLoadingConfiguration() {
        return new GsonBuilder().registerTypeAdapter(Authority.class, (Object)new AuthorityDeserializer()).registerTypeAdapter(AzureActiveDirectoryAudience.class, (Object)new AzureActiveDirectoryAudienceDeserializer()).registerTypeAdapter(Logger.LogLevel.class, (Object)new LogLevelDeserializer()).create();
    }
}

