/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.fragment.app.Fragment;
import com.microsoft.identity.client.Account;
import com.microsoft.identity.client.AccountAdapter;
import com.microsoft.identity.client.AcquireTokenParameters;
import com.microsoft.identity.client.AcquireTokenSilentParameters;
import com.microsoft.identity.client.AuthenticationCallback;
import com.microsoft.identity.client.AuthenticationResultAdapter;
import com.microsoft.identity.client.DeviceCodeFlowParameters;
import com.microsoft.identity.client.IAccount;
import com.microsoft.identity.client.IAuthenticationResult;
import com.microsoft.identity.client.IClaimable;
import com.microsoft.identity.client.IMultipleAccountPublicClientApplication;
import com.microsoft.identity.client.IPublicClientApplication;
import com.microsoft.identity.client.ISingleAccountPublicClientApplication;
import com.microsoft.identity.client.ITenantProfile;
import com.microsoft.identity.client.ITokenShare;
import com.microsoft.identity.client.Logger;
import com.microsoft.identity.client.MultiTenantAccount;
import com.microsoft.identity.client.MultipleAccountPublicClientApplication;
import com.microsoft.identity.client.PoPAuthenticationScheme;
import com.microsoft.identity.client.Prompt;
import com.microsoft.identity.client.PublicClientApplicationConfiguration;
import com.microsoft.identity.client.PublicClientApplicationConfigurationFactory;
import com.microsoft.identity.client.SilentAuthenticationCallback;
import com.microsoft.identity.client.SingleAccountPublicClientApplication;
import com.microsoft.identity.client.TokenParameters;
import com.microsoft.identity.client.TokenShareResult;
import com.microsoft.identity.client.claims.ClaimsRequest;
import com.microsoft.identity.client.configuration.AccountMode;
import com.microsoft.identity.client.configuration.LoggerConfiguration;
import com.microsoft.identity.client.exception.MsalArgumentException;
import com.microsoft.identity.client.exception.MsalClientException;
import com.microsoft.identity.client.exception.MsalDeclinedScopeException;
import com.microsoft.identity.client.exception.MsalException;
import com.microsoft.identity.client.exception.MsalUiRequiredException;
import com.microsoft.identity.client.helper.BrokerHelperActivity;
import com.microsoft.identity.client.internal.AsyncResult;
import com.microsoft.identity.client.internal.CommandParametersAdapter;
import com.microsoft.identity.client.internal.MsalUtils;
import com.microsoft.identity.client.internal.controllers.MSALControllerFactory;
import com.microsoft.identity.client.internal.controllers.MsalExceptionAdapter;
import com.microsoft.identity.common.adal.internal.tokensharing.ITokenShareResultInternal;
import com.microsoft.identity.common.adal.internal.tokensharing.TokenShareUtility;
import com.microsoft.identity.common.components.AndroidPlatformComponentsFactory;
import com.microsoft.identity.common.crypto.AndroidAuthSdkStorageEncryptionManager;
import com.microsoft.identity.common.internal.activebrokerdiscovery.BrokerDiscoveryClientFactory;
import com.microsoft.identity.common.internal.broker.BrokerData;
import com.microsoft.identity.common.internal.broker.BrokerValidator;
import com.microsoft.identity.common.internal.broker.PackageHelper;
import com.microsoft.identity.common.internal.cache.SharedPreferencesFileManager;
import com.microsoft.identity.common.internal.commands.GenerateShrCommand;
import com.microsoft.identity.common.internal.commands.GetDeviceModeCommand;
import com.microsoft.identity.common.internal.controllers.LocalMSALController;
import com.microsoft.identity.common.internal.migration.AdalMigrationAdapter;
import com.microsoft.identity.common.internal.migration.IMigrationAdapter;
import com.microsoft.identity.common.internal.migration.TokenMigrationCallback;
import com.microsoft.identity.common.internal.migration.TokenMigrationUtility;
import com.microsoft.identity.common.internal.net.cache.HttpCache;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.java.authorities.Authority;
import com.microsoft.identity.common.java.authorities.AzureActiveDirectoryAudience;
import com.microsoft.identity.common.java.authorities.AzureActiveDirectoryAuthority;
import com.microsoft.identity.common.java.authorities.AzureActiveDirectoryB2CAuthority;
import com.microsoft.identity.common.java.authorities.CIAMAuthority;
import com.microsoft.identity.common.java.authorities.Environment;
import com.microsoft.identity.common.java.cache.ICacheRecord;
import com.microsoft.identity.common.java.cache.IShareSingleSignOnState;
import com.microsoft.identity.common.java.cache.MsalOAuth2TokenCache;
import com.microsoft.identity.common.java.commands.BaseCommand;
import com.microsoft.identity.common.java.commands.CommandCallback;
import com.microsoft.identity.common.java.commands.DeviceCodeFlowCommand;
import com.microsoft.identity.common.java.commands.DeviceCodeFlowCommandCallback;
import com.microsoft.identity.common.java.commands.InteractiveTokenCommand;
import com.microsoft.identity.common.java.commands.SilentTokenCommand;
import com.microsoft.identity.common.java.commands.parameters.CommandParameters;
import com.microsoft.identity.common.java.commands.parameters.DeviceCodeFlowCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.GenerateShrCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.java.controllers.BaseController;
import com.microsoft.identity.common.java.controllers.CommandDispatcher;
import com.microsoft.identity.common.java.controllers.ExceptionAdapter;
import com.microsoft.identity.common.java.crypto.IKeyAccessor;
import com.microsoft.identity.common.java.dto.AccountRecord;
import com.microsoft.identity.common.java.exception.BaseException;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.exception.ServiceException;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.opentelemetry.AttributeName;
import com.microsoft.identity.common.java.opentelemetry.OTelUtility;
import com.microsoft.identity.common.java.opentelemetry.OtelContextExtension;
import com.microsoft.identity.common.java.opentelemetry.SpanExtension;
import com.microsoft.identity.common.java.opentelemetry.SpanName;
import com.microsoft.identity.common.java.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.java.result.GenerateShrResult;
import com.microsoft.identity.common.java.result.ILocalAuthenticationResult;
import com.microsoft.identity.common.java.result.LocalAuthenticationResult;
import com.microsoft.identity.common.java.util.ResultFuture;
import com.microsoft.identity.common.java.util.SchemaUtil;
import com.microsoft.identity.common.java.util.StringUtil;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PublicClientApplication
implements IPublicClientApplication,
ITokenShare {
    private static final String TAG = PublicClientApplication.class.getSimpleName();
    private static final String INTERNET_PERMISSION = "android.permission.INTERNET";
    private static final String ACCESS_NETWORK_STATE_PERMISSION = "android.permission.ACCESS_NETWORK_STATE";
    private static final String ERR_UNSUPPORTED_OPERATION = "This method is unsupported.";
    private static final ExecutorService sBackgroundExecutor = Executors.newCachedThreadPool();
    private static final String TSL_MSG_FAILED_TO_SAVE = "Failed to save FRT - see getCause() for additional Exception info";
    private static final String TSM_MSG_FAILED_TO_RETRIEVE = "Failed to retrieve FRT - see getCause() for additional Exception info";
    protected PublicClientApplicationConfiguration mPublicClientConfiguration;
    protected TokenShareUtility mTokenShareUtility;
    protected AccountMatcher homeAccountMatcher = new AccountMatcher(){

        @Override
        boolean matches(@NonNull String homeAccountId, @NonNull IAccount account) {
            return homeAccountId.contains(account.getId());
        }
    };
    protected AccountMatcher localAccountMatcher = new AccountMatcher(){

        @Override
        boolean matches(@NonNull String localAccountId, @NonNull IAccount account) {
            MultiTenantAccount multiTenantAccount;
            Map<String, ITenantProfile> tenantProfiles;
            if (localAccountId.contains(account.getId())) {
                return true;
            }
            if (account instanceof MultiTenantAccount && null != (tenantProfiles = (multiTenantAccount = (MultiTenantAccount)account).getTenantProfiles()) && !tenantProfiles.isEmpty()) {
                for (Map.Entry<String, ITenantProfile> profileEntry : tenantProfiles.entrySet()) {
                    if (TextUtils.isEmpty((CharSequence)profileEntry.getValue().getId()) || !localAccountId.contains(profileEntry.getValue().getId())) continue;
                    return true;
                }
            }
            return false;
        }
    };
    protected AccountMatcher usernameMatcher = new AccountMatcher(){

        @Override
        boolean matches(@NonNull String username, @NonNull IAccount account) {
            ArrayList<IClaimable> thingsWithClaims = new ArrayList<IClaimable>();
            if (null != account.getClaims()) {
                thingsWithClaims.add(account);
            }
            if (account instanceof MultiTenantAccount) {
                MultiTenantAccount multiTenantAccount = (MultiTenantAccount)account;
                Map<String, ITenantProfile> profiles = multiTenantAccount.getTenantProfiles();
                for (Map.Entry<String, ITenantProfile> profileEntry : profiles.entrySet()) {
                    if (null == profileEntry.getValue().getClaims()) continue;
                    thingsWithClaims.add(profileEntry.getValue());
                }
            }
            for (IClaimable thingWithClaims : thingsWithClaims) {
                if (null == thingWithClaims.getClaims() || !username.equalsIgnoreCase(SchemaUtil.getDisplayableId(thingWithClaims.getClaims()))) continue;
                return true;
            }
            return false;
        }
    };

    public static void create(final @NonNull Context context, final int configFileResourceId, final @NonNull IPublicClientApplication.ApplicationCreatedListener listener) {
        MsalUtils.validateNonNullArgument(context, "context");
        MsalUtils.validateNonNullArgument(listener, "listener");
        PublicClientApplication.runOnBackground(new Runnable(){

            @Override
            public void run() {
                PublicClientApplication.create(PublicClientApplicationConfigurationFactory.initializeConfiguration(context, configFileResourceId), null, null, null, listener);
            }
        });
    }

    public static void create(final @NonNull Context context, final @NonNull File configFile, final @NonNull IPublicClientApplication.ApplicationCreatedListener listener) {
        MsalUtils.validateNonNullArgument(context, "context");
        MsalUtils.validateNonNullArgument(listener, "listener");
        PublicClientApplication.runOnBackground(new Runnable(){

            @Override
            public void run() {
                PublicClientApplication.create(PublicClientApplicationConfigurationFactory.initializeConfiguration(context, configFile), null, null, null, listener);
            }
        });
    }

    public static void create(final @NonNull Context context, final @NonNull String clientId, final @Nullable String authority, final @NonNull String redirectUri, final @NonNull IPublicClientApplication.ApplicationCreatedListener listener) {
        MsalUtils.validateNonNullArgument(context, "context");
        MsalUtils.validateNonNullArgument(clientId, "client_id");
        MsalUtils.validateNonNullArgument(redirectUri, "redirect_uri");
        MsalUtils.validateNonNullArgument(listener, "listener");
        PublicClientApplication.runOnBackground(new Runnable(){

            @Override
            public void run() {
                PublicClientApplication.create(PublicClientApplicationConfigurationFactory.initializeConfiguration(context), clientId, authority, redirectUri, listener);
            }
        });
    }

    @WorkerThread
    @NonNull
    public static IPublicClientApplication create(@NonNull Context context, int configFileResourceId) throws InterruptedException, MsalException {
        MsalUtils.validateNonNullArgument(context, "context");
        return PublicClientApplication.create(PublicClientApplicationConfigurationFactory.initializeConfiguration(context, configFileResourceId));
    }

    public static void createMultipleAccountPublicClientApplication(final @NonNull Context context, final int configFileResourceId, final @NonNull IPublicClientApplication.IMultipleAccountApplicationCreatedListener listener) {
        MsalUtils.validateNonNullArgument(context, "context");
        MsalUtils.validateNonNullArgument(listener, "listener");
        PublicClientApplication.runOnBackground(new Runnable(){

            @Override
            public void run() {
                PublicClientApplication.createMultipleAccountPublicClientApplication(PublicClientApplicationConfigurationFactory.initializeConfiguration(context, configFileResourceId), listener);
            }
        });
    }

    public static void createMultipleAccountPublicClientApplication(final @NonNull Context context, final @NonNull File configFile, final @NonNull IPublicClientApplication.IMultipleAccountApplicationCreatedListener listener) {
        MsalUtils.validateNonNullArgument(context, "context");
        MsalUtils.validateNonNullArgument(listener, "listener");
        PublicClientApplication.runOnBackground(new Runnable(){

            @Override
            public void run() {
                PublicClientApplication.createMultipleAccountPublicClientApplication(PublicClientApplicationConfigurationFactory.initializeConfiguration(context, configFile), listener);
            }
        });
    }

    @WorkerThread
    @NonNull
    public static IMultipleAccountPublicClientApplication createMultipleAccountPublicClientApplication(@NonNull Context context, @NonNull int configFileResourceId) throws MsalException, InterruptedException {
        MsalUtils.validateNonNullArgument(context, "context");
        return PublicClientApplication.createMultipleAccountPublicClientApplication(PublicClientApplicationConfigurationFactory.initializeConfiguration(context, configFileResourceId));
    }

    @WorkerThread
    @NonNull
    public static IMultipleAccountPublicClientApplication createMultipleAccountPublicClientApplication(@NonNull Context context, @NonNull File configFile) throws InterruptedException, MsalException {
        MsalUtils.validateNonNullArgument(context, "context");
        MsalUtils.validateNonNullArgument(configFile, "configFile");
        return PublicClientApplication.createMultipleAccountPublicClientApplication(PublicClientApplicationConfigurationFactory.initializeConfiguration(context, configFile));
    }

    public static void createSingleAccountPublicClientApplication(final @NonNull Context context, final int configFileResourceId, final @NonNull IPublicClientApplication.ISingleAccountApplicationCreatedListener listener) {
        MsalUtils.validateNonNullArgument(context, "context");
        MsalUtils.validateNonNullArgument(listener, "listener");
        PublicClientApplication.runOnBackground(new Runnable(){

            @Override
            public void run() {
                PublicClientApplication.createSingleAccountPublicClientApplication(PublicClientApplicationConfigurationFactory.initializeConfiguration(context, configFileResourceId), listener);
            }
        });
    }

    public static void createSingleAccountPublicClientApplication(final @NonNull Context context, final @NonNull File configFile, final @NonNull IPublicClientApplication.ISingleAccountApplicationCreatedListener listener) {
        MsalUtils.validateNonNullArgument(context, "context");
        MsalUtils.validateNonNullArgument(configFile, "config_file");
        MsalUtils.validateNonNullArgument(listener, "listener");
        PublicClientApplication.runOnBackground(new Runnable(){

            @Override
            public void run() {
                PublicClientApplication.createSingleAccountPublicClientApplication(PublicClientApplicationConfigurationFactory.initializeConfiguration(context, configFile), listener);
            }
        });
    }

    @WorkerThread
    @NonNull
    public static ISingleAccountPublicClientApplication createSingleAccountPublicClientApplication(@NonNull Context context, int configFileResourceId) throws InterruptedException, MsalException {
        MsalUtils.validateNonNullArgument(context, "context");
        return PublicClientApplication.createSingleAccountPublicClientApplication(PublicClientApplicationConfigurationFactory.initializeConfiguration(context, configFileResourceId));
    }

    @WorkerThread
    @NonNull
    public static ISingleAccountPublicClientApplication createSingleAccountPublicClientApplication(@NonNull Context context, @Nullable File configFile) throws InterruptedException, MsalException {
        MsalUtils.validateNonNullArgument(context, "context");
        return PublicClientApplication.createSingleAccountPublicClientApplication(PublicClientApplicationConfigurationFactory.initializeConfiguration(context, configFile));
    }

    @WorkerThread
    private static IPublicClientApplication create(@NonNull PublicClientApplicationConfiguration configuration) throws MsalException, InterruptedException {
        MsalUtils.validateNonNullArgument(configuration, "configuration");
        MsalUtils.throwOnMainThread("createPublicClientApplication");
        final ResultFuture future = new ResultFuture();
        PublicClientApplication.create(configuration, null, null, null, new IPublicClientApplication.ApplicationCreatedListener(){

            @Override
            public void onCreated(IPublicClientApplication application) {
                future.setResult(new AsyncResult<IPublicClientApplication>(application, null));
            }

            @Override
            public void onError(MsalException exception) {
                future.setResult(new AsyncResult<Object>(null, exception));
            }
        });
        try {
            AsyncResult result = (AsyncResult)future.get();
            if (!result.getSuccess()) {
                MsalException ex = result.getException();
                throw ex;
            }
            return (IPublicClientApplication)result.getResult();
        }
        catch (ExecutionException e) {
            throw new MsalClientException("unknown_error", "Unexpected error while initializing PCA.", e);
        }
    }

    @WorkerThread
    private static IMultipleAccountPublicClientApplication createMultipleAccountPublicClientApplication(@NonNull PublicClientApplicationConfiguration configuration) throws InterruptedException, MsalException {
        if (configuration.getAccountMode() != AccountMode.MULTIPLE) {
            throw new MsalClientException("multiple_account_pca_init_fail_account_mode", "AccountMode in configuration is not set to multiple. Cannot initialize multiple account PublicClientApplication.");
        }
        IPublicClientApplication application = PublicClientApplication.create(configuration);
        if (application instanceof IMultipleAccountPublicClientApplication) {
            return (IMultipleAccountPublicClientApplication)application;
        }
        if (configuration.getAccountMode() == AccountMode.MULTIPLE && application.isSharedDevice()) {
            throw new MsalClientException("multiple_account_pca_init_fail_on_shared_device", "This application is not supported in the shared device mode. Please contact application developer to update the app.");
        }
        throw new MsalClientException("multiple_account_pca_init_fail_unknown_reason", "Multiple account PublicClientApplication could not be created for unknown reasons");
    }

    @WorkerThread
    private static ISingleAccountPublicClientApplication createSingleAccountPublicClientApplication(@Nullable PublicClientApplicationConfiguration configuration) throws InterruptedException, MsalException {
        IPublicClientApplication application = PublicClientApplication.create(configuration);
        if (application instanceof ISingleAccountPublicClientApplication) {
            return (ISingleAccountPublicClientApplication)application;
        }
        if (configuration.getAccountMode() != AccountMode.SINGLE) {
            throw new MsalClientException("single_account_pca_init_fail_account_mode", "AccountMode in configuration is not set to single. Cannot initialize single account PublicClientApplication.");
        }
        throw new MsalClientException("single_account_pca_init_fail_unknown_reason", "A single account public client application could not be created for unknown reasons.");
    }

    private static void create(final @NonNull PublicClientApplicationConfiguration config, @Nullable String clientId, @Nullable String authority, @Nullable String redirectUri, final @NonNull IPublicClientApplication.ApplicationCreatedListener listener) {
        if (clientId != null) {
            config.setClientId(clientId);
        }
        if (authority != null) {
            config.getAuthorities().clear();
            Authority authorityObject = Authority.getAuthorityFromAuthorityUrl((String)authority);
            authorityObject.setDefault(Boolean.valueOf(true));
            config.getAuthorities().add(authorityObject);
        }
        if (redirectUri != null) {
            config.setRedirectUri(redirectUri);
        }
        try {
            PublicClientApplication.validateAccountModeConfiguration(config);
        }
        catch (MsalClientException e) {
            listener.onError(e);
            return;
        }
        CommandParameters params = CommandParametersAdapter.createCommandParameters(config, config.getOAuth2TokenCache());
        GetDeviceModeCommand command = new GetDeviceModeCommand(params, new MSALControllerFactory(config).getDefaultController(config.getDefaultAuthority()), (CommandCallback)new CommandCallback<Boolean, BaseException>(){

            public void onError(BaseException error) {
                listener.onError(MsalExceptionAdapter.msalExceptionFromBaseException(error));
            }

            public void onTaskCompleted(Boolean isSharedDevice) {
                config.setIsSharedDevice(isSharedDevice);
                try {
                    if (config.getAccountMode() == AccountMode.SINGLE || isSharedDevice.booleanValue()) {
                        listener.onCreated(new SingleAccountPublicClientApplication(config));
                    } else {
                        listener.onCreated(new MultipleAccountPublicClientApplication(config));
                    }
                }
                catch (MsalClientException e) {
                    listener.onError(e);
                }
            }

            public void onCancel() {
            }
        }, "1200");
        CommandDispatcher.submitSilent((BaseCommand)command);
    }

    private static void validateAccountModeConfiguration(@NonNull PublicClientApplicationConfiguration config) throws MsalClientException {
        String methodTag = TAG + ":validateAccountModeConfiguration";
        if (config.getAccountMode() == AccountMode.SINGLE && null != config.getDefaultAuthority() && config.getDefaultAuthority() instanceof AzureActiveDirectoryB2CAuthority) {
            com.microsoft.identity.common.logging.Logger.warn((String)methodTag, (String)"Warning! B2C applications should use MultipleAccountPublicClientApplication. Use of SingleAccount mode with multiple IEF policies is unsupported.");
            if (config.getAuthorities().size() > 1) {
                throw new MsalClientException("SingleAccountPublicClientApplication cannot be used with multiple B2C policies.");
            }
        }
    }

    private static void createMultipleAccountPublicClientApplication(@NonNull PublicClientApplicationConfiguration configuration, final @NonNull IPublicClientApplication.IMultipleAccountApplicationCreatedListener listener) {
        PublicClientApplication.create(configuration, null, null, null, new IPublicClientApplication.ApplicationCreatedListener(){

            @Override
            public void onCreated(@NonNull IPublicClientApplication application) {
                if (application instanceof IMultipleAccountPublicClientApplication) {
                    listener.onCreated((IMultipleAccountPublicClientApplication)application);
                } else {
                    if (application.getConfiguration().getAccountMode() == AccountMode.MULTIPLE && application.isSharedDevice()) {
                        listener.onError(new MsalClientException("multiple_account_pca_init_fail_on_shared_device", "This application is not supported in the shared device mode. Please contact application developer to update the app."));
                        return;
                    }
                    listener.onError(new MsalClientException("multiple_account_pca_init_fail_unknown_reason", "Multiple account PublicClientApplication could not be created for unknown reasons"));
                }
            }

            @Override
            public void onError(MsalException exception) {
                listener.onError(exception);
            }
        });
    }

    private static void createSingleAccountPublicClientApplication(@NonNull PublicClientApplicationConfiguration configuration, final @NonNull IPublicClientApplication.ISingleAccountApplicationCreatedListener listener) {
        PublicClientApplication.create(configuration, null, null, null, new IPublicClientApplication.ApplicationCreatedListener(){

            @Override
            public void onCreated(IPublicClientApplication application) {
                if (application instanceof ISingleAccountPublicClientApplication) {
                    listener.onCreated((ISingleAccountPublicClientApplication)application);
                } else {
                    if (application.getConfiguration().getAccountMode() != AccountMode.SINGLE) {
                        listener.onError(new MsalClientException("single_account_pca_init_fail_account_mode", "AccountMode in configuration is not set to single. Cannot initialize single account PublicClientApplication."));
                        return;
                    }
                    listener.onError(new MsalClientException("single_account_pca_init_fail_unknown_reason", "A single account public client application could not be created for unknown reasons."));
                }
            }

            @Override
            public void onError(MsalException exception) {
                listener.onError(exception);
            }
        });
    }

    protected PublicClientApplication(@NonNull PublicClientApplicationConfiguration configFile) throws MsalClientException {
        this.mPublicClientConfiguration = configFile;
        this.initializeApplication();
    }

    private void initializeApplication() throws MsalClientException {
        String methodTag = TAG + ":initializeApplication";
        Context context = this.mPublicClientConfiguration.getAppContext();
        this.setupTelemetry(context, this.mPublicClientConfiguration);
        AzureActiveDirectory.setEnvironment((Environment)this.mPublicClientConfiguration.getEnvironment());
        Authority.addKnownAuthorities(this.mPublicClientConfiguration.getAuthorities());
        this.initializeLoggerSettings(this.mPublicClientConfiguration.getLoggerConfiguration());
        this.initializeTokenSharingLibrary();
        this.mPublicClientConfiguration.checkIntentFilterAddedToAppManifestForBrokerFlow();
        this.checkInternetPermission();
        HttpCache.initialize((File)context.getCacheDir());
        com.microsoft.identity.common.logging.Logger.info((String)methodTag, (String)"Create new public client application.");
    }

    private void initializeLoggerSettings(@Nullable LoggerConfiguration loggerConfig) {
        if (null != loggerConfig) {
            Logger.LogLevel configLogLevel = loggerConfig.getLogLevel();
            boolean configPiiState = loggerConfig.isPiiEnabled();
            boolean configLogcatState = loggerConfig.isLogcatEnabled();
            Logger logger = Logger.getInstance();
            if (null != configLogLevel) {
                logger.setLogLevel(configLogLevel);
            }
            logger.setEnablePII(configPiiState);
            logger.setEnableLogcatLog(configLogcatState);
        }
    }

    private void initializeTokenSharingLibrary() {
        if (!(this.mPublicClientConfiguration.getOAuth2TokenCache() instanceof MsalOAuth2TokenCache)) {
            throw new IllegalStateException("TSL support mandates use of the MsalOAuth2TokenCache");
        }
        this.mTokenShareUtility = new TokenShareUtility(this.mPublicClientConfiguration.getClientId(), this.mPublicClientConfiguration.getRedirectUri(), (MsalOAuth2TokenCache)this.mPublicClientConfiguration.getOAuth2TokenCache());
    }

    private void setupTelemetry(@NonNull Context context, @NonNull PublicClientApplicationConfiguration developerConfig) {
        String methodTag = TAG + ":setupTelemetry";
        if (null != developerConfig.getTelemetryConfiguration()) {
            com.microsoft.identity.common.logging.Logger.verbose((String)methodTag, (String)"Telemetry configuration is set. Telemetry is enabled.");
        } else {
            com.microsoft.identity.common.logging.Logger.verbose((String)methodTag, (String)"Telemetry configuration is null. Telemetry is disabled.");
        }
        new Telemetry.Builder().withContext(context).defaultConfiguration(developerConfig.getTelemetryConfiguration()).build();
    }

    @Override
    public TokenShareResult getOrgIdFamilyRefreshTokenWithMetadata(@NonNull String identifier) throws MsalClientException {
        MsalUtils.validateNonNullArgument(identifier, "identifier");
        this.validateBrokerNotInUse();
        try {
            ITokenShareResultInternal resultInternal = this.mTokenShareUtility.getOrgIdFamilyRefreshTokenWithMetadata(identifier);
            return new TokenShareResult(resultInternal);
        }
        catch (Exception e) {
            throw new MsalClientException("token_cache_item_not_found", TSM_MSG_FAILED_TO_RETRIEVE, e);
        }
    }

    @Override
    public String getOrgIdFamilyRefreshToken(@NonNull String identifier) throws MsalClientException {
        return this.getOrgIdFamilyRefreshTokenWithMetadata(identifier).getRefreshToken();
    }

    @Override
    public void saveOrgIdFamilyRefreshToken(@NonNull String ssoStateSerializerBlob) throws MsalClientException {
        MsalUtils.validateNonNullArgument(ssoStateSerializerBlob, "SsoStateSerializerBlob");
        this.validateBrokerNotInUse();
        try {
            this.mTokenShareUtility.saveOrgIdFamilyRefreshToken(ssoStateSerializerBlob);
        }
        catch (Exception e) {
            throw new MsalClientException("token_sharing_deserialization_error", TSL_MSG_FAILED_TO_SAVE, e);
        }
    }

    @Override
    public TokenShareResult getMsaFamilyRefreshTokenWithMetadata(@NonNull String identifier) throws MsalClientException {
        MsalUtils.validateNonNullArgument(identifier, "identifier");
        this.validateBrokerNotInUse();
        try {
            ITokenShareResultInternal resultInternal = this.mTokenShareUtility.getMsaFamilyRefreshTokenWithMetadata(identifier);
            return new TokenShareResult(resultInternal);
        }
        catch (Exception e) {
            throw new MsalClientException("token_cache_item_not_found", TSM_MSG_FAILED_TO_RETRIEVE, e);
        }
    }

    @Override
    public String getMsaFamilyRefreshToken(@NonNull String identifier) throws MsalClientException {
        return this.getMsaFamilyRefreshTokenWithMetadata(identifier).getRefreshToken();
    }

    @Override
    public void saveMsaFamilyRefreshToken(@NonNull String refreshToken) throws MsalClientException {
        MsalUtils.validateNonNullArgument(refreshToken, "refreshToken");
        try {
            this.mTokenShareUtility.saveMsaFamilyRefreshToken(refreshToken);
        }
        catch (Exception e) {
            throw new MsalClientException("failed_to_persist_msa_credential", TSL_MSG_FAILED_TO_SAVE, e);
        }
    }

    private void validateBrokerNotInUse() throws MsalClientException {
        if (new MSALControllerFactory(this.mPublicClientConfiguration).brokerEligibleAndInstalled(this.mPublicClientConfiguration.getDefaultAuthority())) {
            throw new MsalClientException("Cannot perform this action - broker is enabled.");
        }
    }

    public static String getSdkVersion() {
        return "4.6.2";
    }

    public static void showExpectedMsalRedirectUriInfo(Activity activity) {
        activity.startActivity(BrokerHelperActivity.createStartIntent(activity.getApplicationContext()));
    }

    @Override
    public PublicClientApplicationConfiguration getConfiguration() {
        return this.mPublicClientConfiguration;
    }

    @Override
    public boolean isSharedDevice() {
        return this.mPublicClientConfiguration.getIsSharedDevice();
    }

    @Override
    public String generateSignedHttpRequest(@NonNull IAccount account, @NonNull PoPAuthenticationScheme popParameters) throws MsalException {
        final ResultFuture future = new ResultFuture();
        GenerateShrCommand generateShrCommand = this.createGenerateShrCommand(account, popParameters, new CommandCallback<GenerateShrResult, BaseException>(){

            public void onCancel() {
            }

            public void onError(@NonNull BaseException error) {
                future.setResult(new AsyncResult<Object>(null, PublicClientApplication.this.baseExceptionToMsalException(error)));
            }

            public void onTaskCompleted(@NonNull GenerateShrResult generateShrResult) {
                future.setResult(new AsyncResult<GenerateShrResult>(generateShrResult, null));
            }
        }, "1100");
        CommandDispatcher.submitSilent((BaseCommand)generateShrCommand);
        try {
            AsyncResult asyncResult = (AsyncResult)future.get();
            if (asyncResult.getSuccess()) {
                return ((GenerateShrResult)asyncResult.getResult()).getShr();
            }
            throw asyncResult.getException();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new MsalClientException("unknown_error", "Unexpected error while generating SHR.", e);
        }
    }

    @Override
    public void generateSignedHttpRequest(@NonNull IAccount account, @NonNull PoPAuthenticationScheme popParameters, final @NonNull IPublicClientApplication.SignedHttpRequestRequestCallback callback) {
        try {
            GenerateShrCommand generateShrCommand = this.createGenerateShrCommand(account, popParameters, new CommandCallback<GenerateShrResult, BaseException>(){

                public void onCancel() {
                }

                public void onError(@NonNull BaseException error) {
                    callback.onError(PublicClientApplication.this.baseExceptionToMsalException(error));
                }

                public void onTaskCompleted(@NonNull GenerateShrResult generateShrResult) {
                    callback.onTaskCompleted(generateShrResult.getShr());
                }
            }, "1101");
            CommandDispatcher.submitSilent((BaseCommand)generateShrCommand);
        }
        catch (MsalClientException e) {
            MsalClientException clientException = new MsalClientException("unknown_error", "Unexpected error while generating SHR.", (Throwable)((Object)e));
            callback.onError(clientException);
        }
    }

    private GenerateShrCommand createGenerateShrCommand(@NonNull IAccount account, @NonNull PoPAuthenticationScheme popParams, @NonNull CommandCallback<GenerateShrResult, BaseException> cmdCallback, @NonNull String publicApiId) throws MsalClientException {
        GenerateShrCommandParameters cmdParams = CommandParametersAdapter.createGenerateShrCommandParameters(this.mPublicClientConfiguration, this.mPublicClientConfiguration.getOAuth2TokenCache(), ((Account)account).getHomeAccountId(), popParams);
        return new GenerateShrCommand(cmdParams, new MSALControllerFactory(this.mPublicClientConfiguration).getAllControllers(this.mPublicClientConfiguration.getDefaultAuthority()), cmdCallback, publicApiId);
    }

    private MsalException baseExceptionToMsalException(@NonNull BaseException exception) {
        if ("no_account_found".equalsIgnoreCase(exception.getErrorCode())) {
            return new MsalUiRequiredException("no_account_found", "The supplied account could not be located.");
        }
        return new MsalClientException(exception.getErrorCode(), exception.getMessage());
    }

    @Override
    @Deprecated
    public void acquireToken(@NonNull Activity activity, @NonNull String[] scopes, @NonNull AuthenticationCallback callback) {
        AcquireTokenParameters acquireTokenParameters = this.buildAcquireTokenParameters(activity, null, Arrays.asList(scopes), null, null, null, null, null, callback, null, null);
        this.acquireTokenInternal(acquireTokenParameters, "122");
    }

    AcquireTokenParameters buildAcquireTokenParameters(@NonNull Activity activity, @Nullable Fragment fragment, @NonNull List<String> scopes, @Nullable IAccount account, @Nullable Prompt uiBehavior, @Nullable List<Map.Entry<String, String>> extraQueryParameters, @Nullable String[] extraScopesToConsent, @Nullable String authority, @NonNull AuthenticationCallback callback, @Nullable String loginHint, @Nullable ClaimsRequest claimsRequest) {
        MsalUtils.validateNonNullArgument(activity, "activity");
        MsalUtils.validateNonNullArgument(scopes, "scopes");
        MsalUtils.validateNonNullArgument(callback, "callback");
        AcquireTokenParameters.Builder builder = new AcquireTokenParameters.Builder();
        AcquireTokenParameters acquireTokenParameters = ((AcquireTokenParameters.Builder)((AcquireTokenParameters.Builder)((AcquireTokenParameters.Builder)((AcquireTokenParameters.Builder)builder.startAuthorizationFromActivity(activity).withFragment(fragment).forAccount(account)).withScopes(scopes)).withPrompt(uiBehavior).withAuthorizationQueryStringParameters(extraQueryParameters).withOtherScopesToAuthorize(Arrays.asList(null == extraScopesToConsent ? new String[]{} : extraScopesToConsent)).fromAuthority(authority)).withCallback(callback).withLoginHint(loginHint).withClaims(claimsRequest)).build();
        return acquireTokenParameters;
    }

    @Deprecated
    AcquireTokenParameters buildAcquireTokenParameters(@NonNull Activity activity, @Nullable Fragment fragment, @NonNull String[] scopes, @Nullable IAccount account, @Nullable Prompt uiBehavior, @Nullable List<Map.Entry<String, String>> extraQueryParameters, @Nullable String[] extraScopesToConsent, @Nullable String authority, @NonNull AuthenticationCallback callback, @Nullable String loginHint, @Nullable ClaimsRequest claimsRequest) {
        MsalUtils.validateNonNullArgument(activity, "activity");
        MsalUtils.validateNonNullArgument(scopes, "scopes");
        MsalUtils.validateNonNullArgument(callback, "callback");
        AcquireTokenParameters.Builder builder = new AcquireTokenParameters.Builder();
        AcquireTokenParameters acquireTokenParameters = ((AcquireTokenParameters.Builder)((AcquireTokenParameters.Builder)((AcquireTokenParameters.Builder)((AcquireTokenParameters.Builder)builder.startAuthorizationFromActivity(activity).withFragment(fragment).forAccount(account)).withScopes(Arrays.asList(scopes))).withPrompt(uiBehavior).withAuthorizationQueryStringParameters(extraQueryParameters).withOtherScopesToAuthorize(Arrays.asList(null == extraScopesToConsent ? new String[]{} : extraScopesToConsent)).fromAuthority(authority)).withCallback(callback).withLoginHint(loginHint).withClaims(claimsRequest)).build();
        return acquireTokenParameters;
    }

    protected void validateAcquireTokenParameters(AcquireTokenParameters parameters) throws MsalArgumentException {
        Activity activity = parameters.getActivity();
        List<String> scopes = parameters.getScopes();
        AuthenticationCallback callback = parameters.getCallback();
        MsalUtils.validateNonNullArg(activity, "activity");
        MsalUtils.validateNonNullArg(scopes, "scopes");
        MsalUtils.validateNonNullArg(callback, "callback");
    }

    protected void validateAcquireTokenSilentParameters(AcquireTokenSilentParameters parameters) throws MsalArgumentException {
        String authority = parameters.getAuthority();
        IAccount account = parameters.getAccount();
        List<String> scopes = parameters.getScopes();
        SilentAuthenticationCallback callback = parameters.getCallback();
        MsalUtils.validateNonNullArg(authority, "authority");
        MsalUtils.validateNonNullArg(account, "account");
        MsalUtils.validateNonNullArg(callback, "callback");
        MsalUtils.validateNonNullArg(scopes, "scopes");
    }

    @Override
    public void acquireToken(@NonNull AcquireTokenParameters acquireTokenParameters) {
        this.acquireTokenInternal(acquireTokenParameters, "121");
    }

    void acquireTokenInternal(final @NonNull AcquireTokenParameters acquireTokenParameters, final @NonNull String publicApiId) {
        sBackgroundExecutor.submit(OtelContextExtension.wrap((Runnable)new Runnable(){

            @Override
            public void run() {
                final CommandCallback localAuthenticationCallback = PublicClientApplication.this.getCommandCallback(acquireTokenParameters.getCallback(), acquireTokenParameters);
                try {
                    PublicClientApplication.this.validateAcquireTokenParameters(acquireTokenParameters);
                    acquireTokenParameters.setAccountRecord(PublicClientApplication.this.selectAccountRecordForTokenRequest(PublicClientApplication.this.mPublicClientConfiguration, acquireTokenParameters));
                    InteractiveTokenCommandParameters params = CommandParametersAdapter.createInteractiveTokenCommandParameters(PublicClientApplication.this.mPublicClientConfiguration, PublicClientApplication.this.mPublicClientConfiguration.getOAuth2TokenCache(), acquireTokenParameters);
                    InteractiveTokenCommand command = new InteractiveTokenCommand(params, new MSALControllerFactory(PublicClientApplication.this.mPublicClientConfiguration).getDefaultController(params.getAuthority()), localAuthenticationCallback, publicApiId);
                    CommandDispatcher.beginInteractive((InteractiveTokenCommand)command);
                }
                catch (Exception exception) {
                    final BaseException baseException = ExceptionAdapter.baseExceptionFromException((Throwable)exception);
                    Handler handler = new Handler(Looper.getMainLooper());
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            localAuthenticationCallback.onError((Object)baseException);
                        }
                    });
                }
            }
        }));
    }

    protected AcquireTokenSilentParameters buildAcquireTokenSilentParameters(@NonNull String[] scopes, @NonNull IAccount account, @NonNull String authority, boolean forceRefresh, @Nullable ClaimsRequest claimsRequest, @NonNull SilentAuthenticationCallback callback) {
        MsalUtils.validateNonNullArgument(account, "account");
        MsalUtils.validateNonNullArgument(callback, "callback");
        AcquireTokenSilentParameters.Builder builder = new AcquireTokenSilentParameters.Builder();
        AcquireTokenSilentParameters acquireTokenSilentParameters = ((AcquireTokenSilentParameters.Builder)((AcquireTokenSilentParameters.Builder)((AcquireTokenSilentParameters.Builder)((AcquireTokenSilentParameters.Builder)builder.withScopes(Arrays.asList(scopes))).forAccount(account)).fromAuthority(authority)).forceRefresh(forceRefresh).withClaims(claimsRequest)).withCallback(callback).build();
        return acquireTokenSilentParameters;
    }

    @Override
    public void acquireTokenSilentAsync(@NonNull AcquireTokenSilentParameters acquireTokenSilentParameters) {
        this.acquireTokenSilentAsyncInternal(acquireTokenSilentParameters, "22");
    }

    void acquireTokenSilentAsyncInternal(final @NonNull AcquireTokenSilentParameters acquireTokenSilentParameters, final @NonNull String publicApiId) {
        sBackgroundExecutor.submit(OtelContextExtension.wrap((Runnable)new Runnable(){

            @Override
            public void run() {
                final CommandCallback callback = PublicClientApplication.this.getCommandCallback(acquireTokenSilentParameters.getCallback(), acquireTokenSilentParameters);
                try {
                    PublicClientApplication.this.validateAcquireTokenSilentParameters(acquireTokenSilentParameters);
                    acquireTokenSilentParameters.setAccountRecord(PublicClientApplication.this.selectAccountRecordForTokenRequest(PublicClientApplication.this.mPublicClientConfiguration, acquireTokenSilentParameters));
                    SilentTokenCommandParameters params = CommandParametersAdapter.createSilentTokenCommandParameters(PublicClientApplication.this.mPublicClientConfiguration, PublicClientApplication.this.mPublicClientConfiguration.getOAuth2TokenCache(), acquireTokenSilentParameters);
                    SilentTokenCommand silentTokenCommand = new SilentTokenCommand(params, new MSALControllerFactory(PublicClientApplication.this.mPublicClientConfiguration).getAllControllers(params.getAuthority()), callback, publicApiId);
                    CommandDispatcher.submitSilent((BaseCommand)silentTokenCommand);
                }
                catch (Exception exception) {
                    final BaseException baseException = ExceptionAdapter.baseExceptionFromException((Throwable)exception);
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onError((Object)baseException);
                        }
                    });
                }
            }
        }));
    }

    private AccountRecord selectAccountRecordForTokenRequest(@NonNull PublicClientApplicationConfiguration pcaConfig, @NonNull TokenParameters tokenParameters) throws ServiceException, ClientException {
        String methodTag = TAG + ":selectAccountRecordForTokenRequest";
        if (TextUtils.isEmpty((CharSequence)tokenParameters.getAuthority())) {
            tokenParameters.setAuthority(pcaConfig.getDefaultAuthority().getAuthorityURL().toString());
        }
        if (null == tokenParameters.getAccount()) {
            return null;
        }
        IAccount rootAccount = tokenParameters.getAccount();
        MultiTenantAccount multiTenantAccount = (MultiTenantAccount)rootAccount;
        String requestAuthority = tokenParameters.getAuthority();
        Authority authority = Authority.getAuthorityFromAuthorityUrl((String)requestAuthority);
        if (authority instanceof AzureActiveDirectoryB2CAuthority || authority instanceof CIAMAuthority) {
            return AccountAdapter.getAccountInternal(this.mPublicClientConfiguration.getClientId(), this.mPublicClientConfiguration.getOAuth2TokenCache(), multiTenantAccount.getHomeAccountId(), multiTenantAccount.getTenantId());
        }
        if (authority instanceof AzureActiveDirectoryAuthority) {
            boolean isSilent;
            AzureActiveDirectoryAuthority aadAuthority = (AzureActiveDirectoryAuthority)authority;
            String tenantId = aadAuthority.getAudience().getTenantId();
            AccountRecord accountRecord = new AccountRecord();
            accountRecord.setEnvironment(multiTenantAccount.getEnvironment());
            accountRecord.setHomeAccountId(multiTenantAccount.getHomeAccountId());
            boolean isUuid = StringUtil.isUuid((String)tenantId);
            if (!isUuid && !AzureActiveDirectoryAudience.isHomeTenantAlias((String)tenantId)) {
                tenantId = ((AzureActiveDirectoryAuthority)authority).getAudience().getTenantUuidForAlias(authority.getAuthorityURL().toString());
            }
            accountRecord.setRealm(tenantId);
            IAccount accountForRequest = AzureActiveDirectoryAudience.isHomeTenantAlias((String)tenantId) || PublicClientApplication.isAccountHomeTenant(multiTenantAccount.getClaims(), tenantId) ? (multiTenantAccount.getClaims() != null ? multiTenantAccount : null) : (IAccount)multiTenantAccount.getTenantProfiles().get(tenantId);
            if (null == accountForRequest && (isSilent = tokenParameters instanceof AcquireTokenSilentParameters)) {
                if (rootAccount.getClaims() != null) {
                    accountForRequest = rootAccount;
                } else {
                    for (ITenantProfile tenantProfile : multiTenantAccount.getTenantProfiles().values()) {
                        if (tenantProfile.getClaims() == null) continue;
                        accountForRequest = tenantProfile;
                        break;
                    }
                }
            }
            if (accountForRequest == null) {
                com.microsoft.identity.common.logging.Logger.warnPII((String)methodTag, (String)("No account record found for IAccount with request tenantId: " + tenantId));
                throw new ClientException("no_account_found", "No account record found for IAccount");
            }
            accountRecord.setLocalAccountId(accountForRequest.getId());
            accountRecord.setUsername(accountForRequest.getUsername());
            return accountRecord;
        }
        throw new UnsupportedOperationException("Unsupported Authority type: " + authority.getClass().getSimpleName());
    }

    @Override
    public IAuthenticationResult acquireTokenSilent(@NonNull AcquireTokenSilentParameters acquireTokenSilentParameters) throws InterruptedException, MsalException {
        return this.acquireTokenSilentInternal(acquireTokenSilentParameters, "21");
    }

    IAuthenticationResult acquireTokenSilentInternal(@NonNull AcquireTokenSilentParameters acquireTokenSilentParameters, @NonNull String publicApiId) throws InterruptedException, MsalException {
        if (acquireTokenSilentParameters.getCallback() != null) {
            throw new IllegalArgumentException("Do not provide callback for synchronous methods");
        }
        final ResultFuture future = new ResultFuture();
        acquireTokenSilentParameters.setCallback(new SilentAuthenticationCallback(){

            @Override
            public void onSuccess(IAuthenticationResult authenticationResult) {
                future.setResult(new AsyncResult<IAuthenticationResult>(authenticationResult, null));
            }

            @Override
            public void onError(MsalException exception) {
                future.setResult(new AsyncResult<Object>(null, exception));
            }
        });
        this.acquireTokenSilentAsyncInternal(acquireTokenSilentParameters, publicApiId);
        try {
            AsyncResult result = (AsyncResult)future.get();
            if (result.getSuccess()) {
                return (IAuthenticationResult)result.getResult();
            }
            throw result.getException();
        }
        catch (ExecutionException e) {
            throw new MsalClientException("unknown_error", "Unexpected error while acquiring token.", e);
        }
    }

    @Override
    public void acquireTokenWithDeviceCode(@NonNull List<String> scopes, @NonNull IPublicClientApplication.DeviceCodeFlowCallback callback, @Nullable ClaimsRequest claimsRequest, @Nullable UUID correlationId) {
        Context context = this.mPublicClientConfiguration.getAppContext();
        PackageHelper packageHelper = new PackageHelper(context);
        Span span = OTelUtility.createSpan((String)SpanName.AcquireTokenDcf.name());
        try (Scope scope = SpanExtension.makeCurrentSpan((Span)span);){
            span.setAttribute(AttributeName.application_name.name(), this.mPublicClientConfiguration.getAppContext().getPackageName());
            if (!packageHelper.verifyIfValidTeamsPackage(context.getPackageName())) {
                span.setAttribute(AttributeName.error_message.name(), "acquireTokenWithDeviceCode with claims is not supported for current package.");
                throw new UnsupportedOperationException(ERR_UNSUPPORTED_OPERATION);
            }
            DeviceCodeFlowParameters.Builder builder = new DeviceCodeFlowParameters.Builder();
            if (null != correlationId) {
                builder.withCorrelationId(correlationId);
                span.setAttribute(AttributeName.correlation_id.name(), correlationId.toString());
            }
            DeviceCodeFlowParameters deviceCodeFlowParameters = ((DeviceCodeFlowParameters.Builder)((DeviceCodeFlowParameters.Builder)builder.withScopes(scopes)).withClaims(claimsRequest)).build();
            DeviceCodeFlowCommandParameters commandParameters = CommandParametersAdapter.createDeviceCodeFlowWithClaimsCommandParameters(this.mPublicClientConfiguration, this.mPublicClientConfiguration.getOAuth2TokenCache(), deviceCodeFlowParameters);
            DeviceCodeFlowCommandCallback deviceCodeFlowCommandCallback = this.getDeviceCodeFlowCommandCallback(callback);
            DeviceCodeFlowCommand deviceCodeFlowCommand = new DeviceCodeFlowCommand(commandParameters, new MSALControllerFactory(this.mPublicClientConfiguration).getDefaultController(commandParameters.getAuthority()), deviceCodeFlowCommandCallback, "651");
            CommandDispatcher.submitSilent((BaseCommand)deviceCodeFlowCommand);
            span.setStatus(StatusCode.OK);
        }
        catch (Throwable throwable) {
            span.setStatus(StatusCode.ERROR);
            span.recordException(throwable);
            throw throwable;
        }
        finally {
            span.end();
        }
    }

    @Override
    public void acquireTokenWithDeviceCode(@NonNull List<String> scopes, @NonNull IPublicClientApplication.DeviceCodeFlowCallback callback) {
        DeviceCodeFlowCommandParameters commandParameters = CommandParametersAdapter.createDeviceCodeFlowCommandParameters(this.mPublicClientConfiguration, this.mPublicClientConfiguration.getOAuth2TokenCache(), scopes);
        DeviceCodeFlowCommandCallback deviceCodeFlowCommandCallback = this.getDeviceCodeFlowCommandCallback(callback);
        DeviceCodeFlowCommand deviceCodeFlowCommand = new DeviceCodeFlowCommand(commandParameters, (BaseController)new LocalMSALController(), deviceCodeFlowCommandCallback, "650");
        CommandDispatcher.submitSilent((BaseCommand)deviceCodeFlowCommand);
    }

    @Override
    @Deprecated
    public void acquireTokenWithDeviceCode(@NonNull String[] scopes, @NonNull IPublicClientApplication.DeviceCodeFlowCallback callback) {
        DeviceCodeFlowCommandParameters commandParameters = CommandParametersAdapter.createDeviceCodeFlowCommandParameters(this.mPublicClientConfiguration, this.mPublicClientConfiguration.getOAuth2TokenCache(), Arrays.asList(scopes));
        DeviceCodeFlowCommandCallback deviceCodeFlowCommandCallback = this.getDeviceCodeFlowCommandCallback(callback);
        DeviceCodeFlowCommand deviceCodeFlowCommand = new DeviceCodeFlowCommand(commandParameters, (BaseController)new LocalMSALController(), deviceCodeFlowCommandCallback, "650");
        CommandDispatcher.submitSilent((BaseCommand)deviceCodeFlowCommand);
    }

    private void checkInternetPermission() {
        PackageManager packageManager = this.mPublicClientConfiguration.getAppContext().getPackageManager();
        if (packageManager.checkPermission(INTERNET_PERMISSION, this.mPublicClientConfiguration.getAppContext().getPackageName()) != 0 || packageManager.checkPermission(ACCESS_NETWORK_STATE_PERMISSION, this.mPublicClientConfiguration.getAppContext().getPackageName()) != 0) {
            throw new IllegalStateException("android.permission.Internet or android.permission.ACCESS_NETWORK_STATE is missing");
        }
    }

    static CommandCallback<List<ICacheRecord>, BaseException> getLoadAccountsCallback(final IPublicClientApplication.LoadAccountsCallback loadAccountsCallback) {
        return new CommandCallback<List<ICacheRecord>, BaseException>(){

            public void onTaskCompleted(List<ICacheRecord> result) {
                if (null == result) {
                    loadAccountsCallback.onTaskCompleted(null);
                } else {
                    loadAccountsCallback.onTaskCompleted(AccountAdapter.adapt(result));
                }
            }

            public void onError(BaseException exception) {
                loadAccountsCallback.onError(MsalExceptionAdapter.msalExceptionFromBaseException(exception));
            }

            public void onCancel() {
            }
        };
    }

    protected CommandCallback getCommandCallback(final @NonNull SilentAuthenticationCallback authenticationCallback, final @NonNull TokenParameters tokenParameters) {
        return new CommandCallback<ILocalAuthenticationResult, BaseException>(){

            public void onTaskCompleted(ILocalAuthenticationResult localAuthenticationResult) {
                PublicClientApplication.this.postAuthResult(localAuthenticationResult, tokenParameters, authenticationCallback);
            }

            public void onError(BaseException exception) {
                MsalException msalException = MsalExceptionAdapter.msalExceptionFromBaseException(exception);
                if (authenticationCallback == null) {
                    throw new IllegalStateException("callback cannot be null or empty");
                }
                authenticationCallback.onError(msalException);
            }

            public void onCancel() {
                if (!(authenticationCallback instanceof AuthenticationCallback)) {
                    throw new IllegalStateException("Silent requests cannot be cancelled.");
                }
                ((AuthenticationCallback)authenticationCallback).onCancel();
            }
        };
    }

    protected DeviceCodeFlowCommandCallback getDeviceCodeFlowCommandCallback(final @NonNull IPublicClientApplication.DeviceCodeFlowCallback callback) {
        return new DeviceCodeFlowCommandCallback<LocalAuthenticationResult, BaseException>(){

            public void onUserCodeReceived(@NonNull String vUri, @NonNull String userCode, @NonNull String message, @NonNull Date sessionExpirationDate) {
                callback.onUserCodeReceived(vUri, userCode, message, sessionExpirationDate);
            }

            public void onTaskCompleted(@NonNull LocalAuthenticationResult tokenResult) {
                IAuthenticationResult convertedResult = AuthenticationResultAdapter.adapt((ILocalAuthenticationResult)tokenResult);
                callback.onTokenReceived(convertedResult);
            }

            public void onError(@NonNull BaseException exception) {
                MsalException msalException = MsalExceptionAdapter.msalExceptionFromBaseException(exception);
                callback.onError(msalException);
            }

            public void onCancel() {
            }
        };
    }

    protected void postAuthResult(@NonNull ILocalAuthenticationResult localAuthenticationResult, @NonNull TokenParameters requestParameters, @NonNull SilentAuthenticationCallback authenticationCallback) {
        if (authenticationCallback == null) {
            throw new IllegalStateException("callback cannot be null or empty");
        }
        List<String> declinedScopes = AuthenticationResultAdapter.getDeclinedScopes(Arrays.asList(localAuthenticationResult.getScope()), requestParameters.getScopes());
        if (!declinedScopes.isEmpty()) {
            MsalDeclinedScopeException declinedScopeException = AuthenticationResultAdapter.declinedScopeExceptionFromResult(localAuthenticationResult, declinedScopes, requestParameters);
            authenticationCallback.onError(declinedScopeException);
        } else {
            IAuthenticationResult authenticationResult = AuthenticationResultAdapter.adapt(localAuthenticationResult);
            authenticationCallback.onSuccess(authenticationResult);
        }
    }

    private OAuth2TokenCache<?, ?, ?> getOAuth2TokenCache() {
        return MsalOAuth2TokenCache.create((IPlatformComponents)AndroidPlatformComponentsFactory.createFromContext((Context)this.mPublicClientConfiguration.getAppContext()));
    }

    IAuthenticationResult acquireTokenSilentSyncInternal(@NonNull String[] scopes, @NonNull String authority, @NonNull IAccount account, boolean forceRefresh, @NonNull String publicApiId) throws MsalException, InterruptedException {
        MsalUtils.throwOnMainThread("acquireTokenSilent");
        final ResultFuture future = new ResultFuture();
        AcquireTokenSilentParameters acquireTokenSilentParameters = this.buildAcquireTokenSilentParameters(scopes, account, authority, forceRefresh, null, new SilentAuthenticationCallback(){

            @Override
            public void onSuccess(IAuthenticationResult authenticationResult) {
                future.setResult(new AsyncResult<IAuthenticationResult>(authenticationResult, null));
            }

            @Override
            public void onError(MsalException exception) {
                future.setResult(new AsyncResult<Object>(null, exception));
            }
        });
        this.acquireTokenSilentAsyncInternal(acquireTokenSilentParameters, publicApiId);
        try {
            AsyncResult result = (AsyncResult)future.get();
            if (result.getSuccess()) {
                return (IAuthenticationResult)result.getResult();
            }
            throw result.getException();
        }
        catch (ExecutionException e) {
            throw new MsalClientException("unknown_error", "Unexpected error while acquiring token.", e);
        }
    }

    void performMigration(@NonNull TokenMigrationCallback callback) {
        HashMap<String, String> redirects = new HashMap<String, String>();
        redirects.put(this.mPublicClientConfiguration.getClientId(), this.mPublicClientConfiguration.getRedirectUri());
        AdalMigrationAdapter adalMigrationAdapter = new AdalMigrationAdapter(this.mPublicClientConfiguration.getAppContext(), redirects, false);
        if (adalMigrationAdapter.getMigrationStatus()) {
            callback.onMigrationFinished(0);
        } else {
            SharedPreferencesFileManager sharedPreferencesFileManager = new SharedPreferencesFileManager(this.mPublicClientConfiguration.getAppContext(), "com.microsoft.aad.adal.cache", (IKeyAccessor)new AndroidAuthSdkStorageEncryptionManager(this.mPublicClientConfiguration.getAppContext()));
            Map credentials = sharedPreferencesFileManager.getAll();
            new TokenMigrationUtility()._import((IMigrationAdapter)adalMigrationAdapter, credentials, (IShareSingleSignOnState)this.mPublicClientConfiguration.getOAuth2TokenCache(), callback);
        }
    }

    private static void runOnBackground(@NonNull Runnable runnable) {
        new Thread(runnable).start();
    }

    private static boolean isAccountHomeTenant(@Nullable Map<String, ?> claims, @NonNull String tenantId) {
        boolean isAccountHomeTenant = false;
        if (null != claims && !claims.isEmpty()) {
            isAccountHomeTenant = claims.get("tid").equals(tenantId);
        }
        return isAccountHomeTenant;
    }

    public boolean isValidBrokerPackage(@NonNull Context context, @NonNull String packageName) {
        return new BrokerValidator(context).isValidBrokerPackage(packageName);
    }

    @Nullable
    public String getActiveBrokerPackageName(@NonNull Context context) {
        BrokerData activeBroker = BrokerDiscoveryClientFactory.getInstance((Context)context, (IPlatformComponents)AndroidPlatformComponentsFactory.createFromContext((Context)context)).getActiveBroker(false);
        return activeBroker != null ? activeBroker.getPackageName() : null;
    }

    protected class AccountMatcher {
        private final AccountMatcher[] mDelegateMatchers;

        AccountMatcher() {
            this.mDelegateMatchers = new AccountMatcher[0];
        }

        AccountMatcher(AccountMatcher ... delegateMatchers) {
            this.mDelegateMatchers = delegateMatchers;
        }

        boolean matches(@NonNull String identifier, @NonNull IAccount account) {
            AccountMatcher matcher;
            boolean matches = false;
            AccountMatcher[] accountMatcherArray = this.mDelegateMatchers;
            int n = accountMatcherArray.length;
            for (int i = 0; i < n && !(matches = (matcher = accountMatcherArray[i]).matches(identifier, account)); ++i) {
            }
            return matches;
        }
    }

    public static interface BrokerDeviceModeCallback {
        public void onGetMode(boolean var1);

        public void onError(MsalException var1);
    }

    static class NONNULL_CONSTANTS {
        static final String CONTEXT = "context";
        static final String LISTENER = "listener";
        static final String CALLBACK = "callback";
        static final String CLIENT_ID = "client_id";
        static final String AUTHORITY = "authority";
        static final String REDIRECT_URI = "redirect_uri";
        static final String CONFIG_FILE = "config_file";
        static final String ACTIVITY = "activity";
        static final String SCOPES = "scopes";
        static final String ACCOUNT = "account";
        static final String NULL_ERROR_SUFFIX = " cannot be null or empty";

        NONNULL_CONSTANTS() {
        }
    }
}

