/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import com.microsoft.identity.client.AcquireTokenParameters;
import com.microsoft.identity.client.AcquireTokenSilentParameters;
import com.microsoft.identity.client.DeviceCodeFlowParameters;
import com.microsoft.identity.client.IAccount;
import com.microsoft.identity.client.ITenantProfile;
import com.microsoft.identity.client.MultiTenantAccount;
import com.microsoft.identity.client.PoPAuthenticationScheme;
import com.microsoft.identity.client.PublicClientApplication;
import com.microsoft.identity.client.PublicClientApplicationConfiguration;
import com.microsoft.identity.client.claims.ClaimsRequest;
import com.microsoft.identity.client.claims.RequestedClaimAdditionalInformation;
import com.microsoft.identity.client.internal.IntuneAcquireTokenParameters;
import com.microsoft.identity.common.components.AndroidPlatformComponentsFactory;
import com.microsoft.identity.common.internal.commands.parameters.AndroidActivityInteractiveTokenCommandParameters;
import com.microsoft.identity.common.internal.util.StringUtil;
import com.microsoft.identity.common.java.authorities.Authority;
import com.microsoft.identity.common.java.authorities.AzureActiveDirectoryAuthority;
import com.microsoft.identity.common.java.authorities.AzureActiveDirectoryB2CAuthority;
import com.microsoft.identity.common.java.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.java.authscheme.AuthenticationSchemeFactory;
import com.microsoft.identity.common.java.authscheme.BearerAuthenticationSchemeInternal;
import com.microsoft.identity.common.java.authscheme.INameable;
import com.microsoft.identity.common.java.authscheme.IPoPAuthenticationSchemeParams;
import com.microsoft.identity.common.java.commands.parameters.CommandParameters;
import com.microsoft.identity.common.java.commands.parameters.DeviceCodeFlowCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.GenerateShrCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.RemoveAccountCommandParameters;
import com.microsoft.identity.common.java.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.java.dto.AccountRecord;
import com.microsoft.identity.common.java.dto.IAccountRecord;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.interfaces.IPlatformComponents;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.java.providers.oauth2.OpenIdConnectPromptParameter;
import com.microsoft.identity.common.java.request.SdkType;
import com.microsoft.identity.common.java.ui.AuthorizationAgent;
import com.microsoft.identity.common.java.util.SchemaUtil;
import com.microsoft.identity.common.logging.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class CommandParametersAdapter {
    private static final String TAG = CommandParametersAdapter.class.getSimpleName();
    public static final String CLIENT_CAPABILITIES_CLAIM = "xms_cc";

    public static CommandParameters createCommandParameters(@NonNull PublicClientApplicationConfiguration configuration, @NonNull OAuth2TokenCache tokenCache) {
        CommandParameters commandParameters = CommandParameters.builder().platformComponents(AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext())).applicationName(configuration.getAppContext().getPackageName()).applicationVersion(CommandParametersAdapter.getPackageVersion(configuration.getAppContext())).clientId(configuration.getClientId()).isSharedDevice(configuration.getIsSharedDevice()).oAuth2TokenCache(tokenCache).redirectUri(configuration.getRedirectUri()).requiredBrokerProtocolVersion(configuration.getRequiredBrokerProtocolVersion()).sdkType(SdkType.MSAL).sdkVersion(PublicClientApplication.getSdkVersion()).powerOptCheckEnabled(configuration.isPowerOptCheckForEnabled().booleanValue()).build();
        return commandParameters;
    }

    public static RemoveAccountCommandParameters createRemoveAccountCommandParameters(@NonNull PublicClientApplicationConfiguration configuration, @NonNull OAuth2TokenCache tokenCache, @NonNull AccountRecord account) {
        RemoveAccountCommandParameters commandParameters = ((RemoveAccountCommandParameters.RemoveAccountCommandParametersBuilder)((RemoveAccountCommandParameters.RemoveAccountCommandParametersBuilder)((RemoveAccountCommandParameters.RemoveAccountCommandParametersBuilder)((RemoveAccountCommandParameters.RemoveAccountCommandParametersBuilder)((RemoveAccountCommandParameters.RemoveAccountCommandParametersBuilder)((RemoveAccountCommandParameters.RemoveAccountCommandParametersBuilder)((RemoveAccountCommandParameters.RemoveAccountCommandParametersBuilder)((RemoveAccountCommandParameters.RemoveAccountCommandParametersBuilder)((RemoveAccountCommandParameters.RemoveAccountCommandParametersBuilder)((RemoveAccountCommandParameters.RemoveAccountCommandParametersBuilder)((RemoveAccountCommandParameters.RemoveAccountCommandParametersBuilder)RemoveAccountCommandParameters.builder().platformComponents(AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext()))).applicationName(configuration.getAppContext().getPackageName())).applicationVersion(CommandParametersAdapter.getPackageVersion(configuration.getAppContext()))).clientId(configuration.getClientId())).isSharedDevice(configuration.getIsSharedDevice())).oAuth2TokenCache(tokenCache)).redirectUri(configuration.getRedirectUri())).requiredBrokerProtocolVersion(configuration.getRequiredBrokerProtocolVersion())).sdkType(SdkType.MSAL)).sdkVersion(PublicClientApplication.getSdkVersion())).account((IAccountRecord)account).browserSafeList(configuration.getBrowserSafeList()).powerOptCheckEnabled(configuration.isPowerOptCheckForEnabled().booleanValue())).build();
        return commandParameters;
    }

    public static InteractiveTokenCommandParameters createInteractiveTokenCommandParameters(@NonNull PublicClientApplicationConfiguration configuration, @NonNull OAuth2TokenCache tokenCache, @NonNull AcquireTokenParameters parameters) throws ClientException {
        AbstractAuthenticationScheme authenticationScheme = AuthenticationSchemeFactory.createScheme((IPlatformComponents)AndroidPlatformComponentsFactory.createFromContext((Context)parameters.getActivity()), (INameable)parameters.getAuthenticationScheme());
        Authority authority = CommandParametersAdapter.getAuthority(configuration, parameters);
        String claimsRequestJson = ClaimsRequest.getJsonStringFromClaimsRequest(CommandParametersAdapter.getClaimsRequest(parameters.getClaimsRequest(), configuration, authority));
        AndroidActivityInteractiveTokenCommandParameters commandParameters = ((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)((AndroidActivityInteractiveTokenCommandParameters.AndroidActivityInteractiveTokenCommandParametersBuilder)AndroidActivityInteractiveTokenCommandParameters.builder().activity(parameters.getActivity()).platformComponents(AndroidPlatformComponentsFactory.createFromActivity((Activity)parameters.getActivity(), (Fragment)parameters.getFragment()))).applicationName(configuration.getAppContext().getPackageName())).applicationVersion(CommandParametersAdapter.getPackageVersion(configuration.getAppContext()))).clientId(configuration.getClientId())).isSharedDevice(configuration.getIsSharedDevice())).oAuth2TokenCache(tokenCache)).redirectUri(configuration.getRedirectUri())).requiredBrokerProtocolVersion(configuration.getRequiredBrokerProtocolVersion())).sdkType(SdkType.MSAL)).sdkVersion(PublicClientApplication.getSdkVersion())).preferredBrowser(configuration.getPreferredBrowser())).browserSafeList(configuration.getBrowserSafeList())).authority(authority)).claimsRequestJson(claimsRequestJson)).forceRefresh(parameters.getClaimsRequest() != null)).scopes(new HashSet<String>(parameters.getScopes()))).extraScopesToConsent(parameters.getExtraScopesToConsent())).extraQueryStringParameters(CommandParametersAdapter.appendToExtraQueryParametersIfWebAuthnCapable(parameters.getExtraQueryStringParameters(), configuration))).loginHint(CommandParametersAdapter.getLoginHint(parameters))).account((IAccountRecord)parameters.getAccountRecord())).authenticationScheme(authenticationScheme)).authorizationAgent(CommandParametersAdapter.getAuthorizationAgent(configuration))).brokerBrowserSupportEnabled(CommandParametersAdapter.getBrokerBrowserSupportEnabled(parameters))).prompt(CommandParametersAdapter.getPromptParameter(parameters))).isWebViewZoomControlsEnabled(configuration.isWebViewZoomControlsEnabled())).isWebViewZoomEnabled(configuration.isWebViewZoomEnabled())).handleNullTaskAffinity(configuration.isHandleNullTaskAffinityEnabled().booleanValue())).powerOptCheckEnabled(configuration.isPowerOptCheckForEnabled().booleanValue())).correlationId(parameters.getCorrelationId())).build();
        return commandParameters;
    }

    public static SilentTokenCommandParameters createSilentTokenCommandParameters(@NonNull PublicClientApplicationConfiguration configuration, @NonNull OAuth2TokenCache tokenCache, @NonNull AcquireTokenSilentParameters parameters) throws ClientException {
        Authority authority = CommandParametersAdapter.getAuthority(configuration, parameters);
        ClaimsRequest claimsRequest = parameters.getClaimsRequest();
        ClaimsRequest mergedClaimsRequest = CommandParametersAdapter.getClaimsRequest(parameters.getClaimsRequest(), configuration, authority);
        String claimsRequestJson = ClaimsRequest.getJsonStringFromClaimsRequest(mergedClaimsRequest);
        boolean forceRefresh = claimsRequest != null || parameters.getForceRefresh();
        AbstractAuthenticationScheme authenticationScheme = AuthenticationSchemeFactory.createScheme((IPlatformComponents)AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext()), (INameable)parameters.getAuthenticationScheme());
        SilentTokenCommandParameters commandParameters = ((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)SilentTokenCommandParameters.builder().platformComponents(AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext()))).applicationName(configuration.getAppContext().getPackageName())).applicationVersion(CommandParametersAdapter.getPackageVersion(configuration.getAppContext()))).clientId(configuration.getClientId())).isSharedDevice(configuration.getIsSharedDevice())).oAuth2TokenCache(tokenCache)).redirectUri(configuration.getRedirectUri())).requiredBrokerProtocolVersion(configuration.getRequiredBrokerProtocolVersion())).sdkType(SdkType.MSAL)).sdkVersion(PublicClientApplication.getSdkVersion())).authority(authority)).claimsRequestJson(claimsRequestJson)).forceRefresh(forceRefresh)).account((IAccountRecord)parameters.getAccountRecord())).authenticationScheme(authenticationScheme)).scopes(new HashSet<String>(parameters.getScopes()))).powerOptCheckEnabled(configuration.isPowerOptCheckForEnabled().booleanValue())).correlationId(parameters.getCorrelationId())).build();
        return commandParameters;
    }

    public static DeviceCodeFlowCommandParameters createDeviceCodeFlowWithClaimsCommandParameters(@NonNull PublicClientApplicationConfiguration configuration, @NonNull OAuth2TokenCache tokenCache, @NonNull DeviceCodeFlowParameters parameters) {
        String claimsRequestJson = ClaimsRequest.getJsonStringFromClaimsRequest(parameters.getClaimsRequest());
        Authority authority = configuration.getDefaultAuthority();
        BearerAuthenticationSchemeInternal authenticationScheme = new BearerAuthenticationSchemeInternal();
        DeviceCodeFlowCommandParameters commandParameters = ((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)DeviceCodeFlowCommandParameters.builder().platformComponents(AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext()))).applicationName(configuration.getAppContext().getPackageName())).applicationVersion(CommandParametersAdapter.getPackageVersion(configuration.getAppContext()))).clientId(configuration.getClientId())).isSharedDevice(configuration.getIsSharedDevice())).redirectUri(configuration.getRedirectUri())).oAuth2TokenCache(tokenCache)).requiredBrokerProtocolVersion(configuration.getRequiredBrokerProtocolVersion())).sdkType(SdkType.MSAL)).sdkVersion(PublicClientApplication.getSdkVersion())).powerOptCheckEnabled(configuration.isPowerOptCheckForEnabled().booleanValue())).authenticationScheme((AbstractAuthenticationScheme)authenticationScheme)).scopes(new HashSet<String>(parameters.getScopes()))).authority(authority)).claimsRequestJson(claimsRequestJson)).correlationId(parameters.getCorrelationId())).build();
        return commandParameters;
    }

    public static DeviceCodeFlowCommandParameters createDeviceCodeFlowCommandParameters(@NonNull PublicClientApplicationConfiguration configuration, @NonNull OAuth2TokenCache tokenCache, @NonNull List<String> scopes) {
        Authority authority = configuration.getDefaultAuthority();
        BearerAuthenticationSchemeInternal authenticationScheme = new BearerAuthenticationSchemeInternal();
        DeviceCodeFlowCommandParameters commandParameters = ((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)((DeviceCodeFlowCommandParameters.DeviceCodeFlowCommandParametersBuilder)DeviceCodeFlowCommandParameters.builder().platformComponents(AndroidPlatformComponentsFactory.createFromContext((Context)configuration.getAppContext()))).applicationName(configuration.getAppContext().getPackageName())).applicationVersion(CommandParametersAdapter.getPackageVersion(configuration.getAppContext()))).clientId(configuration.getClientId())).isSharedDevice(configuration.getIsSharedDevice())).redirectUri(configuration.getRedirectUri())).oAuth2TokenCache(tokenCache)).requiredBrokerProtocolVersion(configuration.getRequiredBrokerProtocolVersion())).sdkType(SdkType.MSAL)).sdkVersion(PublicClientApplication.getSdkVersion())).powerOptCheckEnabled(configuration.isPowerOptCheckForEnabled().booleanValue())).authenticationScheme((AbstractAuthenticationScheme)authenticationScheme)).scopes(new HashSet<String>(scopes))).authority(authority)).build();
        return commandParameters;
    }

    private static String getPackageVersion(@NonNull Context context) {
        String packageName = context.getPackageName();
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(packageName, 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Authority getRequestAuthority(@NonNull PublicClientApplicationConfiguration publicClientApplicationConfiguration) {
        String requestAuthority = null;
        if (publicClientApplicationConfiguration.getDefaultAuthority() instanceof AzureActiveDirectoryB2CAuthority) {
            requestAuthority = publicClientApplicationConfiguration.getDefaultAuthority().getAuthorityURL().toString();
        }
        Authority authority = requestAuthority == null ? publicClientApplicationConfiguration.getDefaultAuthority() : Authority.getAuthorityFromAuthorityUrl(requestAuthority);
        return authority;
    }

    public static ClaimsRequest addClientCapabilitiesToClaimsRequest(ClaimsRequest cr, String clientCapabilities) {
        ClaimsRequest mergedClaimsRequest;
        ClaimsRequest claimsRequest = mergedClaimsRequest = cr == null ? new ClaimsRequest() : cr;
        if (clientCapabilities != null) {
            RequestedClaimAdditionalInformation info = new RequestedClaimAdditionalInformation();
            String[] capabilities = clientCapabilities.split(",");
            info.setValues(new ArrayList<Object>(Arrays.asList(capabilities)));
            mergedClaimsRequest.requestClaimInAccessToken(CLIENT_CAPABILITIES_CLAIM, info);
        }
        return mergedClaimsRequest;
    }

    private static String getUsername(@NonNull IAccount account) {
        String username = null;
        if (null != account.getClaims()) {
            username = SchemaUtil.getDisplayableId(account.getClaims());
        } else {
            MultiTenantAccount multiTenantAccount = (MultiTenantAccount)account;
            Map<String, ITenantProfile> tenantProfiles = multiTenantAccount.getTenantProfiles();
            for (Map.Entry<String, ITenantProfile> profileEntry : tenantProfiles.entrySet()) {
                String displayableId;
                if (null == profileEntry.getValue().getClaims() || "Missing from the token response".equalsIgnoreCase(displayableId = SchemaUtil.getDisplayableId(profileEntry.getValue().getClaims()))) continue;
                username = displayableId;
                break;
            }
        }
        return username;
    }

    private static Authority getAuthority(PublicClientApplicationConfiguration configuration, @NonNull AcquireTokenParameters parameters) {
        Authority authority = StringUtil.isEmpty((String)parameters.getAuthority()) ? (parameters.getAccount() != null ? CommandParametersAdapter.getRequestAuthority(configuration) : configuration.getDefaultAuthority()) : Authority.getAuthorityFromAuthorityUrl((String)parameters.getAuthority());
        if (authority instanceof AzureActiveDirectoryAuthority) {
            AzureActiveDirectoryAuthority aadAuthority = (AzureActiveDirectoryAuthority)authority;
            aadAuthority.setMultipleCloudsSupported(configuration.getMultipleCloudsSupported().booleanValue());
        }
        return authority;
    }

    private static Authority getAuthority(@NonNull PublicClientApplicationConfiguration configuration, @NonNull AcquireTokenSilentParameters parameters) {
        String requestAuthority = parameters.getAuthority();
        Authority authority = Authority.getAuthorityFromAuthorityUrl((String)requestAuthority);
        if (authority instanceof AzureActiveDirectoryAuthority) {
            AzureActiveDirectoryAuthority aadAuthority = (AzureActiveDirectoryAuthority)authority;
            aadAuthority.setMultipleCloudsSupported(configuration.getMultipleCloudsSupported().booleanValue());
        }
        return authority;
    }

    private static ClaimsRequest getClaimsRequest(@NonNull ClaimsRequest requestedClaims, @NonNull PublicClientApplicationConfiguration configuration, @NonNull Authority authority) {
        if (authority instanceof AzureActiveDirectoryAuthority) {
            return CommandParametersAdapter.addClientCapabilitiesToClaimsRequest(requestedClaims, configuration.getClientCapabilities());
        }
        return requestedClaims;
    }

    private static String getLoginHint(@NonNull AcquireTokenParameters parameters) {
        if (parameters.getAccount() != null) {
            IAccount account = parameters.getAccount();
            return CommandParametersAdapter.getUsername(account);
        }
        return parameters.getLoginHint();
    }

    private static AuthorizationAgent getAuthorizationAgent(@NonNull PublicClientApplicationConfiguration configuration) {
        if (configuration.getAuthorizationAgent() != null) {
            return configuration.getAuthorizationAgent();
        }
        return AuthorizationAgent.DEFAULT;
    }

    private static boolean getBrokerBrowserSupportEnabled(@NonNull AcquireTokenParameters parameters) {
        String methodTag = TAG + ":getBrokerBrowserSupportEnabled";
        if (parameters instanceof IntuneAcquireTokenParameters) {
            boolean brokerBrowserEnabled = ((IntuneAcquireTokenParameters)parameters).isBrokerBrowserSupportEnabled();
            Logger.info((String)methodTag, (String)(" IntuneAcquireTokenParameters instance, broker browser enabled : " + brokerBrowserEnabled));
            return brokerBrowserEnabled;
        }
        return false;
    }

    private static OpenIdConnectPromptParameter getPromptParameter(@NonNull AcquireTokenParameters parameters) {
        if (parameters.getPrompt() == null) {
            return OpenIdConnectPromptParameter.SELECT_ACCOUNT;
        }
        return parameters.getPrompt().toOpenIdConnectPromptParameter();
    }

    public static GenerateShrCommandParameters createGenerateShrCommandParameters(@NonNull PublicClientApplicationConfiguration clientConfig, @NonNull OAuth2TokenCache oAuth2TokenCache, @NonNull String homeAccountId, @NonNull PoPAuthenticationScheme popParameters) {
        Context context = clientConfig.getAppContext();
        return ((GenerateShrCommandParameters.GenerateShrCommandParametersBuilder)((GenerateShrCommandParameters.GenerateShrCommandParametersBuilder)((GenerateShrCommandParameters.GenerateShrCommandParametersBuilder)((GenerateShrCommandParameters.GenerateShrCommandParametersBuilder)((GenerateShrCommandParameters.GenerateShrCommandParametersBuilder)((GenerateShrCommandParameters.GenerateShrCommandParametersBuilder)((GenerateShrCommandParameters.GenerateShrCommandParametersBuilder)((GenerateShrCommandParameters.GenerateShrCommandParametersBuilder)((GenerateShrCommandParameters.GenerateShrCommandParametersBuilder)((GenerateShrCommandParameters.GenerateShrCommandParametersBuilder)((GenerateShrCommandParameters.GenerateShrCommandParametersBuilder)GenerateShrCommandParameters.builder().platformComponents(AndroidPlatformComponentsFactory.createFromContext((Context)context))).applicationName(context.getPackageName())).applicationVersion(CommandParametersAdapter.getPackageVersion(context))).clientId(clientConfig.getClientId())).isSharedDevice(clientConfig.getIsSharedDevice())).redirectUri(clientConfig.getRedirectUri())).oAuth2TokenCache(oAuth2TokenCache)).requiredBrokerProtocolVersion(clientConfig.getRequiredBrokerProtocolVersion())).sdkType(SdkType.MSAL)).sdkVersion(PublicClientApplication.getSdkVersion())).powerOptCheckEnabled(clientConfig.isPowerOptCheckForEnabled().booleanValue())).homeAccountId(homeAccountId).popParameters((IPoPAuthenticationSchemeParams)popParameters).build();
    }

    @Nullable
    public static List<Map.Entry<String, String>> appendToExtraQueryParametersIfWebAuthnCapable(@Nullable List<Map.Entry<String, String>> queryStringParameters, @NonNull PublicClientApplicationConfiguration configuration) {
        return queryStringParameters;
    }
}

