/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.helper;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.internal.broker.BrokerValidator;
import com.microsoft.identity.common.internal.broker.PackageHelper;
import com.microsoft.identity.msal.R;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class BrokerHelperActivity
extends Activity {
    private final String MANIFEST_TEMPLATE = "<activity android:name=\"com.microsoft.identity.client.BrowserTabActivity\">\n    <intent-filter>\n        <action android:name=\"android.intent.action.VIEW\" />\n        <category android:name=\"android.intent.category.DEFAULT\" />\n        <category android:name=\"android.intent.category.BROWSABLE\" />\n        <data\n            android:host=\"%s\"\n            android:path=\"/%s\"\n            android:scheme=\"msauth\" />\n    </intent-filter>\n</activity>";
    TextView mPackageName;
    TextView mSignature;
    TextView mRedirect;
    TextView mManifest;

    public static Intent createStartIntent(Context context) {
        Intent intent = new Intent(context, BrokerHelperActivity.class);
        return intent;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.broker_helper);
        this.mPackageName = (TextView)this.findViewById(R.id.txtPackageName);
        this.mSignature = (TextView)this.findViewById(R.id.txtSignature);
        this.mRedirect = (TextView)this.findViewById(R.id.txtRedirect);
        this.mManifest = (TextView)this.findViewById(R.id.txtManifest);
        this.mSignature.append((CharSequence)this.getSignature(false));
        this.mRedirect.append((CharSequence)BrokerValidator.getBrokerRedirectUri((Context)this.getApplicationContext(), (String)this.getPackageName()));
        this.mManifest.append((CharSequence)String.format("<activity android:name=\"com.microsoft.identity.client.BrowserTabActivity\">\n    <intent-filter>\n        <action android:name=\"android.intent.action.VIEW\" />\n        <category android:name=\"android.intent.category.DEFAULT\" />\n        <category android:name=\"android.intent.category.BROWSABLE\" />\n        <data\n            android:host=\"%s\"\n            android:path=\"/%s\"\n            android:scheme=\"msauth\" />\n    </intent-filter>\n</activity>", this.getPackageName(), this.getSignature(false)));
        this.mPackageName.append((CharSequence)this.getPackageName());
    }

    private String getSignature(boolean urlEncode) {
        PackageHelper info = new PackageHelper(this.getApplicationContext().getPackageManager());
        String signatureDigest = info.getCurrentSignatureForPackage(this.getPackageName());
        String signature = "";
        try {
            signature = urlEncode ? URLEncoder.encode(signatureDigest, "UTF-8") : signatureDigest;
        }
        catch (UnsupportedEncodingException e) {
            Log.e((String)"getSignature", (String)"Character encoding UTF-8 is not supported.", (Throwable)e);
            throw new RuntimeException("Unexpected: Unable to get the signature for this application package.");
        }
        return signature;
    }
}

