/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.claims;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.microsoft.identity.client.claims.ClaimsRequest;
import com.microsoft.identity.client.claims.RequestedClaim;
import com.microsoft.identity.client.claims.RequestedClaimAdditionalInformation;
import java.lang.reflect.Type;
import java.util.List;

class ClaimsRequestSerializer
implements JsonSerializer<ClaimsRequest> {
    ClaimsRequestSerializer() {
    }

    public JsonElement serialize(ClaimsRequest src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject claimsRequest = new JsonObject();
        JsonObject userInfoObject = new JsonObject();
        JsonObject accessTokenObject = new JsonObject();
        JsonObject idTokenObject = new JsonObject();
        this.addPropertiesToObject(src.getAccessTokenClaimsRequested(), accessTokenObject, context);
        this.addPropertiesToObject(src.getIdTokenClaimsRequested(), idTokenObject, context);
        this.addPropertiesToObject(src.getUserInfoClaimsRequested(), userInfoObject, context);
        if (userInfoObject.size() != 0) {
            claimsRequest.add("userinfo", (JsonElement)userInfoObject);
        }
        if (idTokenObject.size() != 0) {
            claimsRequest.add("id_token", (JsonElement)idTokenObject);
        }
        if (accessTokenObject.size() != 0) {
            claimsRequest.add("access_token", (JsonElement)accessTokenObject);
        }
        return claimsRequest;
    }

    public void addPropertiesToObject(List<RequestedClaim> requestedClaims, JsonObject addTo, JsonSerializationContext context) {
        for (RequestedClaim claim : requestedClaims) {
            addTo.add(claim.getName(), context.serialize((Object)claim.getAdditionalInformation(), RequestedClaimAdditionalInformation.class));
        }
    }
}

