/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.controllers;

import com.microsoft.identity.client.exception.MsalArgumentException;
import com.microsoft.identity.client.exception.MsalClientException;
import com.microsoft.identity.client.exception.MsalException;
import com.microsoft.identity.client.exception.MsalIntuneAppProtectionPolicyRequiredException;
import com.microsoft.identity.client.exception.MsalServiceException;
import com.microsoft.identity.client.exception.MsalUiRequiredException;
import com.microsoft.identity.client.exception.MsalUserCancelException;
import com.microsoft.identity.common.exception.ArgumentException;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.exception.IntuneAppProtectionPolicyRequiredException;
import com.microsoft.identity.common.exception.ServiceException;
import com.microsoft.identity.common.exception.UiRequiredException;
import com.microsoft.identity.common.exception.UserCancelException;

public class MsalExceptionAdapter {
    public static MsalException msalExceptionFromBaseException(BaseException e) {
        MsalException msalException = null;
        if (e instanceof MsalException) {
            msalException = (MsalException)e;
        } else if (e instanceof ClientException) {
            ClientException clientException = (ClientException)e;
            msalException = new MsalClientException(clientException.getErrorCode(), clientException.getMessage(), (Throwable)clientException);
        } else if (e instanceof ArgumentException) {
            ArgumentException argumentException = (ArgumentException)e;
            msalException = new MsalArgumentException(argumentException.getArgumentName(), argumentException.getOperationName(), argumentException.getMessage(), (Throwable)argumentException);
        } else if (e instanceof UiRequiredException) {
            UiRequiredException uiRequiredException = (UiRequiredException)e;
            msalException = new MsalUiRequiredException(uiRequiredException.getErrorCode(), uiRequiredException.getMessage());
        } else if (e instanceof IntuneAppProtectionPolicyRequiredException) {
            msalException = new MsalIntuneAppProtectionPolicyRequiredException((IntuneAppProtectionPolicyRequiredException)e);
        } else if (e instanceof ServiceException) {
            ServiceException serviceException = (ServiceException)e;
            msalException = new MsalServiceException(serviceException.getErrorCode(), serviceException.getMessage(), serviceException.getHttpStatusCode(), serviceException);
        } else if (e instanceof UserCancelException) {
            msalException = new MsalUserCancelException();
        }
        if (msalException == null) {
            msalException = new MsalClientException("unknown_error", e.getMessage(), (Throwable)e);
        }
        return msalException;
    }
}

