/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.net.Uri;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.client.BrowserTabActivity;
import com.microsoft.identity.client.configuration.AccountMode;
import com.microsoft.identity.client.configuration.HttpConfiguration;
import com.microsoft.identity.client.configuration.LoggerConfiguration;
import com.microsoft.identity.client.exception.MsalClientException;
import com.microsoft.identity.client.internal.MsalUtils;
import com.microsoft.identity.common.adal.internal.AuthenticationSettings;
import com.microsoft.identity.common.internal.authorities.Authority;
import com.microsoft.identity.common.internal.authorities.AzureActiveDirectoryAuthority;
import com.microsoft.identity.common.internal.authorities.Environment;
import com.microsoft.identity.common.internal.authorities.UnknownAudience;
import com.microsoft.identity.common.internal.authorities.UnknownAuthority;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.internal.telemetry.TelemetryConfiguration;
import com.microsoft.identity.common.internal.ui.AuthorizationAgent;
import com.microsoft.identity.common.internal.ui.browser.BrowserDescriptor;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;

public class PublicClientApplicationConfiguration {
    private static final String TAG = PublicClientApplicationConfiguration.class.getSimpleName();
    private static final String BROKER_REDIRECT_URI_SCHEME_AND_SEPARATOR = "msauth://";
    @SerializedName(value="client_id")
    private String mClientId;
    @SerializedName(value="redirect_uri")
    private String mRedirectUri;
    @SerializedName(value="authorities")
    private List<Authority> mAuthorities;
    @SerializedName(value="authorization_user_agent")
    private AuthorizationAgent mAuthorizationAgent;
    @SerializedName(value="http")
    private HttpConfiguration mHttpConfiguration;
    @SerializedName(value="logging")
    private LoggerConfiguration mLoggerConfiguration;
    @SerializedName(value="multiple_clouds_supported")
    private Boolean mMultipleCloudsSupported;
    @SerializedName(value="broker_redirect_uri_registered")
    private Boolean mUseBroker;
    @SerializedName(value="environment")
    private Environment mEnvironment;
    @SerializedName(value="minimum_required_broker_protocol_version")
    private String mRequiredBrokerProtocolVersion;
    @SerializedName(value="browser_safelist")
    private List<BrowserDescriptor> mBrowserSafeList;
    @SerializedName(value="telemetry")
    private TelemetryConfiguration mTelemetryConfiguration;
    @SerializedName(value="account_mode")
    private AccountMode mAccountMode;
    @SerializedName(value="client_capabilities")
    private String mClientCapabilities;
    @SerializedName(value="web_view_zoom_controls_enabled")
    private Boolean webViewZoomControlsEnabled;
    @SerializedName(value="web_view_zoom_enabled")
    private Boolean webViewZoomEnabled;
    @SerializedName(value="power_opt_check_for_network_req_enabled")
    private Boolean powerOptCheckEnabled;
    private transient OAuth2TokenCache mOAuth2TokenCache;
    private transient Context mAppContext;
    private transient boolean mIsSharedDevice = false;

    public void setTokenCacheSecretKeys(@NonNull byte[] rawKey) {
        AuthenticationSettings.INSTANCE.setSecretKey(rawKey);
    }

    public List<BrowserDescriptor> getBrowserSafeList() {
        return this.mBrowserSafeList;
    }

    public String getClientId() {
        return this.mClientId;
    }

    public void setClientId(String clientId) {
        this.mClientId = clientId;
    }

    public List<Authority> getAuthorities() {
        return this.mAuthorities;
    }

    public Environment getEnvironment() {
        return this.mEnvironment;
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.mHttpConfiguration;
    }

    public LoggerConfiguration getLoggerConfiguration() {
        return this.mLoggerConfiguration;
    }

    public TelemetryConfiguration getTelemetryConfiguration() {
        return this.mTelemetryConfiguration;
    }

    public String getRedirectUri() {
        return this.mRedirectUri;
    }

    public void setRedirectUri(@NonNull String redirectUri) {
        this.mRedirectUri = redirectUri;
    }

    public AuthorizationAgent getAuthorizationAgent() {
        return this.mAuthorizationAgent;
    }

    public Boolean getMultipleCloudsSupported() {
        return this.mMultipleCloudsSupported;
    }

    public Boolean getUseBroker() {
        return this.mUseBroker;
    }

    public AccountMode getAccountMode() {
        return this.mAccountMode;
    }

    public String getClientCapabilities() {
        return this.mClientCapabilities;
    }

    public String getRequiredBrokerProtocolVersion() {
        return this.mRequiredBrokerProtocolVersion;
    }

    public Context getAppContext() {
        return this.mAppContext;
    }

    void setAppContext(Context applicationContext) {
        this.mAppContext = applicationContext;
    }

    OAuth2TokenCache getOAuth2TokenCache() {
        return this.mOAuth2TokenCache;
    }

    void setOAuth2TokenCache(OAuth2TokenCache tokenCache) {
        this.mOAuth2TokenCache = tokenCache;
    }

    public boolean getIsSharedDevice() {
        return this.mIsSharedDevice;
    }

    void setIsSharedDevice(boolean isSharedDevice) {
        this.mIsSharedDevice = isSharedDevice;
    }

    public boolean isWebViewZoomControlsEnabled() {
        return this.webViewZoomControlsEnabled;
    }

    public boolean isWebViewZoomEnabled() {
        return this.webViewZoomEnabled;
    }

    public void setWebViewZoomControlsEnabled(boolean webViewZoomControlsEnabled) {
        this.webViewZoomControlsEnabled = webViewZoomControlsEnabled;
    }

    public void setWebViewZoomEnabled(boolean webViewZoomEnabled) {
        this.webViewZoomEnabled = webViewZoomEnabled;
    }

    public Boolean isPowerOptCheckForEnabled() {
        return this.powerOptCheckEnabled;
    }

    public void setPowerOptCheckEnabled(Boolean powerOptCheckEnabled) {
        this.powerOptCheckEnabled = powerOptCheckEnabled;
    }

    public Authority getDefaultAuthority() {
        if (this.mAuthorities != null) {
            if (this.mAuthorities.size() > 1) {
                for (Authority authority : this.mAuthorities) {
                    if (!authority.getDefault()) continue;
                    return authority;
                }
                return null;
            }
            return this.mAuthorities.get(0);
        }
        return null;
    }

    private void checkDefaultAuthoritySpecified() {
        if (this.mAuthorities != null && this.mAuthorities.size() > 1) {
            int defaultCount = 0;
            for (Authority authority : this.mAuthorities) {
                if (!authority.getDefault()) continue;
                ++defaultCount;
            }
            if (defaultCount == 0) {
                throw new IllegalArgumentException("One authority in your configuration must be marked as default.");
            }
            if (defaultCount > 1) {
                throw new IllegalArgumentException("More than one authority in your configuration is marked as default.  Only one authority may be default.");
            }
        }
    }

    public boolean isDefaultAuthorityConfigured() {
        Authority authority = this.getDefaultAuthority();
        return authority != null;
    }

    void mergeConfiguration(PublicClientApplicationConfiguration config) {
        this.mClientId = config.mClientId == null ? this.mClientId : config.mClientId;
        this.mRedirectUri = config.mRedirectUri == null ? this.mRedirectUri : config.mRedirectUri;
        this.mAuthorities = config.mAuthorities == null ? this.mAuthorities : config.mAuthorities;
        this.mAuthorizationAgent = config.mAuthorizationAgent == null ? this.mAuthorizationAgent : config.mAuthorizationAgent;
        this.mEnvironment = config.mEnvironment == null ? this.mEnvironment : config.mEnvironment;
        this.mHttpConfiguration = config.mHttpConfiguration == null ? this.mHttpConfiguration : config.mHttpConfiguration;
        this.mMultipleCloudsSupported = config.mMultipleCloudsSupported == null ? this.mMultipleCloudsSupported : config.mMultipleCloudsSupported;
        this.mUseBroker = config.mUseBroker == null ? this.mUseBroker : config.mUseBroker;
        this.mTelemetryConfiguration = config.mTelemetryConfiguration == null ? this.mTelemetryConfiguration : config.mTelemetryConfiguration;
        String string = this.mRequiredBrokerProtocolVersion = config.mRequiredBrokerProtocolVersion == null ? this.mRequiredBrokerProtocolVersion : config.mRequiredBrokerProtocolVersion;
        if (this.mBrowserSafeList == null) {
            this.mBrowserSafeList = config.mBrowserSafeList;
        } else if (config.mBrowserSafeList != null) {
            this.mBrowserSafeList.addAll(config.mBrowserSafeList);
        }
        this.mAccountMode = config.mAccountMode != AccountMode.MULTIPLE ? config.mAccountMode : this.mAccountMode;
        this.mClientCapabilities = config.mClientCapabilities == null ? this.mClientCapabilities : config.mClientCapabilities;
        this.mIsSharedDevice = config.mIsSharedDevice ? this.mIsSharedDevice : config.mIsSharedDevice;
        this.mLoggerConfiguration = config.mLoggerConfiguration == null ? this.mLoggerConfiguration : config.mLoggerConfiguration;
        this.webViewZoomControlsEnabled = config.webViewZoomControlsEnabled == null || config.webViewZoomControlsEnabled != false;
        this.webViewZoomEnabled = config.webViewZoomEnabled == null || config.webViewZoomEnabled != false;
        this.powerOptCheckEnabled = config.powerOptCheckEnabled == null || config.powerOptCheckEnabled != false;
    }

    void validateConfiguration() {
        this.nullConfigurationCheck("redirect_uri", this.mRedirectUri);
        this.nullConfigurationCheck("client_id", this.mClientId);
        this.checkDefaultAuthoritySpecified();
        if (!this.mAuthorizationAgent.equals((Object)AuthorizationAgent.WEBVIEW) && (this.mBrowserSafeList == null || this.mBrowserSafeList.isEmpty())) {
            throw new IllegalArgumentException("Null browser safe list configured.");
        }
        for (Authority authority : this.mAuthorities) {
            if (authority instanceof UnknownAuthority) {
                throw new IllegalArgumentException("Unrecognized authority type -- null, invalid or unknown type specified.");
            }
            if (!(authority instanceof AzureActiveDirectoryAuthority)) continue;
            this.validateAzureActiveDirectoryAuthority((AzureActiveDirectoryAuthority)authority);
        }
    }

    private void validateAzureActiveDirectoryAuthority(@NonNull AzureActiveDirectoryAuthority azureActiveDirectoryAuthority) {
        if (null != azureActiveDirectoryAuthority.mAudience && azureActiveDirectoryAuthority.mAudience instanceof UnknownAudience) {
            throw new IllegalArgumentException("Unrecognized audience type for AzureActiveDirectoryAuthority -- null, invalid, or unknown type specified");
        }
    }

    private void nullConfigurationCheck(String configKey, String configValue) {
        if (configValue == null) {
            throw new IllegalArgumentException(configKey + " cannot be null.  Invalid configuration.");
        }
    }

    @VisibleForTesting
    public static boolean isBrokerRedirectUri(@NonNull String redirectUri, @NonNull String packageName) {
        String potentialPrefix = BROKER_REDIRECT_URI_SCHEME_AND_SEPARATOR + packageName + "/";
        return redirectUri != null && redirectUri.startsWith(potentialPrefix);
    }

    private void verifyRedirectUriWithAppSignature() throws MsalClientException {
        String packageName = this.mAppContext.getPackageName();
        try {
            PackageInfo info = this.mAppContext.getPackageManager().getPackageInfo(packageName, 64);
            for (Signature signature : info.signatures) {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA");
                messageDigest.update(signature.toByteArray());
                String signatureHash = Base64.encodeToString((byte[])messageDigest.digest(), (int)2);
                Uri.Builder builder = new Uri.Builder();
                Uri uri = builder.scheme("msauth").authority(packageName).appendPath(signatureHash).build();
                if (!this.mRedirectUri.equalsIgnoreCase(uri.toString())) continue;
                return;
            }
        }
        catch (PackageManager.NameNotFoundException | NoSuchAlgorithmException e) {
            Logger.error((String)TAG, (String)"Unexpected error in verifyRedirectUriWithAppSignature()", (Throwable)e);
        }
        throw new MsalClientException("redirect_uri_validation_error", "The redirect URI in the configuration file doesn't match with the one generated with package name and signature hash. Please verify the uri in the config file and your app registration in Azure portal.");
    }

    public void checkIntentFilterAddedToAppManifestForBrokerFlow() throws MsalClientException {
        boolean hasCustomTabRedirectActivity = MsalUtils.hasCustomTabRedirectActivity(this.mAppContext, this.mRedirectUri);
        if (!(this.getAuthorizationAgent() != AuthorizationAgent.DEFAULT && this.getAuthorizationAgent() != AuthorizationAgent.BROWSER || hasCustomTabRedirectActivity)) {
            Uri redirectUri = Uri.parse((String)this.mRedirectUri);
            throw new MsalClientException("app_manifest_validation_error", "Intent filter for: " + BrowserTabActivity.class.getSimpleName() + " is missing.  Please make sure you have the following activity in your AndroidManifest.xml \n\n<activity android:name=\"com.microsoft.identity.client.BrowserTabActivity\">\n\t<intent-filter>\n\t\t<action android:name=\"android.intent.action.VIEW\" />\n\t\t<category android:name=\"android.intent.category.DEFAULT\" />\n\t\t<category android:name=\"android.intent.category.BROWSABLE\" />\n\t\t<data\n\t\t\tandroid:host=\"" + redirectUri.getHost() + "\"\n\t\t\tandroid:path=\"" + redirectUri.getPath() + "\"\n\t\t\tandroid:scheme=\"" + redirectUri.getScheme() + "\" />\n\t</intent-filter>\n</activity>\n");
        }
        if (!this.mUseBroker.booleanValue()) {
            return;
        }
        if (!PublicClientApplicationConfiguration.isBrokerRedirectUri(this.mRedirectUri, this.mAppContext.getPackageName())) {
            Logger.warn((String)TAG, (String)"The app is still using legacy MSAL redirect uri. Switch to MSAL local auth.  For brokered auth, the redirect URI is expected to conform to 'msauth://<authority>/.*' where the authority in that uri is the package name of the app. This package name is listed as 'applicationId' in the build.gradle file.");
            this.mUseBroker = false;
            return;
        }
        this.verifyRedirectUriWithAppSignature();
    }

    public static final class SerializedNames {
        static final String CLIENT_ID = "client_id";
        static final String REDIRECT_URI = "redirect_uri";
        static final String AUTHORITIES = "authorities";
        static final String AUTHORIZATION_USER_AGENT = "authorization_user_agent";
        static final String HTTP = "http";
        static final String LOGGING = "logging";
        static final String MULTIPLE_CLOUDS_SUPPORTED = "multiple_clouds_supported";
        static final String USE_BROKER = "broker_redirect_uri_registered";
        static final String ENVIRONMENT = "environment";
        static final String REQUIRED_BROKER_PROTOCOL_VERSION = "minimum_required_broker_protocol_version";
        static final String TELEMETRY = "telemetry";
        static final String BROWSER_SAFE_LIST = "browser_safelist";
        static final String ACCOUNT_MODE = "account_mode";
        static final String CLIENT_CAPABILITIES = "client_capabilities";
        static final String WEB_VIEW_ZOOM_CONTROLS_ENABLED = "web_view_zoom_controls_enabled";
        static final String WEB_VIEW_ZOOM_ENABLED = "web_view_zoom_enabled";
        static final String POWER_OPT_CHECK_FOR_NETWORK_REQUEST_ENABLED = "power_opt_check_for_network_req_enabled";
    }
}

