/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.oauth2.OpenIdConnectPromptParameter;

public enum Prompt {
    SELECT_ACCOUNT,
    LOGIN,
    CONSENT,
    WHEN_REQUIRED;


    public String toString() {
        switch (this) {
            case SELECT_ACCOUNT: {
                return SELECT_ACCOUNT.name().toLowerCase();
            }
            case LOGIN: {
                return LOGIN.name().toLowerCase();
            }
            case CONSENT: {
                return CONSENT.name().toLowerCase();
            }
            case WHEN_REQUIRED: {
                return WHEN_REQUIRED.name().toLowerCase();
            }
        }
        throw new IllegalArgumentException();
    }

    public OpenIdConnectPromptParameter toOpenIdConnectPromptParameter() {
        String tag = Prompt.class.getSimpleName() + ":toOpenIdConnectPromptParameter";
        switch (this) {
            case SELECT_ACCOUNT: {
                return OpenIdConnectPromptParameter.SELECT_ACCOUNT;
            }
            case LOGIN: {
                return OpenIdConnectPromptParameter.LOGIN;
            }
            case CONSENT: {
                return OpenIdConnectPromptParameter.CONSENT;
            }
            case WHEN_REQUIRED: {
                String error = "WHEN_REQUIRED Does not have corresponding value in in the OIDC prompt enumeration.  It's meant to convey do not sent the prompt parameter.";
                Logger.info((String)tag, (String)error);
                throw new UnsupportedOperationException(error);
            }
        }
        return OpenIdConnectPromptParameter.SELECT_ACCOUNT;
    }
}

