/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.app.Activity;
import android.util.Pair;
import androidx.fragment.app.Fragment;
import com.microsoft.identity.client.AuthenticationCallback;
import com.microsoft.identity.client.Prompt;
import com.microsoft.identity.client.TokenParameters;
import java.util.List;

public class AcquireTokenParameters
extends TokenParameters {
    private Activity mActivity;
    private Fragment mFragment;
    private String mLoginHint;
    private Prompt mPrompt;
    private List<String> mExtraScopesToConsent;
    private List<Pair<String, String>> mExtraQueryStringParameters;
    private AuthenticationCallback mCallback;

    public AcquireTokenParameters(Builder builder) {
        super(builder);
        this.mActivity = builder.mActivity;
        this.mFragment = builder.mFragment;
        this.mLoginHint = builder.mLoginHint;
        this.mPrompt = builder.mPrompt;
        this.mExtraScopesToConsent = builder.mExtraScopesToConsent;
        this.mExtraQueryStringParameters = builder.mExtraQueryStringParameters;
        this.mCallback = builder.mCallback;
    }

    public Activity getActivity() {
        return this.mActivity;
    }

    public Fragment getFragment() {
        return this.mFragment;
    }

    public String getLoginHint() {
        return this.mLoginHint;
    }

    void setLoginHint(String loginHint) {
        this.mLoginHint = loginHint;
    }

    public Prompt getPrompt() {
        return this.mPrompt;
    }

    public List<String> getExtraScopesToConsent() {
        return this.mExtraScopesToConsent;
    }

    public List<Pair<String, String>> getExtraQueryStringParameters() {
        return this.mExtraQueryStringParameters;
    }

    public AuthenticationCallback getCallback() {
        return this.mCallback;
    }

    public static class Builder
    extends TokenParameters.Builder<Builder> {
        private Activity mActivity;
        private Fragment mFragment;
        private String mLoginHint;
        private Prompt mPrompt;
        private List<String> mExtraScopesToConsent;
        private List<Pair<String, String>> mExtraQueryStringParameters;
        private AuthenticationCallback mCallback;

        public Builder startAuthorizationFromActivity(Activity activity) {
            this.mActivity = activity;
            return this.self();
        }

        public Builder withFragment(Fragment fragment) {
            this.mFragment = fragment;
            return this.self();
        }

        public Builder withLoginHint(String loginHint) {
            this.mLoginHint = loginHint;
            return this.self();
        }

        public Builder withPrompt(Prompt prompt) {
            this.mPrompt = prompt;
            return this.self();
        }

        public Builder withOtherScopesToAuthorize(List<String> scopes) {
            this.mExtraScopesToConsent = scopes;
            return this.self();
        }

        public Builder withAuthorizationQueryStringParameters(List<Pair<String, String>> parameters) {
            this.mExtraQueryStringParameters = parameters;
            return this.self();
        }

        public Builder withCallback(AuthenticationCallback authenticationCallback) {
            this.mCallback = authenticationCallback;
            return this.self();
        }

        @Override
        public Builder self() {
            return this;
        }

        @Override
        public AcquireTokenParameters build() {
            return new AcquireTokenParameters(this);
        }
    }
}

