/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.controllers;

import android.accounts.AccountManager;
import android.accounts.AuthenticatorDescription;
import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.os.PowerManager;
import androidx.annotation.NonNull;
import com.microsoft.identity.client.PublicClientApplicationConfiguration;
import com.microsoft.identity.client.exception.MsalClientException;
import com.microsoft.identity.client.internal.controllers.BrokerMsalController;
import com.microsoft.identity.client.internal.controllers.LocalMSALController;
import com.microsoft.identity.common.internal.authorities.AnyPersonalAccount;
import com.microsoft.identity.common.internal.authorities.Authority;
import com.microsoft.identity.common.internal.authorities.AzureActiveDirectoryAuthority;
import com.microsoft.identity.common.internal.broker.BrokerValidator;
import com.microsoft.identity.common.internal.controllers.BaseController;
import com.microsoft.identity.common.internal.logging.Logger;
import java.util.ArrayList;
import java.util.List;

public class MSALControllerFactory {
    private static final String TAG = MSALControllerFactory.class.getName();

    public static BaseController getDefaultController(@NonNull Context applicationContext, @NonNull Authority authority, @NonNull PublicClientApplicationConfiguration applicationConfiguration) throws MsalClientException {
        if (MSALControllerFactory.brokerEligible(applicationContext, authority, applicationConfiguration)) {
            return new BrokerMsalController(applicationContext);
        }
        return new LocalMSALController();
    }

    public static List<BaseController> getAllControllers(@NonNull Context applicationContext, @NonNull Authority authority, @NonNull PublicClientApplicationConfiguration applicationConfiguration) throws MsalClientException {
        ArrayList<BaseController> controllers = new ArrayList<BaseController>();
        controllers.add(new LocalMSALController());
        if (MSALControllerFactory.brokerEligible(applicationContext, authority, applicationConfiguration)) {
            controllers.add(new BrokerMsalController(applicationContext));
        }
        return controllers;
    }

    public static boolean brokerEligible(@NonNull Context applicationContext, @NonNull Authority authority, @NonNull PublicClientApplicationConfiguration applicationConfiguration) throws MsalClientException {
        String methodName = ":brokerEligible";
        String logBrokerEligibleFalse = "Eligible to call broker? [false]. ";
        if (!applicationConfiguration.getUseBroker().booleanValue() || !(authority instanceof AzureActiveDirectoryAuthority)) {
            Logger.verbose((String)(TAG + ":brokerEligible"), (String)"Eligible to call broker? [false]. App does not ask for Broker or the authority is not AAD authority.");
            return false;
        }
        AzureActiveDirectoryAuthority azureActiveDirectoryAuthority = (AzureActiveDirectoryAuthority)authority;
        if (azureActiveDirectoryAuthority.getAudience() instanceof AnyPersonalAccount) {
            Logger.verbose((String)(TAG + ":brokerEligible"), (String)"Eligible to call broker? [false]. The audience is MSA only.");
            return false;
        }
        if (!MSALControllerFactory.brokerInstalled(applicationContext)) {
            Logger.verbose((String)(TAG + ":brokerEligible"), (String)"Eligible to call broker? [false]. Broker application is not installed.");
            return false;
        }
        if (MSALControllerFactory.powerOptimizationEnabled(applicationContext)) {
            Logger.verbose((String)(TAG + ":brokerEligible"), (String)"Is the power optimization enabled? [true]");
        }
        return true;
    }

    @TargetApi(value=23)
    private static boolean powerOptimizationEnabled(@NonNull Context applicationContext) {
        String methodName = ":powerOptimizationEnabled";
        String packageName = applicationContext.getPackageName();
        PowerManager pm = (PowerManager)applicationContext.getSystemService("power");
        if (Build.VERSION.SDK_INT >= 23 && null != pm) {
            boolean isPowerOptimizationOn = !pm.isIgnoringBatteryOptimizations(packageName);
            Logger.verbose((String)(TAG + ":powerOptimizationEnabled"), (String)("Is power optimization on? [" + isPowerOptimizationOn + "]"));
            return isPowerOptimizationOn;
        }
        Logger.verbose((String)(TAG + ":powerOptimizationEnabled"), (String)"Is power optimization on? [false]");
        return false;
    }

    protected static boolean brokerInstalled(@NonNull Context applicationContext) {
        AuthenticatorDescription[] authenticators;
        BrokerValidator brokerValidator = new BrokerValidator(applicationContext);
        AccountManager accountManager = AccountManager.get((Context)applicationContext);
        for (AuthenticatorDescription authenticator : authenticators = accountManager.getAuthenticatorTypes()) {
            if (!authenticator.type.equals("com.microsoft.workaccount") || !brokerValidator.verifySignature(authenticator.packageName)) continue;
            return true;
        }
        return false;
    }
}

