/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.controllers;

import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ProviderInfo;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.microsoft.identity.client.exception.BrokerCommunicationException;
import com.microsoft.identity.client.exception.MsalClientException;
import com.microsoft.identity.client.internal.controllers.BrokerAccountManagerStrategy;
import com.microsoft.identity.client.internal.controllers.BrokerActivity;
import com.microsoft.identity.client.internal.controllers.BrokerAuthServiceStrategy;
import com.microsoft.identity.client.internal.controllers.BrokerBaseStrategy;
import com.microsoft.identity.client.internal.controllers.BrokerContentProviderStrategy;
import com.microsoft.identity.common.BaseAccount;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.exception.ServiceException;
import com.microsoft.identity.common.internal.broker.BrokerResult;
import com.microsoft.identity.common.internal.broker.BrokerResultFuture;
import com.microsoft.identity.common.internal.broker.BrokerValidator;
import com.microsoft.identity.common.internal.broker.MicrosoftAuthClient;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.cache.MsalOAuth2TokenCache;
import com.microsoft.identity.common.internal.commands.parameters.CommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.RemoveAccountCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.internal.controllers.BaseController;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftRefreshToken;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAccount;
import com.microsoft.identity.common.internal.providers.oauth2.IDToken;
import com.microsoft.identity.common.internal.providers.oauth2.RefreshToken;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.result.MsalBrokerResultAdapter;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.ApiEndEvent;
import com.microsoft.identity.common.internal.telemetry.events.ApiStartEvent;
import com.microsoft.identity.common.internal.telemetry.events.BaseEvent;
import com.microsoft.identity.common.internal.util.AccountManagerUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class BrokerMsalController
extends BaseController {
    private static final String TAG = BrokerMsalController.class.getSimpleName();
    private BrokerResultFuture mBrokerResultFuture;
    private Context mApplicationContext;

    public BrokerMsalController(Context applicationContext) {
        this.mApplicationContext = applicationContext;
    }

    public AcquireTokenResult acquireToken(InteractiveTokenCommandParameters parameters) throws Exception {
        AcquireTokenResult result;
        Telemetry.emit((BaseEvent)new ApiStartEvent().putProperties((CommandParameters)parameters).putApiId("201"));
        this.mBrokerResultFuture = new BrokerResultFuture();
        Intent interactiveRequestIntent = this.getBrokerAuthorizationIntent(parameters);
        Intent brokerActivityIntent = new Intent(parameters.getAndroidApplicationContext(), BrokerActivity.class);
        brokerActivityIntent.putExtra("broker_intent", (Parcelable)interactiveRequestIntent);
        this.mBrokerResultFuture = new BrokerResultFuture();
        parameters.getActivity().startActivity(brokerActivityIntent);
        Bundle resultBundle = this.mBrokerResultFuture.get();
        this.saveMsaAccountToCache(resultBundle, (MsalOAuth2TokenCache)parameters.getOAuth2TokenCache());
        try {
            result = new MsalBrokerResultAdapter().getAcquireTokenResultFromResultBundle(resultBundle);
        }
        catch (BaseException e) {
            Telemetry.emit((BaseEvent)new ApiEndEvent().putException((Exception)((Object)e)).putApiId("201"));
            throw e;
        }
        Telemetry.emit((BaseEvent)new ApiEndEvent().putResult(result).putApiId("201"));
        return result;
    }

    private <T extends CommandParameters, U> U invokeBrokerOperation(@NonNull T parameters, @NonNull BrokerOperationInfo<T, U> strategyTask) throws Exception {
        if (strategyTask.getTelemetryApiId() != null) {
            Telemetry.emit((BaseEvent)new ApiStartEvent().putProperties(parameters).putApiId(strategyTask.getTelemetryApiId()));
        }
        List<BrokerBaseStrategy> strategies = this.getStrategies();
        Object result = null;
        Object lastCaughtException = null;
        for (int ii = 0; ii < strategies.size(); ++ii) {
            BrokerBaseStrategy strategy = strategies.get(ii);
            try {
                Logger.info((String)(TAG + strategyTask.getMethodName()), (String)("Executing with broker strategy: " + strategy.getClass().getSimpleName()));
                String negotiatedBrokerProtocolVersion = strategy.hello(parameters);
                result = strategyTask.perform(strategy, parameters, negotiatedBrokerProtocolVersion);
                if (result == null) continue;
                break;
            }
            catch (BrokerCommunicationException communicationException) {
                lastCaughtException = communicationException;
                continue;
            }
            catch (BaseException exception) {
                if (strategyTask.getTelemetryApiId() != null) {
                    Telemetry.emit((BaseEvent)new ApiEndEvent().putException((Exception)((Object)exception)).putApiId(strategyTask.getTelemetryApiId()));
                }
                throw exception;
            }
            catch (Exception exception) {
                lastCaughtException = exception;
            }
        }
        if (result == null) {
            MsalClientException exception = new MsalClientException("Failed to bind the service in broker app", "Unable to connect to the broker", (Throwable)lastCaughtException);
            if (strategyTask.getTelemetryApiId() != null) {
                Telemetry.emit((BaseEvent)new ApiEndEvent().putException((Exception)((Object)exception)).putApiId(strategyTask.getTelemetryApiId()));
            }
            throw exception;
        }
        if (strategyTask.getTelemetryApiId() != null) {
            ApiEndEvent successEvent = new ApiEndEvent().putApiId(strategyTask.getTelemetryApiId()).isApiCallSuccessful(Boolean.TRUE);
            strategyTask.putValueInSuccessEvent(successEvent, result);
            Telemetry.emit((BaseEvent)successEvent);
        }
        return result;
    }

    private List<BrokerBaseStrategy> getStrategies() {
        ArrayList<BrokerBaseStrategy> strategies = new ArrayList<BrokerBaseStrategy>();
        StringBuilder sb = new StringBuilder(100);
        sb.append("Broker Strategies added : ");
        if (this.isBrokerContentProviderAvailable()) {
            sb.append("ContentProviderStrategy, ");
            strategies.add(new BrokerContentProviderStrategy());
        }
        if (this.isMicrosoftAuthServiceSupported()) {
            sb.append("AuthServiceStrategy, ");
            strategies.add(new BrokerAuthServiceStrategy());
        }
        if (AccountManagerUtil.canUseAccountManagerOperation((Context)this.mApplicationContext)) {
            sb.append("AccountManagerStrategy.");
            strategies.add(new BrokerAccountManagerStrategy());
        }
        Logger.info((String)TAG, (String)sb.toString());
        return strategies;
    }

    private Intent getBrokerAuthorizationIntent(@NonNull InteractiveTokenCommandParameters parameters) throws Exception {
        return this.invokeBrokerOperation(parameters, new BrokerOperationInfo<InteractiveTokenCommandParameters, Intent>(){

            @Override
            @Nullable
            public Intent perform(@NonNull BrokerBaseStrategy strategy, @NonNull InteractiveTokenCommandParameters parameters, @Nullable String negotiatedBrokerProtocolVersion) throws BaseException, InterruptedException, ExecutionException, RemoteException {
                return strategy.getBrokerAuthorizationIntent(parameters, negotiatedBrokerProtocolVersion);
            }

            @Override
            public String getMethodName() {
                return ":getBrokerAuthorizationIntent";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return null;
            }

            @Override
            public void putValueInSuccessEvent(ApiEndEvent event, Intent result) {
            }
        });
    }

    public void completeAcquireToken(int requestCode, int resultCode, Intent data) {
        Telemetry.emit((BaseEvent)new ApiStartEvent().putApiId("202").put("Microsoft.MSAL.result_code", String.valueOf(resultCode)).put("Microsoft.MSAL.request_code", String.valueOf(requestCode)));
        this.mBrokerResultFuture.setResultBundle(data.getExtras());
        Telemetry.emit((BaseEvent)new ApiEndEvent().putApiId("202"));
    }

    public AcquireTokenResult acquireTokenSilent(SilentTokenCommandParameters parameters) throws Exception {
        return this.invokeBrokerOperation(parameters, new BrokerOperationInfo<SilentTokenCommandParameters, AcquireTokenResult>(){

            @Override
            @Nullable
            public AcquireTokenResult perform(@NonNull BrokerBaseStrategy strategy, @NonNull SilentTokenCommandParameters parameters, @Nullable String negotiatedBrokerProtocolVersion) throws BaseException, InterruptedException, ExecutionException, RemoteException {
                return strategy.acquireTokenSilent(parameters, negotiatedBrokerProtocolVersion);
            }

            @Override
            public String getMethodName() {
                return ":acquireTokenSilent";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return "203";
            }

            @Override
            public void putValueInSuccessEvent(ApiEndEvent event, AcquireTokenResult result) {
                event.putResult(result);
            }
        });
    }

    public List<ICacheRecord> getAccounts(@NonNull CommandParameters parameters) throws Exception {
        return this.invokeBrokerOperation(parameters, new BrokerOperationInfo<CommandParameters, List<ICacheRecord>>(){

            @Override
            @Nullable
            public List<ICacheRecord> perform(@NonNull BrokerBaseStrategy strategy, @NonNull CommandParameters parameters, @Nullable String negotiatedBrokerProtocolVersion) throws RemoteException, InterruptedException, ExecutionException, AuthenticatorException, IOException, OperationCanceledException, BaseException {
                return strategy.getBrokerAccounts(parameters, negotiatedBrokerProtocolVersion);
            }

            @Override
            public String getMethodName() {
                return ":getBrokerAccounts";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return "206";
            }

            @Override
            public void putValueInSuccessEvent(ApiEndEvent event, List<ICacheRecord> result) {
                event.put("Microsoft.MSAL.accounts_number", Integer.toString(result.size()));
            }
        });
    }

    @WorkerThread
    public boolean removeAccount(@NonNull RemoveAccountCommandParameters parameters) throws Exception {
        return this.invokeBrokerOperation(parameters, new BrokerOperationInfo<RemoveAccountCommandParameters, Boolean>(){

            @Override
            @Nullable
            public Boolean perform(@NonNull BrokerBaseStrategy strategy, @NonNull RemoveAccountCommandParameters parameters, @Nullable String negotiatedBrokerProtocolVersion) throws InterruptedException, ExecutionException, BaseException, RemoteException {
                strategy.removeBrokerAccount(parameters, negotiatedBrokerProtocolVersion);
                return true;
            }

            @Override
            public String getMethodName() {
                return ":removeAccount";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return "207";
            }

            @Override
            public void putValueInSuccessEvent(ApiEndEvent event, Boolean result) {
            }
        });
    }

    @WorkerThread
    public boolean getDeviceMode(@NonNull CommandParameters parameters) throws Exception {
        return this.invokeBrokerOperation(parameters, new BrokerOperationInfo<CommandParameters, Boolean>(){

            @Override
            @Nullable
            public Boolean perform(@NonNull BrokerBaseStrategy strategy, @NonNull CommandParameters parameters, @Nullable String negotiatedBrokerProtocolVersion) throws Exception {
                return strategy.getDeviceMode(parameters, negotiatedBrokerProtocolVersion);
            }

            @Override
            public String getMethodName() {
                return ":getDeviceMode";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return "204";
            }

            @Override
            public void putValueInSuccessEvent(ApiEndEvent event, Boolean result) {
                event.put("Microsoft.MSAL.is_device_shared", Boolean.toString(result));
            }
        });
    }

    public List<ICacheRecord> getCurrentAccount(CommandParameters parameters) throws Exception {
        String methodName = ":getCurrentAccount";
        if (!parameters.isSharedDevice()) {
            Logger.verbose((String)(TAG + ":getCurrentAccount"), (String)"Not a shared device, invoke getAccounts() instead of getCurrentAccount()");
            return this.getAccounts(parameters);
        }
        return this.invokeBrokerOperation(parameters, new BrokerOperationInfo<CommandParameters, List<ICacheRecord>>(){

            @Override
            @Nullable
            public List<ICacheRecord> perform(@NonNull BrokerBaseStrategy strategy, @NonNull CommandParameters parameters, @Nullable String negotiatedBrokerProtocolVersion) throws Exception {
                return strategy.getCurrentAccountInSharedDevice(parameters, negotiatedBrokerProtocolVersion);
            }

            @Override
            public String getMethodName() {
                return ":getCurrentAccount";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return "205";
            }

            @Override
            public void putValueInSuccessEvent(ApiEndEvent event, List<ICacheRecord> result) {
                event.put("Microsoft.MSAL.accounts_number", Integer.toString(result.size()));
            }
        });
    }

    public boolean removeCurrentAccount(RemoveAccountCommandParameters parameters) throws Exception {
        String methodName = ":removeCurrentAccount";
        if (!parameters.isSharedDevice()) {
            Logger.verbose((String)(TAG + ":removeCurrentAccount"), (String)"Not a shared device, invoke removeAccount() instead of removeCurrentAccount()");
            return this.removeAccount(parameters);
        }
        return this.invokeBrokerOperation(parameters, new BrokerOperationInfo<RemoveAccountCommandParameters, Boolean>(){

            @Override
            @Nullable
            public Boolean perform(@NonNull BrokerBaseStrategy strategy, @NonNull RemoveAccountCommandParameters parameters, @Nullable String negotiatedBrokerProtocolVersion) throws InterruptedException, ExecutionException, BaseException, RemoteException {
                strategy.signOutFromSharedDevice(parameters, negotiatedBrokerProtocolVersion);
                return true;
            }

            @Override
            public String getMethodName() {
                return ":removeCurrentAccount";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return "208";
            }

            @Override
            public void putValueInSuccessEvent(ApiEndEvent event, Boolean result) {
            }
        });
    }

    private void saveMsaAccountToCache(@NonNull Bundle resultBundle, @NonNull MsalOAuth2TokenCache msalOAuth2TokenCache) throws ClientException {
        String methodName = ":saveMsaAccountToCache";
        BrokerResult brokerResult = new MsalBrokerResultAdapter().brokerResultFromBundle(resultBundle);
        if (resultBundle.getBoolean("broker_request_v2_success") && brokerResult != null && "9188040d-6c67-4c5b-b112-36a304b66dad".equalsIgnoreCase(brokerResult.getTenantId())) {
            Logger.info((String)(TAG + ":saveMsaAccountToCache"), (String)"Result returned for MSA Account, saving to cache");
            try {
                ClientInfo clientInfo = new ClientInfo(brokerResult.getClientInfo());
                MicrosoftStsAccount microsoftStsAccount = new MicrosoftStsAccount(new IDToken(brokerResult.getIdToken()), clientInfo);
                microsoftStsAccount.setEnvironment(brokerResult.getEnvironment());
                MicrosoftRefreshToken microsoftRefreshToken = new MicrosoftRefreshToken(brokerResult.getRefreshToken(), clientInfo, brokerResult.getScope(), brokerResult.getClientId(), brokerResult.getEnvironment(), brokerResult.getFamilyId());
                msalOAuth2TokenCache.setSingleSignOnState((BaseAccount)microsoftStsAccount, (RefreshToken)microsoftRefreshToken);
            }
            catch (ServiceException e) {
                Logger.errorPII((String)(TAG + ":saveMsaAccountToCache"), (String)"Exception while creating Idtoken or ClientInfo, cannot save MSA account tokens", (Throwable)e);
                throw new ClientException("invalid_jwt", e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean isMicrosoftAuthServiceSupported() {
        MicrosoftAuthClient client = new MicrosoftAuthClient(this.mApplicationContext);
        Intent microsoftAuthServiceIntent = client.getIntentForAuthService(this.mApplicationContext);
        return null != microsoftAuthServiceIntent;
    }

    private boolean isBrokerContentProviderAvailable() {
        String activeBrokerPackageName = new BrokerValidator(this.mApplicationContext).getCurrentActiveBrokerPackageName();
        String brokerContentProviderAuthority = activeBrokerPackageName + "." + "microsoft.identity.broker";
        List providers = this.mApplicationContext.getPackageManager().queryContentProviders(null, 0, 0);
        for (ProviderInfo providerInfo : providers) {
            if (providerInfo.authority == null || !providerInfo.authority.equals(brokerContentProviderAuthority)) continue;
            return true;
        }
        return false;
    }

    private static interface BrokerOperationInfo<T extends CommandParameters, U> {
        @Nullable
        public U perform(BrokerBaseStrategy var1, T var2, String var3) throws Exception;

        public String getMethodName();

        @Nullable
        public String getTelemetryApiId();

        public void putValueInSuccessEvent(ApiEndEvent var1, U var2);
    }
}

