/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.controllers;

import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.client.exception.BrokerCommunicationException;
import com.microsoft.identity.client.internal.controllers.BrokerBaseStrategy;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.internal.broker.BrokerValidator;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.commands.parameters.CommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.RemoveAccountCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.BaseEvent;
import com.microsoft.identity.common.internal.telemetry.events.BrokerEndEvent;
import com.microsoft.identity.common.internal.telemetry.events.BrokerStartEvent;
import com.microsoft.identity.common.internal.util.ParcelableUtil;
import java.util.List;

public class BrokerContentProviderStrategy
extends BrokerBaseStrategy {
    private static final String TAG = BrokerContentProviderStrategy.class.getName();

    private <T extends CommandParameters, U> U performContentProviderOperation(@NonNull T parameters, @NonNull ContentProviderOperation<T, U> contentProviderOperation) throws BaseException {
        Cursor cursor;
        String methodName = contentProviderOperation.getMethodName();
        Telemetry.emit((BaseEvent)new BrokerStartEvent().putAction(methodName).putStrategy("content_provider"));
        Uri uri = this.getContentProviderURI(parameters.getAndroidApplicationContext(), contentProviderOperation.getUriPath());
        Logger.info((String)(TAG + methodName), (String)("Request to BrokerContentProvider for uri path " + contentProviderOperation.getUriPath()));
        String marshalledRequestString = null;
        Bundle requestBundle = contentProviderOperation.getRequestBundle(parameters);
        if (requestBundle != null) {
            byte[] marshalledBytes = ParcelableUtil.marshall((Parcelable)requestBundle);
            marshalledRequestString = Base64.encodeToString((byte[])marshalledBytes, (int)0);
        }
        if ((cursor = parameters.getAndroidApplicationContext().getContentResolver().query(uri, null, marshalledRequestString, null, null)) != null) {
            U result = contentProviderOperation.getResultFromBundle(cursor.getExtras());
            cursor.close();
            Telemetry.emit((BaseEvent)new BrokerEndEvent().putAction(methodName).isSuccessful(true));
            Logger.info((String)(TAG + methodName), (String)"Received successful result from broker");
            return result;
        }
        String message = "Failed to get result from Broker Content Provider, cursor is null";
        Logger.error((String)(TAG + methodName), (String)"Failed to get result from Broker Content Provider, cursor is null", null);
        Telemetry.emit((BaseEvent)new BrokerEndEvent().putAction(methodName).isSuccessful(false).putErrorDescription("Failed to get result from Broker Content Provider, cursor is null"));
        throw new BrokerCommunicationException("Failed to get result from Broker Content Provider, cursor is null", null);
    }

    @Override
    String hello(@NonNull CommandParameters parameters) throws BaseException {
        String methodName = "helloWithContentProvider";
        return this.performContentProviderOperation(parameters, new ContentProviderOperation<CommandParameters, String>(){

            @Override
            public Bundle getRequestBundle(CommandParameters parameters) {
                return BrokerContentProviderStrategy.this.mRequestAdapter.getRequestBundleForHello(parameters);
            }

            @Override
            public String getMethodName() {
                return "helloWithContentProvider";
            }

            @Override
            public String getUriPath() {
                return "/hello";
            }

            @Override
            public String getResultFromBundle(Bundle resultBundle) throws BaseException {
                return BrokerContentProviderStrategy.this.mResultAdapter.verifyHelloFromResultBundle(resultBundle);
            }
        });
    }

    @Override
    Intent getBrokerAuthorizationIntent(final @NonNull InteractiveTokenCommandParameters parameters, final @Nullable String negotiatedBrokerProtocolVersion) throws BaseException {
        String methodName = "getBrokerAuthorizationIntentForContentProvider";
        return this.performContentProviderOperation(parameters, new ContentProviderOperation<InteractiveTokenCommandParameters, Intent>(){

            @Override
            public Bundle getRequestBundle(InteractiveTokenCommandParameters parameters2) {
                return null;
            }

            @Override
            public String getMethodName() {
                return "getBrokerAuthorizationIntentForContentProvider";
            }

            @Override
            public String getUriPath() {
                return "/acquireTokenInteractive";
            }

            @Override
            public Intent getResultFromBundle(Bundle resultBundle) throws BaseException {
                return BrokerContentProviderStrategy.this.mRequestAdapter.getRequestIntentForAcquireTokenInteractive(resultBundle, parameters, negotiatedBrokerProtocolVersion);
            }
        });
    }

    @Override
    AcquireTokenResult acquireTokenSilent(@NonNull SilentTokenCommandParameters parameters, final @Nullable String negotiatedBrokerProtocolVersion) throws BaseException {
        String methodName = "acquireTokenSilentWithContentProvider";
        return this.performContentProviderOperation(parameters, new ContentProviderOperation<SilentTokenCommandParameters, AcquireTokenResult>(){

            @Override
            @Nullable
            public Bundle getRequestBundle(SilentTokenCommandParameters parameters) {
                return BrokerContentProviderStrategy.this.mRequestAdapter.getRequestBundleForAcquireTokenSilent(parameters, negotiatedBrokerProtocolVersion);
            }

            @Override
            @NonNull
            public String getMethodName() {
                return "acquireTokenSilentWithContentProvider";
            }

            @Override
            @NonNull
            public String getUriPath() {
                return "/acquireTokenSilent";
            }

            @Override
            @NonNull
            public AcquireTokenResult getResultFromBundle(Bundle resultBundle) throws BaseException {
                return BrokerContentProviderStrategy.this.mResultAdapter.getAcquireTokenResultFromResultBundle(resultBundle);
            }
        });
    }

    @Override
    List<ICacheRecord> getBrokerAccounts(@NonNull CommandParameters parameters, final @Nullable String negotiatedBrokerProtocolVersion) throws BaseException {
        String methodName = "getBrokerAccountsWithContentProvider";
        return this.performContentProviderOperation(parameters, new ContentProviderOperation<CommandParameters, List<ICacheRecord>>(){

            @Override
            @Nullable
            public Bundle getRequestBundle(CommandParameters parameters) {
                return BrokerContentProviderStrategy.this.mRequestAdapter.getRequestBundleForGetAccounts(parameters, negotiatedBrokerProtocolVersion);
            }

            @Override
            @NonNull
            public String getMethodName() {
                return "getBrokerAccountsWithContentProvider";
            }

            @Override
            @NonNull
            public String getUriPath() {
                return "/getAccounts";
            }

            @Override
            @NonNull
            public List<ICacheRecord> getResultFromBundle(Bundle resultBundle) throws BaseException {
                return BrokerContentProviderStrategy.this.mResultAdapter.getAccountsFromResultBundle(resultBundle);
            }
        });
    }

    @Override
    void removeBrokerAccount(@NonNull RemoveAccountCommandParameters parameters, final @Nullable String negotiatedBrokerProtocolVersion) throws BaseException {
        String methodName = "removeBrokerAccountWithContentProvider";
        this.performContentProviderOperation(parameters, new ContentProviderOperation<RemoveAccountCommandParameters, Void>(){

            @Override
            @Nullable
            public Bundle getRequestBundle(RemoveAccountCommandParameters parameters) {
                return BrokerContentProviderStrategy.this.mRequestAdapter.getRequestBundleForRemoveAccount(parameters, negotiatedBrokerProtocolVersion);
            }

            @Override
            @NonNull
            public String getMethodName() {
                return "removeBrokerAccountWithContentProvider";
            }

            @Override
            @NonNull
            public String getUriPath() {
                return "/removeAccounts";
            }

            @Override
            @NonNull
            public Void getResultFromBundle(Bundle resultBundle) throws BaseException {
                BrokerContentProviderStrategy.this.mResultAdapter.verifyRemoveAccountResultFromBundle(resultBundle);
                return null;
            }
        });
    }

    @Override
    boolean getDeviceMode(@NonNull CommandParameters parameters, @Nullable String negotiatedBrokerProtocolVersion) throws BaseException {
        String methodName = "getDeviceModeWithContentProvider";
        return this.performContentProviderOperation(parameters, new ContentProviderOperation<CommandParameters, Boolean>(){

            @Override
            @Nullable
            public Bundle getRequestBundle(CommandParameters parameters) {
                return null;
            }

            @Override
            @NonNull
            public String getMethodName() {
                return "getDeviceModeWithContentProvider";
            }

            @Override
            @NonNull
            public String getUriPath() {
                return "/getDeviceMode";
            }

            @Override
            @NonNull
            public Boolean getResultFromBundle(Bundle resultBundle) throws BaseException {
                return BrokerContentProviderStrategy.this.mResultAdapter.getDeviceModeFromResultBundle(resultBundle);
            }
        });
    }

    @Override
    List<ICacheRecord> getCurrentAccountInSharedDevice(@NonNull CommandParameters parameters, final @Nullable String negotiatedBrokerProtocolVersion) throws BaseException {
        String method = "getCurrentAccountInSharedDeviceWithContentProvider";
        return this.performContentProviderOperation(parameters, new ContentProviderOperation<CommandParameters, List<ICacheRecord>>(){

            @Override
            @Nullable
            public Bundle getRequestBundle(CommandParameters parameters) {
                return BrokerContentProviderStrategy.this.mRequestAdapter.getRequestBundleForGetAccounts(parameters, negotiatedBrokerProtocolVersion);
            }

            @Override
            @NonNull
            public String getMethodName() {
                return "getCurrentAccountInSharedDeviceWithContentProvider";
            }

            @Override
            @NonNull
            public String getUriPath() {
                return "/getCurrentAccountSharedDevice";
            }

            @Override
            @NonNull
            public List<ICacheRecord> getResultFromBundle(Bundle resultBundle) throws BaseException {
                return BrokerContentProviderStrategy.this.mResultAdapter.getAccountsFromResultBundle(resultBundle);
            }
        });
    }

    @Override
    void signOutFromSharedDevice(@NonNull RemoveAccountCommandParameters parameters, final @Nullable String negotiatedBrokerProtocolVersion) throws BaseException {
        String methodName = "signOutFromSharedDeviceWithContentProvider";
        this.performContentProviderOperation(parameters, new ContentProviderOperation<RemoveAccountCommandParameters, Void>(){

            @Override
            @Nullable
            public Bundle getRequestBundle(RemoveAccountCommandParameters parameters) {
                return BrokerContentProviderStrategy.this.mRequestAdapter.getRequestBundleForRemoveAccountFromSharedDevice(parameters, negotiatedBrokerProtocolVersion);
            }

            @Override
            @NonNull
            public String getMethodName() {
                return "signOutFromSharedDeviceWithContentProvider";
            }

            @Override
            @NonNull
            public String getUriPath() {
                return "/signOutFromSharedDevice";
            }

            @Override
            @NonNull
            public Void getResultFromBundle(Bundle resultBundle) throws BaseException {
                BrokerContentProviderStrategy.this.mResultAdapter.verifyRemoveAccountResultFromBundle(resultBundle);
                return null;
            }
        });
    }

    private Uri getContentProviderURI(@NonNull Context context, @NonNull String path) {
        BrokerValidator brokerValidator = new BrokerValidator(context);
        String activeBrokerPackage = brokerValidator.getCurrentActiveBrokerPackageName();
        String authority = activeBrokerPackage + "." + "microsoft.identity.broker";
        return Uri.parse((String)("content://" + authority + path));
    }

    public static interface ContentProviderOperation<T extends CommandParameters, U> {
        @Nullable
        public Bundle getRequestBundle(T var1);

        @NonNull
        public String getMethodName();

        @NonNull
        public String getUriPath();

        @NonNull
        public U getResultFromBundle(Bundle var1) throws BaseException;
    }
}

