/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.controllers;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.microsoft.identity.common.internal.logging.Logger;

public final class BrokerActivity
extends Activity {
    public static final String BROKER_INTENT = "broker_intent";
    static final String BROKER_INTENT_STARTED = "broker_intent_started";
    static final int BROKER_INTENT_REQUEST_CODE = 1001;
    private static final String TAG = BrokerActivity.class.getSimpleName();
    private Intent mBrokerInteractiveRequestIntent;
    private Boolean mBrokerIntentStarted = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            this.mBrokerInteractiveRequestIntent = (Intent)this.getIntent().getExtras().getParcelable(BROKER_INTENT);
        } else {
            this.mBrokerInteractiveRequestIntent = (Intent)savedInstanceState.getParcelable(BROKER_INTENT);
            this.mBrokerIntentStarted = savedInstanceState.getBoolean(BROKER_INTENT_STARTED);
        }
    }

    protected void onResume() {
        super.onResume();
        if (!this.mBrokerIntentStarted.booleanValue()) {
            this.mBrokerIntentStarted = true;
            this.startActivityForResult(this.mBrokerInteractiveRequestIntent, 1001);
        }
    }

    protected void onStop() {
        super.onStop();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable(BROKER_INTENT, (Parcelable)this.mBrokerInteractiveRequestIntent);
        outState.putBoolean(BROKER_INTENT_STARTED, this.mBrokerIntentStarted.booleanValue());
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        String methodName = ":onActivityResult";
        Logger.info((String)(TAG + ":onActivityResult"), (String)("Result received from Broker Request code: " + requestCode + " Result code: " + requestCode));
        if (resultCode == 2004 || resultCode == 2001 || resultCode == 2002) {
            Logger.verbose((String)(TAG + ":onActivityResult"), (String)"Completing interactive request ");
            data.setAction("return_interactive_request_result");
            data.putExtra("com.microsoft.identity.client.request.code", 1001);
            data.putExtra("com.microsoft.identity.client.result.code", resultCode);
            LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).sendBroadcast(data);
        }
        this.finish();
    }
}

