/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.app.Activity;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.microsoft.identity.client.AccountAdapter;
import com.microsoft.identity.client.AcquireTokenParameters;
import com.microsoft.identity.client.AcquireTokenSilentParameters;
import com.microsoft.identity.client.AuthenticationCallback;
import com.microsoft.identity.client.CurrentAccountResult;
import com.microsoft.identity.client.IAccount;
import com.microsoft.identity.client.IAuthenticationResult;
import com.microsoft.identity.client.ICurrentAccountResult;
import com.microsoft.identity.client.ISingleAccountPublicClientApplication;
import com.microsoft.identity.client.MultiTenantAccount;
import com.microsoft.identity.client.Prompt;
import com.microsoft.identity.client.PublicClientApplication;
import com.microsoft.identity.client.PublicClientApplicationConfiguration;
import com.microsoft.identity.client.SilentAuthenticationCallback;
import com.microsoft.identity.client.TokenParameters;
import com.microsoft.identity.client.exception.MsalClientException;
import com.microsoft.identity.client.exception.MsalException;
import com.microsoft.identity.client.internal.AsyncResult;
import com.microsoft.identity.client.internal.CommandParametersAdapter;
import com.microsoft.identity.client.internal.MsalUtils;
import com.microsoft.identity.client.internal.controllers.MSALControllerFactory;
import com.microsoft.identity.client.internal.controllers.MsalExceptionAdapter;
import com.microsoft.identity.common.adal.internal.cache.IStorageHelper;
import com.microsoft.identity.common.adal.internal.cache.StorageHelper;
import com.microsoft.identity.common.adal.internal.util.JsonExtensions;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.cache.SharedPreferencesFileManager;
import com.microsoft.identity.common.internal.commands.BaseCommand;
import com.microsoft.identity.common.internal.commands.CommandCallback;
import com.microsoft.identity.common.internal.commands.GetCurrentAccountCommand;
import com.microsoft.identity.common.internal.commands.RemoveCurrentAccountCommand;
import com.microsoft.identity.common.internal.commands.parameters.CommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.RemoveAccountCommandParameters;
import com.microsoft.identity.common.internal.controllers.BaseController;
import com.microsoft.identity.common.internal.controllers.CommandDispatcher;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.migration.TokenMigrationCallback;
import com.microsoft.identity.common.internal.result.ILocalAuthenticationResult;
import com.microsoft.identity.common.internal.result.ResultFuture;
import java.util.List;

public class SingleAccountPublicClientApplication
extends PublicClientApplication
implements ISingleAccountPublicClientApplication {
    private static final String TAG = SingleAccountPublicClientApplication.class.getSimpleName();
    public static final String SINGLE_ACCOUNT_CREDENTIAL_SHARED_PREFERENCES = "com.microsoft.identity.client.single_account_credential_cache";
    public static final String CURRENT_ACCOUNT_SHARED_PREFERENCE_KEY = "com.microsoft.identity.client.single_account_credential_cache.current_account";
    private SharedPreferencesFileManager sharedPreferencesFileManager;

    protected SingleAccountPublicClientApplication(@NonNull PublicClientApplicationConfiguration config) throws MsalClientException {
        super(config);
        this.initializeSharedPreferenceFileManager(config.getAppContext());
    }

    private void initializeSharedPreferenceFileManager(@NonNull Context context) {
        this.sharedPreferencesFileManager = new SharedPreferencesFileManager(context, SINGLE_ACCOUNT_CREDENTIAL_SHARED_PREFERENCES, (IStorageHelper)new StorageHelper(context));
    }

    @Override
    public void getCurrentAccountAsync(@NonNull ISingleAccountPublicClientApplication.CurrentAccountCallback callback) {
        this.getCurrentAccountAsyncInternal(callback, "922");
    }

    private void getCurrentAccountAsyncInternal(final @NonNull ISingleAccountPublicClientApplication.CurrentAccountCallback callback, final @NonNull String publicApiId) {
        TokenMigrationCallback migrationCallback = new TokenMigrationCallback(){

            public void onMigrationFinished(int numberOfAccountsMigrated) {
                BaseController controller;
                CommandParameters params = CommandParametersAdapter.createCommandParameters(SingleAccountPublicClientApplication.this.mPublicClientConfiguration, SingleAccountPublicClientApplication.this.mPublicClientConfiguration.getOAuth2TokenCache());
                try {
                    controller = MSALControllerFactory.getDefaultController(SingleAccountPublicClientApplication.this.mPublicClientConfiguration.getAppContext(), SingleAccountPublicClientApplication.this.mPublicClientConfiguration.getDefaultAuthority(), SingleAccountPublicClientApplication.this.mPublicClientConfiguration);
                }
                catch (MsalClientException e) {
                    callback.onError(e);
                    return;
                }
                GetCurrentAccountCommand command = new GetCurrentAccountCommand(params, controller, (CommandCallback)new CommandCallback<List<ICacheRecord>, BaseException>(){

                    public void onTaskCompleted(List<ICacheRecord> result) {
                        SingleAccountPublicClientApplication.this.checkCurrentAccountNotifyCallback(callback, result);
                        SingleAccountPublicClientApplication.this.persistCurrentAccount(result);
                    }

                    public void onError(BaseException exception) {
                        callback.onError(MsalExceptionAdapter.msalExceptionFromBaseException(exception));
                    }

                    public void onCancel() {
                    }
                }, publicApiId);
                CommandDispatcher.submitSilent((BaseCommand)command);
            }
        };
        this.performMigration(migrationCallback);
    }

    @Override
    public ICurrentAccountResult getCurrentAccount() throws InterruptedException, MsalException {
        MsalUtils.throwOnMainThread("getCurrentAccount");
        final ResultFuture future = new ResultFuture();
        this.getCurrentAccountAsyncInternal(new ISingleAccountPublicClientApplication.CurrentAccountCallback(){

            @Override
            public void onAccountLoaded(@Nullable IAccount activeAccount) {
                CurrentAccountResult currentAccountResult = new CurrentAccountResult(activeAccount, null, false);
                future.setResult(new AsyncResult<CurrentAccountResult>(currentAccountResult, null));
            }

            @Override
            public void onAccountChanged(@Nullable IAccount priorAccount, @Nullable IAccount currentAccount) {
                CurrentAccountResult currentAccountResult = new CurrentAccountResult(currentAccount, priorAccount, false);
                future.setResult(new AsyncResult<CurrentAccountResult>(currentAccountResult, null));
            }

            @Override
            public void onError(@NonNull MsalException exception) {
                future.setResult(new AsyncResult<Object>(null, exception));
            }
        }, "921");
        AsyncResult result = (AsyncResult)future.get();
        if (result.getSuccess()) {
            return (ICurrentAccountResult)result.getResult();
        }
        throw result.getException();
    }

    private void checkCurrentAccountNotifyCallback(@NonNull ISingleAccountPublicClientApplication.CurrentAccountCallback callback, @Nullable List<ICacheRecord> newAccountRecords) {
        MultiTenantAccount newAccount;
        MultiTenantAccount localAccount = this.getPersistedCurrentAccount();
        MultiTenantAccount multiTenantAccount = newAccount = newAccountRecords == null ? null : this.getAccountFromICacheRecordList(newAccountRecords);
        if (!this.isHomeAccountIdMatching(localAccount, newAccount)) {
            callback.onAccountChanged(localAccount, newAccount);
        }
        callback.onAccountLoaded(newAccount);
    }

    @Override
    public void signIn(@NonNull Activity activity, @Nullable String loginHint, @NonNull String[] scopes, @NonNull AuthenticationCallback callback) {
        MultiTenantAccount persistedAccount = this.getPersistedCurrentAccount();
        if (persistedAccount != null) {
            callback.onError(new MsalClientException("invalid_parameter", "An account is already signed in."));
            return;
        }
        AcquireTokenParameters acquireTokenParameters = this.buildAcquireTokenParameters(activity, null, scopes, null, null, null, null, null, callback, loginHint, null);
        this.acquireTokenInternal(acquireTokenParameters, "123");
    }

    @Override
    public void signIn(@NonNull Activity activity, @Nullable String loginHint, @NonNull String[] scopes, @Nullable Prompt prompt, @NonNull AuthenticationCallback callback) {
        MultiTenantAccount persistedAccount = this.getPersistedCurrentAccount();
        if (persistedAccount != null) {
            callback.onError(new MsalClientException("invalid_parameter", "An account is already signed in."));
            return;
        }
        AcquireTokenParameters acquireTokenParameters = this.buildAcquireTokenParameters(activity, null, scopes, null, prompt, null, null, null, callback, loginHint, null);
        this.acquireTokenInternal(acquireTokenParameters, "130");
    }

    @Override
    public void signInAgain(@NonNull Activity activity, @NonNull String[] scopes, @Nullable Prompt prompt, @NonNull AuthenticationCallback callback) {
        MultiTenantAccount persistedCurrentAccount = this.getPersistedCurrentAccount();
        if (persistedCurrentAccount == null) {
            callback.onError(new MsalClientException("no_current_account", "There is no signed in account."));
            return;
        }
        AcquireTokenParameters acquireTokenParameters = this.buildAcquireTokenParameters(activity, null, scopes, persistedCurrentAccount, prompt, null, null, null, callback, null, null);
        this.acquireTokenInternal(acquireTokenParameters, "131");
    }

    protected CommandCallback<ILocalAuthenticationResult, BaseException> getCommandCallback(final @NonNull SilentAuthenticationCallback authenticationCallback, final @NonNull TokenParameters tokenParameters) {
        return new CommandCallback<ILocalAuthenticationResult, BaseException>(){

            public void onTaskCompleted(@NonNull ILocalAuthenticationResult localAuthenticationResult) {
                if (authenticationCallback == null) {
                    throw new IllegalStateException("callback cannot be null or empty");
                }
                SingleAccountPublicClientApplication.this.persistCurrentAccount(localAuthenticationResult.getCacheRecordWithTenantProfileData());
                SingleAccountPublicClientApplication.this.postAuthResult(localAuthenticationResult, tokenParameters, authenticationCallback);
            }

            public void onError(BaseException exception) {
                MsalException msalException = MsalExceptionAdapter.msalExceptionFromBaseException(exception);
                if (authenticationCallback == null) {
                    throw new IllegalStateException("callback cannot be null or empty");
                }
                authenticationCallback.onError(msalException);
            }

            public void onCancel() {
                if (!(authenticationCallback instanceof AuthenticationCallback)) {
                    throw new IllegalStateException("Silent requests cannot be cancelled.");
                }
                ((AuthenticationCallback)authenticationCallback).onCancel();
            }
        };
    }

    private boolean isHomeAccountIdMatching(@Nullable IAccount firstAccount, @Nullable IAccount secondAccount) {
        MultiTenantAccount firstMultiTenantAccount = firstAccount instanceof MultiTenantAccount ? (MultiTenantAccount)firstAccount : null;
        MultiTenantAccount secondMultiTenantAccount = secondAccount instanceof MultiTenantAccount ? (MultiTenantAccount)secondAccount : null;
        String firstMultiTenantAccountId = firstMultiTenantAccount == null ? "" : firstMultiTenantAccount.getHomeAccountId();
        String secondMultiTenantAccountId = secondMultiTenantAccount == null ? "" : secondMultiTenantAccount.getHomeAccountId();
        return firstMultiTenantAccountId.equalsIgnoreCase(secondMultiTenantAccountId);
    }

    @Override
    public void signOut(@NonNull ISingleAccountPublicClientApplication.SignOutCallback callback) {
        this.signOutInternal(callback, "928");
    }

    void signOutInternal(final @NonNull ISingleAccountPublicClientApplication.SignOutCallback callback, @NonNull String publicApiId) {
        BaseController controller;
        MultiTenantAccount persistedCurrentAccount = this.getPersistedCurrentAccount();
        if (persistedCurrentAccount == null) {
            callback.onError(new MsalClientException("no_current_account", "There is no signed in account."));
            return;
        }
        AccountRecord requestAccountRecord = new AccountRecord();
        requestAccountRecord.setEnvironment(persistedCurrentAccount.getEnvironment());
        requestAccountRecord.setHomeAccountId(persistedCurrentAccount.getHomeAccountId());
        RemoveAccountCommandParameters params = CommandParametersAdapter.createRemoveAccountCommandParameters(this.mPublicClientConfiguration, this.mPublicClientConfiguration.getOAuth2TokenCache(), requestAccountRecord);
        try {
            controller = MSALControllerFactory.getDefaultController(this.mPublicClientConfiguration.getAppContext(), this.mPublicClientConfiguration.getDefaultAuthority(), this.mPublicClientConfiguration);
        }
        catch (MsalClientException e) {
            callback.onError(e);
            return;
        }
        RemoveCurrentAccountCommand command = new RemoveCurrentAccountCommand(params, controller, (CommandCallback)new CommandCallback<Boolean, BaseException>(){

            public void onError(BaseException error) {
                callback.onError(MsalExceptionAdapter.msalExceptionFromBaseException(error));
            }

            public void onTaskCompleted(Boolean result) {
                SingleAccountPublicClientApplication.this.persistCurrentAccount(null);
                callback.onSignOut();
            }

            public void onCancel() {
            }
        }, publicApiId);
        CommandDispatcher.submitSilent((BaseCommand)command);
    }

    @Override
    public boolean signOut() throws MsalException, InterruptedException {
        MsalUtils.throwOnMainThread("signOut");
        final ResultFuture future = new ResultFuture();
        this.signOutInternal(new ISingleAccountPublicClientApplication.SignOutCallback(){

            @Override
            public void onSignOut() {
                future.setResult(new AsyncResult<Boolean>(true, null));
            }

            @Override
            public void onError(@NonNull MsalException exception) {
                future.setResult(new AsyncResult<Boolean>(false, exception));
            }
        }, "927");
        AsyncResult result = (AsyncResult)future.get();
        if (result.getSuccess()) {
            return (Boolean)result.getResult();
        }
        throw result.getException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MultiTenantAccount getPersistedCurrentAccount() {
        Class<SingleAccountPublicClientApplication> clazz = SingleAccountPublicClientApplication.class;
        synchronized (SingleAccountPublicClientApplication.class) {
            String currentAccountJsonString = this.sharedPreferencesFileManager.getString(CURRENT_ACCOUNT_SHARED_PREFERENCE_KEY);
            if (StringExtensions.isNullOrBlank((String)currentAccountJsonString)) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            List cacheRecordList = JsonExtensions.getICacheRecordListFromJsonString((String)currentAccountJsonString);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.getAccountFromICacheRecordList(cacheRecordList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistCurrentAccount(@Nullable List<ICacheRecord> cacheRecords) {
        Class<SingleAccountPublicClientApplication> clazz = SingleAccountPublicClientApplication.class;
        synchronized (SingleAccountPublicClientApplication.class) {
            if (cacheRecords == null || cacheRecords.size() == 0) {
                this.sharedPreferencesFileManager.clear();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            String currentAccountJsonString = JsonExtensions.getJsonStringFromICacheRecordList(cacheRecords);
            this.sharedPreferencesFileManager.putString(CURRENT_ACCOUNT_SHARED_PREFERENCE_KEY, currentAccountJsonString);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Nullable
    private MultiTenantAccount getAccountFromICacheRecordList(@NonNull List<ICacheRecord> cacheRecords) {
        String methodName = ":getAccountFromICacheRecords";
        if (cacheRecords == null || cacheRecords.size() == 0) {
            return null;
        }
        List<IAccount> account = AccountAdapter.adapt(cacheRecords);
        if (account.size() != 1) {
            Logger.verbose((String)(TAG + ":getAccountFromICacheRecords"), (String)"Returned cacheRecords were adapted into multiple IAccount. This is unexpected in Single account mode.Returning the first adapted account.");
        }
        return (MultiTenantAccount)account.get(0);
    }

    @Override
    public void acquireToken(@NonNull Activity activity, @NonNull String[] scopes, @NonNull AuthenticationCallback callback) {
        MultiTenantAccount persistedAccount = this.getPersistedCurrentAccount();
        if (persistedAccount == null) {
            callback.onError(new MsalClientException("no_current_account", "There is no signed in account."));
            return;
        }
        AcquireTokenParameters acquireTokenParameters = this.buildAcquireTokenParameters(activity, null, scopes, this.getPersistedCurrentAccount(), null, null, null, null, callback, null, null);
        this.acquireTokenInternal(acquireTokenParameters, "125");
    }

    @Override
    public void acquireToken(@NonNull AcquireTokenParameters acquireTokenParameters) {
        MultiTenantAccount persistedAccount = this.getPersistedCurrentAccount();
        if (persistedAccount != null) {
            if (acquireTokenParameters.getAccount() == null && StringExtensions.isNullOrBlank((String)acquireTokenParameters.getLoginHint())) {
                acquireTokenParameters.getCallback().onError(new MsalClientException("current_account_mismatch", "The signed in account does not match with the provided account."));
                return;
            }
            if (acquireTokenParameters.getAccount() != null && !this.isHomeAccountIdMatching(persistedAccount, acquireTokenParameters.getAccount())) {
                acquireTokenParameters.getCallback().onError(new MsalClientException("current_account_mismatch", "The signed in account does not match with the provided account."));
                return;
            }
            if (!StringExtensions.isNullOrBlank((String)acquireTokenParameters.getLoginHint()) && !persistedAccount.getUsername().equalsIgnoreCase(acquireTokenParameters.getLoginHint())) {
                acquireTokenParameters.getCallback().onError(new MsalClientException("current_account_mismatch", "The signed in account does not match with the provided account."));
                return;
            }
        }
        this.acquireTokenInternal(acquireTokenParameters, "124");
    }

    @Override
    public void acquireTokenSilentAsync(@NonNull String[] scopes, @NonNull String authority, @NonNull SilentAuthenticationCallback callback) {
        MultiTenantAccount persistedAccount = this.getPersistedCurrentAccount();
        if (persistedAccount == null) {
            callback.onError(new MsalClientException("no_current_account", "There is no signed in account."));
            return;
        }
        AcquireTokenSilentParameters acquireTokenSilentParameters = this.buildAcquireTokenSilentParameters(scopes, persistedAccount, authority, false, null, callback);
        this.acquireTokenSilentAsyncInternal(acquireTokenSilentParameters, "26");
    }

    @Override
    @WorkerThread
    public IAuthenticationResult acquireTokenSilent(@NonNull String[] scopes, @NonNull String authority) throws MsalException, InterruptedException {
        MultiTenantAccount persistedAccount = this.getPersistedCurrentAccount();
        if (persistedAccount == null) {
            throw new MsalClientException("no_current_account", "There is no signed in account.");
        }
        return this.acquireTokenSilentSyncInternal(scopes, authority, persistedAccount, false, "25");
    }

    @Override
    public void acquireTokenSilentAsync(@NonNull AcquireTokenSilentParameters acquireTokenSilentParameters) {
        MultiTenantAccount persistedAccount = this.getPersistedCurrentAccount();
        if (persistedAccount == null) {
            acquireTokenSilentParameters.getCallback().onError(new MsalClientException("no_current_account", "There is no signed in account."));
            return;
        }
        if (!this.isHomeAccountIdMatching(persistedAccount, acquireTokenSilentParameters.getAccount())) {
            acquireTokenSilentParameters.getCallback().onError(new MsalClientException("current_account_mismatch", "The signed in account does not match with the provided account."));
            return;
        }
        this.acquireTokenSilentAsyncInternal(acquireTokenSilentParameters, "24");
    }

    @Override
    public IAuthenticationResult acquireTokenSilent(@NonNull AcquireTokenSilentParameters acquireTokenSilentParameters) throws InterruptedException, MsalException {
        MultiTenantAccount persistedAccount = this.getPersistedCurrentAccount();
        if (persistedAccount == null) {
            throw new MsalClientException("no_current_account", "There is no signed in account.");
        }
        if (!this.isHomeAccountIdMatching(persistedAccount, acquireTokenSilentParameters.getAccount())) {
            throw new MsalClientException("current_account_mismatch", "The signed in account does not match with the provided account.");
        }
        return this.acquireTokenSilentInternal(acquireTokenSilentParameters, "23");
    }
}

