/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.controllers;

import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.commands.parameters.CommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.RemoveAccountCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.internal.request.MsalBrokerRequestAdapter;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.result.MsalBrokerResultAdapter;
import java.util.List;

abstract class BrokerBaseStrategy {
    protected final MsalBrokerRequestAdapter mRequestAdapter = new MsalBrokerRequestAdapter();
    protected final MsalBrokerResultAdapter mResultAdapter = new MsalBrokerResultAdapter();

    BrokerBaseStrategy() {
    }

    abstract String hello(@NonNull CommandParameters var1) throws BaseException;

    abstract Intent getBrokerAuthorizationIntent(@NonNull InteractiveTokenCommandParameters var1, @Nullable String var2) throws BaseException;

    abstract AcquireTokenResult acquireTokenSilent(@NonNull SilentTokenCommandParameters var1, @Nullable String var2) throws BaseException;

    abstract List<ICacheRecord> getBrokerAccounts(@NonNull CommandParameters var1, @Nullable String var2) throws BaseException;

    abstract void removeBrokerAccount(@NonNull RemoveAccountCommandParameters var1, @Nullable String var2) throws BaseException;

    abstract boolean getDeviceMode(@NonNull CommandParameters var1, @Nullable String var2) throws BaseException;

    abstract List<ICacheRecord> getCurrentAccountInSharedDevice(@NonNull CommandParameters var1, @Nullable String var2) throws BaseException;

    abstract void signOutFromSharedDevice(@NonNull RemoveAccountCommandParameters var1, @Nullable String var2) throws BaseException;

    Handler getPreferredHandler() {
        if (null != Looper.myLooper() && Looper.getMainLooper() != Looper.myLooper()) {
            return new Handler(Looper.myLooper());
        }
        return new Handler(Looper.getMainLooper());
    }

    protected Intent completeInteractiveRequestIntent(@NonNull Intent interactiveRequestIntent, @NonNull InteractiveTokenCommandParameters parameters, @Nullable String negotiatedProtocolVersion) {
        interactiveRequestIntent.putExtras(this.mRequestAdapter.getRequestBundleForAcquireTokenInteractive(parameters, negotiatedProtocolVersion));
        interactiveRequestIntent.putExtra("common.broker.protocol.version.name", negotiatedProtocolVersion);
        return interactiveRequestIntent;
    }
}

