/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.controllers;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.microsoft.identity.client.IMicrosoftAuthService;
import com.microsoft.identity.client.exception.BrokerCommunicationException;
import com.microsoft.identity.client.internal.controllers.BrokerBaseStrategy;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.broker.MicrosoftAuthClient;
import com.microsoft.identity.common.internal.broker.MicrosoftAuthServiceFuture;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.commands.parameters.CommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.InteractiveTokenCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.RemoveAccountCommandParameters;
import com.microsoft.identity.common.internal.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.BaseEvent;
import com.microsoft.identity.common.internal.telemetry.events.BrokerEndEvent;
import com.microsoft.identity.common.internal.telemetry.events.BrokerStartEvent;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class BrokerAuthServiceStrategy
extends BrokerBaseStrategy {
    private static final String TAG = BrokerAuthServiceStrategy.class.getSimpleName();

    @Override
    @WorkerThread
    Intent getBrokerAuthorizationIntent(@NonNull InteractiveTokenCommandParameters parameters, @Nullable String negotiatedBrokerProtocolVersion) throws BaseException {
        String methodName = ":getBrokerAuthorizationIntent";
        Logger.verbose((String)(TAG + ":getBrokerAuthorizationIntent"), (String)"Get the broker authorization intent from auth service.");
        Intent interactiveRequestIntent = this.getBrokerAuthorizationIntentFromAuthService(parameters);
        return this.completeInteractiveRequestIntent(interactiveRequestIntent, parameters, negotiatedBrokerProtocolVersion);
    }

    private <T> T performAuthServiceOperation(@NonNull Context appContext, @NonNull AuthServiceOperation<T> authServiceOperation) throws BaseException {
        T result;
        String methodName = authServiceOperation.getOperationName();
        Telemetry.emit((BaseEvent)new BrokerStartEvent().putAction(methodName).putStrategy("bound_service"));
        MicrosoftAuthClient client = new MicrosoftAuthClient(appContext);
        try {
            MicrosoftAuthServiceFuture authServiceFuture = client.connect();
            IMicrosoftAuthService service = authServiceFuture.get();
            result = authServiceOperation.perform(service);
        }
        catch (RemoteException | InterruptedException | ExecutionException e) {
            String errorDescription = e instanceof RemoteException ? "RemoteException occurred while attempting to invoke remote service" : "Exception occurred while awaiting (get) return of MicrosoftAuthService";
            Logger.error((String)(TAG + methodName), (String)errorDescription, (Throwable)e);
            Telemetry.emit((BaseEvent)new BrokerEndEvent().putAction(methodName).isSuccessful(false).putErrorCode("io_error").putErrorDescription(e.getMessage()));
            throw new BrokerCommunicationException(errorDescription, e);
        }
        catch (BaseException e) {
            Logger.error((String)(TAG + methodName), (String)e.getMessage(), (Throwable)e);
            Telemetry.emit((BaseEvent)new BrokerEndEvent().putAction(methodName).isSuccessful(false).putErrorCode(e.getErrorCode()).putErrorDescription(e.getMessage()));
            throw e;
        }
        finally {
            client.disconnect();
        }
        Telemetry.emit((BaseEvent)new BrokerEndEvent().putAction(methodName).isSuccessful(true));
        return result;
    }

    @Override
    @WorkerThread
    String hello(final @NonNull CommandParameters parameters) throws BaseException {
        return this.performAuthServiceOperation(parameters.getAndroidApplicationContext(), new AuthServiceOperation<String>(){

            @Override
            public String perform(IMicrosoftAuthService service) throws RemoteException, ClientException {
                Bundle requestBundle = BrokerAuthServiceStrategy.this.mRequestAdapter.getRequestBundleForHello(parameters);
                String negotiatedProtocolVersion = BrokerAuthServiceStrategy.this.mResultAdapter.verifyHelloFromResultBundle(service.hello(requestBundle));
                return negotiatedProtocolVersion;
            }

            @Override
            public String getOperationName() {
                return ":helloWithMicrosoftAuthService";
            }
        });
    }

    private Intent getBrokerAuthorizationIntentFromAuthService(@NonNull InteractiveTokenCommandParameters parameters) throws BaseException {
        return this.performAuthServiceOperation(parameters.getAndroidApplicationContext(), new AuthServiceOperation<Intent>(){

            @Override
            public Intent perform(IMicrosoftAuthService service) throws RemoteException {
                return service.getIntentForInteractiveRequest();
            }

            @Override
            public String getOperationName() {
                return ":getBrokerAuthorizationIntentFromAuthService";
            }
        });
    }

    @Override
    @WorkerThread
    AcquireTokenResult acquireTokenSilent(final @NonNull SilentTokenCommandParameters parameters, final @Nullable String negotiatedBrokerProtocolVersion) throws BaseException {
        return this.performAuthServiceOperation(parameters.getAndroidApplicationContext(), new AuthServiceOperation<AcquireTokenResult>(){

            @Override
            public AcquireTokenResult perform(IMicrosoftAuthService service) throws RemoteException, BaseException {
                Bundle requestBundle = BrokerAuthServiceStrategy.this.mRequestAdapter.getRequestBundleForAcquireTokenSilent(parameters, negotiatedBrokerProtocolVersion);
                requestBundle.putString("common.broker.protocol.version.name", negotiatedBrokerProtocolVersion);
                return BrokerAuthServiceStrategy.this.mResultAdapter.getAcquireTokenResultFromResultBundle(service.acquireTokenSilently(requestBundle));
            }

            @Override
            public String getOperationName() {
                return ":acquireTokenSilentWithAuthService";
            }
        });
    }

    @Override
    @WorkerThread
    protected List<ICacheRecord> getBrokerAccounts(final @NonNull CommandParameters parameters, final @Nullable String negotiatedBrokerProtocolVersion) throws BaseException {
        return this.performAuthServiceOperation(parameters.getAndroidApplicationContext(), new AuthServiceOperation<List<ICacheRecord>>(){

            @Override
            public List<ICacheRecord> perform(IMicrosoftAuthService service) throws RemoteException, BaseException {
                Bundle requestBundle = BrokerAuthServiceStrategy.this.mRequestAdapter.getRequestBundleForGetAccounts(parameters);
                requestBundle.putString("common.broker.protocol.version.name", negotiatedBrokerProtocolVersion);
                return BrokerAuthServiceStrategy.this.mResultAdapter.getAccountsFromResultBundle(service.getAccounts(requestBundle));
            }

            @Override
            public String getOperationName() {
                return ":getBrokerAccountsWithAuthService";
            }
        });
    }

    @Override
    @WorkerThread
    protected void removeBrokerAccount(final @NonNull RemoveAccountCommandParameters parameters, final @Nullable String negotiatedBrokerProtocolVersion) throws BaseException {
        this.performAuthServiceOperation(parameters.getAndroidApplicationContext(), new AuthServiceOperation<Void>(){

            @Override
            public Void perform(IMicrosoftAuthService service) throws RemoteException, BaseException {
                Bundle requestBundle = BrokerAuthServiceStrategy.this.mRequestAdapter.getRequestBundleForRemoveAccount(parameters);
                requestBundle.putString("common.broker.protocol.version.name", negotiatedBrokerProtocolVersion);
                BrokerAuthServiceStrategy.this.mResultAdapter.verifyRemoveAccountResultFromBundle(service.removeAccount(requestBundle));
                return null;
            }

            @Override
            public String getOperationName() {
                return ":removeBrokerAccountWithAuthService";
            }
        });
    }

    @Override
    @WorkerThread
    protected boolean getDeviceMode(@NonNull CommandParameters parameters, @Nullable String negotiatedBrokerProtocolVersion) throws BaseException {
        return this.performAuthServiceOperation(parameters.getAndroidApplicationContext(), new AuthServiceOperation<Boolean>(){

            @Override
            public Boolean perform(IMicrosoftAuthService service) throws BaseException, RemoteException {
                return BrokerAuthServiceStrategy.this.mResultAdapter.getDeviceModeFromResultBundle(service.getDeviceMode());
            }

            @Override
            public String getOperationName() {
                return ":getDeviceModeWithAuthService";
            }
        });
    }

    @Override
    @WorkerThread
    protected List<ICacheRecord> getCurrentAccountInSharedDevice(final @NonNull CommandParameters parameters, final @Nullable String negotiatedBrokerProtocolVersion) throws BaseException {
        return this.performAuthServiceOperation(parameters.getAndroidApplicationContext(), new AuthServiceOperation<List<ICacheRecord>>(){

            @Override
            public List<ICacheRecord> perform(IMicrosoftAuthService service) throws RemoteException, BaseException {
                Bundle requestBundle = BrokerAuthServiceStrategy.this.mRequestAdapter.getRequestBundleForGetAccounts(parameters);
                requestBundle.putString("common.broker.protocol.version.name", negotiatedBrokerProtocolVersion);
                return BrokerAuthServiceStrategy.this.mResultAdapter.getAccountsFromResultBundle(service.getCurrentAccount(requestBundle));
            }

            @Override
            public String getOperationName() {
                return ":getCurrentAccountInSharedDeviceWithAuthService";
            }
        });
    }

    @Override
    @WorkerThread
    protected void signOutFromSharedDevice(final @NonNull RemoveAccountCommandParameters parameters, final @Nullable String negotiatedBrokerProtocolVersion) throws BaseException {
        this.performAuthServiceOperation(parameters.getAndroidApplicationContext(), new AuthServiceOperation<Void>(){

            @Override
            public Void perform(IMicrosoftAuthService service) throws RemoteException, BaseException {
                Bundle requestBundle = BrokerAuthServiceStrategy.this.mRequestAdapter.getRequestBundleForRemoveAccountFromSharedDevice(parameters);
                requestBundle.putString("common.broker.protocol.version.name", negotiatedBrokerProtocolVersion);
                BrokerAuthServiceStrategy.this.mResultAdapter.verifyRemoveAccountResultFromBundle(service.removeAccountFromSharedDevice(requestBundle));
                return null;
            }

            @Override
            public String getOperationName() {
                return ":signOutFromSharedDeviceWithAuthService";
            }
        });
    }

    public static interface AuthServiceOperation<T> {
        public T perform(IMicrosoftAuthService var1) throws BaseException, RemoteException;

        public String getOperationName();
    }
}

