/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.client.AuthenticationScheme;
import com.microsoft.identity.client.HttpMethod;
import com.microsoft.identity.common.internal.authscheme.IPoPAuthenticationSchemeParams;
import java.net.URL;

public class PoPAuthenticationScheme
extends AuthenticationScheme
implements IPoPAuthenticationSchemeParams {
    private final URL mUrl;
    private final HttpMethod mHttpMethod;
    private final String mNonce;

    private PoPAuthenticationScheme(@NonNull HttpMethod method, @NonNull URL url, @Nullable String nonce) {
        super("PoP");
        this.mHttpMethod = method;
        this.mUrl = url;
        this.mNonce = nonce;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getHttpMethod() {
        return this.mHttpMethod.name();
    }

    public URL getUrl() {
        return this.mUrl;
    }

    public String getNonce() {
        return this.mNonce;
    }

    public static class Builder {
        private URL mUrl;
        private HttpMethod mHttpMethod;
        private String mNonce;

        private Builder() {
        }

        public Builder withUrl(@NonNull URL url) {
            this.mUrl = url;
            return this;
        }

        public Builder withHttpMethod(@NonNull HttpMethod method) {
            this.mHttpMethod = method;
            return this;
        }

        public Builder withNonce(@Nullable String nonce) {
            this.mNonce = nonce;
            return this;
        }

        public PoPAuthenticationScheme build() {
            String errMsg = "PoP authentication scheme param must not be null: ";
            if (null == this.mUrl) {
                throw new IllegalArgumentException(errMsg + "URL");
            }
            if (null == this.mHttpMethod) {
                throw new IllegalArgumentException(errMsg + "HTTP Method");
            }
            return new PoPAuthenticationScheme(this.mHttpMethod, this.mUrl, this.mNonce);
        }
    }
}

