/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.controllers;

import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.microsoft.identity.common.adal.internal.net.HttpWebRequest;
import com.microsoft.identity.common.exception.ArgumentException;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.exception.ServiceException;
import com.microsoft.identity.common.internal.authorities.Authority;
import com.microsoft.identity.common.internal.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.controllers.BaseController;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import com.microsoft.identity.common.internal.dto.Credential;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationStatus;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationStrategy;
import com.microsoft.identity.common.internal.providers.oauth2.IResult;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2StrategyParameters;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResult;
import com.microsoft.identity.common.internal.request.AcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.AcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.OperationParameters;
import com.microsoft.identity.common.internal.request.SdkType;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.result.ILocalAuthenticationResult;
import com.microsoft.identity.common.internal.result.LocalAuthenticationResult;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.ApiEndEvent;
import com.microsoft.identity.common.internal.telemetry.events.ApiStartEvent;
import com.microsoft.identity.common.internal.telemetry.events.BaseEvent;
import com.microsoft.identity.common.internal.ui.AuthorizationStrategyFactory;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class LocalMSALController
extends BaseController {
    private static final String TAG = LocalMSALController.class.getSimpleName();
    private AuthorizationStrategy mAuthorizationStrategy = null;
    private AuthorizationRequest mAuthorizationRequest = null;

    public AcquireTokenResult acquireToken(@NonNull AcquireTokenOperationParameters parameters) throws ExecutionException, InterruptedException, ClientException, IOException, ArgumentException {
        String methodName = ":acquireToken";
        Logger.verbose((String)(TAG + ":acquireToken"), (String)"Acquiring token...");
        Telemetry.emit((BaseEvent)new ApiStartEvent().putProperties((OperationParameters)parameters).putApiId("101"));
        AcquireTokenResult acquireTokenResult = new AcquireTokenResult();
        parameters.validate();
        this.addDefaultScopes((OperationParameters)parameters);
        this.logParameters(TAG, parameters);
        HttpWebRequest.throwIfNetworkNotAvailable((Context)parameters.getAppContext());
        Authority.KnownAuthorityResult authorityResult = Authority.getKnownAuthorityResult((Authority)parameters.getAuthority());
        if (!authorityResult.getKnown()) {
            Telemetry.emit((BaseEvent)new ApiEndEvent().putException((Exception)authorityResult.getClientException()).putApiId("101"));
            throw authorityResult.getClientException();
        }
        OAuth2StrategyParameters strategyParameters = new OAuth2StrategyParameters();
        strategyParameters.setContext(parameters.getAppContext());
        OAuth2Strategy oAuth2Strategy = parameters.getAuthority().createOAuth2Strategy(strategyParameters);
        AuthorizationResult result = this.performAuthorizationRequest(oAuth2Strategy, parameters);
        acquireTokenResult.setAuthorizationResult(result);
        LocalMSALController.logResult((String)TAG, (IResult)result);
        if (result.getAuthorizationStatus().equals((Object)AuthorizationStatus.SUCCESS)) {
            TokenResult tokenResult = this.performTokenRequest(oAuth2Strategy, this.mAuthorizationRequest, result.getAuthorizationResponse(), parameters);
            acquireTokenResult.setTokenResult(tokenResult);
            if (tokenResult != null && tokenResult.getSuccess()) {
                List records = this.saveTokens(oAuth2Strategy, this.mAuthorizationRequest, tokenResult.getTokenResponse(), parameters.getTokenCache());
                ICacheRecord newestRecord = (ICacheRecord)records.get(0);
                acquireTokenResult.setLocalAuthenticationResult((ILocalAuthenticationResult)new LocalAuthenticationResult(this.finalizeCacheRecordForResult(newestRecord, parameters.getAuthenticationScheme()), records, SdkType.MSAL));
            }
        }
        Telemetry.emit((BaseEvent)new ApiEndEvent().putResult(acquireTokenResult).putApiId("101"));
        return acquireTokenResult;
    }

    private AuthorizationResult performAuthorizationRequest(@NonNull OAuth2Strategy strategy, @NonNull AcquireTokenOperationParameters parameters) throws ExecutionException, InterruptedException, ClientException {
        HttpWebRequest.throwIfNetworkNotAvailable((Context)parameters.getAppContext());
        this.mAuthorizationStrategy = AuthorizationStrategyFactory.getInstance().getAuthorizationStrategy(parameters);
        this.mAuthorizationRequest = this.getAuthorizationRequest(strategy, (OperationParameters)parameters);
        Future future = strategy.requestAuthorization(this.mAuthorizationRequest, this.mAuthorizationStrategy);
        AuthorizationResult result = (AuthorizationResult)future.get();
        return result;
    }

    public void completeAcquireToken(int requestCode, int resultCode, Intent data) {
        String methodName = ":completeAcquireToken";
        Logger.verbose((String)(TAG + ":completeAcquireToken"), (String)"Completing acquire token...");
        Telemetry.emit((BaseEvent)new ApiStartEvent().putApiId("1032").put("Microsoft.MSAL.result_code", String.valueOf(resultCode)).put("Microsoft.MSAL.request_code", String.valueOf(requestCode)));
        this.mAuthorizationStrategy.completeAuthorization(requestCode, resultCode, data);
        Telemetry.emit((BaseEvent)new ApiEndEvent().putApiId("1032"));
    }

    /*
     * Enabled aggressive block sorting
     */
    public AcquireTokenResult acquireTokenSilent(@NonNull AcquireTokenSilentOperationParameters parameters) throws IOException, ClientException, ArgumentException, ServiceException {
        String methodName = ":acquireTokenSilent";
        Logger.verbose((String)(TAG + ":acquireTokenSilent"), (String)"Acquiring token silently...");
        Telemetry.emit((BaseEvent)new ApiStartEvent().putProperties((OperationParameters)parameters).putApiId("103"));
        AcquireTokenResult acquireTokenSilentResult = new AcquireTokenResult();
        parameters.validate();
        this.addDefaultScopes((OperationParameters)parameters);
        OAuth2TokenCache tokenCache = parameters.getTokenCache();
        AccountRecord targetAccount = this.getCachedAccountRecord(parameters);
        AbstractAuthenticationScheme authScheme = parameters.getAuthenticationScheme();
        OAuth2StrategyParameters strategyParameters = new OAuth2StrategyParameters();
        strategyParameters.setContext(parameters.getAppContext());
        OAuth2Strategy strategy = parameters.getAuthority().createOAuth2Strategy(strategyParameters);
        List cacheRecords = tokenCache.loadWithAggregatedAccountData(parameters.getClientId(), TextUtils.join((CharSequence)" ", (Iterable)parameters.getScopes()), targetAccount, authScheme);
        ICacheRecord fullCacheRecord = (ICacheRecord)cacheRecords.get(0);
        if (this.accessTokenIsNull(fullCacheRecord) || this.refreshTokenIsNull(fullCacheRecord) || parameters.getForceRefresh() || !this.isRequestAuthorityRealmSameAsATRealm(parameters.getAuthority(), fullCacheRecord.getAccessToken()) || !strategy.validateCachedResult(authScheme, fullCacheRecord)) {
            if (this.refreshTokenIsNull(fullCacheRecord)) {
                ClientException exception = new ClientException("no_tokens_found", "No refresh token was found. ");
                Telemetry.emit((BaseEvent)new ApiEndEvent().putException((Exception)exception).putApiId("103"));
                throw exception;
            }
            Logger.verbose((String)(TAG + ":acquireTokenSilent"), (String)"No access token found, but RT is available.");
            this.renewAccessToken(parameters, acquireTokenSilentResult, tokenCache, strategy, fullCacheRecord);
        } else if (fullCacheRecord.getAccessToken().isExpired()) {
            Logger.warn((String)(TAG + ":acquireTokenSilent"), (String)"Access token is expired. Removing from cache...");
            tokenCache.removeCredential((Credential)fullCacheRecord.getAccessToken());
            Logger.verbose((String)(TAG + ":acquireTokenSilent"), (String)"Renewing access token...");
            this.renewAccessToken(parameters, acquireTokenSilentResult, tokenCache, strategy, fullCacheRecord);
        } else {
            Logger.verbose((String)(TAG + ":acquireTokenSilent"), (String)"Returning silent result");
            acquireTokenSilentResult.setLocalAuthenticationResult((ILocalAuthenticationResult)new LocalAuthenticationResult(this.finalizeCacheRecordForResult(fullCacheRecord, parameters.getAuthenticationScheme()), cacheRecords, SdkType.MSAL));
        }
        Telemetry.emit((BaseEvent)new ApiEndEvent().putResult(acquireTokenSilentResult).putApiId("103"));
        return acquireTokenSilentResult;
    }

    @WorkerThread
    public List<ICacheRecord> getAccounts(@NonNull OperationParameters parameters) {
        Telemetry.emit((BaseEvent)new ApiStartEvent().putProperties(parameters).putApiId("106"));
        List accountsInCache = parameters.getTokenCache().getAccountsWithAggregatedAccountData(null, parameters.getClientId());
        Telemetry.emit((BaseEvent)new ApiEndEvent().putApiId("106").put("Microsoft.MSAL.accounts_number", Integer.toString(accountsInCache.size())).put("_is_successful", "true"));
        return accountsInCache;
    }

    @WorkerThread
    public boolean removeAccount(@NonNull OperationParameters parameters) {
        Telemetry.emit((BaseEvent)new ApiStartEvent().putProperties(parameters).putApiId("107"));
        String realm = null;
        if (parameters.getAccount() != null) {
            realm = parameters.getAccount().getRealm();
        }
        boolean localRemoveAccountSuccess = !parameters.getTokenCache().removeAccount(parameters.getAccount() == null ? null : parameters.getAccount().getEnvironment(), parameters.getClientId(), parameters.getAccount() == null ? null : parameters.getAccount().getHomeAccountId(), realm).isEmpty();
        Telemetry.emit((BaseEvent)new ApiEndEvent().put("_is_successful", String.valueOf(localRemoveAccountSuccess)).putApiId("107"));
        return localRemoveAccountSuccess;
    }

    public boolean getDeviceMode(OperationParameters parameters) throws Exception {
        String methodName = ":getDeviceMode";
        String errorMessage = "LocalMSALController is not eligible to use the broker. Do not check sharedDevice mode and return false immediately.";
        Logger.warn((String)(TAG + ":getDeviceMode"), (String)"LocalMSALController is not eligible to use the broker. Do not check sharedDevice mode and return false immediately.");
        return false;
    }

    public List<ICacheRecord> getCurrentAccount(OperationParameters parameters) throws Exception {
        return this.getAccounts(parameters);
    }

    public boolean removeCurrentAccount(OperationParameters parameters) throws Exception {
        return this.removeAccount(parameters);
    }
}

