/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.controllers;

import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.internal.broker.BrokerRequest;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.request.AcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.AcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.MsalBrokerRequestAdapter;
import com.microsoft.identity.common.internal.request.OperationParameters;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.result.MsalBrokerResultAdapter;
import java.util.List;

abstract class BrokerBaseStrategy {
    protected final MsalBrokerRequestAdapter mRequestAdapter = new MsalBrokerRequestAdapter();
    protected final MsalBrokerResultAdapter mResultAdapter = new MsalBrokerResultAdapter();

    BrokerBaseStrategy() {
    }

    abstract void hello(@NonNull OperationParameters var1) throws BaseException;

    abstract Intent getBrokerAuthorizationIntent(@NonNull AcquireTokenOperationParameters var1) throws BaseException;

    abstract AcquireTokenResult acquireTokenSilent(AcquireTokenSilentOperationParameters var1) throws BaseException;

    abstract List<ICacheRecord> getBrokerAccounts(@NonNull OperationParameters var1) throws BaseException;

    abstract void removeBrokerAccount(@NonNull OperationParameters var1) throws BaseException;

    abstract boolean getDeviceMode(@NonNull OperationParameters var1) throws BaseException;

    abstract List<ICacheRecord> getCurrentAccountInSharedDevice(@NonNull OperationParameters var1) throws BaseException;

    abstract void signOutFromSharedDevice(@NonNull OperationParameters var1) throws BaseException;

    Handler getPreferredHandler() {
        if (null != Looper.myLooper() && Looper.getMainLooper() != Looper.myLooper()) {
            return new Handler(Looper.myLooper());
        }
        return new Handler(Looper.getMainLooper());
    }

    protected Intent completeInteractiveRequestIntent(@NonNull Intent interactiveRequestIntent, @NonNull AcquireTokenOperationParameters parameters) {
        interactiveRequestIntent.putExtra("broker_request_v2", MsalBrokerRequestAdapter.sRequestAdapterGsonInstance.toJson((Object)this.mRequestAdapter.brokerRequestFromAcquireTokenParameters(parameters), BrokerRequest.class));
        return interactiveRequestIntent;
    }
}

