/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.controllers;

import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.gson.GsonBuilder;
import com.microsoft.identity.client.internal.controllers.BrokerAccountManagerStrategy;
import com.microsoft.identity.client.internal.controllers.BrokerActivity;
import com.microsoft.identity.client.internal.controllers.BrokerAuthServiceStrategy;
import com.microsoft.identity.client.internal.controllers.BrokerBaseStrategy;
import com.microsoft.identity.common.BaseAccount;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.BrokerCommunicationException;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.exception.ServiceException;
import com.microsoft.identity.common.internal.broker.BrokerResult;
import com.microsoft.identity.common.internal.broker.BrokerResultFuture;
import com.microsoft.identity.common.internal.broker.MicrosoftAuthClient;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.cache.MsalOAuth2TokenCache;
import com.microsoft.identity.common.internal.controllers.BaseController;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftRefreshToken;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAccount;
import com.microsoft.identity.common.internal.providers.oauth2.IDToken;
import com.microsoft.identity.common.internal.providers.oauth2.RefreshToken;
import com.microsoft.identity.common.internal.request.AcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.AcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.OperationParameters;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.result.MsalBrokerResultAdapter;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.ApiEndEvent;
import com.microsoft.identity.common.internal.telemetry.events.ApiStartEvent;
import com.microsoft.identity.common.internal.telemetry.events.BaseEvent;
import com.microsoft.identity.common.internal.util.ICacheRecordGsonAdapter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class BrokerMsalController
extends BaseController {
    private static final String TAG = BrokerMsalController.class.getSimpleName();
    private static final String MANIFEST_PERMISSION_MANAGE_ACCOUNTS = "android.permission.MANAGE_ACCOUNTS";
    private BrokerResultFuture mBrokerResultFuture;

    public AcquireTokenResult acquireToken(AcquireTokenOperationParameters parameters) throws Exception {
        AcquireTokenResult result;
        Telemetry.emit((BaseEvent)new ApiStartEvent().putProperties((OperationParameters)parameters).putApiId("201"));
        this.mBrokerResultFuture = new BrokerResultFuture();
        Intent interactiveRequestIntent = this.getBrokerAuthorizationIntent(parameters);
        Intent brokerActivityIntent = new Intent(parameters.getAppContext(), BrokerActivity.class);
        brokerActivityIntent.putExtra("broker_intent", (Parcelable)interactiveRequestIntent);
        this.mBrokerResultFuture = new BrokerResultFuture();
        parameters.getActivity().startActivity(brokerActivityIntent);
        Bundle resultBundle = this.mBrokerResultFuture.get();
        this.saveMsaAccountToCache(resultBundle, (MsalOAuth2TokenCache)parameters.getTokenCache());
        try {
            result = new MsalBrokerResultAdapter().getAcquireTokenResultFromResultBundle(resultBundle);
        }
        catch (BaseException e) {
            Telemetry.emit((BaseEvent)new ApiEndEvent().putException((Exception)((Object)e)).putApiId("201"));
            throw e;
        }
        Telemetry.emit((BaseEvent)new ApiEndEvent().putResult(result).putApiId("201"));
        return result;
    }

    private <T extends OperationParameters, U> U invokeBrokerOperation(@NonNull T parameters, @NonNull BrokerOperationInfo<T, U> strategyTask) throws Exception {
        if (strategyTask.getTelemetryApiId() != null) {
            Telemetry.emit((BaseEvent)new ApiStartEvent().putProperties(parameters).putApiId(strategyTask.getTelemetryApiId()));
        }
        List<BrokerBaseStrategy> strategies = this.getStrategies();
        Object result = null;
        for (int ii = 0; ii < strategies.size(); ++ii) {
            BrokerBaseStrategy strategy = strategies.get(ii);
            try {
                Logger.info((String)(TAG + strategyTask.getMethodName()), (String)("Executing with strategy: " + strategy.getClass().getSimpleName()));
                strategy.hello(parameters);
                result = strategyTask.perform(strategy, parameters);
                if (result == null) continue;
                break;
            }
            catch (BrokerCommunicationException brokerCommunicationException) {
                continue;
            }
            catch (Exception exception) {
                if (strategyTask.getTelemetryApiId() != null) {
                    Telemetry.emit((BaseEvent)new ApiEndEvent().putException(exception).putApiId(strategyTask.getTelemetryApiId()));
                }
                throw exception;
            }
        }
        if (result == null) {
            BrokerCommunicationException exception = new BrokerCommunicationException("MSAL failed to communicate to Broker.");
            if (strategyTask.getTelemetryApiId() != null) {
                Telemetry.emit((BaseEvent)new ApiEndEvent().putException((Exception)((Object)exception)).putApiId(strategyTask.getTelemetryApiId()));
            }
            throw exception;
        }
        if (strategyTask.getTelemetryApiId() != null) {
            ApiEndEvent successEvent = new ApiEndEvent().putApiId(strategyTask.getTelemetryApiId()).isApiCallSuccessful(Boolean.TRUE);
            strategyTask.putValueInSuccessEvent(successEvent, result);
            Telemetry.emit((BaseEvent)successEvent);
        }
        return result;
    }

    private List<BrokerBaseStrategy> getStrategies() {
        ArrayList<BrokerBaseStrategy> strategies = new ArrayList<BrokerBaseStrategy>();
        strategies.add(new BrokerAuthServiceStrategy());
        strategies.add(new BrokerAccountManagerStrategy());
        return strategies;
    }

    private Intent getBrokerAuthorizationIntent(@NonNull AcquireTokenOperationParameters parameters) throws Exception {
        return this.invokeBrokerOperation(parameters, new BrokerOperationInfo<AcquireTokenOperationParameters, Intent>(){

            @Override
            @Nullable
            public Intent perform(BrokerBaseStrategy strategy, AcquireTokenOperationParameters parameters) throws BaseException, InterruptedException, ExecutionException, RemoteException {
                return strategy.getBrokerAuthorizationIntent(parameters);
            }

            @Override
            public String getMethodName() {
                return ":getBrokerAuthorizationIntent";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return null;
            }

            @Override
            public void putValueInSuccessEvent(ApiEndEvent event, Intent result) {
            }
        });
    }

    public void completeAcquireToken(int requestCode, int resultCode, Intent data) {
        Telemetry.emit((BaseEvent)new ApiStartEvent().putApiId("202").put("Microsoft.MSAL.result_code", String.valueOf(resultCode)).put("Microsoft.MSAL.request_code", String.valueOf(requestCode)));
        this.mBrokerResultFuture.setResultBundle(data.getExtras());
        Telemetry.emit((BaseEvent)new ApiEndEvent().putApiId("202"));
    }

    public AcquireTokenResult acquireTokenSilent(AcquireTokenSilentOperationParameters parameters) throws Exception {
        return this.invokeBrokerOperation(parameters, new BrokerOperationInfo<AcquireTokenSilentOperationParameters, AcquireTokenResult>(){

            @Override
            @Nullable
            public AcquireTokenResult perform(BrokerBaseStrategy strategy, AcquireTokenSilentOperationParameters parameters) throws BaseException, InterruptedException, ExecutionException, RemoteException {
                return strategy.acquireTokenSilent(parameters);
            }

            @Override
            public String getMethodName() {
                return ":acquireTokenSilent";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return "203";
            }

            @Override
            public void putValueInSuccessEvent(ApiEndEvent event, AcquireTokenResult result) {
                event.putResult(result);
            }
        });
    }

    public List<ICacheRecord> getAccounts(@NonNull OperationParameters parameters) throws Exception {
        return this.invokeBrokerOperation(parameters, new BrokerOperationInfo<OperationParameters, List<ICacheRecord>>(){

            @Override
            @Nullable
            public List<ICacheRecord> perform(BrokerBaseStrategy strategy, OperationParameters parameters) throws RemoteException, InterruptedException, ExecutionException, AuthenticatorException, IOException, OperationCanceledException, BaseException {
                return strategy.getBrokerAccounts(parameters);
            }

            @Override
            public String getMethodName() {
                return ":getBrokerAccounts";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return "206";
            }

            @Override
            public void putValueInSuccessEvent(ApiEndEvent event, List<ICacheRecord> result) {
                event.put("Microsoft.MSAL.accounts_number", Integer.toString(result.size()));
            }
        });
    }

    @WorkerThread
    public boolean removeAccount(@NonNull OperationParameters parameters) throws Exception {
        return this.invokeBrokerOperation(parameters, new BrokerOperationInfo<OperationParameters, Boolean>(){

            @Override
            @Nullable
            public Boolean perform(BrokerBaseStrategy strategy, OperationParameters parameters) throws InterruptedException, ExecutionException, BaseException, RemoteException {
                strategy.removeBrokerAccount(parameters);
                return true;
            }

            @Override
            public String getMethodName() {
                return ":removeAccount";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return "207";
            }

            @Override
            public void putValueInSuccessEvent(ApiEndEvent event, Boolean result) {
            }
        });
    }

    @WorkerThread
    public boolean getDeviceMode(@NonNull OperationParameters parameters) throws Exception {
        return this.invokeBrokerOperation(parameters, new BrokerOperationInfo<OperationParameters, Boolean>(){

            @Override
            @Nullable
            public Boolean perform(BrokerBaseStrategy strategy, OperationParameters parameters) throws Exception {
                return strategy.getDeviceMode(parameters);
            }

            @Override
            public String getMethodName() {
                return ":getDeviceMode";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return "204";
            }

            @Override
            public void putValueInSuccessEvent(ApiEndEvent event, Boolean result) {
                event.put("Microsoft.MSAL.is_device_shared", Boolean.toString(result));
            }
        });
    }

    public List<ICacheRecord> getCurrentAccount(OperationParameters parameters) throws Exception {
        String methodName = ":getCurrentAccount";
        if (!parameters.getIsSharedDevice()) {
            Logger.verbose((String)(TAG + ":getCurrentAccount"), (String)"Not a shared device, invoke getAccounts() instead of getCurrentAccount()");
            return this.getAccounts(parameters);
        }
        return this.invokeBrokerOperation(parameters, new BrokerOperationInfo<OperationParameters, List<ICacheRecord>>(){

            @Override
            @Nullable
            public List<ICacheRecord> perform(BrokerBaseStrategy strategy, OperationParameters parameters) throws Exception {
                return strategy.getCurrentAccountInSharedDevice(parameters);
            }

            @Override
            public String getMethodName() {
                return ":getCurrentAccount";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return "205";
            }

            @Override
            public void putValueInSuccessEvent(ApiEndEvent event, List<ICacheRecord> result) {
                event.put("Microsoft.MSAL.accounts_number", Integer.toString(result.size()));
            }
        });
    }

    public boolean removeCurrentAccount(OperationParameters parameters) throws Exception {
        String methodName = ":removeCurrentAccount";
        if (!parameters.getIsSharedDevice()) {
            Logger.verbose((String)(TAG + ":removeCurrentAccount"), (String)"Not a shared device, invoke removeAccount() instead of removeCurrentAccount()");
            return this.removeAccount(parameters);
        }
        return this.invokeBrokerOperation(parameters, new BrokerOperationInfo<OperationParameters, Boolean>(){

            @Override
            @Nullable
            public Boolean perform(BrokerBaseStrategy strategy, OperationParameters parameters) throws InterruptedException, ExecutionException, BaseException, RemoteException {
                strategy.signOutFromSharedDevice(parameters);
                return true;
            }

            @Override
            public String getMethodName() {
                return ":removeCurrentAccount";
            }

            @Override
            @Nullable
            public String getTelemetryApiId() {
                return "208";
            }

            @Override
            public void putValueInSuccessEvent(ApiEndEvent event, Boolean result) {
            }
        });
    }

    private void saveMsaAccountToCache(@NonNull Bundle resultBundle, @NonNull MsalOAuth2TokenCache msalOAuth2TokenCache) throws ClientException {
        String methodName = ":saveMsaAccountToCache";
        BrokerResult brokerResult = (BrokerResult)new GsonBuilder().registerTypeAdapter(ICacheRecord.class, (Object)new ICacheRecordGsonAdapter()).create().fromJson(resultBundle.getString("broker_result_v2"), BrokerResult.class);
        if (resultBundle.getBoolean("broker_request_v2_success") && brokerResult != null && "9188040d-6c67-4c5b-b112-36a304b66dad".equalsIgnoreCase(brokerResult.getTenantId())) {
            Logger.info((String)(TAG + ":saveMsaAccountToCache"), (String)"Result returned for MSA Account, saving to cache");
            try {
                ClientInfo clientInfo = new ClientInfo(brokerResult.getClientInfo());
                MicrosoftStsAccount microsoftStsAccount = new MicrosoftStsAccount(new IDToken(brokerResult.getIdToken()), clientInfo);
                microsoftStsAccount.setEnvironment(brokerResult.getEnvironment());
                MicrosoftRefreshToken microsoftRefreshToken = new MicrosoftRefreshToken(brokerResult.getRefreshToken(), clientInfo, brokerResult.getScope(), brokerResult.getClientId(), brokerResult.getEnvironment(), brokerResult.getFamilyId());
                msalOAuth2TokenCache.setSingleSignOnState((BaseAccount)microsoftStsAccount, (RefreshToken)microsoftRefreshToken);
            }
            catch (ServiceException e) {
                Logger.errorPII((String)(TAG + ":saveMsaAccountToCache"), (String)"Exception while creating Idtoken or ClientInfo, cannot save MSA account tokens", (Throwable)e);
                throw new ClientException("invalid_jwt", e.getMessage(), (Throwable)e);
            }
        }
    }

    static boolean isMicrosoftAuthServiceSupported(@NonNull Context context) {
        MicrosoftAuthClient client = new MicrosoftAuthClient(context);
        Intent microsoftAuthServiceIntent = client.getIntentForAuthService(context);
        return null != microsoftAuthServiceIntent;
    }

    static boolean isAccountManagerPermissionsGranted(@NonNull Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            return true;
        }
        return BrokerMsalController.isPermissionGranted(context, MANIFEST_PERMISSION_MANAGE_ACCOUNTS);
    }

    private static boolean isPermissionGranted(@NonNull Context context, @NonNull String permissionName) {
        String methodName = ":isPermissionGranted";
        PackageManager pm = context.getPackageManager();
        boolean isGranted = pm.checkPermission(permissionName, context.getPackageName()) == 0;
        Logger.verbose((String)(TAG + ":isPermissionGranted"), (String)("is " + permissionName + " granted? [" + isGranted + "]"));
        return isGranted;
    }

    private static interface BrokerOperationInfo<T extends OperationParameters, U> {
        @Nullable
        public U perform(BrokerBaseStrategy var1, T var2) throws Exception;

        public String getMethodName();

        @Nullable
        public String getTelemetryApiId();

        public void putValueInSuccessEvent(ApiEndEvent var1, U var2);
    }
}

