/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.controllers;

import android.accounts.AccountManager;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.microsoft.identity.client.internal.controllers.BrokerBaseStrategy;
import com.microsoft.identity.client.internal.controllers.BrokerMsalController;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.BrokerCommunicationException;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.request.AcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.AcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.OperationParameters;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.BaseEvent;
import com.microsoft.identity.common.internal.telemetry.events.BrokerEndEvent;
import com.microsoft.identity.common.internal.telemetry.events.BrokerStartEvent;
import java.io.IOException;
import java.util.List;

public class BrokerAccountManagerStrategy
extends BrokerBaseStrategy {
    private static final String TAG = BrokerAccountManagerStrategy.class.getSimpleName();

    @SuppressLint(value={"MissingPermission"})
    public <T extends OperationParameters, U> U invokeBrokerAccountManagerOperation(T parameters, OperationInfo<T, U> operationInfo) throws BaseException {
        U result;
        String methodName = operationInfo.getMethodName();
        Telemetry.emit((BaseEvent)new BrokerStartEvent().putAction(methodName).putStrategy("account_manager"));
        try {
            AccountManager accountManager = AccountManager.get((Context)parameters.getAppContext());
            AccountManagerFuture resultBundle = accountManager.addAccount("com.microsoft.workaccount", "adal.authtoken.type", null, operationInfo.getRequestBundle(parameters), null, null, this.getPreferredHandler());
            Logger.verbose((String)(TAG + methodName), (String)"Received result from broker");
            result = operationInfo.getResultFromBundle((Bundle)resultBundle.getResult());
        }
        catch (AuthenticatorException | OperationCanceledException | IOException e) {
            Logger.error((String)(TAG + methodName), (String)e.getMessage(), (Throwable)e);
            Telemetry.emit((BaseEvent)new BrokerEndEvent().putAction(methodName).isSuccessful(false).putErrorCode("io_error").putErrorDescription(e.getMessage()));
            throw new BrokerCommunicationException("Failed to connect to AccountManager");
        }
        catch (BaseException e) {
            Logger.error((String)(TAG + methodName), (String)e.getMessage(), (Throwable)e);
            Telemetry.emit((BaseEvent)new BrokerEndEvent().putAction(methodName).isSuccessful(false).putErrorCode(e.getErrorCode()).putErrorDescription(e.getMessage()));
            throw e;
        }
        Telemetry.emit((BaseEvent)new BrokerEndEvent().putAction(methodName).isSuccessful(true));
        return result;
    }

    @Override
    @WorkerThread
    @SuppressLint(value={"MissingPermission"})
    void hello(@NonNull OperationParameters parameters) throws BaseException {
        if (!BrokerMsalController.isAccountManagerPermissionsGranted(parameters.getAppContext())) {
            throw new BrokerCommunicationException("Account manager permissions are not granted");
        }
        this.invokeBrokerAccountManagerOperation(parameters, new OperationInfo<OperationParameters, Void>(){

            @Override
            public Bundle getRequestBundle(OperationParameters parameters) {
                Bundle requestBundle = BrokerAccountManagerStrategy.this.mRequestAdapter.getRequestBundleForHello(parameters);
                requestBundle.putString("com.microsoft.broker_accountmanager_operation_key", "HELLO");
                return requestBundle;
            }

            @Override
            public String getMethodName() {
                return ":helloWithAccountManager";
            }

            @Override
            public Void getResultFromBundle(Bundle bundle) throws BaseException {
                BrokerAccountManagerStrategy.this.mResultAdapter.verifyHelloFromResultBundle(bundle);
                return null;
            }
        });
    }

    @Override
    @WorkerThread
    Intent getBrokerAuthorizationIntent(final @NonNull AcquireTokenOperationParameters parameters) throws BaseException {
        String methodName = ":getBrokerAuthorizationIntent";
        Logger.verbose((String)(TAG + ":getBrokerAuthorizationIntent"), (String)"Get the broker authorization intent from Account Manager.");
        return this.invokeBrokerAccountManagerOperation(parameters, new OperationInfo<AcquireTokenOperationParameters, Intent>(){

            @Override
            public Bundle getRequestBundle(AcquireTokenOperationParameters parameters2) {
                Bundle requestBundle = new Bundle();
                requestBundle.putString("com.microsoft.broker_accountmanager_operation_key", "GET_INTENT_FOR_INTERACTIVE_REQUEST");
                return requestBundle;
            }

            @Override
            public String getMethodName() {
                return ":getBrokerAuthorizationIntent";
            }

            @Override
            public Intent getResultFromBundle(Bundle bundle) {
                Intent interactiveRequestIntent = (Intent)bundle.getParcelable("intent");
                return BrokerAccountManagerStrategy.this.completeInteractiveRequestIntent(interactiveRequestIntent, parameters);
            }
        });
    }

    @Override
    @WorkerThread
    AcquireTokenResult acquireTokenSilent(AcquireTokenSilentOperationParameters parameters) throws BaseException {
        return this.invokeBrokerAccountManagerOperation(parameters, new OperationInfo<AcquireTokenSilentOperationParameters, AcquireTokenResult>(){

            @Override
            public Bundle getRequestBundle(AcquireTokenSilentOperationParameters parameters) {
                Bundle requestBundle = BrokerAccountManagerStrategy.this.mRequestAdapter.getRequestBundleForAcquireTokenSilent(parameters);
                requestBundle.putString("com.microsoft.broker_accountmanager_operation_key", "ACQUIRE_TOKEN_SILENT");
                return requestBundle;
            }

            @Override
            public String getMethodName() {
                return ":acquireTokenSilentWithAccountManager";
            }

            @Override
            public AcquireTokenResult getResultFromBundle(Bundle bundle) throws BaseException {
                return BrokerAccountManagerStrategy.this.mResultAdapter.getAcquireTokenResultFromResultBundle(bundle);
            }
        });
    }

    @Override
    @WorkerThread
    protected List<ICacheRecord> getBrokerAccounts(@NonNull OperationParameters parameters) throws BaseException {
        return this.invokeBrokerAccountManagerOperation(parameters, new OperationInfo<OperationParameters, List<ICacheRecord>>(){

            @Override
            public Bundle getRequestBundle(OperationParameters parameters) {
                Bundle requestBundle = BrokerAccountManagerStrategy.this.mRequestAdapter.getRequestBundleForGetAccounts(parameters);
                requestBundle.putString("com.microsoft.broker_accountmanager_operation_key", "GET_ACCOUNTS");
                return requestBundle;
            }

            @Override
            public String getMethodName() {
                return ":getBrokerAccountsWithAccountManager";
            }

            @Override
            public List<ICacheRecord> getResultFromBundle(Bundle bundle) throws BaseException {
                return BrokerAccountManagerStrategy.this.mResultAdapter.getAccountsFromResultBundle(bundle);
            }
        });
    }

    @Override
    @WorkerThread
    protected void removeBrokerAccount(@NonNull OperationParameters parameters) throws BaseException {
        this.invokeBrokerAccountManagerOperation(parameters, new OperationInfo<OperationParameters, Void>(){

            @Override
            public Bundle getRequestBundle(OperationParameters parameters) {
                Bundle requestBundle = BrokerAccountManagerStrategy.this.mRequestAdapter.getRequestBundleForRemoveAccount(parameters);
                requestBundle.putString("com.microsoft.broker_accountmanager_operation_key", "REMOVE_ACCOUNT");
                return requestBundle;
            }

            @Override
            public String getMethodName() {
                return ":removeBrokerAccountWithAccountManager";
            }

            @Override
            public Void getResultFromBundle(Bundle bundle) throws BaseException {
                BrokerAccountManagerStrategy.this.mResultAdapter.verifyRemoveAccountResultFromBundle(bundle);
                return null;
            }
        });
    }

    @Override
    boolean getDeviceMode(@NonNull OperationParameters parameters) throws BaseException {
        return this.invokeBrokerAccountManagerOperation(parameters, new OperationInfo<OperationParameters, Boolean>(){

            @Override
            public Bundle getRequestBundle(OperationParameters parameters) {
                Bundle requestBundle = new Bundle();
                requestBundle.putString("com.microsoft.broker_accountmanager_operation_key", "GET_DEVICE_MODE");
                return requestBundle;
            }

            @Override
            public String getMethodName() {
                return ":getDeviceModeWithAccountManager";
            }

            @Override
            public Boolean getResultFromBundle(Bundle bundle) throws BaseException {
                return BrokerAccountManagerStrategy.this.mResultAdapter.getDeviceModeFromResultBundle(bundle);
            }
        });
    }

    @Override
    List<ICacheRecord> getCurrentAccountInSharedDevice(@NonNull OperationParameters parameters) throws BaseException {
        return this.invokeBrokerAccountManagerOperation(parameters, new OperationInfo<OperationParameters, List<ICacheRecord>>(){

            @Override
            public Bundle getRequestBundle(OperationParameters parameters) {
                Bundle requestBundle = BrokerAccountManagerStrategy.this.mRequestAdapter.getRequestBundleForGetAccounts(parameters);
                requestBundle.putString("com.microsoft.broker_accountmanager_operation_key", "GET_CURRENT_ACCOUNT");
                return requestBundle;
            }

            @Override
            public String getMethodName() {
                return ":getCurrentAccountInSharedDeviceWithAccountManager";
            }

            @Override
            public List<ICacheRecord> getResultFromBundle(Bundle bundle) throws BaseException {
                return BrokerAccountManagerStrategy.this.mResultAdapter.getAccountsFromResultBundle(bundle);
            }
        });
    }

    @Override
    void signOutFromSharedDevice(@NonNull OperationParameters parameters) throws BaseException {
        this.invokeBrokerAccountManagerOperation(parameters, new OperationInfo<OperationParameters, Void>(){

            @Override
            public Bundle getRequestBundle(OperationParameters parameters) {
                Bundle requestBundle = BrokerAccountManagerStrategy.this.mRequestAdapter.getRequestBundleForRemoveAccountFromSharedDevice(parameters);
                requestBundle.putString("com.microsoft.broker_accountmanager_operation_key", "REMOVE_ACCOUNT_FROM_SHARED_DEVICE");
                return requestBundle;
            }

            @Override
            public String getMethodName() {
                return ":signOutFromSharedDeviceWithAccountManager";
            }

            @Override
            public Void getResultFromBundle(Bundle bundle) throws BaseException {
                BrokerAccountManagerStrategy.this.mResultAdapter.verifyRemoveAccountResultFromBundle(bundle);
                return null;
            }
        });
    }

    public static interface OperationInfo<T extends OperationParameters, U> {
        public Bundle getRequestBundle(T var1);

        public String getMethodName();

        public U getResultFromBundle(Bundle var1) throws BaseException;
    }
}

