/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import com.microsoft.identity.client.ILoggerCallback;
import com.microsoft.identity.common.internal.logging.Logger;

public final class Logger {
    private static final Logger sINSTANCE = new Logger();
    private ILoggerCallback mExternalLogger;

    public static Logger getInstance() {
        return sINSTANCE;
    }

    public void setLogLevel(LogLevel logLevel) {
        com.microsoft.identity.common.internal.logging.Logger logger = com.microsoft.identity.common.internal.logging.Logger.getInstance();
        switch (logLevel) {
            case ERROR: {
                logger.setLogLevel(Logger.LogLevel.ERROR);
                break;
            }
            case WARNING: {
                logger.setLogLevel(Logger.LogLevel.WARN);
                break;
            }
            case INFO: {
                logger.setLogLevel(Logger.LogLevel.INFO);
                break;
            }
            case VERBOSE: {
                logger.setLogLevel(Logger.LogLevel.VERBOSE);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown logLevel");
            }
        }
    }

    public synchronized void setExternalLogger(ILoggerCallback externalLogger) {
        if (externalLogger == null) {
            return;
        }
        if (null != this.mExternalLogger) {
            throw new IllegalStateException("External logger is already set, cannot be set again.");
        }
        com.microsoft.identity.common.internal.logging.Logger logger = com.microsoft.identity.common.internal.logging.Logger.getInstance();
        logger.setExternalLogger(new com.microsoft.identity.common.internal.logging.ILoggerCallback(){

            public void log(String tag, Logger.LogLevel logLevel, String message, boolean containsPII) {
                switch (logLevel) {
                    case ERROR: {
                        Logger.this.mExternalLogger.log(tag, LogLevel.ERROR, message, containsPII);
                        break;
                    }
                    case WARN: {
                        Logger.this.mExternalLogger.log(tag, LogLevel.WARNING, message, containsPII);
                        break;
                    }
                    case VERBOSE: {
                        Logger.this.mExternalLogger.log(tag, LogLevel.VERBOSE, message, containsPII);
                        break;
                    }
                    case INFO: {
                        Logger.this.mExternalLogger.log(tag, LogLevel.INFO, message, containsPII);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown logLevel");
                    }
                }
            }
        });
        this.mExternalLogger = externalLogger;
    }

    public void setEnableLogcatLog(boolean enableLogcatLog) {
        com.microsoft.identity.common.internal.logging.Logger.setAllowLogcat((boolean)enableLogcatLog);
    }

    public void setEnablePII(boolean enablePII) {
        com.microsoft.identity.common.internal.logging.Logger.setAllowPii((boolean)enablePII);
    }

    public static enum LogLevel {
        ERROR,
        WARNING,
        INFO,
        VERBOSE;

    }
}

