/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.controllers;

import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import com.google.gson.Gson;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.internal.broker.BrokerRequest;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.request.AcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.AcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.MsalBrokerRequestAdapter;
import com.microsoft.identity.common.internal.request.OperationParameters;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.result.MsalBrokerResultAdapter;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;

abstract class BrokerBaseStrategy {
    protected final MsalBrokerRequestAdapter mRequestAdapter = new MsalBrokerRequestAdapter();
    protected final MsalBrokerResultAdapter mResultAdapter = new MsalBrokerResultAdapter();

    BrokerBaseStrategy() {
    }

    abstract boolean hello(@NonNull OperationParameters var1) throws BaseException, InterruptedException, ExecutionException, RemoteException;

    abstract Intent getBrokerAuthorizationIntent(@NonNull AcquireTokenOperationParameters var1) throws BaseException, InterruptedException, ExecutionException, RemoteException;

    abstract AcquireTokenResult acquireTokenSilent(AcquireTokenSilentOperationParameters var1) throws BaseException, InterruptedException, ExecutionException, RemoteException;

    abstract List<ICacheRecord> getBrokerAccounts(@NonNull OperationParameters var1) throws InterruptedException, ExecutionException, RemoteException, OperationCanceledException, IOException, AuthenticatorException, BaseException;

    abstract void removeBrokerAccount(@NonNull OperationParameters var1) throws BaseException, InterruptedException, ExecutionException, RemoteException;

    abstract boolean getDeviceMode(@NonNull OperationParameters var1) throws BaseException, InterruptedException, ExecutionException, RemoteException;

    abstract List<ICacheRecord> getCurrentAccountInSharedDevice(@NonNull OperationParameters var1) throws InterruptedException, ExecutionException, RemoteException, OperationCanceledException, IOException, AuthenticatorException, BaseException;

    abstract void signOutFromSharedDevice(@NonNull OperationParameters var1) throws BaseException, InterruptedException, ExecutionException, RemoteException;

    Handler getPreferredHandler() {
        if (null != Looper.myLooper() && Looper.getMainLooper() != Looper.myLooper()) {
            return new Handler(Looper.myLooper());
        }
        return new Handler(Looper.getMainLooper());
    }

    protected Intent completeInteractiveRequestIntent(@NonNull Intent interactiveRequestIntent, @NonNull AcquireTokenOperationParameters parameters) {
        interactiveRequestIntent.putExtra("broker_request_v2", new Gson().toJson((Object)this.mRequestAdapter.brokerRequestFromAcquireTokenParameters(parameters), BrokerRequest.class));
        return interactiveRequestIntent;
    }
}

