/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.microsoft.identity.client.AccountAdapter;
import com.microsoft.identity.client.AcquireTokenParameters;
import com.microsoft.identity.client.AcquireTokenSilentParameters;
import com.microsoft.identity.client.AuthenticationCallback;
import com.microsoft.identity.client.AuthenticationResultAdapter;
import com.microsoft.identity.client.IAccount;
import com.microsoft.identity.client.IAuthenticationResult;
import com.microsoft.identity.client.IClaimable;
import com.microsoft.identity.client.IMultipleAccountPublicClientApplication;
import com.microsoft.identity.client.IPublicClientApplication;
import com.microsoft.identity.client.ISingleAccountPublicClientApplication;
import com.microsoft.identity.client.ITenantProfile;
import com.microsoft.identity.client.ITokenShare;
import com.microsoft.identity.client.Logger;
import com.microsoft.identity.client.MultiTenantAccount;
import com.microsoft.identity.client.MultipleAccountPublicClientApplication;
import com.microsoft.identity.client.Prompt;
import com.microsoft.identity.client.PublicClientApplicationConfiguration;
import com.microsoft.identity.client.PublicClientApplicationConfigurationFactory;
import com.microsoft.identity.client.SilentAuthenticationCallback;
import com.microsoft.identity.client.SingleAccountPublicClientApplication;
import com.microsoft.identity.client.TokenParameters;
import com.microsoft.identity.client.claims.ClaimsRequest;
import com.microsoft.identity.client.configuration.AccountMode;
import com.microsoft.identity.client.configuration.HttpConfiguration;
import com.microsoft.identity.client.configuration.LoggerConfiguration;
import com.microsoft.identity.client.exception.MsalArgumentException;
import com.microsoft.identity.client.exception.MsalClientException;
import com.microsoft.identity.client.exception.MsalDeclinedScopeException;
import com.microsoft.identity.client.exception.MsalException;
import com.microsoft.identity.client.internal.AsyncResult;
import com.microsoft.identity.client.internal.MsalUtils;
import com.microsoft.identity.client.internal.controllers.MSALControllerFactory;
import com.microsoft.identity.client.internal.controllers.MsalExceptionAdapter;
import com.microsoft.identity.client.internal.controllers.OperationParametersAdapter;
import com.microsoft.identity.common.adal.internal.tokensharing.TokenShareUtility;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.exception.ServiceException;
import com.microsoft.identity.common.internal.authorities.Authority;
import com.microsoft.identity.common.internal.authorities.AzureActiveDirectoryAudience;
import com.microsoft.identity.common.internal.authorities.AzureActiveDirectoryAuthority;
import com.microsoft.identity.common.internal.authorities.AzureActiveDirectoryB2CAuthority;
import com.microsoft.identity.common.internal.authorities.Environment;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.cache.MsalOAuth2TokenCache;
import com.microsoft.identity.common.internal.cache.SchemaUtil;
import com.microsoft.identity.common.internal.controllers.BaseCommand;
import com.microsoft.identity.common.internal.controllers.BaseController;
import com.microsoft.identity.common.internal.controllers.CommandCallback;
import com.microsoft.identity.common.internal.controllers.CommandDispatcher;
import com.microsoft.identity.common.internal.controllers.ExceptionAdapter;
import com.microsoft.identity.common.internal.controllers.GetDeviceModeCommand;
import com.microsoft.identity.common.internal.controllers.InteractiveTokenCommand;
import com.microsoft.identity.common.internal.controllers.TokenCommand;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import com.microsoft.identity.common.internal.eststelemetry.EstsTelemetry;
import com.microsoft.identity.common.internal.net.HttpRequest;
import com.microsoft.identity.common.internal.net.cache.HttpCache;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.internal.request.AcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.AcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.OperationParameters;
import com.microsoft.identity.common.internal.result.ILocalAuthenticationResult;
import com.microsoft.identity.common.internal.result.ResultFuture;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PublicClientApplication
implements IPublicClientApplication,
ITokenShare {
    private static final String TAG = PublicClientApplication.class.getSimpleName();
    private static final String INTERNET_PERMISSION = "android.permission.INTERNET";
    private static final String ACCESS_NETWORK_STATE_PERMISSION = "android.permission.ACCESS_NETWORK_STATE";
    private static final ExecutorService sBackgroundExecutor = Executors.newCachedThreadPool();
    private static final String TSL_MSG_FAILED_TO_SAVE = "Failed to save FRT - see getCause() for additional Exception info";
    private static final String TSM_MSG_FAILED_TO_RETRIEVE = "Failed to retrieve FRT - see getCause() for additional Exception info";
    protected PublicClientApplicationConfiguration mPublicClientConfiguration;
    protected TokenShareUtility mTokenShareUtility;
    protected AccountMatcher homeAccountMatcher = new AccountMatcher(){

        @Override
        boolean matches(@NonNull String homeAccountId, @NonNull IAccount account) {
            return homeAccountId.contains(account.getId());
        }
    };
    protected AccountMatcher localAccountMatcher = new AccountMatcher(){

        @Override
        boolean matches(@NonNull String localAccountId, @NonNull IAccount account) {
            MultiTenantAccount multiTenantAccount;
            Map<String, ITenantProfile> tenantProfiles;
            if (localAccountId.contains(account.getId())) {
                return true;
            }
            if (account instanceof MultiTenantAccount && null != (tenantProfiles = (multiTenantAccount = (MultiTenantAccount)account).getTenantProfiles()) && !tenantProfiles.isEmpty()) {
                for (Map.Entry<String, ITenantProfile> profileEntry : tenantProfiles.entrySet()) {
                    if (TextUtils.isEmpty((CharSequence)profileEntry.getValue().getId()) || !localAccountId.contains(profileEntry.getValue().getId())) continue;
                    return true;
                }
            }
            return false;
        }
    };
    protected AccountMatcher usernameMatcher = new AccountMatcher(){

        @Override
        boolean matches(@NonNull String username, @NonNull IAccount account) {
            ArrayList<IAccount> thingsWithClaims = new ArrayList<IAccount>();
            if (null != account.getClaims()) {
                thingsWithClaims.add(account);
            }
            if (account instanceof MultiTenantAccount) {
                MultiTenantAccount multiTenantAccount = (MultiTenantAccount)account;
                Map<String, ITenantProfile> map = multiTenantAccount.getTenantProfiles();
                for (Map.Entry<String, ITenantProfile> profileEntry : map.entrySet()) {
                    if (null == profileEntry.getValue().getClaims()) continue;
                    thingsWithClaims.add(profileEntry.getValue());
                }
            }
            for (IClaimable iClaimable : thingsWithClaims) {
                if (null == iClaimable.getClaims() || !username.equalsIgnoreCase(SchemaUtil.getDisplayableId(iClaimable.getClaims()))) continue;
                return true;
            }
            return false;
        }
    };

    public static void create(@NonNull Context context, int configFileResourceId, @NonNull IPublicClientApplication.ApplicationCreatedListener listener) {
        MsalUtils.validateNonNullArgument(context, "context");
        MsalUtils.validateNonNullArgument(listener, "listener");
        PublicClientApplication.create(PublicClientApplicationConfigurationFactory.initializeConfiguration(context, configFileResourceId), null, null, listener);
    }

    public static void create(@NonNull Context context, @Nullable File configFile, @NonNull IPublicClientApplication.ApplicationCreatedListener listener) {
        MsalUtils.validateNonNullArgument(context, "context");
        MsalUtils.validateNonNullArgument(listener, "listener");
        PublicClientApplication.create(PublicClientApplicationConfigurationFactory.initializeConfiguration(context, configFile), null, null, listener);
    }

    public static void create(@NonNull Context context, @NonNull String clientId, @NonNull IPublicClientApplication.ApplicationCreatedListener listener) {
        MsalUtils.validateNonNullArgument(context, "context");
        MsalUtils.validateNonNullArgument(clientId, "client_id");
        MsalUtils.validateNonNullArgument(listener, "listener");
        PublicClientApplication.create(PublicClientApplicationConfigurationFactory.initializeConfiguration(context), clientId, null, listener);
    }

    public static void create(@NonNull Context context, @NonNull String clientId, @NonNull String authority, @NonNull IPublicClientApplication.ApplicationCreatedListener listener) {
        MsalUtils.validateNonNullArgument(context, "context");
        MsalUtils.validateNonNullArgument(clientId, "client_id");
        MsalUtils.validateNonNullArgument(authority, "authority");
        MsalUtils.validateNonNullArgument(listener, "listener");
        PublicClientApplication.create(PublicClientApplicationConfigurationFactory.initializeConfiguration(context), clientId, authority, listener);
    }

    @WorkerThread
    @NonNull
    public static IPublicClientApplication create(@NonNull Context context, int configFileResourceId) throws InterruptedException, MsalException {
        MsalUtils.validateNonNullArgument(context, "context");
        return PublicClientApplication.create(PublicClientApplicationConfigurationFactory.initializeConfiguration(context, configFileResourceId));
    }

    public static void createMultipleAccountPublicClientApplication(@NonNull Context context, int configFileResourceId, @NonNull IPublicClientApplication.IMultipleAccountApplicationCreatedListener listener) {
        MsalUtils.validateNonNullArgument(context, "context");
        MsalUtils.validateNonNullArgument(listener, "listener");
        PublicClientApplication.createMultipleAccountPublicClientApplication(PublicClientApplicationConfigurationFactory.initializeConfiguration(context, configFileResourceId), listener);
    }

    public static void createMultipleAccountPublicClientApplication(@NonNull Context context, @NonNull File configFile, @NonNull IPublicClientApplication.IMultipleAccountApplicationCreatedListener listener) {
        MsalUtils.validateNonNullArgument(context, "context");
        MsalUtils.validateNonNullArgument(listener, "listener");
        PublicClientApplication.createMultipleAccountPublicClientApplication(PublicClientApplicationConfigurationFactory.initializeConfiguration(context, configFile), listener);
    }

    @WorkerThread
    @NonNull
    public static IMultipleAccountPublicClientApplication createMultipleAccountPublicClientApplication(@NonNull Context context, @NonNull int configFileResourceId) throws MsalException, InterruptedException {
        MsalUtils.validateNonNullArgument(context, "context");
        return PublicClientApplication.createMultipleAccountPublicClientApplication(PublicClientApplicationConfigurationFactory.initializeConfiguration(context, configFileResourceId));
    }

    @WorkerThread
    @NonNull
    public static IMultipleAccountPublicClientApplication createMultipleAccountPublicClientApplication(@NonNull Context context, @NonNull File configFile) throws InterruptedException, MsalException {
        MsalUtils.validateNonNullArgument(context, "context");
        MsalUtils.validateNonNullArgument(configFile, "configFile");
        return PublicClientApplication.createMultipleAccountPublicClientApplication(PublicClientApplicationConfigurationFactory.initializeConfiguration(context, configFile));
    }

    public static void createSingleAccountPublicClientApplication(@NonNull Context context, int configFileResourceId, @NonNull IPublicClientApplication.ISingleAccountApplicationCreatedListener listener) {
        MsalUtils.validateNonNullArgument(context, "context");
        MsalUtils.validateNonNullArgument(listener, "listener");
        PublicClientApplication.createSingleAccountPublicClientApplication(PublicClientApplicationConfigurationFactory.initializeConfiguration(context, configFileResourceId), listener);
    }

    public static void createSingleAccountPublicClientApplication(@NonNull Context context, @NonNull File configFile, @NonNull IPublicClientApplication.ISingleAccountApplicationCreatedListener listener) {
        MsalUtils.validateNonNullArgument(context, "context");
        MsalUtils.validateNonNullArgument(configFile, "config_file");
        MsalUtils.validateNonNullArgument(listener, "listener");
        PublicClientApplication.createSingleAccountPublicClientApplication(PublicClientApplicationConfigurationFactory.initializeConfiguration(context, configFile), listener);
    }

    @WorkerThread
    @NonNull
    public static ISingleAccountPublicClientApplication createSingleAccountPublicClientApplication(@NonNull Context context, int configFileResourceId) throws InterruptedException, MsalException {
        MsalUtils.validateNonNullArgument(context, "context");
        return PublicClientApplication.createSingleAccountPublicClientApplication(PublicClientApplicationConfigurationFactory.initializeConfiguration(context, configFileResourceId));
    }

    @WorkerThread
    @NonNull
    public static ISingleAccountPublicClientApplication createSingleAccountPublicClientApplication(@NonNull Context context, @Nullable File configFile) throws InterruptedException, MsalException {
        MsalUtils.validateNonNullArgument(context, "context");
        return PublicClientApplication.createSingleAccountPublicClientApplication(PublicClientApplicationConfigurationFactory.initializeConfiguration(context, configFile));
    }

    @WorkerThread
    private static IPublicClientApplication create(@NonNull PublicClientApplicationConfiguration configuration) throws MsalException, InterruptedException {
        MsalUtils.validateNonNullArgument(configuration, "configuration");
        MsalUtils.throwOnMainThread("createPublicClientApplication");
        final ResultFuture future = new ResultFuture();
        PublicClientApplication.create(configuration, null, null, new IPublicClientApplication.ApplicationCreatedListener(){

            @Override
            public void onCreated(IPublicClientApplication application) {
                future.setResult(new AsyncResult<IPublicClientApplication>(application, null));
            }

            @Override
            public void onError(MsalException exception) {
                future.setResult(new AsyncResult<Object>(null, exception));
            }
        });
        AsyncResult result = (AsyncResult)future.get();
        if (!result.getSuccess()) {
            MsalException ex = result.getException();
            throw ex;
        }
        return (IPublicClientApplication)result.getResult();
    }

    @WorkerThread
    private static IMultipleAccountPublicClientApplication createMultipleAccountPublicClientApplication(@NonNull PublicClientApplicationConfiguration configuration) throws InterruptedException, MsalException {
        if (configuration.mAccountMode != AccountMode.MULTIPLE) {
            throw new MsalClientException("multiple_account_pca_init_fail_account_mode", "AccountMode in configuration is not set to multiple. Cannot initialize multiple account PublicClientApplication.");
        }
        IPublicClientApplication application = PublicClientApplication.create(configuration);
        if (application instanceof IMultipleAccountPublicClientApplication) {
            return (IMultipleAccountPublicClientApplication)application;
        }
        if (configuration.mAccountMode == AccountMode.MULTIPLE && application.isSharedDevice()) {
            throw new MsalClientException("multiple_account_pca_init_fail_on_shared_device", "AccountMode in configuration is set to multiple. However, the device is marked as shared (which requires single account mode).");
        }
        throw new MsalClientException("multiple_account_pca_init_fail_unknown_reason", "Multiple account PublicClientApplication could not be created for unknown reasons");
    }

    @WorkerThread
    private static ISingleAccountPublicClientApplication createSingleAccountPublicClientApplication(@Nullable PublicClientApplicationConfiguration configuration) throws InterruptedException, MsalException {
        IPublicClientApplication application = PublicClientApplication.create(configuration);
        if (application instanceof ISingleAccountPublicClientApplication) {
            return (ISingleAccountPublicClientApplication)application;
        }
        if (configuration.mAccountMode != AccountMode.SINGLE) {
            throw new MsalClientException("single_account_pca_init_fail_account_mode", "AccountMode in configuration is not set to single. Cannot initialize single account PublicClientApplication.");
        }
        throw new MsalClientException("single_account_pca_init_fail_unknown_reason", "A single account public client application could not be created for unknown reasons.");
    }

    private static void create(final @NonNull PublicClientApplicationConfiguration config, final @Nullable String clientId, final @Nullable String authority, final @NonNull IPublicClientApplication.ApplicationCreatedListener listener) {
        BaseController controller;
        OperationParameters params = OperationParametersAdapter.createOperationParameters(config, config.getOAuth2TokenCache());
        try {
            controller = MSALControllerFactory.getDefaultController(config.getAppContext(), params.getAuthority(), config);
        }
        catch (MsalClientException e) {
            listener.onError(e);
            return;
        }
        GetDeviceModeCommand command = new GetDeviceModeCommand(params, controller, (CommandCallback)new CommandCallback<Boolean, BaseException>(){

            public void onError(BaseException error) {
                listener.onError(MsalExceptionAdapter.msalExceptionFromBaseException(error));
            }

            public void onTaskCompleted(Boolean isSharedDevice) {
                config.setIsSharedDevice(isSharedDevice);
                if (config.getAccountMode() == AccountMode.SINGLE || isSharedDevice.booleanValue()) {
                    listener.onCreated(new SingleAccountPublicClientApplication(config, clientId, authority));
                } else {
                    listener.onCreated(new MultipleAccountPublicClientApplication(config, clientId, authority));
                }
            }

            public void onCancel() {
            }
        });
        CommandDispatcher.submitSilent((BaseCommand)command);
    }

    private static void createMultipleAccountPublicClientApplication(@NonNull PublicClientApplicationConfiguration configuration, final @NonNull IPublicClientApplication.IMultipleAccountApplicationCreatedListener listener) {
        PublicClientApplication.create(configuration, null, null, new IPublicClientApplication.ApplicationCreatedListener(){

            @Override
            public void onCreated(@NonNull IPublicClientApplication application) {
                if (application instanceof IMultipleAccountPublicClientApplication) {
                    listener.onCreated((IMultipleAccountPublicClientApplication)application);
                } else {
                    if (application.getConfiguration().mAccountMode == AccountMode.MULTIPLE && application.isSharedDevice()) {
                        listener.onError(new MsalClientException("multiple_account_pca_init_fail_on_shared_device", "AccountMode in configuration is set to multiple. However, the device is marked as shared (which requires single account mode)."));
                        return;
                    }
                    listener.onError(new MsalClientException("multiple_account_pca_init_fail_unknown_reason", "Multiple account PublicClientApplication could not be created for unknown reasons"));
                }
            }

            @Override
            public void onError(MsalException exception) {
                listener.onError(exception);
            }
        });
    }

    private static void createSingleAccountPublicClientApplication(@NonNull PublicClientApplicationConfiguration configuration, final @NonNull IPublicClientApplication.ISingleAccountApplicationCreatedListener listener) {
        PublicClientApplication.create(configuration, null, null, new IPublicClientApplication.ApplicationCreatedListener(){

            @Override
            public void onCreated(IPublicClientApplication application) {
                if (application instanceof ISingleAccountPublicClientApplication) {
                    listener.onCreated((ISingleAccountPublicClientApplication)application);
                } else {
                    if (application.getConfiguration().mAccountMode != AccountMode.SINGLE) {
                        listener.onError(new MsalClientException("single_account_pca_init_fail_account_mode", "AccountMode in configuration is not set to single. Cannot initialize single account PublicClientApplication."));
                        return;
                    }
                    listener.onError(new MsalClientException("single_account_pca_init_fail_unknown_reason", "A single account public client application could not be created for unknown reasons."));
                }
            }

            @Override
            public void onError(MsalException exception) {
                listener.onError(exception);
            }
        });
    }

    protected PublicClientApplication(@NonNull PublicClientApplicationConfiguration configFile, @Nullable String clientId, @Nullable String authority) {
        this.mPublicClientConfiguration = configFile;
        if (clientId != null) {
            this.mPublicClientConfiguration.mClientId = clientId;
        }
        if (authority != null) {
            this.mPublicClientConfiguration.getAuthorities().clear();
            Authority authorityObject = Authority.getAuthorityFromAuthorityUrl((String)authority);
            authorityObject.setDefault(Boolean.valueOf(true));
            this.mPublicClientConfiguration.getAuthorities().add(authorityObject);
        }
        this.initializeApplication();
    }

    private void initializeApplication() {
        String methodName = ":initializeApplication";
        Context context = this.mPublicClientConfiguration.getAppContext();
        EstsTelemetry.getInstance().setupLastRequestTelemetryCache(context);
        this.setupTelemetry(context, this.mPublicClientConfiguration);
        AzureActiveDirectory.setEnvironment((Environment)this.mPublicClientConfiguration.getEnvironment());
        Authority.addKnownAuthorities(this.mPublicClientConfiguration.getAuthorities());
        this.initializeHttpSettings(this.mPublicClientConfiguration.getHttpConfiguration());
        this.initializeLoggerSettings(this.mPublicClientConfiguration.getLoggerConfiguration());
        this.initializeTokenSharingLibrary();
        this.mPublicClientConfiguration.checkIntentFilterAddedToAppManifestForBrokerFlow();
        this.checkInternetPermission();
        HttpCache.initialize((File)context.getCacheDir());
        com.microsoft.identity.common.internal.logging.Logger.info((String)(TAG + ":initializeApplication"), (String)"Create new public client application.");
    }

    private void initializeLoggerSettings(@Nullable LoggerConfiguration loggerConfig) {
        if (null != loggerConfig) {
            Logger.LogLevel configLogLevel = loggerConfig.getLogLevel();
            boolean configPiiState = loggerConfig.isPiiEnabled();
            boolean configLogcatState = loggerConfig.isLogcatEnabled();
            Logger logger = Logger.getInstance();
            if (null != configLogLevel) {
                logger.setLogLevel(configLogLevel);
            }
            logger.setEnablePII(configPiiState);
            logger.setEnableLogcatLog(configLogcatState);
        }
    }

    private void initializeHttpSettings(@Nullable HttpConfiguration httpConfiguration) {
        String methodName = ":initializeHttpSettings";
        if (null == httpConfiguration) {
            com.microsoft.identity.common.internal.logging.Logger.info((String)(TAG + ":initializeHttpSettings"), (String)"HttpConfiguration not provided - using defaults.");
            return;
        }
        int readTimeout = httpConfiguration.getReadTimeout();
        int connectTimeout = httpConfiguration.getConnectTimeout();
        if (readTimeout >= 0) {
            HttpRequest.READ_TIMEOUT = readTimeout;
        }
        if (connectTimeout >= 0) {
            HttpRequest.CONNECT_TIMEOUT = connectTimeout;
        }
    }

    private void initializeTokenSharingLibrary() {
        if (!(this.mPublicClientConfiguration.getOAuth2TokenCache() instanceof MsalOAuth2TokenCache)) {
            throw new IllegalStateException("TSL support mandates use of the MsalOAuth2TokenCache");
        }
        this.mTokenShareUtility = new TokenShareUtility(this.mPublicClientConfiguration.getClientId(), this.mPublicClientConfiguration.getRedirectUri(), this.mPublicClientConfiguration.getDefaultAuthority().getAuthorityURL().toString(), (MsalOAuth2TokenCache)this.mPublicClientConfiguration.getOAuth2TokenCache());
    }

    private void setupTelemetry(@NonNull Context context, @NonNull PublicClientApplicationConfiguration developerConfig) {
        if (null != developerConfig.getTelemetryConfiguration()) {
            com.microsoft.identity.common.internal.logging.Logger.verbose((String)TAG, (String)"Telemetry configuration is set. Telemetry is enabled.");
        } else {
            com.microsoft.identity.common.internal.logging.Logger.verbose((String)TAG, (String)"Telemetry configuration is null. Telemetry is disabled.");
        }
        new Telemetry.Builder().withContext(context).defaultConfiguration(developerConfig.getTelemetryConfiguration()).build();
    }

    @Override
    public String getOrgIdFamilyRefreshToken(@NonNull String identifier) throws MsalClientException {
        MsalUtils.validateNonNullArgument(identifier, "identifier");
        this.validateBrokerNotInUse();
        try {
            return this.mTokenShareUtility.getOrgIdFamilyRefreshToken(identifier);
        }
        catch (Exception e) {
            throw new MsalClientException("token_cache_item_not_found", TSM_MSG_FAILED_TO_RETRIEVE, e);
        }
    }

    @Override
    public void saveOrgIdFamilyRefreshToken(@NonNull String ssoStateSerializerBlob) throws MsalClientException {
        MsalUtils.validateNonNullArgument(ssoStateSerializerBlob, "SsoStateSerializerBlob");
        this.validateBrokerNotInUse();
        try {
            this.mTokenShareUtility.saveOrgIdFamilyRefreshToken(ssoStateSerializerBlob);
        }
        catch (Exception e) {
            throw new MsalClientException("token_sharing_deserialization_error", TSL_MSG_FAILED_TO_SAVE, e);
        }
    }

    @Override
    public String getMsaFamilyRefreshToken(@NonNull String identifier) throws MsalClientException {
        MsalUtils.validateNonNullArgument(identifier, "identifier");
        this.validateBrokerNotInUse();
        try {
            return this.mTokenShareUtility.getMsaFamilyRefreshToken(identifier);
        }
        catch (Exception e) {
            throw new MsalClientException("token_cache_item_not_found", TSM_MSG_FAILED_TO_RETRIEVE, e);
        }
    }

    @Override
    public void saveMsaFamilyRefreshToken(@NonNull String refreshToken) throws MsalClientException {
        MsalUtils.validateNonNullArgument(refreshToken, "refreshToken");
        this.validateBrokerNotInUse();
        try {
            this.mTokenShareUtility.saveMsaFamilyRefreshToken(refreshToken);
        }
        catch (Exception e) {
            throw new MsalClientException("failed_to_persist_msa_credential", TSL_MSG_FAILED_TO_SAVE, e);
        }
    }

    private void validateBrokerNotInUse() throws MsalClientException {
        if (MSALControllerFactory.brokerEligible(this.mPublicClientConfiguration.getAppContext(), this.mPublicClientConfiguration.getDefaultAuthority(), this.mPublicClientConfiguration)) {
            throw new MsalClientException("Cannot perform this action - broker is enabled.");
        }
    }

    public static String getSdkVersion() {
        return "1.1.0-hf1";
    }

    @Override
    public PublicClientApplicationConfiguration getConfiguration() {
        return this.mPublicClientConfiguration;
    }

    @Override
    public boolean isSharedDevice() {
        return this.mPublicClientConfiguration.getIsSharedDevice();
    }

    @Override
    public void acquireToken(@NonNull Activity activity, @NonNull String[] scopes, @NonNull AuthenticationCallback callback) {
        AcquireTokenParameters acquireTokenParameters = this.buildAcquireTokenParameters(activity, scopes, null, null, null, null, null, callback, null, null);
        this.acquireTokenInternal(acquireTokenParameters, "122");
    }

    AcquireTokenParameters buildAcquireTokenParameters(@NonNull Activity activity, @NonNull String[] scopes, @Nullable IAccount account, @Nullable Prompt uiBehavior, @Nullable List<Pair<String, String>> extraQueryParameters, @Nullable String[] extraScopesToConsent, @Nullable String authority, @NonNull AuthenticationCallback callback, @Nullable String loginHint, @Nullable ClaimsRequest claimsRequest) {
        MsalUtils.validateNonNullArgument(activity, "activity");
        MsalUtils.validateNonNullArgument(scopes, "scopes");
        MsalUtils.validateNonNullArgument(callback, "callback");
        AcquireTokenParameters.Builder builder = new AcquireTokenParameters.Builder();
        AcquireTokenParameters acquireTokenParameters = ((AcquireTokenParameters.Builder)((AcquireTokenParameters.Builder)((AcquireTokenParameters.Builder)((AcquireTokenParameters.Builder)builder.startAuthorizationFromActivity(activity).forAccount(account)).withScopes(Arrays.asList(scopes))).withPrompt(uiBehavior).withAuthorizationQueryStringParameters(extraQueryParameters).withOtherScopesToAuthorize(Arrays.asList(null == extraScopesToConsent ? new String[]{} : extraScopesToConsent)).fromAuthority(authority)).withCallback(callback).withLoginHint(loginHint).withClaims(claimsRequest)).build();
        return acquireTokenParameters;
    }

    protected void validateAcquireTokenParameters(AcquireTokenParameters parameters) throws MsalArgumentException {
        Activity activity = parameters.getActivity();
        List<String> scopes = parameters.getScopes();
        AuthenticationCallback callback = parameters.getCallback();
        MsalUtils.validateNonNullArg(activity, "activity");
        MsalUtils.validateNonNullArg(scopes, "scopes");
        MsalUtils.validateNonNullArg(callback, "callback");
    }

    protected void validateAcquireTokenSilentParameters(AcquireTokenSilentParameters parameters) throws MsalArgumentException {
        String authority = parameters.getAuthority();
        IAccount account = parameters.getAccount();
        List<String> scopes = parameters.getScopes();
        SilentAuthenticationCallback callback = parameters.getCallback();
        MsalUtils.validateNonNullArg(authority, "authority");
        MsalUtils.validateNonNullArg(account, "account");
        MsalUtils.validateNonNullArg(callback, "callback");
        MsalUtils.validateNonNullArg(scopes, "scopes");
    }

    @Override
    public void acquireToken(@NonNull AcquireTokenParameters acquireTokenParameters) {
        this.acquireTokenInternal(acquireTokenParameters, "121");
    }

    void acquireTokenInternal(final @NonNull AcquireTokenParameters acquireTokenParameters, final @NonNull String publicApiId) {
        sBackgroundExecutor.submit(new Runnable(){

            @Override
            public void run() {
                final CommandCallback localAuthenticationCallback = PublicClientApplication.this.getCommandCallback(acquireTokenParameters.getCallback(), acquireTokenParameters);
                try {
                    PublicClientApplication.this.validateAcquireTokenParameters(acquireTokenParameters);
                    acquireTokenParameters.setAccountRecord(PublicClientApplication.this.selectAccountRecordForTokenRequest(PublicClientApplication.this.mPublicClientConfiguration, acquireTokenParameters));
                    AcquireTokenOperationParameters params = OperationParametersAdapter.createAcquireTokenOperationParameters(acquireTokenParameters, PublicClientApplication.this.mPublicClientConfiguration, PublicClientApplication.this.mPublicClientConfiguration.getOAuth2TokenCache());
                    InteractiveTokenCommand command = new InteractiveTokenCommand(params, MSALControllerFactory.getDefaultController(PublicClientApplication.this.mPublicClientConfiguration.getAppContext(), params.getAuthority(), PublicClientApplication.this.mPublicClientConfiguration), localAuthenticationCallback);
                    command.setPublicApiId(publicApiId);
                    CommandDispatcher.beginInteractive((InteractiveTokenCommand)command);
                }
                catch (Exception exception) {
                    final BaseException baseException = ExceptionAdapter.baseExceptionFromException((Exception)exception);
                    Handler handler = new Handler(Looper.getMainLooper());
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            localAuthenticationCallback.onError((Object)baseException);
                        }
                    });
                }
            }
        });
    }

    protected AcquireTokenSilentParameters buildAcquireTokenSilentParameters(@NonNull String[] scopes, @NonNull IAccount account, @NonNull String authority, boolean forceRefresh, @Nullable ClaimsRequest claimsRequest, @NonNull SilentAuthenticationCallback callback) {
        MsalUtils.validateNonNullArgument(account, "account");
        MsalUtils.validateNonNullArgument(callback, "callback");
        AcquireTokenSilentParameters.Builder builder = new AcquireTokenSilentParameters.Builder();
        AcquireTokenSilentParameters acquireTokenSilentParameters = ((AcquireTokenSilentParameters.Builder)((AcquireTokenSilentParameters.Builder)((AcquireTokenSilentParameters.Builder)((AcquireTokenSilentParameters.Builder)builder.withScopes(Arrays.asList(scopes))).forAccount(account)).fromAuthority(authority)).forceRefresh(forceRefresh).withClaims(claimsRequest)).withCallback(callback).build();
        return acquireTokenSilentParameters;
    }

    @Override
    public void acquireTokenSilentAsync(@NonNull AcquireTokenSilentParameters acquireTokenSilentParameters) {
        this.acquireTokenSilentAsyncInternal(acquireTokenSilentParameters, "22");
    }

    void acquireTokenSilentAsyncInternal(final @NonNull AcquireTokenSilentParameters acquireTokenSilentParameters, final @NonNull String publicApiId) {
        sBackgroundExecutor.submit(new Runnable(){

            @Override
            public void run() {
                final CommandCallback callback = PublicClientApplication.this.getCommandCallback(acquireTokenSilentParameters.getCallback(), acquireTokenSilentParameters);
                try {
                    PublicClientApplication.this.validateAcquireTokenSilentParameters(acquireTokenSilentParameters);
                    acquireTokenSilentParameters.setAccountRecord(PublicClientApplication.this.selectAccountRecordForTokenRequest(PublicClientApplication.this.mPublicClientConfiguration, acquireTokenSilentParameters));
                    AcquireTokenSilentOperationParameters params = OperationParametersAdapter.createAcquireTokenSilentOperationParameters(acquireTokenSilentParameters, PublicClientApplication.this.mPublicClientConfiguration, PublicClientApplication.this.mPublicClientConfiguration.getOAuth2TokenCache());
                    TokenCommand silentTokenCommand = new TokenCommand((OperationParameters)params, MSALControllerFactory.getAllControllers(PublicClientApplication.this.mPublicClientConfiguration.getAppContext(), params.getAuthority(), PublicClientApplication.this.mPublicClientConfiguration), callback);
                    silentTokenCommand.setPublicApiId(publicApiId);
                    CommandDispatcher.submitSilent((BaseCommand)silentTokenCommand);
                }
                catch (Exception exception) {
                    final BaseException baseException = ExceptionAdapter.baseExceptionFromException((Exception)exception);
                    new Handler(Looper.getMainLooper()).post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onError((Object)baseException);
                        }
                    });
                }
            }
        });
    }

    private AccountRecord selectAccountRecordForTokenRequest(@NonNull PublicClientApplicationConfiguration pcaConfig, @NonNull TokenParameters tokenParameters) throws ServiceException, ClientException {
        if (TextUtils.isEmpty((CharSequence)tokenParameters.getAuthority())) {
            tokenParameters.setAuthority(pcaConfig.getDefaultAuthority().getAuthorityUri().toString());
        }
        if (null == tokenParameters.getAccount()) {
            return null;
        }
        IAccount rootAccount = tokenParameters.getAccount();
        MultiTenantAccount multiTenantAccount = (MultiTenantAccount)rootAccount;
        String requestAuthority = tokenParameters.getAuthority();
        Authority authority = Authority.getAuthorityFromAuthorityUrl((String)requestAuthority);
        if (authority instanceof AzureActiveDirectoryB2CAuthority) {
            return AccountAdapter.getAccountInternal(this.mPublicClientConfiguration.getClientId(), this.mPublicClientConfiguration.getOAuth2TokenCache(), multiTenantAccount.getHomeAccountId(), multiTenantAccount.getTenantId());
        }
        if (authority instanceof AzureActiveDirectoryAuthority) {
            boolean isSilent;
            IAccount accountForRequest;
            AzureActiveDirectoryAuthority aadAuthority = (AzureActiveDirectoryAuthority)authority;
            String tenantId = aadAuthority.getAudience().getTenantId();
            AccountRecord accountRecord = new AccountRecord();
            accountRecord.setEnvironment(multiTenantAccount.getEnvironment());
            accountRecord.setHomeAccountId(multiTenantAccount.getHomeAccountId());
            boolean isUuid = StringUtil.isUuid((String)tenantId);
            if (!isUuid && !AzureActiveDirectoryAudience.isHomeTenantAlias((String)tenantId)) {
                tenantId = ((AzureActiveDirectoryAuthority)authority).getAudience().getTenantUuidForAlias(authority.getAuthorityURL().toString());
            }
            if (null == (accountForRequest = AzureActiveDirectoryAudience.isHomeTenantAlias((String)tenantId) || OperationParametersAdapter.isAccountHomeTenant(multiTenantAccount.getClaims(), tenantId) ? (multiTenantAccount.getClaims() != null ? multiTenantAccount : null) : (IAccount)multiTenantAccount.getTenantProfiles().get(tenantId)) && (isSilent = tokenParameters instanceof AcquireTokenSilentParameters)) {
                if (rootAccount.getClaims() != null) {
                    accountForRequest = rootAccount;
                } else {
                    for (ITenantProfile tenantProfile : multiTenantAccount.getTenantProfiles().values()) {
                        if (tenantProfile.getClaims() == null) continue;
                        accountForRequest = tenantProfile;
                        break;
                    }
                }
            }
            if (accountForRequest == null) {
                com.microsoft.identity.common.internal.logging.Logger.warnPII((String)TAG, (String)("No account record found for IAccount with request tenantId: " + tenantId));
                throw new ClientException("no_account_found", "No account record found for IAccount");
            }
            accountRecord.setLocalAccountId(accountForRequest.getId());
            accountRecord.setUsername(accountForRequest.getUsername());
            return accountRecord;
        }
        throw new UnsupportedOperationException("Unsupported Authority type: " + authority.getClass().getSimpleName());
    }

    @Override
    public IAuthenticationResult acquireTokenSilent(@NonNull AcquireTokenSilentParameters acquireTokenSilentParameters) throws InterruptedException, MsalException {
        return this.acquireTokenSilentInternal(acquireTokenSilentParameters, "21");
    }

    IAuthenticationResult acquireTokenSilentInternal(@NonNull AcquireTokenSilentParameters acquireTokenSilentParameters, @NonNull String publicApiId) throws InterruptedException, MsalException {
        if (acquireTokenSilentParameters.getCallback() != null) {
            throw new IllegalArgumentException("Do not provide callback for synchronous methods");
        }
        final ResultFuture future = new ResultFuture();
        acquireTokenSilentParameters.setCallback(new SilentAuthenticationCallback(){

            @Override
            public void onSuccess(IAuthenticationResult authenticationResult) {
                future.setResult(new AsyncResult<IAuthenticationResult>(authenticationResult, null));
            }

            @Override
            public void onError(MsalException exception) {
                future.setResult(new AsyncResult<Object>(null, exception));
            }
        });
        this.acquireTokenSilentAsyncInternal(acquireTokenSilentParameters, publicApiId);
        AsyncResult result = (AsyncResult)future.get();
        if (result.getSuccess()) {
            return (IAuthenticationResult)result.getResult();
        }
        throw result.getException();
    }

    private void checkInternetPermission() {
        PackageManager packageManager = this.mPublicClientConfiguration.getAppContext().getPackageManager();
        if (packageManager.checkPermission(INTERNET_PERMISSION, this.mPublicClientConfiguration.getAppContext().getPackageName()) != 0 || packageManager.checkPermission(ACCESS_NETWORK_STATE_PERMISSION, this.mPublicClientConfiguration.getAppContext().getPackageName()) != 0) {
            throw new IllegalStateException("android.permission.Internet or android.permission.ACCESS_NETWORK_STATE is missing");
        }
    }

    static CommandCallback<List<ICacheRecord>, BaseException> getLoadAccountsCallback(final IPublicClientApplication.LoadAccountsCallback loadAccountsCallback) {
        return new CommandCallback<List<ICacheRecord>, BaseException>(){

            public void onTaskCompleted(List<ICacheRecord> result) {
                if (null == result) {
                    loadAccountsCallback.onTaskCompleted(null);
                } else {
                    loadAccountsCallback.onTaskCompleted(AccountAdapter.adapt(result));
                }
            }

            public void onError(BaseException exception) {
                loadAccountsCallback.onError(MsalExceptionAdapter.msalExceptionFromBaseException(exception));
            }

            public void onCancel() {
            }
        };
    }

    protected CommandCallback getCommandCallback(final @NonNull SilentAuthenticationCallback authenticationCallback, final @NonNull TokenParameters tokenParameters) {
        return new CommandCallback<ILocalAuthenticationResult, BaseException>(){

            public void onTaskCompleted(ILocalAuthenticationResult localAuthenticationResult) {
                PublicClientApplication.this.postAuthResult(localAuthenticationResult, tokenParameters, authenticationCallback);
            }

            public void onError(BaseException exception) {
                MsalException msalException = MsalExceptionAdapter.msalExceptionFromBaseException(exception);
                if (authenticationCallback == null) {
                    throw new IllegalStateException("callback cannot be null or empty");
                }
                authenticationCallback.onError(msalException);
            }

            public void onCancel() {
                if (!(authenticationCallback instanceof AuthenticationCallback)) {
                    throw new IllegalStateException("Silent requests cannot be cancelled.");
                }
                ((AuthenticationCallback)authenticationCallback).onCancel();
            }
        };
    }

    protected void postAuthResult(@NonNull ILocalAuthenticationResult localAuthenticationResult, @NonNull TokenParameters requestParameters, @NonNull SilentAuthenticationCallback authenticationCallback) {
        if (authenticationCallback == null) {
            throw new IllegalStateException("callback cannot be null or empty");
        }
        List<String> declinedScopes = AuthenticationResultAdapter.getDeclinedScopes(Arrays.asList(localAuthenticationResult.getScope()), requestParameters.getScopes());
        if (!declinedScopes.isEmpty()) {
            MsalDeclinedScopeException declinedScopeException = AuthenticationResultAdapter.declinedScopeExceptionFromResult(localAuthenticationResult, declinedScopes, requestParameters);
            authenticationCallback.onError(declinedScopeException);
        } else {
            IAuthenticationResult authenticationResult = AuthenticationResultAdapter.adapt(localAuthenticationResult);
            authenticationCallback.onSuccess(authenticationResult);
        }
    }

    private OAuth2TokenCache<?, ?, ?> getOAuth2TokenCache() {
        return MsalOAuth2TokenCache.create((Context)this.mPublicClientConfiguration.getAppContext());
    }

    IAuthenticationResult acquireTokenSilentSyncInternal(@NonNull String[] scopes, @NonNull String authority, @NonNull IAccount account, boolean forceRefresh, @NonNull String publicApiId) throws MsalException, InterruptedException {
        MsalUtils.throwOnMainThread("acquireTokenSilent");
        final ResultFuture future = new ResultFuture();
        AcquireTokenSilentParameters acquireTokenSilentParameters = this.buildAcquireTokenSilentParameters(scopes, account, authority, forceRefresh, null, new SilentAuthenticationCallback(){

            @Override
            public void onSuccess(IAuthenticationResult authenticationResult) {
                future.setResult(new AsyncResult<IAuthenticationResult>(authenticationResult, null));
            }

            @Override
            public void onError(MsalException exception) {
                future.setResult(new AsyncResult<Object>(null, exception));
            }
        });
        this.acquireTokenSilentAsyncInternal(acquireTokenSilentParameters, publicApiId);
        AsyncResult result = (AsyncResult)future.get();
        if (result.getSuccess()) {
            return (IAuthenticationResult)result.getResult();
        }
        throw result.getException();
    }

    protected class AccountMatcher {
        private final AccountMatcher[] mDelegateMatchers;

        AccountMatcher() {
            this.mDelegateMatchers = new AccountMatcher[0];
        }

        AccountMatcher(AccountMatcher ... delegateMatchers) {
            this.mDelegateMatchers = delegateMatchers;
        }

        boolean matches(@NonNull String identifier, @NonNull IAccount account) {
            AccountMatcher matcher;
            boolean matches = false;
            AccountMatcher[] accountMatcherArray = this.mDelegateMatchers;
            int n = accountMatcherArray.length;
            for (int i = 0; i < n && !(matches = (matcher = accountMatcherArray[i]).matches(identifier, account)); ++i) {
            }
            return matches;
        }
    }

    public static interface BrokerDeviceModeCallback {
        public void onGetMode(boolean var1);

        public void onError(MsalException var1);
    }

    static class NONNULL_CONSTANTS {
        static final String CONTEXT = "context";
        static final String LISTENER = "listener";
        static final String CALLBACK = "callback";
        static final String CLIENT_ID = "client_id";
        static final String AUTHORITY = "authority";
        static final String CONFIG_FILE = "config_file";
        static final String ACTIVITY = "activity";
        static final String SCOPES = "scopes";
        static final String ACCOUNT = "account";
        static final String NULL_ERROR_SUFFIX = " cannot be null or empty";

        NONNULL_CONSTANTS() {
        }
    }
}

