/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.client.AccountAdapter;
import com.microsoft.identity.client.IAccount;
import com.microsoft.identity.client.IAuthenticationResult;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.dto.AccessTokenRecord;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class AuthenticationResult
implements IAuthenticationResult {
    private final String mTenantId;
    private final AccessTokenRecord mAccessToken;
    private final IAccount mAccount;

    public AuthenticationResult(@NonNull List<ICacheRecord> cacheRecords) {
        ICacheRecord mostRecentlyAuthorized = cacheRecords.get(0);
        this.mAccessToken = mostRecentlyAuthorized.getAccessToken();
        this.mTenantId = mostRecentlyAuthorized.getAccount().getRealm();
        this.mAccount = AccountAdapter.adapt(cacheRecords).get(0);
    }

    @Override
    @NonNull
    public String getAccessToken() {
        return this.mAccessToken.getSecret();
    }

    @Override
    @NonNull
    public Date getExpiresOn() {
        Date expiresOn = new Date(TimeUnit.SECONDS.toMillis(Long.parseLong(this.mAccessToken.getExpiresOn())));
        return expiresOn;
    }

    @Override
    @Nullable
    public String getTenantId() {
        return this.mTenantId;
    }

    @Override
    @NonNull
    public IAccount getAccount() {
        return this.mAccount;
    }

    @Override
    @NonNull
    public String[] getScope() {
        return this.mAccessToken.getTarget().split("\\s");
    }
}

