/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.controllers;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.microsoft.identity.client.AcquireTokenParameters;
import com.microsoft.identity.client.AcquireTokenSilentParameters;
import com.microsoft.identity.client.IAccount;
import com.microsoft.identity.client.IClaimable;
import com.microsoft.identity.client.ITenantProfile;
import com.microsoft.identity.client.MultiTenantAccount;
import com.microsoft.identity.client.Prompt;
import com.microsoft.identity.client.PublicClientApplication;
import com.microsoft.identity.client.PublicClientApplicationConfiguration;
import com.microsoft.identity.client.claims.ClaimsRequest;
import com.microsoft.identity.client.exception.MsalClientException;
import com.microsoft.identity.common.internal.authorities.Authority;
import com.microsoft.identity.common.internal.authorities.AzureActiveDirectoryAuthority;
import com.microsoft.identity.common.internal.authorities.AzureActiveDirectoryB2CAuthority;
import com.microsoft.identity.common.internal.cache.SchemaUtil;
import com.microsoft.identity.common.internal.dto.IAccountRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.internal.providers.oauth2.OpenIdConnectPromptParameter;
import com.microsoft.identity.common.internal.request.AcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.AcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.OperationParameters;
import com.microsoft.identity.common.internal.ui.AuthorizationAgent;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.util.HashSet;
import java.util.Map;

public class OperationParametersAdapter {
    private static final String TAG = OperationParametersAdapter.class.getSimpleName();

    public static OperationParameters createOperationParameters(@NonNull PublicClientApplicationConfiguration configuration, @NonNull OAuth2TokenCache cache) {
        OperationParameters parameters = new OperationParameters();
        parameters.setAppContext(configuration.getAppContext());
        parameters.setTokenCache(cache);
        parameters.setClientId(configuration.getClientId());
        parameters.setRedirectUri(configuration.getRedirectUri());
        parameters.setAuthority(configuration.getDefaultAuthority());
        parameters.setApplicationName(configuration.getAppContext().getPackageName());
        parameters.setApplicationVersion(OperationParametersAdapter.getPackageVersion(configuration.getAppContext()));
        parameters.setSdkVersion(PublicClientApplication.getSdkVersion());
        parameters.setRequiredBrokerProtocolVersion(configuration.getRequiredBrokerProtocolVersion());
        return parameters;
    }

    public static AcquireTokenOperationParameters createAcquireTokenOperationParameters(@NonNull AcquireTokenParameters acquireTokenParameters, @NonNull PublicClientApplicationConfiguration publicClientApplicationConfiguration, @NonNull OAuth2TokenCache cache) {
        String methodName = ":createAcquireTokenOperationParameters";
        AcquireTokenOperationParameters acquireTokenOperationParameters = new AcquireTokenOperationParameters();
        if (StringUtil.isEmpty((String)acquireTokenParameters.getAuthority())) {
            if (acquireTokenParameters.getAccount() != null) {
                acquireTokenOperationParameters.setAuthority(OperationParametersAdapter.getRequestAuthority(publicClientApplicationConfiguration));
            } else {
                acquireTokenOperationParameters.setAuthority(publicClientApplicationConfiguration.getDefaultAuthority());
            }
        } else {
            acquireTokenOperationParameters.setAuthority(Authority.getAuthorityFromAuthorityUrl((String)acquireTokenParameters.getAuthority()));
        }
        acquireTokenOperationParameters.setBrowserSafeList(publicClientApplicationConfiguration.getBrowserSafeList());
        if (acquireTokenOperationParameters.getAuthority() instanceof AzureActiveDirectoryAuthority) {
            AzureActiveDirectoryAuthority aadAuthority = (AzureActiveDirectoryAuthority)acquireTokenOperationParameters.getAuthority();
            aadAuthority.setMultipleCloudsSupported(publicClientApplicationConfiguration.getMultipleCloudsSupported().booleanValue());
        }
        Logger.verbosePII((String)":createAcquireTokenOperationParameters", (String)("Using authority: [" + acquireTokenOperationParameters.getAuthority().getAuthorityUri() + "]"));
        acquireTokenOperationParameters.setScopes(new HashSet<String>(acquireTokenParameters.getScopes()));
        acquireTokenOperationParameters.setClientId(publicClientApplicationConfiguration.getClientId());
        acquireTokenOperationParameters.setRedirectUri(publicClientApplicationConfiguration.getRedirectUri());
        acquireTokenOperationParameters.setActivity(acquireTokenParameters.getActivity());
        if (acquireTokenParameters.getAccount() != null) {
            IAccount account = acquireTokenParameters.getAccount();
            String username = OperationParametersAdapter.getUsername(account);
            acquireTokenOperationParameters.setLoginHint(username);
            acquireTokenOperationParameters.setAccount((IAccountRecord)acquireTokenParameters.getAccountRecord());
        } else {
            acquireTokenOperationParameters.setLoginHint(acquireTokenParameters.getLoginHint());
        }
        acquireTokenOperationParameters.setTokenCache(cache);
        acquireTokenOperationParameters.setExtraQueryStringParameters(acquireTokenParameters.getExtraQueryStringParameters());
        acquireTokenOperationParameters.setExtraScopesToConsent(acquireTokenParameters.getExtraScopesToConsent());
        acquireTokenOperationParameters.setAppContext(publicClientApplicationConfiguration.getAppContext());
        acquireTokenOperationParameters.setClaimsRequest(ClaimsRequest.getJsonStringFromClaimsRequest(acquireTokenParameters.getClaimsRequest()));
        if (null != publicClientApplicationConfiguration.getAuthorizationAgent()) {
            acquireTokenOperationParameters.setAuthorizationAgent(publicClientApplicationConfiguration.getAuthorizationAgent());
        } else {
            acquireTokenOperationParameters.setAuthorizationAgent(AuthorizationAgent.DEFAULT);
        }
        if (acquireTokenParameters.getPrompt() == null || acquireTokenParameters.getPrompt() == Prompt.WHEN_REQUIRED) {
            acquireTokenOperationParameters.setOpenIdConnectPromptParameter(OpenIdConnectPromptParameter.SELECT_ACCOUNT);
        } else {
            acquireTokenOperationParameters.setOpenIdConnectPromptParameter(acquireTokenParameters.getPrompt().toOpenIdConnectPromptParameter());
        }
        Context context = acquireTokenParameters.getActivity().getApplicationContext();
        acquireTokenOperationParameters.setApplicationName(context.getPackageName());
        acquireTokenOperationParameters.setApplicationVersion(OperationParametersAdapter.getPackageVersion(context));
        acquireTokenOperationParameters.setSdkVersion(PublicClientApplication.getSdkVersion());
        return acquireTokenOperationParameters;
    }

    private static String getUsername(@NonNull IAccount account) {
        String username = null;
        if (null != account.getClaims()) {
            username = SchemaUtil.getDisplayableId(account.getClaims());
        } else {
            MultiTenantAccount multiTenantAccount = (MultiTenantAccount)account;
            Map<String, ITenantProfile> tenantProfiles = multiTenantAccount.getTenantProfiles();
            for (Map.Entry<String, ITenantProfile> profileEntry : tenantProfiles.entrySet()) {
                String displayableId;
                if (null == profileEntry.getValue().getClaims() || "Missing from the token response".equalsIgnoreCase(displayableId = SchemaUtil.getDisplayableId(profileEntry.getValue().getClaims()))) continue;
                username = displayableId;
                break;
            }
        }
        return username;
    }

    public static AcquireTokenSilentOperationParameters createAcquireTokenSilentOperationParameters(@NonNull AcquireTokenSilentParameters acquireTokenSilentParameters, @NonNull PublicClientApplicationConfiguration pcaConfig, @NonNull OAuth2TokenCache cache) {
        Context context = pcaConfig.getAppContext();
        String requestAuthority = acquireTokenSilentParameters.getAuthority();
        Authority authority = Authority.getAuthorityFromAuthorityUrl((String)requestAuthority);
        ClaimsRequest claimsRequest = acquireTokenSilentParameters.getClaimsRequest();
        String jsonClaimsRequest = ClaimsRequest.getJsonStringFromClaimsRequest(claimsRequest);
        AcquireTokenSilentOperationParameters atsOperationParams = new AcquireTokenSilentOperationParameters();
        atsOperationParams.setAppContext(pcaConfig.getAppContext());
        atsOperationParams.setScopes(new HashSet<String>(acquireTokenSilentParameters.getScopes()));
        atsOperationParams.setClientId(pcaConfig.getClientId());
        atsOperationParams.setTokenCache(cache);
        atsOperationParams.setAuthority(authority);
        atsOperationParams.setApplicationName(context.getPackageName());
        atsOperationParams.setApplicationVersion(OperationParametersAdapter.getPackageVersion(context));
        atsOperationParams.setSdkVersion(PublicClientApplication.getSdkVersion());
        atsOperationParams.setForceRefresh(acquireTokenSilentParameters.getForceRefresh());
        atsOperationParams.setRedirectUri(pcaConfig.getRedirectUri());
        atsOperationParams.setClaimsRequest(jsonClaimsRequest);
        atsOperationParams.setAccount((IAccountRecord)acquireTokenSilentParameters.getAccountRecord());
        if (atsOperationParams.getAuthority() instanceof AzureActiveDirectoryAuthority) {
            AzureActiveDirectoryAuthority aadAuthority = (AzureActiveDirectoryAuthority)atsOperationParams.getAuthority();
            aadAuthority.setMultipleCloudsSupported(pcaConfig.getMultipleCloudsSupported().booleanValue());
        }
        return atsOperationParams;
    }

    public static void validateClaimsExistForTenant(@NonNull String tenantId, @Nullable IClaimable claimable) throws MsalClientException {
        String methodName = ":validateClaimsExistForTenant";
        if (null == claimable || null == claimable.getClaims()) {
            String errMsg = "Attempting to authorize for tenant: " + tenantId + " but no matching account was found.";
            Logger.warn((String)(TAG + ":validateClaimsExistForTenant"), (String)errMsg);
            throw new MsalClientException(errMsg);
        }
    }

    public static boolean isAccountHomeTenant(@Nullable Map<String, ?> claims, @NonNull String tenantId) {
        boolean isAccountHomeTenant = false;
        if (null != claims && !claims.isEmpty()) {
            isAccountHomeTenant = claims.get("tid").equals(tenantId);
        }
        return isAccountHomeTenant;
    }

    public static boolean isHomeTenantEquivalent(@NonNull String tenantId) {
        return tenantId.equalsIgnoreCase("common") || tenantId.equalsIgnoreCase("consumers") || tenantId.equalsIgnoreCase("organizations");
    }

    private static Authority getRequestAuthority(@NonNull PublicClientApplicationConfiguration publicClientApplicationConfiguration) {
        String requestAuthority = null;
        if (publicClientApplicationConfiguration.getDefaultAuthority() instanceof AzureActiveDirectoryB2CAuthority) {
            requestAuthority = publicClientApplicationConfiguration.getDefaultAuthority().getAuthorityURL().toString();
        }
        Authority authority = requestAuthority == null ? publicClientApplicationConfiguration.getDefaultAuthority() : Authority.getAuthorityFromAuthorityUrl(requestAuthority);
        return authority;
    }

    private static String getPackageVersion(@NonNull Context context) {
        String packageName = context.getPackageName();
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(packageName, 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

