/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.controllers;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.gson.GsonBuilder;
import com.microsoft.identity.client.IMicrosoftAuthService;
import com.microsoft.identity.client.PublicClientApplication;
import com.microsoft.identity.client.PublicClientApplicationConfiguration;
import com.microsoft.identity.client.exception.MsalClientException;
import com.microsoft.identity.client.exception.MsalException;
import com.microsoft.identity.client.internal.controllers.BrokerAccountManagerStrategy;
import com.microsoft.identity.client.internal.controllers.BrokerActivity;
import com.microsoft.identity.client.internal.controllers.BrokerAuthServiceStrategy;
import com.microsoft.identity.client.internal.controllers.BrokerBaseStrategy;
import com.microsoft.identity.client.internal.controllers.MSALControllerFactory;
import com.microsoft.identity.client.internal.controllers.MsalExceptionAdapter;
import com.microsoft.identity.client.internal.controllers.OperationParametersAdapter;
import com.microsoft.identity.common.BaseAccount;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.exception.ServiceException;
import com.microsoft.identity.common.internal.broker.BrokerResult;
import com.microsoft.identity.common.internal.broker.BrokerResultFuture;
import com.microsoft.identity.common.internal.broker.MicrosoftAuthClient;
import com.microsoft.identity.common.internal.broker.MicrosoftAuthServiceFuture;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.cache.MsalOAuth2TokenCache;
import com.microsoft.identity.common.internal.controllers.BaseController;
import com.microsoft.identity.common.internal.controllers.ExceptionAdapter;
import com.microsoft.identity.common.internal.controllers.TaskCompletedCallbackWithError;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftRefreshToken;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAccount;
import com.microsoft.identity.common.internal.providers.oauth2.IDToken;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.internal.providers.oauth2.RefreshToken;
import com.microsoft.identity.common.internal.request.AcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.AcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.MsalBrokerRequestAdapter;
import com.microsoft.identity.common.internal.request.OperationParameters;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.result.MsalBrokerResultAdapter;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.ApiEndEvent;
import com.microsoft.identity.common.internal.telemetry.events.ApiStartEvent;
import com.microsoft.identity.common.internal.telemetry.events.BaseEvent;
import com.microsoft.identity.common.internal.telemetry.events.BrokerStartEvent;
import com.microsoft.identity.common.internal.ui.browser.Browser;
import com.microsoft.identity.common.internal.ui.browser.BrowserSelector;
import com.microsoft.identity.common.internal.util.ICacheRecordGsonAdapter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class BrokerMsalController
extends BaseController {
    private static final String TAG = BrokerMsalController.class.getSimpleName();
    private List<BrokerBaseStrategy> mStrategies = new ArrayList<BrokerBaseStrategy>();
    private static final String MANIFEST_PERMISSION_GET_ACCOUNTS = "android.permission.GET_ACCOUNTS";
    private static final String MANIFEST_PERMISSION_MANAGE_ACCOUNTS = "android.permission.MANAGE_ACCOUNTS";
    private static final String MANIFEST_PERMISSION_USE_CREDENTIALS = "android.permission.USE_CREDENTIALS";
    private BrokerResultFuture mBrokerResultFuture;
    private static final ExecutorService sBackgroundExecutor = Executors.newCachedThreadPool();

    List<BrokerBaseStrategy> getStrategies() {
        return this.mStrategies;
    }

    void addBrokerStrategy(@NonNull BrokerBaseStrategy strategy) {
        this.mStrategies.add(strategy);
    }

    public AcquireTokenResult acquireToken(AcquireTokenOperationParameters parameters) throws InterruptedException, BaseException {
        Telemetry.emit((BaseEvent)new ApiStartEvent().putProperties((OperationParameters)parameters).putApiId("206"));
        this.mBrokerResultFuture = new BrokerResultFuture();
        Intent interactiveRequestIntent = this.getBrokerAuthorizationIntent(parameters);
        Intent brokerActivityIntent = new Intent(parameters.getAppContext(), BrokerActivity.class);
        brokerActivityIntent.putExtra("broker_intent", (Parcelable)interactiveRequestIntent);
        this.mBrokerResultFuture = new BrokerResultFuture();
        parameters.getActivity().startActivity(brokerActivityIntent);
        Bundle resultBundle = this.mBrokerResultFuture.get();
        this.saveMsaAccountToCache(resultBundle, (MsalOAuth2TokenCache)parameters.getTokenCache());
        AcquireTokenResult result = BrokerBaseStrategy.getAcquireTokenResult(resultBundle);
        Telemetry.emit((BaseEvent)new ApiEndEvent().putResult(result).putApiId("206"));
        return result;
    }

    private Intent getBrokerAuthorizationIntent(@NonNull AcquireTokenOperationParameters parameters) throws ClientException {
        String methodName = ":getBrokerAuthorizationIntent";
        this.helloBroker((OperationParameters)parameters);
        Intent interactiveRequestIntent = null;
        for (int ii = 0; ii < this.getStrategies().size(); ++ii) {
            BrokerBaseStrategy strategy = this.getStrategies().get(ii);
            Logger.verbose((String)(TAG + ":getBrokerAuthorizationIntent"), (String)("Executing with strategy: " + strategy.getClass().getSimpleName()));
            try {
                interactiveRequestIntent = strategy.getBrokerAuthorizationIntent(parameters);
                if (interactiveRequestIntent == null) continue;
                break;
            }
            catch (Exception exception) {
                if (ii != this.getStrategies().size() - 1) continue;
                throw exception;
            }
        }
        return interactiveRequestIntent;
    }

    public void completeAcquireToken(int requestCode, int resultCode, Intent data) {
        Telemetry.emit((BaseEvent)new ApiStartEvent().putApiId("202").put("result_code", String.valueOf(resultCode)).put("request_code", String.valueOf(requestCode)));
        this.mBrokerResultFuture.setResultBundle(data.getExtras());
        Telemetry.emit((BaseEvent)new ApiEndEvent().putApiId("202"));
    }

    public AcquireTokenResult acquireTokenSilent(AcquireTokenSilentOperationParameters parameters) throws BaseException {
        String methodName = ":acquireTokenSilent";
        this.helloBroker((OperationParameters)parameters);
        Telemetry.emit((BaseEvent)new ApiStartEvent().putProperties((OperationParameters)parameters).putApiId("203"));
        AcquireTokenResult acquireTokenResult = null;
        for (int ii = 0; ii < this.getStrategies().size(); ++ii) {
            BrokerBaseStrategy strategy = this.getStrategies().get(ii);
            Logger.verbose((String)(TAG + ":acquireTokenSilent"), (String)("Executing with strategy for silent : " + strategy.getClass().getSimpleName()));
            try {
                acquireTokenResult = strategy.acquireTokenSilent(parameters);
                if (acquireTokenResult == null) continue;
                break;
            }
            catch (Exception exception) {
                if (ii != this.getStrategies().size() - 1) continue;
                throw exception;
            }
        }
        Telemetry.emit((BaseEvent)new ApiEndEvent().putResult(acquireTokenResult).putApiId("203"));
        return acquireTokenResult;
    }

    public List<ICacheRecord> getAccounts(@NonNull OperationParameters parameters) throws ClientException, InterruptedException, ExecutionException, RemoteException, OperationCanceledException, IOException, AuthenticatorException {
        String methodName = ":getBrokerAccounts";
        this.helloBroker(parameters);
        List<ICacheRecord> result = null;
        for (int ii = 0; ii < this.getStrategies().size(); ++ii) {
            BrokerBaseStrategy strategy = this.getStrategies().get(ii);
            Logger.verbose((String)(TAG + ":getBrokerAccounts"), (String)("Executing with strategy: " + strategy.getClass().getSimpleName()));
            try {
                result = strategy.getBrokerAccounts(parameters);
                if (result.isEmpty()) continue;
                break;
            }
            catch (Exception exception) {
                if (ii != this.getStrategies().size() - 1) continue;
                throw exception;
            }
        }
        return result;
    }

    @WorkerThread
    public boolean removeAccount(@NonNull OperationParameters parameters) throws BaseException, InterruptedException, ExecutionException, RemoteException {
        String methodName = ":removeBrokerAccount";
        this.helloBroker(parameters);
        boolean result = false;
        for (int ii = 0; ii < this.getStrategies().size(); ++ii) {
            BrokerBaseStrategy strategy = this.getStrategies().get(ii);
            Logger.verbose((String)(TAG + ":removeBrokerAccount"), (String)("Executing with strategy: " + strategy.getClass().getSimpleName()));
            try {
                result = strategy.removeBrokerAccount(parameters);
                continue;
            }
            catch (Exception exception) {
                if (ii != this.getStrategies().size() - 1) continue;
                throw exception;
            }
        }
        return result;
    }

    public void getBrokerDeviceMode(final PublicClientApplicationConfiguration configuration, final PublicClientApplication.BrokerDeviceModeCallback callback) {
        String methodName = ":getBrokerDeviceMode";
        try {
            if (!MSALControllerFactory.brokerEligible(configuration.getAppContext(), configuration.getDefaultAuthority(), configuration)) {
                String errorMessage = "This request is not eligible to use the broker. Do not check sharedDevice mode and return false immediately.";
                Logger.error((String)(TAG + ":getBrokerDeviceMode"), (String)"This request is not eligible to use the broker. Do not check sharedDevice mode and return false immediately.", null);
                callback.onGetMode(false);
                return;
            }
        }
        catch (MsalClientException e) {
            Logger.error((String)(TAG + ":getBrokerDeviceMode"), (String)e.toString(), null);
            callback.onGetMode(false);
            return;
        }
        Telemetry.emit((BaseEvent)new BrokerStartEvent().putAction(":getBrokerDeviceMode"));
        final Handler handler = new Handler(Looper.getMainLooper());
        sBackgroundExecutor.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MicrosoftAuthClient client = new MicrosoftAuthClient(configuration.getAppContext());
                try {
                    MicrosoftAuthServiceFuture authServiceFuture = client.connect();
                    IMicrosoftAuthService service = authServiceFuture.get();
                    final boolean mode = MsalBrokerResultAdapter.deviceModeFromBundle((Bundle)service.getDeviceMode());
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onGetMode(mode);
                        }
                    });
                }
                catch (RemoteException | ClientException | InterruptedException | ExecutionException e) {
                    String errorMessage = "Exception is thrown when trying to get current mode from Broker";
                    Logger.error((String)(TAG + ":getBrokerDeviceMode"), (String)"Exception is thrown when trying to get current mode from Broker", (Throwable)e);
                    handler.post(new Runnable((Exception)e){
                        final /* synthetic */ Exception val$e;
                        {
                            this.val$e = exception;
                        }

                        @Override
                        public void run() {
                            callback.onError(new MsalClientException("io_error", "Exception is thrown when trying to get current mode from Broker", this.val$e));
                        }
                    });
                }
                finally {
                    client.disconnect();
                }
            }
        });
    }

    private void saveMsaAccountToCache(@NonNull Bundle resultBundle, @NonNull MsalOAuth2TokenCache msalOAuth2TokenCache) throws ClientException {
        String methodName = ":saveMsaAccountToCache";
        BrokerResult brokerResult = (BrokerResult)new GsonBuilder().registerTypeAdapter(ICacheRecord.class, (Object)new ICacheRecordGsonAdapter()).create().fromJson(resultBundle.getString("broker_result_v2"), BrokerResult.class);
        if (resultBundle.getBoolean("broker_request_v2_success") && brokerResult != null && "9188040d-6c67-4c5b-b112-36a304b66dad".equalsIgnoreCase(brokerResult.getTenantId())) {
            Logger.info((String)(TAG + ":saveMsaAccountToCache"), (String)"Result returned for MSA Account, saving to cache");
            try {
                ClientInfo clientInfo = new ClientInfo(brokerResult.getClientInfo());
                MicrosoftStsAccount microsoftStsAccount = new MicrosoftStsAccount(new IDToken(brokerResult.getIdToken()), clientInfo);
                microsoftStsAccount.setEnvironment(brokerResult.getEnvironment());
                MicrosoftRefreshToken microsoftRefreshToken = new MicrosoftRefreshToken(brokerResult.getRefreshToken(), clientInfo, brokerResult.getScope(), brokerResult.getClientId(), brokerResult.getEnvironment(), brokerResult.getFamilyId());
                msalOAuth2TokenCache.setSingleSignOnState((BaseAccount)microsoftStsAccount, (RefreshToken)microsoftRefreshToken);
            }
            catch (ServiceException e) {
                Logger.errorPII((String)(TAG + ":saveMsaAccountToCache"), (String)"Exception while creating Idtoken or ClientInfo, cannot save MSA account tokens", (Throwable)e);
                throw new ClientException("invalid_jwt", e.getMessage(), (Throwable)e);
            }
        }
    }

    private <T> void performBrokerTask(final @NonNull Context appContext, final @NonNull TaskCompletedCallbackWithError<T, MsalException> callback, final @NonNull BrokerTask<T> brokerTask) {
        final Handler handler = new Handler(Looper.getMainLooper());
        sBackgroundExecutor.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MicrosoftAuthClient client = new MicrosoftAuthClient(appContext);
                try {
                    MicrosoftAuthServiceFuture authServiceFuture = client.connect();
                    IMicrosoftAuthService service = authServiceFuture.get();
                    final Object result = brokerTask.perform(service);
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onTaskCompleted(result);
                        }
                    });
                }
                catch (RemoteException | BaseException | InterruptedException | ExecutionException e) {
                    Logger.error((String)(TAG + brokerTask.getOperationName()), (String)("Exception is thrown when trying to perform a broker operation:" + e.getMessage()), (Throwable)e);
                    handler.post(new Runnable((Exception)e){
                        final /* synthetic */ Exception val$e;
                        {
                            this.val$e = exception;
                        }

                        @Override
                        public void run() {
                            BaseException baseException = ExceptionAdapter.baseExceptionFromException((Exception)this.val$e);
                            callback.onError((Object)MsalExceptionAdapter.msalExceptionFromBaseException(baseException));
                        }
                    });
                }
                finally {
                    client.disconnect();
                }
            }
        });
    }

    public void getCurrentAccount(final @NonNull PublicClientApplicationConfiguration configuration, final @NonNull OAuth2TokenCache cache, @NonNull TaskCompletedCallbackWithError<List<ICacheRecord>, MsalException> callback) {
        String methodName = ":getCurrentAccount";
        this.performBrokerTask(configuration.getAppContext(), callback, new BrokerTask<List<ICacheRecord>>(){

            @Override
            public List<ICacheRecord> perform(IMicrosoftAuthService service) throws ClientException, RemoteException {
                return MsalBrokerResultAdapter.accountsFromBundle((Bundle)service.getCurrentAccount(BrokerAuthServiceStrategy.getRequestBundleForGetAccounts(OperationParametersAdapter.createOperationParameters(configuration, cache))));
            }

            @Override
            public String getOperationName() {
                return ":getCurrentAccount";
            }
        });
    }

    public void removeAccountFromSharedDevice(final @NonNull PublicClientApplicationConfiguration configuration, @NonNull TaskCompletedCallbackWithError<Void, MsalException> callback) {
        String methodName = ":removeAccountFromSharedDevice";
        this.performBrokerTask(configuration.getAppContext(), callback, new BrokerTask<Void>(){

            @Override
            public Void perform(IMicrosoftAuthService service) throws BaseException, RemoteException {
                Bundle resultBundle = service.removeAccountFromSharedDevice(BrokerMsalController.this.getRequestBundleForRemoveAccountFromSharedDevice(configuration));
                if (resultBundle == null) {
                    return null;
                }
                BrokerResult brokerResult = MsalBrokerResultAdapter.brokerResultFromBundle((Bundle)resultBundle);
                Logger.error((String)TAG, (String)("Failed to perform global sign-out." + brokerResult.getErrorMessage()), null);
                throw new MsalClientException("unknown_error", brokerResult.getErrorMessage());
            }

            @Override
            public String getOperationName() {
                return ":removeAccountFromSharedDevice";
            }
        });
    }

    private Bundle getRequestBundleForRemoveAccountFromSharedDevice(PublicClientApplicationConfiguration configuration) {
        Bundle requestBundle = new Bundle();
        try {
            Browser browser = BrowserSelector.select((Context)configuration.getAppContext(), configuration.getBrowserSafeList());
            requestBundle.putString("default.browser.package.name", browser.getPackageName());
        }
        catch (ClientException e) {
            Logger.error((String)TAG, (String)e.getErrorCode(), (Throwable)e);
        }
        return requestBundle;
    }

    @WorkerThread
    static boolean helloWithMicrosoftAuthService(@NonNull Context applicationContext, @NonNull OperationParameters parameters) throws ClientException {
        String methodName = ":helloWithMicrosoftAuthService";
        MicrosoftAuthClient client = new MicrosoftAuthClient(applicationContext);
        try {
            MicrosoftAuthServiceFuture authServiceFuture = client.connect();
            IMicrosoftAuthService service = authServiceFuture.get();
            Bundle requestBundle = MsalBrokerRequestAdapter.getBrokerHelloBundle((OperationParameters)parameters);
            boolean bl = MsalBrokerResultAdapter.getHelloResultFromBundle((Bundle)service.hello(requestBundle));
            return bl;
        }
        catch (RemoteException | InterruptedException | ExecutionException e) {
            Logger.error((String)(TAG + ":helloWithMicrosoftAuthService"), (String)("Exception is thrown when trying to verify the broker protocol version." + e.getMessage()), (String)"io_error", (Throwable)e);
            throw new ClientException("io_error", e.getMessage(), e);
        }
        finally {
            client.disconnect();
        }
    }

    @WorkerThread
    @SuppressLint(value={"MissingPermission"})
    static boolean helloWithAccountManager(@NonNull Context applicationContext, @NonNull OperationParameters parameters) throws ClientException {
        String methodName = ":helloWithAccountManager";
        String DATA_HELLO = "com.microsoft.workaccount.hello";
        if (!BrokerMsalController.isAccountManagerPermissionsGranted(parameters.getAppContext())) {
            return false;
        }
        try {
            Account[] accountList = AccountManager.get((Context)applicationContext).getAccountsByType("com.microsoft.workaccount");
            if (accountList.length > 0) {
                Bundle requestBundle = MsalBrokerRequestAdapter.getBrokerHelloBundle((OperationParameters)parameters);
                requestBundle.putString("com.microsoft.workaccount.hello", "true");
                AccountManagerFuture result = AccountManager.get((Context)parameters.getAppContext()).updateCredentials(accountList[0], "adal.authtoken.type", requestBundle, null, null, null);
                if (result == null) {
                    return false;
                }
                return MsalBrokerResultAdapter.getHelloResultFromBundle((Bundle)((Bundle)result.getResult()));
            }
            return false;
        }
        catch (OperationCanceledException e) {
            Logger.error((String)(TAG + ":helloWithAccountManager"), (String)"Broker request cancelled", (String)"Exception thrown when talking to account manager. The broker request cancelled.", (Throwable)e);
            throw new ClientException("Broker request cancelled", "OperationCanceledException thrown when talking to account manager. The broker request cancelled.", (Throwable)e);
        }
        catch (AuthenticatorException e) {
            Logger.error((String)(TAG + ":helloWithAccountManager"), (String)"Broker request cancelled", (String)"AuthenticatorException thrown when talking to account manager. The broker request cancelled.", (Throwable)e);
            throw new ClientException("Broker request cancelled", "AuthenticatorException thrown when talking to account manager. The broker request cancelled.", (Throwable)e);
        }
        catch (IOException e) {
            Logger.error((String)(TAG + ":helloWithAccountManager"), (String)"Broker request cancelled", (String)"IOException thrown when talking to account manager. The broker request cancelled.", (Throwable)e);
            throw new ClientException("Broker request cancelled", "IOException thrown when talking to account manager. The broker request cancelled.", (Throwable)e);
        }
    }

    static boolean isMicrosoftAuthServiceSupported(@NonNull Context context) {
        MicrosoftAuthClient client = new MicrosoftAuthClient(context);
        Intent microsoftAuthServiceIntent = client.getIntentForAuthService(context);
        return null != microsoftAuthServiceIntent;
    }

    static boolean isAccountManagerPermissionsGranted(@NonNull Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            return BrokerMsalController.isPermissionGranted(context, MANIFEST_PERMISSION_GET_ACCOUNTS);
        }
        return BrokerMsalController.isPermissionGranted(context, MANIFEST_PERMISSION_GET_ACCOUNTS) && BrokerMsalController.isPermissionGranted(context, MANIFEST_PERMISSION_MANAGE_ACCOUNTS) && BrokerMsalController.isPermissionGranted(context, MANIFEST_PERMISSION_USE_CREDENTIALS);
    }

    private static boolean isPermissionGranted(@NonNull Context context, @NonNull String permissionName) {
        String methodName = ":isPermissionGranted";
        PackageManager pm = context.getPackageManager();
        boolean isGranted = pm.checkPermission(permissionName, context.getPackageName()) == 0;
        Logger.verbose((String)(TAG + ":isPermissionGranted"), (String)("is " + permissionName + " granted? [" + isGranted + "]"));
        return isGranted;
    }

    private void helloBroker(@NonNull OperationParameters parameters) throws ClientException {
        String methodName = ":initializeBrokerMsalController";
        if (!this.getStrategies().isEmpty()) {
            this.mStrategies = new ArrayList<BrokerBaseStrategy>();
        }
        if (BrokerMsalController.helloWithMicrosoftAuthService(parameters.getAppContext(), parameters)) {
            Logger.verbose((String)(TAG + ":initializeBrokerMsalController"), (String)"Add the broker AuthService strategy.");
            this.addBrokerStrategy(new BrokerAuthServiceStrategy());
        }
        if (BrokerMsalController.helloWithAccountManager(parameters.getAppContext(), parameters)) {
            Logger.verbose((String)(TAG + ":initializeBrokerMsalController"), (String)"Add the account manager strategy.");
            this.addBrokerStrategy(new BrokerAccountManagerStrategy());
        }
        if (this.getStrategies().isEmpty()) {
            throw new ClientException("unsupported_broker_version", "The protocol versions between the MSAL client app and broker are not compatible.");
        }
    }

    public static interface BrokerTask<T> {
        public T perform(IMicrosoftAuthService var1) throws BaseException, RemoteException;

        public String getOperationName();
    }
}

