/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.controllers;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import com.google.gson.Gson;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.broker.BrokerRequest;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.dto.IAccountRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.request.AcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.AcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.MsalBrokerRequestAdapter;
import com.microsoft.identity.common.internal.request.OperationParameters;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.result.MsalBrokerResultAdapter;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;

abstract class BrokerBaseStrategy {
    private static final String TAG = BrokerBaseStrategy.class.getSimpleName();

    BrokerBaseStrategy() {
    }

    abstract Intent getBrokerAuthorizationIntent(@NonNull AcquireTokenOperationParameters var1) throws ClientException;

    abstract AcquireTokenResult acquireTokenSilent(AcquireTokenSilentOperationParameters var1) throws BaseException;

    abstract List<ICacheRecord> getBrokerAccounts(@NonNull OperationParameters var1) throws InterruptedException, ExecutionException, RemoteException, OperationCanceledException, IOException, AuthenticatorException, ClientException;

    abstract boolean removeBrokerAccount(@NonNull OperationParameters var1) throws BaseException, InterruptedException, ExecutionException, RemoteException;

    Handler getPreferredHandler() {
        if (null != Looper.myLooper() && Looper.getMainLooper() != Looper.myLooper()) {
            return new Handler(Looper.myLooper());
        }
        return new Handler(Looper.getMainLooper());
    }

    Bundle getSilentBrokerRequestBundle(AcquireTokenSilentOperationParameters parameters) {
        MsalBrokerRequestAdapter msalBrokerRequestAdapter = new MsalBrokerRequestAdapter();
        Bundle requestBundle = new Bundle();
        BrokerRequest brokerRequest = msalBrokerRequestAdapter.brokerRequestFromSilentOperationParameters(parameters);
        requestBundle.putString("broker_request_v2", new Gson().toJson((Object)brokerRequest, BrokerRequest.class));
        requestBundle.putInt("caller.info.uid", Binder.getCallingUid());
        return requestBundle;
    }

    @SuppressLint(value={"MissingPermission"})
    Account getTargetAccount(Context context, IAccountRecord accountRecord) {
        Account targetAccount = null;
        Account[] accountList = AccountManager.get((Context)context).getAccountsByType("com.microsoft.workaccount");
        if (accountList != null) {
            for (Account account : accountList) {
                if (account == null || account.name == null || !account.name.equalsIgnoreCase(accountRecord.getUsername())) continue;
                targetAccount = account;
            }
        }
        return targetAccount;
    }

    static AcquireTokenResult getAcquireTokenResult(@NonNull Bundle resultBundle) throws BaseException {
        MsalBrokerResultAdapter resultAdapter = new MsalBrokerResultAdapter();
        if (resultBundle.getBoolean("broker_request_v2_success")) {
            Logger.verbose((String)TAG, (String)"Successful result from the broker ");
            AcquireTokenResult acquireTokenResult = new AcquireTokenResult();
            acquireTokenResult.setLocalAuthenticationResult(resultAdapter.authenticationResultFromBundle(resultBundle));
            return acquireTokenResult;
        }
        Logger.warn((String)TAG, (String)"Exception returned from broker, retrieving exception details ");
        throw resultAdapter.baseExceptionFromBundle(resultBundle);
    }
}

