/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.client.internal.controllers;

import android.content.Intent;
import android.os.Bundle;
import android.os.RemoteException;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.gson.Gson;
import com.microsoft.identity.client.IMicrosoftAuthService;
import com.microsoft.identity.client.internal.controllers.BrokerBaseStrategy;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.broker.BrokerRequest;
import com.microsoft.identity.common.internal.broker.MicrosoftAuthClient;
import com.microsoft.identity.common.internal.broker.MicrosoftAuthServiceFuture;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.request.AcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.AcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.MsalBrokerRequestAdapter;
import com.microsoft.identity.common.internal.request.OperationParameters;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import com.microsoft.identity.common.internal.result.MsalBrokerResultAdapter;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.BaseEvent;
import com.microsoft.identity.common.internal.telemetry.events.BrokerEndEvent;
import com.microsoft.identity.common.internal.telemetry.events.BrokerStartEvent;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class BrokerAuthServiceStrategy
extends BrokerBaseStrategy {
    private static final String TAG = BrokerAuthServiceStrategy.class.getSimpleName();

    @Override
    @WorkerThread
    Intent getBrokerAuthorizationIntent(@NonNull AcquireTokenOperationParameters parameters) throws ClientException {
        String methodName = ":getBrokerAuthorizationIntent";
        Logger.verbose((String)(TAG + ":getBrokerAuthorizationIntent"), (String)"Get the broker authorization intent from auth service.");
        Intent interactiveRequestIntent = this.getBrokerAuthorizationIntentFromAuthService(parameters);
        MsalBrokerRequestAdapter msalBrokerRequestAdapter = new MsalBrokerRequestAdapter();
        interactiveRequestIntent.putExtra("broker_request_v2", new Gson().toJson((Object)msalBrokerRequestAdapter.brokerRequestFromAcquireTokenParameters(parameters), BrokerRequest.class));
        interactiveRequestIntent.putExtra("account.name", parameters.getLoginHint());
        return interactiveRequestIntent;
    }

    private Intent getBrokerAuthorizationIntentFromAuthService(@NonNull AcquireTokenOperationParameters parameters) throws ClientException {
        Intent resultIntent;
        String methodName = ":getBrokerAuthorizationIntentFromAuthService";
        Telemetry.emit((BaseEvent)new BrokerStartEvent().putAction(":getBrokerAuthorizationIntentFromAuthService"));
        MicrosoftAuthClient client = new MicrosoftAuthClient(parameters.getAppContext());
        MicrosoftAuthServiceFuture authServiceFuture = client.connect();
        try {
            IMicrosoftAuthService service = authServiceFuture.get();
            resultIntent = service.getIntentForInteractiveRequest();
            Telemetry.emit((BaseEvent)new BrokerEndEvent().putAction(":getBrokerAuthorizationIntentFromAuthService").isSuccessful(true));
        }
        catch (RemoteException e) {
            Telemetry.emit((BaseEvent)new BrokerEndEvent().putAction(":getBrokerAuthorizationIntentFromAuthService").isSuccessful(false).putErrorCode("Failed to bind the service in broker app").putErrorDescription(e.getLocalizedMessage()));
            throw new ClientException("Failed to bind the service in broker app", "Exception occurred while attempting to invoke remote service", (Throwable)e);
        }
        catch (Exception e) {
            Telemetry.emit((BaseEvent)new BrokerEndEvent().putAction(":getBrokerAuthorizationIntentFromAuthService").isSuccessful(false).putErrorCode("Failed to bind the service in broker app").putErrorDescription(e.getLocalizedMessage()));
            throw new ClientException("Failed to bind the service in broker app", "Exception occurred while awaiting (get) return of MicrosoftAuthService", (Throwable)e);
        }
        finally {
            client.disconnect();
        }
        return resultIntent;
    }

    @Override
    @WorkerThread
    AcquireTokenResult acquireTokenSilent(AcquireTokenSilentOperationParameters parameters) throws BaseException {
        IMicrosoftAuthService service;
        String methodName = ":acquireTokenSilentWithAuthService";
        Telemetry.emit((BaseEvent)new BrokerStartEvent().putAction(":acquireTokenSilentWithAuthService"));
        MicrosoftAuthClient client = new MicrosoftAuthClient(parameters.getAppContext());
        MicrosoftAuthServiceFuture future = client.connect();
        try {
            service = future.get();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception occurred while awaiting (get) return of MicrosoftAuthService", e);
        }
        try {
            Bundle requestBundle = this.getSilentBrokerRequestBundle(parameters);
            Bundle resultBundle = service.acquireTokenSilently(requestBundle);
            AcquireTokenResult result = BrokerAuthServiceStrategy.getAcquireTokenResult(resultBundle);
            Telemetry.emit((BaseEvent)new BrokerEndEvent().putAction(":acquireTokenSilentWithAuthService").isSuccessful(true));
            AcquireTokenResult acquireTokenResult = result;
            return acquireTokenResult;
        }
        catch (RemoteException e) {
            Telemetry.emit((BaseEvent)new BrokerEndEvent().putAction(":acquireTokenSilentWithAuthService").isSuccessful(false).putErrorCode("Failed to bind the service in broker app").putErrorDescription("RemoteException occurred while attempting to invoke remote service"));
            throw new ClientException("Failed to bind the service in broker app", "Exception occurred while attempting to invoke remote service", (Throwable)e);
        }
        finally {
            client.disconnect();
        }
    }

    @Override
    @WorkerThread
    protected List<ICacheRecord> getBrokerAccounts(@NonNull OperationParameters parameters) throws ClientException, InterruptedException, ExecutionException, RemoteException {
        String methodName = ":getBrokerAccountsWithAuthService";
        MicrosoftAuthClient client = new MicrosoftAuthClient(parameters.getAppContext());
        try {
            List cacheRecords;
            MicrosoftAuthServiceFuture authServiceFuture = client.connect();
            IMicrosoftAuthService service = authServiceFuture.get();
            Bundle requestBundle = BrokerAuthServiceStrategy.getRequestBundleForGetAccounts(parameters);
            List list = cacheRecords = MsalBrokerResultAdapter.accountsFromBundle((Bundle)service.getAccounts(requestBundle));
            return list;
        }
        catch (RemoteException | ClientException | InterruptedException | ExecutionException e) {
            Logger.error((String)(TAG + ":getBrokerAccountsWithAuthService"), (String)("Exception is thrown when trying to get account from Broker, returning empty list." + e.getMessage()), (String)"io_error", (Throwable)e);
            throw e;
        }
        finally {
            client.disconnect();
        }
    }

    static Bundle getRequestBundleForGetAccounts(@NonNull OperationParameters parameters) {
        Bundle requestBundle = new Bundle();
        requestBundle.putString("account.clientid.key", parameters.getClientId());
        requestBundle.putString("account.redirect", parameters.getRedirectUri());
        return requestBundle;
    }

    @Override
    @WorkerThread
    protected boolean removeBrokerAccount(@NonNull OperationParameters parameters) throws BaseException, InterruptedException, ExecutionException, RemoteException {
        String methodName = ":removeBrokerAccountWithAuthService";
        MicrosoftAuthClient client = new MicrosoftAuthClient(parameters.getAppContext());
        try {
            MicrosoftAuthServiceFuture authServiceFuture = client.connect();
            IMicrosoftAuthService service = authServiceFuture.get();
            Bundle requestBundle = BrokerAuthServiceStrategy.getRequestBundleForRemoveAccount(parameters);
            service.removeAccount(requestBundle);
            boolean bl = true;
            return bl;
        }
        catch (RemoteException | BaseException | InterruptedException | ExecutionException e) {
            Logger.error((String)(TAG + ":removeBrokerAccountWithAuthService"), (String)("Exception is thrown when trying to get target account." + e.getMessage()), (String)"io_error", (Throwable)e);
            throw e;
        }
        finally {
            client.disconnect();
        }
    }

    static Bundle getRequestBundleForRemoveAccount(@NonNull OperationParameters parameters) {
        Bundle requestBundle = new Bundle();
        requestBundle.putString("account.clientid.key", parameters.getClientId());
        if (null != parameters.getAccount()) {
            requestBundle.putString("environment", parameters.getAccount().getEnvironment());
            requestBundle.putString("account.home.account.id", parameters.getAccount().getHomeAccountId());
        }
        return requestBundle;
    }
}

